/*
 *  zx-sleep.h - cpu sleep and wakeup interface.
 *
 *  Written by zxp.
 *
 */

#ifndef _ZX_SLEEP_H
#define _ZX_SLEEP_H

typedef enum
{
	CPU_SLEEP_TYPE_NULL           		= 0,
	CPU_SLEEP_TYPE_LP1,
	CPU_SLEEP_TYPE_IDLE_LP2,
	CPU_SLEEP_TYPE_HOTPLUG_LP2,
	CPU_SLEEP_TYPE_LP3,				/* maybe only for debug */
} cpu_sleep_type_t;

typedef enum
{
	CPU_POWER_MODE_RUN             		= 0,
	CPU_POWER_MODE_STANDBY         		= 1,
	CPU_POWER_MODE_DORMANT         		= 2, 
	CPU_POWER_MODE_SHUTDOWN        		= 3,
} cpu_power_mode_t;

typedef enum {
    WR_NONE         					= 0,
    WR_WAKE_SRC_NORMAL,
    WR_WAKE_SRC_UNKNOWN,    
    WR_WAKE_SRC_ABNORMAL,
    WR_SW_ABORT,
} pm_wake_reason_t;


#define do_wfi()                                \
do {                                            \
    __asm__ __volatile__("isb" : : : "memory"); \
    __asm__ __volatile__("dsb" : : : "memory"); \
    __asm__ __volatile__("wfi" : : : "memory"); \
} while (0)

extern int zx_board_suspend(void);
extern int zx_board_resume(void);
extern int zx_dpm_suspend(void);
extern int zx_dpm_resume(void);
extern void zx_enter_sleep(cpu_sleep_type_t sleep_type);
extern void cpu_start_restore(void);
extern pm_wake_reason_t pm_get_wakeup_reason(void);
extern void pm_set_wakeup_reason(pm_wake_reason_t reason);

#endif /*_ZX_SLEEP_H*/
