/*
 * ZTE suspend power management driver
 *
 * Copyright (C) 2013 ZTE Ltd.
 * 	by zxp
 *
 */
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/spinlock.h>
#include <linux/interrupt.h>
#include <linux/types.h>
#include <linux/suspend.h>
#include <linux/math64.h>

#include <asm/system_misc.h>

#include <mach/zx-pm.h>


#define __DEBUG_TIMER3_WAKEUP__	

/**************************************
 * SW code for suspend
 **************************************/
#define pm_info(fmt, args...)      	printk(KERN_INFO "[SLP] " fmt, ##args)

#if 0 //zxp
#define pm_ram_log(fmt, args...)   	pm_sram_write(fmt, ##args)
#define pm_ram_print  				pm_sram_printk
#else	//for debug
#define pm_ram_log   				pm_info
#define pm_ram_print()  				
#endif

/*********************************************************************
 * FUNCTION DEFINATIONS
 ********************************************************************/
static int zx_suspend_ops_valid(suspend_state_t state)
{
    return state == PM_SUSPEND_MEM;
}

static int zx_suspend_ops_begin(suspend_state_t state)
{
    pm_ram_log("@@@@@@@@@@@@@@@@@@@@\n");
    pm_ram_log("Chip_pm_begin\n");
    pm_ram_log("@@@@@@@@@@@@@@@@@@@@\n");

	disable_hlt();
    pm_set_wakeup_reason(WR_NONE);

    return 0;
}

static int zx_suspend_ops_prepare(void)
{
    pm_ram_log("@@@@@@@@@@@@@@@@@@@@\n");
    pm_ram_log("Chip_pm_prepare\n");
    pm_ram_log("@@@@@@@@@@@@@@@@@@@@\n");

    return 0;
}

static int zx_suspend_ops_enter(suspend_state_t state)
{
    /* legacy log */
    pm_ram_log("@@@@@@@@@@@@@@@@@@@@\n");
    pm_ram_log("Chip_pm_enter\n");
    pm_ram_log("@@@@@@@@@@@@@@@@@@@@\n");

	/* deal soc/clk/powerdomain/pll out of A9 module
	 *ssuspend debug uartGPIO and other device out of A9 */
	zx_board_suspend();
	/*close clock&powerdomains that PCU does not controls */
	zx_dpm_suspend();

	/*mask all and backup, then unmask wakeup interrupts */
	zx_unmask_wakeup_interrupt();
	
#ifdef __DEBUG_TIMER3_WAKEUP__	
//	setup_timer_wakeup(__SLEEP_TIME_1s__*20);	//20s
//	setup_timer_wakeup(60);			//61us  each is 30.5us  used ot test abnormal exit from sleep
#endif

	/*cpu enter lowpower mode */
//	zx_enter_sleep(CPU_SLEEP_TYPE_LP3);
//	zx_enter_sleep(CPU_SLEEP_TYPE_IDLE_LP2);	
	zx_enter_sleep(CPU_SLEEP_TYPE_LP1);	
	
	/* get wakeup reason */
	//pm_wake_reason = pm_get_wakeup_reason();

	/* restore interrupt that masked */ 
	zx_interrupt_mask_restore();

	/*resume clock&powerdomains */
	zx_dpm_resume();
	/* resume debug uartGPIO and other device out of A9 */
	zx_board_resume();

    return 0;
}

static void zx_suspend_ops_finish(void)
{
    pm_ram_log("@@@@@@@@@@@@@@@@@@@@\n");
    pm_ram_log("Chip_pm_finish\n");
    pm_ram_log("@@@@@@@@@@@@@@@@@@@@\n");
}

static void zx_suspend_ops_end(void)
{
    pm_ram_log("@@@@@@@@@@@@@@@@@@@@\n");
    pm_ram_log("Chip_pm_end\n");
    pm_ram_log("@@@@@@@@@@@@@@@@@@@@\n");

	enable_hlt();

//	zx_pm_trace_out();

	pm_ram_print();
}

static struct platform_suspend_ops zx_suspend_ops = {
    .valid      = zx_suspend_ops_valid,
    .begin      = zx_suspend_ops_begin,
    .prepare    = zx_suspend_ops_prepare,
    .enter      = zx_suspend_ops_enter,
    .finish     = zx_suspend_ops_finish,
    .end        = zx_suspend_ops_end,
};

void zx_suspend_init(void)
{
    pm_info("[SLP] Power/SPM_INIT \n");

 	suspend_set_ops(&zx_suspend_ops);
}

