/*
 * ZTE power management main driver
 *
 * Copyright (C) 2013 ZTE Ltd.
 * 	by zxp
 *
 */
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/spinlock.h>
#include <linux/interrupt.h>
#include <linux/types.h>
#include <linux/sched.h>
#include <linux/io.h>
#include <linux/suspend.h>
#include <linux/time.h>
#include <linux/timer.h>
#include <linux/delay.h>

#include <mach/zx-pm.h>

#ifdef CONFIG_ZX_PM_DEBUG

static struct delayed_work 	pm_debug_work;
struct kobject *pm_debug_kobj;
static struct timer_list pm_debug_timer;

#define PM_DEBUG_DELAY 		msecs_to_jiffies(10000)		//10s

#endif

/*********************************************************************
 * some common pm functions
 ********************************************************************/
#ifdef CONFIG_ZTE_RAM_CONSOLE 
#define	 PM_LOG_SRAM_SIZE	(256*1024)				
static char pm_sram_printk_buf[PM_LOG_SRAM_SIZE];	//no loop
static u32  pm_sram_point = 0;
#endif
/**
 * usage:
 *       1first   "pm_sram_init"  in initial stage
 *       2then    "pm_sram_write"  in sleep stage
 *       3final   "pm_sram_printk"  after exit sleep
 *       4loop  2-->3-->2...
 */
void pm_sram_write(const char *fmt, ...)
{
#ifdef CONFIG_ZTE_RAM_CONSOLE
	unsigned long long t;
	unsigned long nanosec_rem;
	va_list args;
	int r, tlen;
	char *pbuf = pm_sram_printk_buf + pm_sram_point;

	va_start(args, fmt);
	preempt_disable();
	
	t = cpu_clock(read_cpuid());
	nanosec_rem = do_div(t, 1000000000);
	tlen = sprintf(pbuf, ">%5lu.%06lu< ",
		       (unsigned long) t, nanosec_rem / 1000);
	pm_sram_point += tlen;

	r = vsnprintf(pbuf + pm_sram_point, PM_LOG_SRAM_SIZE-pm_sram_point, fmt, args);
	pm_sram_point += r;

//	ram_console_write(NULL, sram_printk_buf, r + tlen);
	
	preempt_enable();
	va_end(args);
#endif
}
EXPORT_SYMBOL(pm_sram_write);

void pm_sram_printk(void)
{
#ifdef CONFIG_ZTE_RAM_CONSOLE
	printk(pm_sram_printk_buf);

	/* reinit the sram*/
	pm_sram_init();
#endif
}
EXPORT_SYMBOL(pm_sram_printk);

void pm_sram_init(void)
{
#ifdef CONFIG_ZTE_RAM_CONSOLE
    pr_info("[SLP] Power/SRAM_INIT \n");

	pm_sram_printk_buf[0] = 0;
	strcpy(pm_sram_printk_buf, "[ZTE SLEEP]");
	pm_sram_point = strlen(pm_sram_printk_buf);
#endif
}

/*********************************************************************
 * some pm debug functions
 *
 * we use sysfs interface
 ********************************************************************/
#ifdef CONFIG_ZX_PM_DEBUG

static void pm_debug_timer_expired(unsigned long data)
{
	mod_timer(&pm_debug_timer, jiffies + msecs_to_jiffies(6*1000));
	
	pr_info("[SLP] pm timer !!!");	
}


/*=============================================================================
 *========  /sys/zte_pm/state =================================================
 *=============================================================================
 */
 
/**
 *  put the string to the buf, and return the string length 	
 */
static ssize_t state_show(struct kobject *kobj, struct kobj_attribute *attr,
			  char *buf)
{
	char *s = buf;

	s += sprintf(s, "%s\n", "[SLP] no debug info now!");	

	return (s - buf);
}
#include "mach/icp.h"

/**
 *  the buf store the input string , n is the string length 
 *  return the status
 */
static ssize_t state_store(struct kobject *kobj, struct kobj_attribute *attr,
			   const char *buf, size_t n)
{
	int error = 0;

	zDrvRpMsg_CreateChannel(M0_ID, channel_1, 0x20);

	return error ? error : n;
}

zte_pm_attr(state);


/*=============================================================================
 *========  /sys/zte_pm/debug_work  ===========================================
 *=============================================================================
 */
#if 0 
static unsigned test_item = 0;
static void pm_test_switch_clock(void)
{
	printk("[SLP] pm_test_switch_clock: %d \n\r", test_item);

	switch(test_item)
	{
	case 0:	/* ufi 400M */
		cpufreq_test(1, 0);

		break;
	case 1: /* ufi 800M */
		cpufreq_test(0, 1);
		break;
	case 2: /* 624 624M */
		cpufreq_test(1, 2);		
		break;
	case 3: /* 624 156M */
		cpufreq_test(2, 3);				
		break;
	case 4: /* main 26M */	
		cpufreq_test(3, 4);		
		test_item = 0;
		return;
		break;
	}
	
	test_item ++;
}
#endif

static void pm_debug_func(struct work_struct *work)
{
	printk("[SLP] runs in %s. \n\r", __func__);

	pm_suspend(PM_SUSPEND_MEM);
//	pm_test_switch_clock();

	schedule_delayed_work(&pm_debug_work, PM_DEBUG_DELAY);
}

static ssize_t pm_debug_show(struct kobject *kobj, struct kobj_attribute *attr,
			  char *buf)
{
	char *s = buf;

	s += sprintf(s, "%s\n", "[SLP] pm debug !");	

	return (s - buf);
}

/* usage: "echo 1 > pm_debug" */
static ssize_t pm_debug_store(struct kobject *kobj, struct kobj_attribute *attr,
			   const char *buf, size_t n)
{
	int error = 0;
	long temp;	

	if(strict_strtol(buf, 0, &temp))
		error = -EINVAL;

	if(temp == 1)
		schedule_delayed_work(&pm_debug_work, PM_DEBUG_DELAY);
	else
		cancel_delayed_work(&pm_debug_work);
		
	return error ? error : n;
}

zte_pm_attr(pm_debug);

/*=============================================================================
 *========  /sys/zte_pm/wakelock  =============================================
 *=============================================================================
 */
extern void test_wakelock(void);
extern void pm_debug_wakelocks(void);
static ssize_t wakelock_show(struct kobject *kobj, struct kobj_attribute *attr,
			  char *buf)
{
	char *s = buf;

	pm_debug_wakelocks();	

	return (s - buf);
}

static ssize_t wakelock_store(struct kobject *kobj, struct kobj_attribute *attr,
			   const char *buf, size_t n)
{
	int error = 0;
	
	test_wakelock();
		
	return error ? error : n;
}

zte_pm_attr(wakelock);

#ifdef CONFIG_ZX_AUTOSLEEP
/*=============================================================================
 *========  /sys/zte_pm/app_done  =============================================
 *=============================================================================
 */
extern void app_start_done(void);
static ssize_t app_done_show(struct kobject *kobj, struct kobj_attribute *attr,
			  char *buf)
{
	char *s = buf;

	return (s - buf);
}

static ssize_t app_done_store(struct kobject *kobj, struct kobj_attribute *attr,
			   const char *buf, size_t n)
{
	int error = 0;
	
	app_start_done();
		
	return error ? error : n;
}

zte_pm_attr(app_done);
#endif

static struct attribute * g[] = 
{
	&state_attr.attr,
	&pm_debug_attr.attr,
	&wakelock_attr.attr,
#ifdef CONFIG_ZX_AUTOSLEEP
	&app_done_attr.attr,	
#endif	
	NULL,
};


static struct attribute_group zte_pm_attr_group = 
{
	.attrs = g,
};


/**
 *  1create sysfs "/sys/zte_pm" 
 *  2add attr 
 */
static int __init pm_debug_init(void)
{
	int ret;
	
    printk(KERN_INFO "[SLP] create sysfs interface\n");
	pm_debug_kobj = kobject_create_and_add("zte_pm", NULL);
	if (!pm_debug_kobj)
		return -ENOMEM;	
    ret = sysfs_create_group(pm_debug_kobj, &zte_pm_attr_group);
    if (ret)
    {
        printk(KERN_WARNING "[SLP] sysfs_create_group ret %d\n", ret);	
		return ret;
    }

	/* init delayed work */
	INIT_DELAYED_WORK_DEFERRABLE(&pm_debug_work, pm_debug_func);
	/* we will start this in sysfs */
//	schedule_delayed_work(&pm_debug_work, PM_DEBUG_DELAY);

	setup_timer(&pm_debug_timer, pm_debug_timer_expired, 0);
//	mod_timer(&pm_debug_timer, jiffies + msecs_to_jiffies(6*1000));

#ifdef CONFIG_CPU_IDLE
	/* cpuidle debug init */
	idle_debug_init();
#endif

	return 0;
}

#endif

/*********************************************************************
 * FUNCTION DEFINATIONS
 ********************************************************************/
#if defined(CONFIG_ARCH_ZX297510EVB) || defined(CONFIG_ARCH_ZX297510CPE)
static int __init zx_pm_init(void)
{
    return 0;
}
#else
static int __init zx_pm_init(void)
{
    pr_info("[SLP] Power/PM_INIT \n");

    /* 1PCU setting */
	zx_pcu_init();

#ifdef	CONFIG_PM_SLEEP
    /* 2Suspend driver */
    zx_suspend_init();
#endif

	/* 3clock gate initial */
	zx_clk_init();

#if 0 //added when debug	 
	/* 4power domain initial */
	zx_pwr_init();
#endif

	/* 5context memory initial */
	zx_pm_context_init();

	/* 6copy the wakeup code address to wakeup address */
	zx_set_wakeup_address(ZX29_IRAM6_VA);

    /* 7SCU/l2 lowerpower setting */
	pm_init_l2_and_scu();
	
	/* 8init the ram log for pm */
	pm_sram_init();

	/* 9we will delete it later */
	pm_init_crm_temp();

    // 10tell m0 ap_pm start
	sign_a9_run_flag();

#ifdef CONFIG_ZX_PM_DEBUG
	pm_debug_init();
#endif

#ifdef CONFIG_CPU_IDLE
    /* 11idle driver initial */
//	zx_cpuidle_init();
#endif

    return 0;
}
#endif

late_initcall(zx_pm_init);

