#ifndef _MACH_ZX29_DMA_H
#define _MACH_ZX29_DMA_H

#include <linux/dmaengine.h>
/*DMA channel definition*/
typedef enum
{
    DMA_CH_UART0_TX = 0,
    DMA_CH_UART0_RX,    	
    DMA_CH_UART1_TX,    	
    DMA_CH_UART1_RX,    	/* reuse with hash_rx_dma */
    DMA_CH_SSP0_TX,   
    
    DMA_CH_SSP0_RX,     	
    DMA_CH_GPRS0,       	
	DMA_CH_GPRS1, 		
    DMA_CH_USIM,       	
    DMA_CH_I2S0_TX,			/* reuse with tdm_tx_dma */
    
    DMA_CH_I2S0_RX0,     	/* reuse with tdm_rx_dma */
    DMA_CH_I2S1_TX,     	/* reuse with tdm_tx_dma */
    DMA_CH_I2S1_RX0,   		/* reuse with tdm_rx_dma */
    DMA_CH_SPIFC_TX,
    DMA_CH_SPIFC_RX,

    DMA_CH_SSP1_TX,
    DMA_CH_SSP1_RX,
    DMA_CH_UART2_TX,    	/* reuse with i2s0_rx1_dma */
    DMA_CH_UART2_RX,    	/* reuse with i2s1_rx1_dma */
    DMA_CH_MEMORY,			/*DMAC0ϵĿͨ*/

	DMA_CH_NUM,

	/* reused channel id */
	DMA_CH_HASH_RX,		// = DMA_CH_UART1_RX,
	DMA_CH_TDM_TX0,		// = DMA_CH_I2S0_TX,
	DMA_CH_TDM_RX0,		// = DMA_CH_I2S0_RX0,
	DMA_CH_TDM_TX1,		// = DMA_CH_I2S1_TX,
	DMA_CH_TDM_RX1,		// = DMA_CH_I2S1_RX0,
	DMA_CH_I2S0_RX1,	// = DMA_CH_UART2_TX,
	DMA_CH_I2S1_RX1,	// = DMA_CH_UART2_RX,	
	
}dma_peripheral_id;

typedef enum
{
    DMA_INT_ERR,			//transmission error
    DMA_INT_END,			//transmission done

    MAX_DMA_INT
}dma_int_status;

//typedef void (*dma_callback_func)(unsigned int channel, dma_int_status status,void *data);


/*----DMA Transfer Control Set------*/
typedef enum
{
    DMA_DISABLE = 0,	//disable DMA transmission
    DMA_ENABLE = 1,		//enable DMA transmission
    DMA_ENABLE_ALL
}dma_control_enable;

/*----DMA Request mode set------*/
typedef enum
{
    DMA_PERIPHERAL_REQ = 0,		//peripheral request
    DMA_SOFT_REQ = 1,			//soft request for single transfer
    
    DMA_REQ_MOD_ALL
}dma_req_mode;

typedef enum
{
    TRAN_PERI_TO_PERI = 0,		
    TRAN_PERI_TO_MEM,
    TRAN_MEM_TO_PERI,
	TRAN_MEM_TO_MEM,    
    
    DMA_TRAN_MOD_ALL
}dma_transfer_mode;


/*----DMA SingleRequest mode set------*/
typedef enum
{
    DMA_SOFT_SINGLE_REQ_DISABLE = 0,		//soft request for single transfer
    DMA_SOFT_SINGLE_REQ_ENABLE = 1,			//soft request for burst transfer
    
    DMA_SINGLE_REQ_MOD_ALL
}dma_single_req_mod;


/*----DMA Source or Dest address mode------*/
typedef enum
{
    DMA_ADDRMOD_RAM = 0,			//RAM mode, address will increase during transmission
    DMA_ADDRMOD_FIFO = 1,			//FIFO mode, address will not change during transmission

    DMA_ADDRMOD_ALL
}dma_addr_mode;

/*----DMA IRQ Mode------*/
typedef enum
{
	DMA_ALL_IRQ_DISABLE = 0,		//Disable DMA Interrupt request
	DMA_TC_IRQ_ENABLE = 1,			//Enable dma complete interrupt 
	DMA_ERR_IRQ_ENABLE =2,			//Enable dma error interrupt
	DMA_ALL_IRQ_ENABLE = 3, 		//Enable DMA Interrupt request
	
	DMA_IRQMOD_ALL
}dma_irq_mode;

/*----DMA Burst Size------*/
typedef enum
{
    DMA_BURST_SIZE_8BIT = 0,
    DMA_BURST_SIZE_16BIT = 1,
    DMA_BURST_SIZE_32BIT = 2,
    DMA_BURST_SIZE_64BIT = 3,
    DMA_BURST_SIZE_128BIT = 4,
    
    DMA_BURST_SIZE_ALL
}dma_burst_size;


/*----DMA Burst Len------*/
typedef enum
{
    DMA_BURST_LEN_1 = 0,		// 1 tranfer in each burst
    DMA_BURST_LEN_2 ,			// 2 tranfers in each burst
    DMA_BURST_LEN_3 ,			// 3 tranfers in each burst
    DMA_BURST_LEN_4 ,			// 4 tranfers in each burst
    DMA_BURST_LEN_5 ,			// 5 tranfers in each burst
    DMA_BURST_LEN_6 ,			// 6 tranfers in each burst
    DMA_BURST_LEN_7 ,			// 7 tranfers in each burst
    DMA_BURST_LEN_8 ,			// 8 tranfers in each burst
    DMA_BURST_LEN_9 ,			// 9 tranfers in each burst
    DMA_BURST_LEN_10,			// 10 tranfers in each burst
    DMA_BURST_LEN_11 ,			// 11 tranfers in each burst
    DMA_BURST_LEN_12 ,			// 12 tranfers in each burst
    DMA_BURST_LEN_13 ,			// 13 tranfers in each burst
    DMA_BURST_LEN_14 ,			// 14 tranfers in each burst
    DMA_BURST_LEN_15 ,			// 15 tranfers in each burst
    DMA_BURST_LEN_16 ,			// 16 tranfers in each burst

    DMA_BURST_LEN_ALL
}dma_burst_len;

typedef enum
{
    DMA_INT_TO_PHY=0,
    DMA_INT_TO_PS,
    DMA_INT_TO_M0,    
    DMA_INT_TO_A9,

    
    DMA_INT_SEL_ALL
}dma_int_sel;

typedef enum
{
    CHANNEL_DISABLE,
    CHANNEL_ENABLE,

    MAX_CHANNEL_STATUS
}dma_channel_satus;

typedef enum 
{
    SYS_RST_ACTIVE=0,
    SYS_RST_RELEASE=1
}sys_reset_state;


/* Attention!!Here  only accept physical SrcAddr and DestAddr.
If your address is from the main memory,Maybe you can
use kmalloc function to get a consistent memory region 
and use dma_map_single to get the velevant physical address
*/
typedef struct
{
    unsigned int 	src_addr;				//DMA source address
    unsigned int 	dest_addr;				//DMA Destination address
    unsigned short 	count;					//Count (Bytes)
    
    unsigned short 	ycount;					//Count (Bytes)
    unsigned short 	zcount;					//Count (Bytes)    
    unsigned short  src_ystep;				//0 when 1-dimension transfer
    unsigned short  src_zstep;				//0 when 1-dimension transfer
    unsigned short  dest_ystep;				//0 when 1-dimension transfer
    unsigned short  dest_zstep;				//0 when 1-dimension transfer

    unsigned int  	link_addr;				//if not cyclic mode, link_addr must be 0
    
    struct
    {
	    dma_transfer_mode	tran_mode;
#if 0		
        dma_req_mode	burst_req_mode;	    //DMA Request mode
        dma_addr_mode 	src_mode;		    //DMA Source address mode
        dma_addr_mode 	dest_mode;		 	//DMA Destination address mode
#endif		
        dma_irq_mode	irq_mode;			/*comment: disable or enable */
        dma_burst_size 	src_burst_size;		/* src burst size(bit): 8/16/32/64/128 */
        dma_burst_len	src_burst_len;
        dma_burst_size 	dest_burst_size;	
        dma_burst_len	dest_burst_len;
/*        dma_int_sel		int_sel; */
    }  dma_control;

#if 0
	void *data;
	dma_callback_func 	callback;
#endif	
}dma_channel_def;

/*group order define*/
typedef enum
{
    DMA_GROUP_1234_5678 = 0,		
    DMA_GROUP_2341_5678 ,			
    DMA_GROUP_3412_5678 ,			
    DMA_GROUP_4123_5678 ,			
    DMA_GROUP_1234_6785 ,		
    DMA_GROUP_2341_6785 ,			
    DMA_GROUP_3412_6785 ,			
    DMA_GROUP_4123_6785 ,			
    DMA_GROUP_1234_7856 ,		
    DMA_GROUP_2341_7856 ,			
    DMA_GROUP_3412_7856 ,			
    DMA_GROUP_4123_7856 ,			
    DMA_GROUP_1234_8567 ,		
    DMA_GROUP_2341_8567 ,			
    DMA_GROUP_3412_8567 ,			
    DMA_GROUP_4123_8567 ,			
    DMA_GROUP_5678_1234 ,		
    DMA_GROUP_5678_2341 ,			
    DMA_GROUP_5678_3412 ,			
    DMA_GROUP_5678_4123 ,			
    DMA_GROUP_6785_1234 ,		
    DMA_GROUP_6785_2341 ,			
    DMA_GROUP_6785_3412 ,			
    DMA_GROUP_6785_4123 ,			
    DMA_GROUP_7856_1234 ,		
    DMA_GROUP_7856_2341 ,			
    DMA_GROUP_7856_3412 ,			
    DMA_GROUP_7856_4123 ,			
    DMA_GROUP_8567_1234 ,		
    DMA_GROUP_8567_2341 ,			
    DMA_GROUP_8567_3412 ,			
    DMA_GROUP_8567_4123 ,			
    DMA_GROUP_ALL
}
dma_group_order;

/*----DMA Group Arbi Mode------*/
typedef enum
{
    DMA_MODE_RR = 0,		/*ѯʽ,DMAЧ*/
    DMA_MODE_8PRI,			/*ÿĸͨһ飬ߴӵλλֳ8
    						   :1234_5678,1>2>3>4>5>6>7>8*/
    DMA_MODE_4PRI,			/*:1234_5678,1>2>3>4,5>6>7>8,12345678ͬȼ*/
    DMA_MODE_2PRI,			/*:1234_5678,1234>5678*/
    DMA_MODE_ALL
}dma_group_mode;

/*dma channel reg define*/
typedef struct
{
    volatile unsigned int src_addr;     			/**< offset:0x0,   	R/W      		 */
    volatile unsigned int dest_addr;   				/**< offset:0x4,   	R/W      		 */
    volatile unsigned int xpara;              		/**< offset:0x8,   	R/W      		 */
    volatile unsigned int yzpara;     				/**< offset:0xc,   	R/W      		 */
    volatile unsigned int src_yzstep;    			/**< offset:0x10,  R/W      		 */
    volatile unsigned int dest_yzstep;  			/**< offset:0x14,  R/W      		 */
    volatile unsigned int reserved0;				/**< offset:0x18,  R/W      		 */
    volatile unsigned int link_addr;               	/**< offset:0x1c,  	R/W      		 */
    volatile unsigned int control;                   /**< offset:0x20,  	R/W      	 */
    volatile unsigned int reserved1[7];   	
}dma_chan_reg;

/*dma device reg module define*/
typedef struct 
{
    dma_chan_reg  channel[32];
    volatile unsigned int  int_tc_status;         		/**< offset:0x800,   	R       	 */
    volatile unsigned int  int_src_err_status;     		/**< offset:0x804,   	R       	 */
    volatile unsigned int  int_dest_err_status;    		/**< offset:0x808,   	R       	 */
    volatile unsigned int  int_cfg_err_status;     		/**< offset:0x80c,   	R       	 */
    volatile unsigned int  raw_int_tc_status;      		/**< offset:0x810,		R/C      	 */
    volatile unsigned int  raw_int_src_err_status;  	/**< offset:0x814,  	R/C      	 */
    volatile unsigned int  raw_int_dest_err_status; 	/**< offset:0x818,  	R/C      	 */
    volatile unsigned int  raw_int_cfg_err_status;  	/**< offset:0x81c,  	R/C      	 */
    volatile unsigned int  working_status;       		/**< offset:0x820,   	R       	 */
    volatile unsigned int  group_order;          		/**< offset:0x824,  	R/W      	 */
    volatile unsigned int  arbit_mode;           		/**< offset:0x828,  	R/W      	 */
    volatile unsigned int  irq_type;             		/**< offset:0x82c,  	R/W      	 */
}dma_regs;

signed int zx29_dma_request(dma_peripheral_id peripheralID);
signed int	zx29_dma_config(unsigned int channel,dma_channel_def *tChanPar);
signed int zx29_dma_start(unsigned int channel);
signed int zx29_dma_stop(unsigned int channel);
signed int zx29_dma_get_transfer_num(unsigned int channel_id);// add by gsn for linuxDMA
signed int  zx29_dma_set_priority(dma_group_order groupOrder,  dma_group_mode  groupMode);

unsigned int zx29_dma_get_status(void);
bool zx29_dma_filter_fn(struct dma_chan *chan, void *param);


#endif 

