/*
 * arch/arm/mach-zx297520v2/include/mach/iomap.h
 *
 *  Copyright (C) 2015 ZTE-TSP
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef IOMAP_H
#define IOMAP_H

#include <asm/pgtable.h>

/*virtual address 0xf8000000--0xfeffffff  for static io remap*/
#define ZX29_ADDR_BASE						(0xf8000000)

#ifndef __ASSEMBLY__
#define ZX29_ADDR(x)						((void __iomem __force *)ZX29_ADDR_BASE + (x))
#else
#define ZX29_ADDR(x)						(ZX29_ADDR_BASE + (x))
#endif

/**************************************************************************************
 *                   virtual address  (need remap)                        
 **************************************************************************************/
#define ZX_A9_PERIPHERAL_BASE    			ZX29_ADDR(0x0)
#define ZX_A9_PERIPHERAL_SIZE    			(SZ_1M)

#define ZX_L2CACHE_CONFIG_BASE   			ZX29_ADDR(0x100000)
#define ZX_L2CACHE_CONFIG_SIZE   			(SZ_1M)

#define ZX_IRAM0_BASE        				ZX29_ADDR(0x200000)
#define ZX_IRAM0_SIZE        				(SZ_128K)

#define ZX_IRAM1_BASE        				ZX29_ADDR(0x300000)
#define ZX_IRAM1_SIZE        				(SZ_1M)  /*(SZ_64K)*/

#define ZX_IRAM2_BASE        				ZX29_ADDR(0x400000)
#define ZX_IRAM2_SIZE        				(SZ_16K)

#define ZX_A1_BASE        					(ZX_IRAM1_BASE + 0x30000)
//#define ZX_A1_BASE        					ZX29_ADDR(0x800000)
//#define ZX_A1_SIZE        					(SZ_128K)

#define ZX_AHB_CFG_BASE        				ZX29_ADDR(0x500000)
#define ZX_AHB_CFG_SIZE        				(SZ_1M)

#define ZX_USB_BASE        					ZX29_ADDR(0x600000)
#define ZX_USB_SIZE        					(SZ_256K)

#define USB_GLOBAL_SIZE					    0x400	
#define USB_DEVICE_SIZE						0x600
#define USB_PWR_CLK_SIZE					0x200

#define ZX_HSIC_BASE        				ZX29_ADDR(0x700000)
#define ZX_HSIC_SIZE        				(SZ_256K)

#define ZX_APB_CFG_BASE        				ZX29_ADDR(0x800000)
#define ZX_APB_CFG_SIZE        				(SZ_64K)

#define ZX_LSP_BASE        					ZX29_ADDR(0x900000)
#define ZX_LSP_SIZE        					(SZ_1M)


/**************************************************************************************
 *                   virtual address  (for driver)                        
 **************************************************************************************/
#define ZX_KEY_BASE        					(ZX_A1_BASE)
#define ZX_UART0_BASE        				(ZX_A1_BASE + 0x1000)
#define ZX_PMIC_I2C_BASE      				(ZX_A1_BASE + 0x2000)
#define ZX_RTC_BASE      					(ZX_A1_BASE + 0x3000)
#define ZX_PCU_BASE      					(ZX_A1_BASE + 0xA000)
#define ZX_TOP_CRM_BASE      				(ZX_A1_BASE + 0xB000)
#define ZX_PAD_CTRL_BASE      				(ZX_A1_BASE + 0xC000)
#define ZX_GPIO0_BASE      					(ZX_A1_BASE + 0xD000)
#define ZX_GPIO1_BASE      					(ZX_A1_BASE + 0xE000)
#define ZX_SOC_SYS_BASE      				(ZX_A1_BASE + 0x10000)
#define ZX_AP_TIMER1_BASE     				(ZX_A1_BASE + 0x13000)
#define ZX_AP_TIMER2_BASE     				(ZX_A1_BASE + 0x14000)
#define ZX_AP_TIMER3_BASE     				(ZX_A1_BASE + 0x16000)

#define ZX_RM_TIMER0_BASE     				(ZX_A1_BASE + 0x12000)//
#define ZX_RM_TIMER1_BASE     				(ZX_A1_BASE + 0x15000)//
#define ZX_PS_TIMER1_BASE     				(ZX_A1_BASE + 0x8000)//
#define ZX_PS_TIMER2_BASE     				(ZX_A1_BASE + 0x9000)//
#define ZX_PS_TIMER0_BASE     				(ZX_LSP_BASE + 0x1000)//
#define ZX_PS_RM_TIMER_BASE     			(ZX_LSP_BASE + 0xB000)//


#define ZX_EDCP_BASE       					(ZX_AHB_CFG_BASE)
#define ZX_SD0_BASE       					(ZX_AHB_CFG_BASE + 0x10000)
#define ZX_SD1_BASE       					(ZX_AHB_CFG_BASE + 0x11000)
#define ZX_NAND_REG_BASE      				(ZX_AHB_CFG_BASE + 0x14000)
#define ZX_NAND_DATA_BASE     				(ZX_AHB_CFG_BASE + 0x15000)
#define ZX_DDR_CTRL_BASE     				(ZX_AHB_CFG_BASE + 0x16000)
#define ZX_DDR_PHY_BASE     				(ZX_AHB_CFG_BASE + 0x1A000)
#define ZX_EFUSE_BASE     					(ZX_AHB_CFG_BASE + 0x1B000)
#define ZX_RSA_BASE     					(ZX_AHB_CFG_BASE + 0x1C000)
#define ZX_HASH_BASE     					(ZX_AHB_CFG_BASE + 0x1D000)

#define ZX_DMA_PHY_BASE       				(ZX_APB_CFG_BASE)
#define ZX_DMA_PS_BASE       				(ZX_APB_CFG_BASE + 0x1000)
#define ZX_ICP_BASE       					(ZX_APB_CFG_BASE + 0x2000)
#define ZX_PIN_MUX_BASE       				(ZX_APB_CFG_BASE + 0x3000)
#define ZX_MATRIX_CRM_BASE       			(ZX_APB_CFG_BASE + 0x6000)
#define ZX_GMAC_BASE       					(ZX_APB_CFG_BASE + 0x7000)

#define ZX_LSP_CRPM_BASE       				(ZX_LSP_BASE)
#define ZX_I2S0_BASE       					(ZX_LSP_BASE + 0x5000)
#define ZX_I2S1_BASE       					(ZX_LSP_BASE + 0x6000)
#define ZX_SPIFC0_BASE       				(ZX_LSP_BASE + 0x7000)
#define ZX_UART1_BASE       				(ZX_LSP_BASE + 0x8000)
#define ZX_I2C1_BASE       					(ZX_LSP_BASE + 0x9000)
#define ZX_SSP0_BASE       					(ZX_LSP_BASE + 0xA000)
#define ZX_UART2_BASE       				(ZX_LSP_BASE + 0xD000)
#define ZX_AP_WDT_BASE       				(ZX_LSP_BASE + 0xE000)
#define ZX_AP_TIMER0_BASE       			(ZX_LSP_BASE + 0xF000)
#define ZX_SSP1_BASE       					(ZX_LSP_BASE + 0x10000)
#define ZX_AP_TIMER4_BASE       			(ZX_LSP_BASE + 0x11000)
#define ZX_TDM_BASE       					(ZX_LSP_BASE + 0x12000)

#define	GIC_DIST_BASE  						(ZX_A9_PERIPHERAL_BASE + 0x1000)
#define GIC_CPU_BASE   						(ZX_A9_PERIPHERAL_BASE + 0x100)
#define A9_CRM_BASE   						(ZX_A9_PERIPHERAL_BASE + 0x3000)
#define A9_CFG_REGS_BASE   					(ZX_A9_PERIPHERAL_BASE + 0x4000)

/**************************************************************************************
 *                        physical address (need map)                         
 **************************************************************************************/
#define ZX29_A9_PERIPHERAL_PHYS    	(0x00800000)					/*4MB*/
#define ZX29_L2CACHE_CONFIG_PHYS   	(0x00c00000)					/*1MB*/
#define ZX29_IRAM0_PHYS        		(0x82000000)					/*128KB*/
#define ZX29_IRAM1_PHYS        		(0x100000)						/*64KB*/
#define ZX29_IRAM2_PHYS        		(0x80000)						/*64KB*/
#define ZX29_A1_PHYS        			(0x130000)						/*128KB*/
#define ZX29_AHB_CFG_PHYS       		(0x1200000)						/*1MB*/
#define ZX29_USB_PHYS       			(0x1500000)						/*256KB*/
#define ZX29_USB_GLOBAL_REG			ZX29_USB_PHYS	/*1KB*/
#define ZX29_USB_DEVICE_REG			(ZX29_USB_PHYS + 0x800)	/*1.5KB*/
#define ZX29_USB_PWR_CLK_REG			(ZX29_USB_PHYS + 0xE00)	/*0.5KB*/
#define ZX29_HSIC_PHYS       			(0x1600000)						/*256KB*/
#define ZX29_APB_CFG_PHYS       		(0x1300000)						/*1MB*/
#define ZX29_LSP_PHYS       			(0x1400000)						/*1MB*/

#define ZX29_UART0_PHYS       		(0x131000)
#define ZX29_UART1_PHYS       		(0x01408000)
#define ZX29_UART2_PHYS       		(0x0140d000)
#define ZX29_SSP0_PHYS               (0x0140a000)
#define ZX29_SSP1_PHYS               (0x01410000)
#define ZX297520_SD0            ZX29_ADDR(0x01210000)
#define ZX297520_SD1            ZX29_ADDR(0x01540000)
#define ZX297520_A1_SOC_SYS     ZX29_ADDR(0x00140000)
#define ZX297520_A1_PAD_CTRL0   ZX29_ADDR(0x0013c000)
#define ZX29_SPIFC0_PHYS       				(ZX29_LSP_PHYS+0x7000)

/**************************************************************************************
 *                        iram: icp/spinlock/poweron_type
 **************************************************************************************/
#define ZX_RPMSG_DDR_BASE 					(ICP_MEM_BASE)//(0x25500000)	/* 1M */

#define ZX29_ICP_APM0_REG 					(ZX_ICP_BASE + 0x188)
#define ZX29_ICP_APM0_REG_SIZE 				SZ_1K
	
#define ZX29_ICP_APPS_REG 					(ZX_ICP_BASE + 0xf8)
#define ZX29_ICP_APPS_REG_SIZE 				SZ_1K

#define ICP_IRAM_BASE 						(ZX_IRAM0_BASE + 0x1B000)	/* TBD, total 12K */

#define ICP_MSG_MODEM_SIZE          		(0x1400)      /* just for ARM0 & ARM1 & M0 communication */
#define ICP_IRAM_AP_BASE  					(ICP_IRAM_BASE + ICP_MSG_MODEM_SIZE) /* for AP&M0&PS */ 
#define SPINLOCK_SOFTLOCK_BASE 				(ICP_IRAM_BASE + 0x25C0)
#define DMA_PUB_CONFIG_BASE 				(SPINLOCK_SOFTLOCK_BASE + 0x100)
#define POWERON_TYPE_BASE 					(SPINLOCK_SOFTLOCK_BASE + 0x200)	/* 0x40 bytes */

#define WDT_IRAM_BASE						(POWERON_TYPE_BASE + 0x10c)/*wdt iram flag 36byte*/

/**************************************************************************************
 *                        iram: tsc
 **************************************************************************************/
/* 1K?????y?Y??  */
#define IRAM_TSC_BASE              (ZX_IRAM0_BASE + 0x0001f400)


#endif

