/*
 * arch/arm/mach-zx297520v2/include/mach/pcu_def.h
 *
 * Copyright (C) 2015 ZTE-TSP
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

struct zx29_pcu_config_info 
{
	PCU_INT_INDEX			index;
	unsigned 				gic_index;
	unsigned 				status_index;	/* index to PCU_INT_READOUT_REG */
	char *					int_name;
	unsigned int 			irq_type;		/*irq type enter to pcu*/
	struct zx29_reg_conf    int_type_reg;
	struct zx29_reg_conf    int_pol_reg;
	struct zx29_reg_conf    int_clr_reg;	
};

static struct zx29_pcu_config_info pcu_info[] = 
{
	{
		.index			= PCU_AP_TIMER1_INT, 
	 	.gic_index		= AP_TIMER1_INT, 
	 	.status_index	= 46,
	 	.int_name		= "ap_timer1",
	 	.irq_type		= IRQ_TYPE_EDGE_RISING,
	 	.int_type_reg	= {PCU_INT_TYPE_REG1, 22, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG1, 22, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG1, 22, 1},	 	
	},
	{
		.index			= PCU_AP_TIMER2_INT, 
	 	.gic_index		= AP_TIMER2_INT, 
	 	.status_index	= 47,
	 	.int_name		= "ap_timer2", 
	 	.irq_type		= IRQ_TYPE_EDGE_RISING,
	 	.int_type_reg	= {PCU_INT_TYPE_REG1, 23, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG1, 23, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG1, 23, 1},	 	
	},
	{
		.index			= PCU_ICP_PS2AP_INT, 
	 	.gic_index		= ICP_PS2AP_INT,
	 	.status_index	= 48,
	 	.int_name		= "icp_ps2ap",
	 	.irq_type		= IRQ_TYPE_LEVEL_HIGH,
	 	.int_type_reg	= {PCU_INT_TYPE_REG1, 20, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG1, 20, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG1, 20, 1}, 	
	},	
	{
		.index			= PCU_USB_POWERDWN_UP_INT, 
	 	.gic_index		= USB_POWERDWN_UP_INT,
	 	.status_index	= 4,	 	
	 	.int_name		= "usb_up",
	 	.irq_type		= IRQ_TYPE_EDGE_RISING,
	 	.int_type_reg	= {PCU_INT_TYPE_REG1, 7, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG1, 7, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG1, 7, 1}, 	
	},	
	{
		.index			= PCU_USB_POWERDWN_DOWN_INT, 
	 	.gic_index		= USB_POWERDWN_DOWN_INT,
	 	.status_index	= 5,	 	
	 	.int_name		= "usb_down",
	 	.irq_type		= IRQ_TYPE_EDGE_FALLING,	 	
	 	.int_type_reg	= {PCU_INT_TYPE_REG1, 8, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG1, 8, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG1, 8, 1}, 	
	},		
	{
		.index			= PCU_HSIC_POWERDWN_UP_INT, 
	 	.gic_index		= HSIC_POWERDWN_UP_INT,
	 	.status_index	= 6,	 	
	 	.int_name		= "hsic_up",
	 	.irq_type		= IRQ_TYPE_EDGE_RISING,
	 	.int_type_reg	= {PCU_INT_TYPE_REG1, 9, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG1, 9, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG1, 9, 1}, 	
	},			
	{
		.index			= PCU_HSIC_POWERDWN_DOWN_INT, 
	 	.gic_index		= HSIC_POWERDWN_DOWN_INT,
	 	.status_index	= 7,	 	
	 	.int_name		= "hsic_down",
	 	.irq_type		= IRQ_TYPE_EDGE_FALLING,	 		 	
	 	.int_type_reg	= {PCU_INT_TYPE_REG1, 10, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG1, 10, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG1, 10, 1}, 	
	},	
	{
		.index			= PCU_ICP_M02AP_INT, 
	 	.gic_index		= ICP_M02AP_INT,
	 	.status_index	= 49,	 	
	 	.int_name		= "icp_m02ap",
	 	.irq_type		= IRQ_TYPE_LEVEL_HIGH,
	 	.int_type_reg	= {PCU_INT_TYPE_REG1, 21, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG1, 21, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG1, 21, 1}, 	
	},		
	{
		.index			= PCU_RTC_ALARM_INT, 
	 	.gic_index		= RTC_ALARM_INT,
	 	.status_index	= 10,	 	
	 	.int_name		= "alarm",
	 	.irq_type		= IRQ_TYPE_LEVEL_LOW,
	 	.int_type_reg	= {PCU_INT_TYPE_REG1, 13, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG1, 13, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG1, 13, 1}, 	
	},		
	{
		.index			= PCU_RTC_TIMER_INT, 
	 	.gic_index		= RTC_TIMER_INT,
	 	.status_index	= 11,	 	
	 	.int_name		= "rtc_timer",
	 	.irq_type		= IRQ_TYPE_LEVEL_LOW,	 	
	 	.int_type_reg	= {PCU_INT_TYPE_REG1, 14, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG1, 14, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG1, 14, 1}, 	
	},	
	{
		.index			= PCU_KEYPAD_INT, 
	 	.gic_index		= KEYPAD_INT,
	 	.status_index	= 12,	 	
	 	.int_name		= "keypad",
	 	.irq_type		= IRQ_TYPE_EDGE_RISING,
	 	.int_type_reg	= {PCU_INT_TYPE_REG1, 15, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG1, 15, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG1, 15, 1}, 	
	},
	{
		.index			= PCU_SD1_DATA1_INT, 
	 	.gic_index		= SD1_DATA1_INT,
	 	.status_index	= 13,	 	
	 	.int_name		= "sd1_data1",
	 	.irq_type		= IRQ_TYPE_LEVEL_LOW,
	 	.int_type_reg	= {PCU_INT_TYPE_REG1, 16, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG1, 16, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG1, 16, 1}, 	
	},	
	{
		.index			= PCU_UART0_CTS_INT, 
	 	.gic_index		= UART0_CTS_INT,
	 	.status_index	= 14,	 	
	 	.int_name		= "uart0_cts",
	 	.irq_type		= IRQ_TYPE_LEVEL_LOW,
	 	.int_type_reg	= {PCU_INT_TYPE_REG1, 17, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG1, 17, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG1, 17, 1}, 	
	},	
	{
		.index			= PCU_SPCU_PW_INT, 
	 	.gic_index		= SPCU_PW_INT,
	 	.status_index	= 15,	 	
	 	.int_name		= "spcu_pw",
	 	.irq_type		= IRQ_TYPE_LEVEL_HIGH,
	 	.int_type_reg	= {PCU_INT_TYPE_REG1, 18, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG1, 18, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG1, 18, 1}, 	
	},	
	{
		.index			= PCU_EX0_INT, 
	 	.gic_index		= EX0_INT,
	 	.status_index	= 25,
	 	.int_name		= "ext0_int",
	 	.irq_type		= IRQ_TYPE_DEFAULT,		/*ext int type need configured by driver*/
	 	.int_type_reg	= {PCU_INT_TYPE_REG3, 2, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG3, 2, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG3, 2, 1}, 	
	},	
	{
		.index			= PCU_EX1_INT, 
	 	.gic_index		= EX1_INT,
	 	.status_index	= 26,	 	
	 	.int_name		= "ext1_int",
	 	.irq_type		= IRQ_TYPE_DEFAULT,	 	
	 	.int_type_reg	= {PCU_INT_TYPE_REG3, 3, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG3, 3, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG3, 3, 1}, 	
	},	
	{
		.index			= PCU_EX2_INT, 
	 	.gic_index		= EX2_INT,
	 	.status_index	= 27,	 	
	 	.int_name		= "ext2_int",
	 	.irq_type		= IRQ_TYPE_DEFAULT,	 	
	 	.int_type_reg	= {PCU_INT_TYPE_REG3, 4, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG3, 4, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG3, 4, 1}, 	
	},	
	{
		.index			= PCU_EX3_INT, 
	 	.gic_index		= EX3_INT,
	 	.status_index	= 28,	 	
	 	.int_name		= "ext3_int",
	 	.irq_type		= IRQ_TYPE_DEFAULT,	 	
	 	.int_type_reg	= {PCU_INT_TYPE_REG3, 5, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG3, 5, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG3, 5, 1}, 	
	},	
	{
		.index			= PCU_EX4_INT, 
	 	.gic_index		= EX4_INT,
	 	.status_index	= 29,	 	
	 	.int_name		= "ext4_int",
	 	.irq_type		= IRQ_TYPE_DEFAULT,	 	
	 	.int_type_reg	= {PCU_INT_TYPE_REG3, 6, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG3, 6, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG3, 6, 1}, 	
	},	
	{
		.index			= PCU_EX5_INT, 
	 	.gic_index		= EX5_INT,
	 	.status_index	= 30,	 	
	 	.int_name		= "ext5_int",
	 	.irq_type		= IRQ_TYPE_DEFAULT,	 	
	 	.int_type_reg	= {PCU_INT_TYPE_REG3, 7, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG3, 7, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG3, 7, 1}, 	
	},	
	{
		.index			= PCU_EX6_INT, 
	 	.gic_index		= EX6_INT,
	 	.status_index	= 31,	 	
	 	.int_name		= "ex6_int",
	 	.irq_type		= IRQ_TYPE_DEFAULT,	 	
	 	.int_type_reg	= {PCU_INT_TYPE_REG3, 8, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG3, 8, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG3, 8, 1}, 	
	},	
	{
		.index			= PCU_EX7_INT, 
	 	.gic_index		= EX7_INT,
	 	.status_index	= 32,	 	
	 	.int_name		= "ex7_int",
	 	.irq_type		= IRQ_TYPE_DEFAULT,		 	
	 	.int_type_reg	= {PCU_INT_TYPE_REG3, 9, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG3, 9, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG3, 9, 1}, 	
	},		
	{
		.index			= PCU_EX8_INT, 
	 	.gic_index		= EX8IN1_INT,
	 	.status_index	= 33,	 	
	 	.int_name		= "ext8_int",
	 	.irq_type		= IRQ_TYPE_DEFAULT,		 	
	 	.int_type_reg	= {PCU_INT_TYPE_REG3, 10, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG3, 10, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG3, 10, 1}, 	
	},	
	{
		.index			= PCU_EX9_INT, 
	 	.gic_index		= EX8IN1_INT,
	 	.status_index	= 34,	 	
	 	.int_name		= "ext9_int",
	 	.irq_type		= IRQ_TYPE_DEFAULT,		 	
	 	.int_type_reg	= {PCU_INT_TYPE_REG3, 11, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG3, 11, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG3, 11, 1}, 	
	},	
	{
		.index			= PCU_EX10_INT, 
	 	.gic_index		= EX8IN1_INT,
	 	.status_index	= 35,	 	
	 	.int_name		= "ext10_int",
	 	.irq_type		= IRQ_TYPE_DEFAULT,		 	
	 	.int_type_reg	= {PCU_INT_TYPE_REG3, 12, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG3, 12, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG3, 12, 1}, 	
	},	
	{
		.index			= PCU_EX11_INT, 
	 	.gic_index		= EX8IN1_INT,
	 	.status_index	= 36,	 	
	 	.int_name		= "ext11_int",
	 	.irq_type		= IRQ_TYPE_DEFAULT,		 	
	 	.int_type_reg	= {PCU_INT_TYPE_REG3, 13, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG3, 13, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG3, 13, 1}, 	
	},	
	{
		.index			= PCU_EX12_INT, 
	 	.gic_index		= EX8IN1_INT,
	 	.status_index	= 37,	 	
	 	.int_name		= "ext12_int",
	 	.irq_type		= IRQ_TYPE_DEFAULT,		 	
	 	.int_type_reg	= {PCU_INT_TYPE_REG3, 14, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG3, 14, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG3, 14, 1}, 	
	},	
	{
		.index			= PCU_EX13_INT, 
	 	.gic_index		= EX8IN1_INT,
	 	.status_index	= 38,	 	
	 	.int_name		= "ext13_int",
	 	.irq_type		= IRQ_TYPE_DEFAULT,		 	
	 	.int_type_reg	= {PCU_INT_TYPE_REG3, 15, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG3, 15, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG3, 15, 1}, 	
	},	
	{
		.index			= PCU_EX14_INT, 
	 	.gic_index		= EX8IN1_INT,
	 	.status_index	= 39,
	 	.int_name		= "ex14_int",
	 	.irq_type		= IRQ_TYPE_DEFAULT,		 	
	 	.int_type_reg	= {PCU_INT_TYPE_REG3, 16, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG3, 16, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG3, 16, 1}, 	
	},	
	{
		.index			= PCU_EX15_INT, 
	 	.gic_index		= EX8IN1_INT,
	 	.status_index	= 40,
	 	.int_name		= "ex15_int",
	 	.irq_type		= IRQ_TYPE_DEFAULT,		 	
	 	.int_type_reg	= {PCU_INT_TYPE_REG3, 17, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG3, 17, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG3, 17, 1}, 	
	},		
	{
		.index			= PCU_SD0_DATA1_INT, 
	 	.gic_index		= SD0_DATA1_INT,
	 	.status_index	= 0,	 	
	 	.int_name		= "sd0_data1",
	 	.irq_type		= IRQ_TYPE_LEVEL_LOW,	 	
	 	.int_type_reg	= {PCU_INT_TYPE_REG1, 3, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG1, 3, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG1, 3, 1}, 	
	},	
	{
		.index			= PCU_GMAC_INT, 
	 	.gic_index		= GMAC_INT,
	 	.status_index	= 61,	 					/* not list in datasheet */
	 	.int_name		= "gmac_int",
	 	.irq_type		= IRQ_TYPE_LEVEL_HIGH,
	 	.int_type_reg	= {PCU_INT_TYPE_REG1, 2, 1},
	 	.int_pol_reg	= {PCU_INT_POLARITY_REG1, 2, 1},
	 	.int_clr_reg	= {PCU_INT_CLEAR_REG1, 2, 1}, 	
	},	
};



static PCU_INT_INDEX pcu_table_by_gic[] = 
{
	PCU_UNKNOWN_INT,			/* WDT_INT */
	PCU_UNKNOWN_INT,			/* UART0_MIX_INT */
	PCU_UNKNOWN_INT,			/* UART2_MIX_INT */
	PCU_UNKNOWN_INT,			/* SSP0_INT	*/
	PCU_RTC_ALARM_INT,			/* RTC_ALARM_INT */
	
	PCU_RTC_TIMER_INT,			/* RTC_TIMER_INT */
	PCU_UNKNOWN_INT,			/* I2S0_INT	*/
	PCU_UNKNOWN_INT,			/* I2S1_INT	*/
	PCU_UNKNOWN_INT,			/* I2C1_INT	*/
	PCU_UNKNOWN_INT,			/* I2C0_INT	*/
	
	PCU_KEYPAD_INT,				/* KEYPAD_INT */
	PCU_UNKNOWN_INT,			/* SD1_INT */
	PCU_UNKNOWN_INT,			/* SD0_INT */
	PCU_ICP_PS2AP_INT,			/* ICP_PS2AP_INT */
	PCU_ICP_M02AP_INT,			/* ICP_M02AP_INT */
	
	PCU_UNKNOWN_INT,			/* AP_TIMER0_INT */
	PCU_AP_TIMER1_INT,			/* AP_TIMER1_INT */
	PCU_AP_TIMER2_INT,			/* AP_TIMER2_INT */
	PCU_UNKNOWN_INT,			/* GSM_SYS0_INT */
	PCU_UNKNOWN_INT,			/* GSM_SYS1_INT */
	
	PCU_UNKNOWN_INT,			/* GSM_SYS2_INT */
	PCU_UNKNOWN_INT,			/* GSM_SYS3_INT */
	PCU_UNKNOWN_INT,			/* GSM_SYS4_INT */
	PCU_UNKNOWN_INT,			/* GSM_SYS5_INT */	
	PCU_UNKNOWN_INT,			/* GSM_SYS6_INT */
	
	PCU_UNKNOWN_INT,			/* GSM_SYS7_INT */
	PCU_UNKNOWN_INT,			/* GSM_SYS8_INT */
	PCU_UNKNOWN_INT,			/* GSM_SYS9_INT */
	PCU_UNKNOWN_INT,			/* GSM_SYS10_INT */
	PCU_UNKNOWN_INT,			/* GSM_SYS11_INT */	
	
	PCU_UNKNOWN_INT,			/* GSM_SYS12_INT */
	PCU_UNKNOWN_INT,			/* GSM_SYS13_INT */
	PCU_SPCU_PW_INT,			/* SPCU_PW_INT */
	PCU_UNKNOWN_INT,			/* GSM_SYS14_INT */
	PCU_UNKNOWN_INT,			/* PS_DMA_INT */
	
	PCU_UNKNOWN_INT,			/* NAND_INT */
	PCU_UNKNOWN_INT,			/* USB_INT */
	PCU_USB_POWERDWN_UP_INT,	/* USB_POWERDWN_UP_INT */
	PCU_USB_POWERDWN_DOWN_INT, 	/* USB_POWERDWN_DOWN_INT */
	PCU_UNKNOWN_INT,			/* HSIC_INT	*/
	
	PCU_HSIC_POWERDWN_UP_INT,	/* HSIC_POWERDWN_UP_INT */
	PCU_HSIC_POWERDWN_DOWN_INT,	/* HSIC_POWERDWN_DOWN_INT */
	PCU_UNKNOWN_INT,			/* RESERVED_INT */
	PCU_UNKNOWN_INT,			/* GSM_USIM_INT	*/
	PCU_UNKNOWN_INT,			/* EX8IN1_INT -- this int doesn't face to user */
	
	PCU_EX0_INT,				/* EX0_INT */
	PCU_EX1_INT,				/* EX1_INT */
	PCU_EX2_INT,				/* EX2_INT */
	PCU_EX3_INT,				/* EX3_INT */
	PCU_EX4_INT,				/* EX4_INT */

	PCU_EX5_INT,				/* EX5_INT */
	PCU_EX6_INT,				/* EX6_INT */
	PCU_EX7_INT,				/* EX7_INT */
	PCU_SD1_DATA1_INT,			/* SD1_DATA1_INT */
	PCU_UART0_CTS_INT,			/* UART0_CTS_INT */
	
	PCU_UNKNOWN_INT,			/* SPI_FC0_INT */
	PCU_UNKNOWN_INT,			/* SSP1_INT */
	PCU_SD0_DATA1_INT,			/* SD0_DATA1_INT */
	PCU_UNKNOWN_INT,			/* EFUSE_INT */
	PCU_UNKNOWN_INT,			/* RSA_INT */
	
	PCU_UNKNOWN_INT,			/* HASH_INT */
	PCU_GMAC_INT,				/* GMAC_INT	*/
	PCU_UNKNOWN_INT,			/* AP_TIMER3_INT */
	PCU_UNKNOWN_INT,			/* AP_TIMER4_INT */
	PCU_EX8_INT,				/* EX8_INT */
	
	PCU_EX9_INT,				/* EX9_INT */
	PCU_EX10_INT,				/* EX10_INT */
	PCU_EX11_INT,				/* EX11_INT */
	PCU_EX12_INT,				/* EX12_INT */
	PCU_EX13_INT,				/* EX13_INT */
	
	PCU_EX14_INT,				/* EX14_INT */
	PCU_EX15_INT,				/* EX15_INT */	
};

/**
 * helper function
 * 
 * get pcu index by gic. 
 * For speed in irq_handler, we use table.
 */
static inline PCU_INT_INDEX pcu_get_index_by_gic(unsigned gic_index)
{
	if((gic_index<WDT_INT) || (gic_index>EX15_INT))
		return PCU_UNKNOWN_INT;
	else
		return pcu_table_by_gic[gic_index-WDT_INT];
}

