/*
 * linux/arch/arm/mach-zx297520v2/gpio.c
 *
 * Copyright (C) 2013 ZTE-TSP
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <linux/clk.h>
#include <linux/errno.h>
#include <linux/interrupt.h>
#include <linux/irq.h>
#include <linux/debugfs.h>
#include <linux/seq_file.h>
#include <linux/kernel.h>
#include <linux/list.h>
#include <linux/module.h>
#include <linux/io.h>

#include <mach/iomap.h>
#include <mach/gpio.h>
#include <mach/gpio_def.h>
#include <mach/pcu.h>
#include <mach/debug.h>
#include <mach/spinlock.h>

#define	GPIO0_NUM	128

#define	gpio_write_reg_lock(a, v)	\
        do {    \
			reg_spin_lock(); \
            zx_write_reg(a, v);    \
            reg_spin_unlock(); \
        } while (0)

#define	gpio_write_bits_lock(a, o, w, v)	\
        do {    \
			reg_spin_lock(); \
            zx_write_bits(a, o, w, v);    \
            reg_spin_unlock(); \
        } while (0)

static gpio_func_id g_gpiofunc_id[] ={
	GPIO0_GPIO0,		GPIO1_GPIO1,	  GPIO2_GPIO2,	GPIO3_GPIO3,    GPIO4_GPIO4,	GPIO5_GPIO5,		GPIO6_GPIO6,	  GPIO7_GPIO7,	GPIO8_GPIO8, GPIO9_GPIO9,
	GPIO10_GPIO10,	GPIO11_GPIO11,GPIO12_GPIO12,	GPIO13_GPIO13, GPIO14_GPIO14,	GPIO15_GPIO15, 	GPIO16_GPIO16,GPIO17_GPIO17, 	GPIO18_GPIO18, GPIO19_GPIO19,
	GPIO20_GPIO20,	GPIO21_GPIO21,GPIO22_GPIO22,	GPIO23_GPIO23, GPIO24_GPIO24,	GPIO25_GPIO25,	GPIO26_GPIO26,GPIO27_GPIO27,	GPIO28_GPIO28, GPIO29_GPIO29,
	GPIO30_GPIO30,	GPIO31_GPIO31,GPIO32_GPIO32,	GPIO33_GPIO33, GPIO34_GPIO34,	GPIO35_GPIO35,	GPIO36_GPIO36,GPIO37_GPIO37,	GPIO38_GPIO38, GPIO39_GPIO39,
	GPIO40_GPIO40,	GPIO41_GPIO41,GPIO42_GPIO42,	GPIO43_GPIO43, GPIO44_GPIO44,	GPIO45_GPIO45,	GPIO46_GPIO46,GPIO47_GPIO47,	GPIO48_GPIO48, GPIO49_GPIO49,
	GPIO50_GPIO50,	GPIO51_GPIO51,GPIO52_GPIO52,	GPIO53_GPIO53, GPIO54_GPIO54,	GPIO55_GPIO55,	GPIO56_GPIO56,GPIO57_GPIO57,	GPIO58_GPIO58, GPIO59_GPIO59,
	GPIO60_GPIO60,	GPIO61_GPIO61,GPIO62_GPIO62,	GPIO63_GPIO63, GPIO64_GPIO64,	GPIO65_GPIO65,	GPIO66_GPIO66,GPIO67_GPIO67,	GPIO68_GPIO68, GPIO69_GPIO69,
	GPIO70_GPIO70,	GPIO71_GPIO71,GPIO72_GPIO72,	GPIO73_GPIO73, GPIO74_GPIO74,	GPIO75_GPIO75,	GPIO76_GPIO76,GPIO77_GPIO77,	GPIO78_GPIO78, GPIO79_GPIO79,
	GPIO80_GPIO80,	GPIO81_GPIO81,GPIO82_GPIO82,	GPIO83_GPIO83, GPIO84_GPIO84,	GPIO85_GPIO85,	GPIO86_GPIO86,GPIO87_GPIO87,	GPIO88_GPIO88, GPIO89_GPIO89,
	GPIO90_GPIO90,	GPIO91_GPIO91,GPIO92_GPIO92,	GPIO93_GPIO93, GPIO94_GPIO94,	GPIO95_GPIO95,	GPIO96_GPIO96,GPIO97_GPIO97,	GPIO98_GPIO98, GPIO99_GPIO99,
	GPIO100_GPIO100,	GPIO101_GPIO101,GPIO102_GPIO102,	GPIO103_GPIO103, GPIO104_GPIO104,	GPIO105_GPIO105,	GPIO106_GPIO106,GPIO107_GPIO107,	GPIO108_GPIO108, GPIO109_GPIO109,
	GPIO110_GPIO110,	GPIO111_GPIO111,GPIO112_GPIO112,	GPIO113_GPIO113, GPIO114_GPIO114,	GPIO115_GPIO115,	GPIO116_GPIO116,GPIO117_GPIO117,	GPIO118_GPIO118, GPIO119_GPIO119,
	GPIO120_GPIO120,	GPIO121_GPIO121,GPIO122_GPIO122,	GPIO123_GPIO123, GPIO124_GPIO124,	GPIO125_GPIO125,	GPIO126_GPIO126,GPIO127_GPIO127,	GPIO128_GPIO128, GPIO129_GPIO129,
	GPIO130_GPIO130,	GPIO131_GPIO131,GPIO132_GPIO132,	GPIO133_GPIO133, GPIO134_GPIO134,	GPIO135_GPIO135
};

/*
  * select gpio multiplex function
  * gpio:  		gpio number
  * func:   PIN_FUNC_SEL_AON/PIN_FUNC_SEL_PD
  * 		according with register defination
  */
int zx29_gpio_function_sel(unsigned int gpio, gpio_func_id func )
{
	int i ;
	unsigned int func_sel = (func>>12)&0x1;
	unsigned int value = func&0x3ff;

	if((gpio != (func>>24))||(gpio > ZX29_GPIO_MAX))
		return -EINVAL;

	for(i=0; i<ARRAY_SIZE(pin_info); i++)
	{
		if(pin_info[i].gpio == gpio)
			break;

		/* no support */
		if(pin_info[i].gpio == ZX29_GPIO_NULL)
			return -ENODATA;
    }

	/* no support */
	if(i >= ARRAY_SIZE(pin_info))
		return -ENODATA;

	/* top_func_sel */
	if(pin_info[i].top_func_sel_reg.reg_addr)
		gpio_write_bits_lock(pin_info[i].top_func_sel_reg.reg_addr,
							pin_info[i].top_func_sel_reg.reg_bit_offset,
							pin_info[i].top_func_sel_reg.reg_bit_size,
							func_sel);

	if(PIN_FUNC_SEL_AON == func_sel)
	{
		if(pin_info[i].aon_func_sel_reg.reg_addr)
			gpio_write_bits_lock(pin_info[i].aon_func_sel_reg.reg_addr,
								pin_info[i].aon_func_sel_reg.reg_bit_offset,
								pin_info[i].aon_func_sel_reg.reg_bit_size,
								value);
	}
	else
	{
		if(pin_info[i].pd_func_sel_reg.reg_addr)
			gpio_write_bits_lock(pin_info[i].pd_func_sel_reg.reg_addr,
								pin_info[i].pd_func_sel_reg.reg_bit_offset,
								pin_info[i].pd_func_sel_reg.reg_bit_size,
								value);
	}

	return 0;
}

static unsigned int get_gpio_by_name(const char *pin_name)
{
	int i ;

	for(i=0; i<ARRAY_SIZE(pin_info); i++)
	{
		if (!strcmp(pin_name, pin_info[i].pin_name))
		{
			return pin_info[i].gpio;
		}
	}

	return ZX29_GPIO_NULL;
}

int zx29_func_sel_by_name(const char *pin_name, gpio_func_id func)
{
	unsigned int gpio = get_gpio_by_name(pin_name);

	if(gpio == ZX29_GPIO_NULL)
	{
		pr_err("zx29_func_sel_by_name(%s) failed. \n", pin_name);
		return -ENODATA;
	}

	return zx29_gpio_function_sel(gpio, func);
}

int zx29_gpio_function_sel_get(unsigned int gpio)
{
    int i=0;
	unsigned int func_sel = 0;
	unsigned int top_func = 0;
	unsigned int value = 0;
	unsigned int temp=0,mask=0;

    if(gpio > ZX29_GPIO_MAX)
    	  return -EINVAL;

    for(i=0; i<ARRAY_SIZE(pin_info); i++)
	{
		if(pin_info[i].gpio == gpio)
			break;
		/* not support*/
		if(pin_info[i].gpio == ZX29_GPIO_NULL)
			return -ENODATA;
	}

	/* no support */
	if(i >= ARRAY_SIZE(pin_info))
		return -ENODATA;

    /*top_func*/
    if(pin_info[i].top_func_sel_reg.reg_addr)
    {
		temp=zx_read_reg(pin_info[i].top_func_sel_reg.reg_addr);
		top_func = temp>>(pin_info[i].top_func_sel_reg.reg_bit_offset);

		top_func = top_func&0x01;
    }
	else
	{
		top_func = PIN_FUNC_SEL_AON;
	}

    /*aon_func*/
    if(top_func == PIN_FUNC_SEL_AON)
    {
		if(pin_info[i].aon_func_sel_reg.reg_addr)
		{
			temp  = zx_read_reg(pin_info[i].aon_func_sel_reg.reg_addr);
			value = temp>>(pin_info[i].aon_func_sel_reg.reg_bit_offset);
			mask  =(1<<pin_info[i].aon_func_sel_reg.reg_bit_size)-1;
			value = value&mask;
		}
		else
			value = 0;
    }
    else/*pd_func*/
	{
		if(pin_info[i].pd_func_sel_reg.reg_addr)
		{
			temp  = zx_read_reg(pin_info[i].pd_func_sel_reg.reg_addr);
			value = temp>>(pin_info[i].pd_func_sel_reg.reg_bit_offset);
			mask  =(1<<pin_info[i].pd_func_sel_reg.reg_bit_size)-1;
			value =value&mask;
		}
		else
			value = 0;
	}

	func_sel = (gpio<<24)|(top_func<<12)|value;

 	return   func_sel;
}


/*
 * set gpio resistance of pull-up and pull-down  status
 *@ gpio: gpio pin number
 *@ config: IO_CFG enum
 *@
 *@ This function is only for config pu/pd, if select driver capacity,
 *@   use another interface.
 */
void zx29_gpio_pd_pu_set(unsigned int gpio, unsigned int config)
{
	int i ;
	int pull_val = 0;

	if(gpio > ZX29_GPIO_MAX)
		return;

	for(i=0; i<ARRAY_SIZE(pin_info); i++)
	{
		if(pin_info[i].gpio == gpio)
			break;

		/* no support */
		if(pin_info[i].gpio == ZX29_GPIO_NULL)
			return;
	}

	/* no support */
	if(i >= ARRAY_SIZE(pin_info))
		return;

	if(pin_info[i].io_cfg_reg.reg_addr == NULL)
		return;

	if(pin_info[i].io_cfg_reg.reg_bit_size == 8)
	{
		/*bit6:PD   bit5:PU*/
		pull_val = zx_read_reg(pin_info[i].io_cfg_reg.reg_addr);

		pull_val = pull_val>>(pin_info[i].io_cfg_reg.reg_bit_offset);

		pull_val &= 0xff;		/*reg_bit_size 8*/
		pull_val &= ~(0x3<<5);	/*bit5 bit6 clear*/
		if(config == IO_CFG_PULL_DOWN)
			pull_val |= (0x1<<6);		/*bit6 PD*/
		else if(config == IO_CFG_PULL_UP)
			pull_val |= (0x1<<5);		/*bit5 PU*/

	}
	else
	{
		/*bit0:PE   bit1:PS*/
		pull_val = config;
	}

	gpio_write_bits_lock(pin_info[i].io_cfg_reg.reg_addr,
					pin_info[i].io_cfg_reg.reg_bit_offset,
					pin_info[i].io_cfg_reg.reg_bit_size,
					pull_val);

}
EXPORT_SYMBOL(zx29_gpio_pd_pu_set);

/****************************************************************
 **    gpio function
 **
 ***************************************************************/
/*
 *  set direction
 *
 *  0:input  1:out
 */
void zx29_gpio_set_direction(unsigned int gpio, unsigned int dir)
{
	unsigned int temp=0;
	void __iomem *regaddr = NULL;

	if(ZX29_GPIO_24 == gpio)
	{
		if(GPIO_IN == dir)
			dir = GPIO_OUT;
		else
			dir = GPIO_IN;
	}

	if(gpio < GPIO0_NUM)
		regaddr = GPIOPDD_REG0(gpio);
	else
	{
		gpio -= GPIO0_NUM;
		regaddr = GPIOPDD_REG1(gpio);
	}

	temp = zx_read_reg(regaddr);
	if(dir == GPIO_IN)
		temp &= ~(1 << (gpio % 16));
	else
		temp |= (1 << (gpio % 16));

	gpio_write_reg_lock(regaddr, temp);
}

/*
 *  get direction
 *
 *  0:input  1:out
 */
unsigned int zx29_gpio_get_direction(unsigned int gpio)
{
	unsigned int temp=0;

	if(gpio <GPIO0_NUM)
		temp = zx_read_reg(GPIOPDD_REG0(gpio));
	else
	{
		gpio -= GPIO0_NUM;
		temp = zx_read_reg(GPIOPDD_REG1(gpio));
	}

	temp = temp >> (gpio % 16);
	temp &= 0x1;

	return temp;
}

/*
 *  gpio out
 *
 *  0:low	1:high
 */
void zx29_gpio_output_data(unsigned int gpio, unsigned int value)
{
    unsigned int temp=0;

	if(value == GPIO_LOW)
	{
   		if(gpio <GPIO0_NUM)
   		{
   			temp = zx_read_reg(SET0_SEND_REG0(gpio));
			temp |= (1 << (gpio % 16));
			gpio_write_reg_lock(SET0_SEND_REG0(gpio), temp);
   		}
		else{
			gpio -= GPIO0_NUM;
			temp = zx_read_reg(SET0_SEND_REG1(gpio));
			temp |= (1 << (gpio % 16));
			gpio_write_reg_lock(SET0_SEND_REG1(gpio), temp);
		}
	}else if(value == GPIO_HIGH)
	{
   		if(gpio <GPIO0_NUM)
		{
			temp = zx_read_reg(SET1_SEND_REG0(gpio));
			temp |= (1 << (gpio % 16));
			gpio_write_reg_lock(SET1_SEND_REG0(gpio), temp);
   		}
		else{
			gpio -= GPIO0_NUM;
			temp = zx_read_reg(SET1_SEND_REG1(gpio));
			temp |= (1 << (gpio % 16));
			gpio_write_reg_lock(SET1_SEND_REG1(gpio), temp);
		}
	} else {
		pr_warn("gpio%d output %X ignored.", gpio, value);
	}
}

/*
 *  gpio input
 *
 * gpio_func_id
 */
gpio_func_id zx29_gpio_get_gpiofunc_id(unsigned int gpio)
{
	return g_gpiofunc_id[gpio];
}
EXPORT_SYMBOL(zx29_gpio_get_gpiofunc_id);
/*
 *  gpio input
 *
 *  0:low	1:high
 */
unsigned int zx29_gpio_input_data(unsigned int gpio)
{
	unsigned int value=0;

    if(gpio < GPIO0_NUM)
    	value = zx_read_reg(RECV_REG0(gpio));
	else
	{
		gpio -= GPIO0_NUM;
		value = zx_read_reg(RECV_REG1(gpio));
	}

	return (value >> (gpio % 16)) & 0x1;
}

/*
 * set extern int source type
 *
 * gpio:  gpio number
 *
 * type: IRQ_TYPE_LEVEL_HIGH
 *         IRQ_TYPE_LEVEL_LOW
 *         IRQ_TYPE_EDGE_RISING
 *         IRQ_TYPE_EDGE_FALLING
 */
void zx29_gpio_set_inttype(unsigned int gpio, unsigned int type)
{
    unsigned int index = 0;

	/*****************************
	 ** gpio47~~54   ----   ext0~~7
	 ** gpio119~~126   ----   ext8~~15
	 ** gpio127~~132   ----   ext8~~13
	 *****************************/
	if ((gpio>=47) && (gpio<=54))
		index = gpio - 47 + (unsigned int)PCU_EX0_INT;
	else if ((gpio>=119) && (gpio<=126))
		index = gpio - 119 + (unsigned int)PCU_EX8_INT;
	else if ((gpio>=127) && (gpio<=132))
		index = gpio - 127 + (unsigned int)PCU_EX8_INT;
	else
		return;

	pcu_int_set_type((PCU_INT_INDEX)index,type);
}
EXPORT_SYMBOL(zx29_gpio_set_inttype);

int zx29_gpio2irq(unsigned int gpio)
{
	if ((gpio>=47) && (gpio<=54))
		return(gpio - 47 + EX0_INT);
	else if ((gpio>=119) && (gpio<=126))
		return (gpio - 119 + EX8_INT);
	else if ((gpio>=127) && (gpio<=132))
		return (gpio - 127 + EX8_INT);

  	return -EINVAL;
}

/*********************************************************************************************
 *** jtag0: sd1_cmd/sd1_data0/sd1_data1/sd1_data2/sd1_data3
 ***        pd_func: 0: sd1  1:ps_jtag   2:phy_jtag  3:ap_jtag    aon_func: 0:gpio  1:m0_jtag
 ***
 *** jtag1: jtag_tck/jtag_tdi/jtag_tdo/jtag_tms/jtag_trst
 ***        pd_func: 0: ps_jtag   1:phy_jtag  2:ap_jtag    aon_func: 0:m0_jtag 1:gpio
 ***
 *** jtag2: kbc_0/kbc_2/kbr_0/kbr_1/kbr_2
 ***        pd_func: 0: ps_jtag   1:phy_jtag  2:ap_jtag    aon_func: 0:key 1:gpio 2:ext_int 3:m0_jtag
 ***********************************************************************************************
 */
void jtag_config(unsigned int jtag_num, unsigned int function)
{
    //unsigned int tmp = 0;

	return ;
}

unsigned int zx29_gpio_outputdata_get(unsigned int gpio)
{
    unsigned int temp=0;
	if(gpio <GPIO0_NUM)
		temp = zx_read_reg(SEND_REG0(gpio));
	else
		{
        gpio -=GPIO0_NUM;
		temp = zx_read_reg(SEND_REG1(gpio));
	    }
   return (temp>>(gpio%16))&0x01;
}

#ifdef	CONFIG_DEBUG_FS

#include <linux/debugfs.h>
#include <linux/seq_file.h>
#include <asm/uaccess.h>
#include <asm/string.h>

static char   temp_buf[50],temp[30];
unsigned char buf = 0;

static struct gpio_status{
		char *function;
		char *direction;
		char *level;
    }gpio_status_get;

struct zx29_gpio_def
{
	char *					gpio_name;
	unsigned int 			gpio_num;
	unsigned int 			gpio_func;
};

static struct zx29_gpio_def gpio_def[] =
{
	{"GPIO0_GPIO0", 			0, 		       GPIO0_GPIO0},
	{"GPIO0_NAND_WE", 			0, 	    	 GPIO0_NAND_WE},
	{"GPIO0_LCD_OE_N", 			0, 	    	 GPIO0_LCD_OE_N},
	{"GPIO1_GPIO1",             1,             GPIO1_GPIO1},
	{"GPIO1_NAND_CS0",          1,          GPIO1_NAND_CS0},
	{"GPIO1_LCD_CS_N",          1,          GPIO1_LCD_CS_N},
	{"GPIO2_GPIO2",             2,             GPIO2_GPIO2},
	{"GPIO2_NAND_READY",        2,        GPIO2_NAND_READY},
	{"GPIO2_LCD_RS",       	 	2,			  GPIO2_LCD_RS},
	{"GPIO3_GPIO3",             3,             GPIO3_GPIO3},
	{"GPIO3_NAND_CLE",          3,          GPIO3_NAND_CLE},
	{"GPIO3_LCD_RESET_N",       3,       GPIO3_LCD_RESET_N},
	{"GPIO4_GPIO4",             4,             GPIO4_GPIO4},
	{"GPIO4_NAND_ALE",          4,          GPIO4_NAND_ALE},
	{"GPIO4_LCD_WE_N",          4,          GPIO4_LCD_WE_N},
	{"GPIO5_GPIO5",             5,             GPIO5_GPIO5},
	{"GPIO5_NAND_RE",           5,           GPIO5_NAND_RE},
	{"GPIO5_LCD_TE",            5,           GPIO5_LCD_TE},
	{"GPIO6_GPIO6",             6,             GPIO6_GPIO6},
	{"GPIO6_NAND_WRITE_PROTECT",6,GPIO6_NAND_WRITE_PROTECT},
	{"GPIO6_LCD_D0",            6,             GPIO6_LCD_D0},
	{"GPIO7_GPIO7",             7,             GPIO7_GPIO7},
	{"GPIO7_NAND_DATA0",        7,        GPIO7_NAND_DATA0},
	{"GPIO7_LCD_D1",            7,           GPIO7_LCD_D1},
	{"GPIO8_GPIO8",             8,             GPIO8_GPIO8},
	{"GPIO8_NAND_DATA1",        8,        GPIO8_NAND_DATA1},
	{"GPIO8_LCD_D2",            8,          GPIO8_LCD_D2},
	{"GPIO9_GPIO9",             9,             GPIO9_GPIO9},
	{"GPIO9_NAND_DATA2",        9,        GPIO9_NAND_DATA2},
	{"GPIO9_LCD_D3",      		9,      	  GPIO9_LCD_D3},
	{"GPIO10_GPIO10",          10,           GPIO10_GPIO10},
	{"GPIO10_NAND_DATA3",      10,       GPIO10_NAND_DATA3},
	{"GPIO10_LCD_D4",     	   10,     		 GPIO10_LCD_D4},
	{"GPIO11_GPIO11",          11,           GPIO11_GPIO11},
	{"GPIO11_NAND_DATA4",      11,       GPIO11_NAND_DATA4},
	{"GPIO11_LCD_D5",    	   11,     		 GPIO11_LCD_D5},
	{"GPIO12_GPIO12",          12,           GPIO12_GPIO12},
	{"GPIO12_NAND_DATA5",      12,       GPIO12_NAND_DATA5},
	{"GPIO12_LCD_D6",    	   12,     		 GPIO12_LCD_D6},
	{"GPIO13_GPIO13",          13,           GPIO13_GPIO13},
	{"GPIO13_NAND_DATA6",      13,       GPIO13_NAND_DATA6},
	{"GPIO13_LCD_D7",          13,           GPIO13_LCD_D7},
	{"GPIO14_GPIO14",          14,           GPIO14_GPIO14},
	{"GPIO14_NAND_DATA7",      14,       GPIO14_NAND_DATA7},
	{"GPIO14_LCD_D8",          14,         	 GPIO14_LCD_D8},
	{"GPIO15_GPIO15",		   15,			 GPIO15_GPIO15},
	{"GPIO15_CLK_OUT0",	   	   15,		   GPIO15_CLK_OUT0},
	{"GPIO16_GPIO16",		   16,			 GPIO16_GPIO16},
	{"GPIO16_CLK_OUT1", 	   16,		   GPIO16_CLK_OUT1},
	{"GPIO17_GPIO17",	   	   17,		 	 GPIO17_GPIO17},
	{"GPIO17_CLK_OUT2",		   17,		   GPIO17_CLK_OUT2},
	{"GPIO17_TEST_CLK_OUT",	   17,	   GPIO17_TEST_CLK_OUT},
	{"GPIO17_TDM_MCLK_OUT",    17,	   GPIO17_TDM_MCLK_OUT},
	{"GPIO17_I2S0_MCLK_OUT",   17,	  GPIO17_I2S0_MCLK_OUT},
	{"GPIO17_I2S1_MCLK_OUT",   17,	  GPIO17_I2S1_MCLK_OUT},
	{"GPIO18_GPIO18",		   18,			 GPIO18_GPIO18},
	{"GPIO18_CLK_32K_OUT", 	   18,		GPIO18_CLK_32K_OUT},
	{"GPIO19_GPIO19",		   19,			 GPIO19_GPIO19},
	{"GPIO19_RMII_CLK_I",	   19,		 GPIO19_RMII_CLK_I},
	{"GPIO20_GPIO20",		   20,			 GPIO20_GPIO20},
	{"GPIO20_RMII_CLK_O",	   20,		 GPIO20_RMII_CLK_O},
	{"GPIO21_CLK_REQ0",		   21,		   GPIO21_CLK_REQ0},
	{"GPIO21_GPIO21",	   	   21,			 GPIO21_GPIO21},
	{"GPIO22_CLK_REQ1", 	   22,		   GPIO22_CLK_REQ1},
	{"GPIO22_GPIO22",		   22,			 GPIO22_GPIO22},
	{"GPIO23_PWRCTRL",         23,          GPIO23_PWRCTRL},
	{"GPIO23_GPIO23",          23,           GPIO23_GPIO23},
	{"GPIO24_GPIO24",          24,           GPIO24_GPIO24},
	{"GPIO25_GPIO25",          25,           GPIO25_GPIO25},
	{"GPIO25_SSP0_CS",         25,          GPIO25_SSP0_CS},
	{"GPIO26_GPIO26",          26,           GPIO26_GPIO26},
	{"GPIO26_SSP0_CLK",        26,         GPIO26_SSP0_CLK},
	{"GPIO27_SSP0_RXD",        27,         GPIO27_SSP0_RXD},
	{"GPIO27_GPIO27",          27,           GPIO27_GPIO27},
	{"GPIO28_GPIO28",		   28,			 GPIO28_GPIO28},
	{"GPIO28_SSP0_TXD", 	   28,		   GPIO28_SSP0_TXD},

	{"GPIO29_UART0_RXD",       29,        GPIO29_UART0_RXD},
	{"GPIO29_GPIO29",          29,           GPIO29_GPIO29},
	{"GPIO29_UART0_TXD",	   29,		  GPIO29_UART0_TXD},
	{"GPIO29_FRAME_SYNC",	   29,		  GPIO29_FRAME_SYNC},
	{"GPIO29_TEST_PIN10",	   29,		  GPIO29_TEST_PIN10},

	{"GPIO30_UART0_TXD",	   30,			 GPIO30_UART0_TXD},
	{"GPIO30_GPIO30",          30,           GPIO30_GPIO30},
	{"GPIO30_UART0_RXD",       30,          GPIO30_UART0_RXD},
	{"GPIO30_LTE_PRE_TX",	   30,		  GPIO30_LTE_PRE_TX},
	{"GPIO30_TEST_PIN11",	   30,		  GPIO30_TEST_PIN11},

	{"GPIO31_GPIO31",          31,           GPIO31_GPIO31},
	{"GPIO31_UART0_CTS",       31,         GPIO31_UART0_CTS},
	{"GPIO31_LTE_TPU_OUT3",	   31,		  GPIO31_LTE_TPU_OUT3},
	{"GPIO31_UART1_TXD",	   31,		  GPIO31_UART1_TXD},
	{"GPIO31_TEST_PIN12",	   31,		  GPIO31_TEST_PIN12},

	{"GPIO32_GPIO32",          32,           GPIO32_GPIO32},
	{"GPIO32_UART0_RTS",       32,         GPIO32_UART0_RTS},
	{"GPIO32_LTE_TPU_OUT4",	   32,		  GPIO32_LTE_TPU_OUT4},
	{"GPIO32_UART1_RXD",	   32,		  GPIO32_UART1_RXD},

	{"GPIO33_GPIO33",          33,           GPIO33_GPIO33},
	{"GPIO33_UART1_RXD",       33,         GPIO33_UART1_RXD},
	{"GPIO33_UART2_TXD",	   33,			 GPIO33_UART2_TXD},
	{"GPIO33_UART2_RXD",	   33,		   GPIO33_UART2_RXD},

	{"GPIO34_UART1_TXD",       34,        GPIO34_UART1_TXD},
	{"GPIO34_GPIO34",          34,           GPIO34_GPIO34},
	{"GPIO34_UART2_RXD",       34,        GPIO34_UART2_RXD},
	{"GPIO34_UART2_TXD",       34,       GPIO34_UART2_TXD},

	{"GPIO35_GPIO35",          35,           GPIO35_GPIO35},
	{"GPIO35_I2S0_WS",         35,        GPIO35_I2S0_WS},
	{"GPIO35_TEST_PIN0",       35,       GPIO35_TEST_PIN0},
	{"GPIO35_TDM_FS",          35,       GPIO35_TDM_FS},

	{"GPIO36_GPIO36",          36,           GPIO36_GPIO36},
	{"GPIO36_I2S0_CLK",        36,        GPIO36_I2S0_CLK},
	{"GPIO36_TEST_PIN1",       36,     GPIO36_TEST_PIN1},
	{"GPIO36_TDM_CLK",         36,       GPIO36_TDM_CLK},

	{"GPIO37_GPIO37",          37,           GPIO37_GPIO37},
	{"GPIO37_I2S0_DIN",        37,        GPIO37_I2S0_DIN},
	{"GPIO37_TEST_PIN2",       37,     GPIO37_TEST_PIN2},
	{"GPIO37_TDM_DATA_IN",     37,        GPIO37_TDM_DATA_IN},

	{"GPIO38_GPIO38",          38,           GPIO38_GPIO38},
	{"GPIO38_I2S0_DOUT",       38,          GPIO38_I2S0_DOUT},
	{"GPIO38_TEST_PIN3",			38,          GPIO38_TEST_PIN3},
	{"GPIO38_TDM_DATA_OUT", 		38,			GPIO38_TDM_DATA_OUT},

	{"GPIO39_GPIO39",              39,             GPIO39_GPIO39},
	{"GPIO39_I2S1_WS",            39,           GPIO39_I2S1_WS},
	{"GPIO39_TEST_PIN4",           39,          GPIO39_TEST_PIN4},
	{"GPIO39_TDM_FS", 				39,			GPIO39_TDM_FS},
	{"GPIO39_PWM0",             	39,            GPIO39_PWM0},
	{"GPIO40_GPIO40",              40,             GPIO40_GPIO40},
	{"GPIO40_I2S1_CLK", 		   40,		     GPIO40_I2S1_CLK},
	{"GPIO40_TEST_PIN5",		   40,			GPIO40_TEST_PIN5},
	{"GPIO40_TDM_CLK",    		   40,	 		GPIO40_TDM_CLK},
	{"GPIO40_PWM1",		 		   40,				  GPIO40_PWM1},
	{"GPIO41_GPIO41", 			   41,			   GPIO41_GPIO41},
	{"GPIO41_I2S1_DIN", 		   41,			GPIO41_I2S1_DIN},
	{"GPIO41_TEST_PIN6", 		   41,			GPIO41_TEST_PIN6},
	{"GPIO41_TDM_DATA_IN",		   41,	 GPIO41_TDM_DATA_IN},

	{"GPIO42_GPIO42", 			   42,			   GPIO42_GPIO42},
	{"GPIO42_I2S1_DOUT", 		   42,			  GPIO42_I2S1_DOUT},
	{"GPIO42_TEST_PIN7", 		   42,			GPIO42_TEST_PIN7},
	{"GPIO42_TDM_DATA_OUT",		   42,		 GPIO42_TDM_DATA_OUT},

	{"GPIO43_GPIO43", 			   43,			   GPIO43_GPIO43},
	{"GPIO43_SCL0",		 		   43,				 GPIO43_SCL0},

	{"GPIO44_GPIO44", 			   44,			   GPIO44_GPIO44},
	{"GPIO44_SDA0",		 		   44,			 GPIO44_SDA0},

	{"GPIO45_GPIO45", 			   45,			   GPIO45_GPIO45},
	{"GPIO45_SCL1",		 		   45,			GPIO45_SCL1},

	{"GPIO46_GPIO46", 			   46,			   GPIO46_GPIO46},
	{"GPIO46_SDA1", 			   46,			   GPIO46_SDA1},

	{"GPIO47_GPIO47", 			   47,			   GPIO47_GPIO47},
	{"GPIO47_EXT_INT0", 		   47,		     GPIO47_EXT_INT0},

	{"GPIO48_GPIO48", 			   48,			   GPIO48_GPIO48},
	{"GPIO48_EXT_INT1", 		   48,				 GPIO48_EXT_INT1},
	{"GPIO49_GPIO49", 			   49,			   GPIO49_GPIO49},
	{"GPIO49_EXT_INT2", 		   49,				 GPIO49_EXT_INT2},
	{"GPIO50_GPIO50", 			   50,			   GPIO50_GPIO50},
	{"GPIO50_EXT_INT3", 		   50, 			 GPIO50_EXT_INT3},
	{"GPIO50_TEST_PIN8", 		   50, 			 GPIO50_TEST_PIN8},
	{"GPIO51_GPIO51", 			   51,			   GPIO51_GPIO51},
	{"GPIO51_EXT_INT4", 		   51, 		  	 GPIO51_EXT_INT4},
	{"GPIO51_TEST_PIN9", 		   51, 		  	 GPIO51_TEST_PIN9},
	{"GPIO52_GPIO52", 			   52,			   GPIO52_GPIO52},
	{"GPIO52_EXT_INT5", 		   52,			 GPIO52_EXT_INT5},
	{"GPIO52_TEST_PIN13", 		   52,			 GPIO52_TEST_PIN13},

	{"GPIO53_GPIO53", 			   53,			   GPIO53_GPIO53},
	{"GPIO53_EXT_INT6", 		   53,			 GPIO53_EXT_INT6},
	{"GPIO53_TEST_PIN14", 		   53,		    GPIO53_TEST_PIN14},
	{"GPIO54_GPIO54", 			   54,			   GPIO54_GPIO54},
	{"GPIO54_EXT_INT7", 		   54,		     GPIO54_EXT_INT7},
	{"GPIO54_TEST_PIN15", 		   54,			GPIO54_TEST_PIN15},
	{"GPIO55_GPIO55", 			   55,             GPIO55_GPIO55},
	{"GPIO55_RMII_TXEN", 		   55,			 GPIO55_RMII_TXEN},

	{"GPIO56_GPIO56", 			   56,			   GPIO56_GPIO56},
	{"GPIO56_RMII_RXEN", 		   56,			 GPIO56_RMII_RXEN},

	{"GPIO57_GPIO57", 			   57,			   GPIO57_GPIO57},
	{"GPIO57_RMII_RXD0", 		   57,			 GPIO57_RMII_RXD0},

	{"GPIO58_GPIO58", 			   58,			   GPIO58_GPIO58},
	{"GPIO58_RMII_RXD1", 		   58,	 		  GPIO58_RMII_RXD1},
	{"GPIO59_GPIO59",			   59,			   GPIO59_GPIO59},
	{"GPIO59_RMII_TXD0", 		   59,		   GPIO59_RMII_TXD0},

    {"GPIO60_GPIO60", 			   60,			   GPIO60_GPIO60},
    {"GPIO60_RMII_TXD1", 		   60,		   GPIO60_RMII_TXD1},

    {"GPIO61_GPIO61", 			   61,			   GPIO61_GPIO61},
    {"GPIO61_MDC_SCLK", 		   61,			  GPIO61_MDC_SCLK},

    {"GPIO62_GPIO62", 			   62,  		   GPIO62_GPIO62},
    {"GPIO62_MDC_SDIO", 		   62,		   GPIO62_MDC_SDIO},

    {"GPIO63_GPIO63", 			   63,		       GPIO63_GPIO63},
    {"GPIO63_PHY_RST",	 		   63,			   GPIO63_PHY_RST},

    {"GPIO64_GPIO64", 			   64,			   GPIO64_GPIO64},
    {"GPIO64_PHY_INT",	 		   64,			  GPIO64_PHY_INT},

    {"GPIO65_GPIO65",	 		   65,			  GPIO65_GPIO65},

    {"GPIO66_GPIO66", 			   66,			   GPIO66_GPIO66},
    {"GPIO66_KEY_COL2", 		   66,		  GPIO66_KEY_COL2},
    {"GPIO66_EMMC_CLK",		 	   66,		 GPIO66_EMMC_CLK},

    {"GPIO67_GPIO67", 			   67,			   GPIO67_GPIO67},
    {"GPIO67_KEY_COL3", 		   67,  	  GPIO67_KEY_COL3},
    {"GPIO67_EMMC_CMD",		 	   67,		 GPIO67_EMMC_CMD},

    {"GPIO68_GPIO68", 			   68,			   GPIO68_GPIO68},
    {"GPIO68_KEY_COL4", 		   68,		  GPIO68_KEY_COL4},
    {"GPIO68_EMMC_DATA0",	 	   68,		 GPIO68_EMMC_DATA0},

    {"GPIO69_GPIO69", 			   69,			   GPIO69_GPIO69},
    {"GPIO69_KEY_ROW2",		 	   69,		 GPIO69_KEY_ROW2},
    {"GPIO69_EMMC_DATA1",	 	   69,		GPIO69_EMMC_DATA1},

    {"GPIO70_GPIO70", 			   70,			   GPIO70_GPIO70},
    {"GPIO70_KEY_ROW3", 		   70,			 GPIO70_KEY_ROW3},
    {"GPIO70_EMMC_DATA2", 		   70,		   GPIO70_EMMC_DATA2},

    {"GPIO71_GPIO71", 			   71,		  	   GPIO71_GPIO71},
	{"GPIO71_KEY_ROW4", 		   71,			 GPIO71_KEY_ROW4},
    {"GPIO71_EMMC_DATA3",			71,			 GPIO71_EMMC_DATA3},
    {"GPIO72_GPIO72", 			   72,			   GPIO72_GPIO72},
    {"GPIO72_SD1_HOST_SDCLK", 	   72,			GPIO72_SD1_HOST_SDCLK},

    {"GPIO73_GPIO73", 			   73,			   GPIO73_GPIO73},
    {"GPIO73_M_JTAG_TDO", 		   73,		    GPIO73_M_JTAG_TDO},
    {"GPIO73_SD1_CMD",			    73,			 GPIO73_SD1_CMD},
    {"GPIO73_PS_JTAG_TDO", 		   73,		    GPIO73_PS_JTAG_TDO},
    {"GPIO73_PHY_JTAG_TDO", 		73,		    GPIO73_PHY_JTAG_TDO},
    {"GPIO73_AP_JTAG_TDO",	 		73,		    GPIO73_AP_JTAG_TDO},

    {"GPIO74_GPIO74", 			   74,			   GPIO74_GPIO74},
    {"GPIO74_M_JTAG_TCK", 		   74,		    GPIO74_M_JTAG_TCK},
    {"GPIO74_SD1_DATA0", 		   74,		  GPIO74_SD1_DATA0},
    {"GPIO74_PS_JTAG_TCK",	 	   74,		 GPIO74_PS_JTAG_TCK},
    {"GPIO74_PHY_JTAG_TCK", 	   74,		GPIO74_PHY_JTAG_TCK},
    {"GPIO74_AP_JTAG_TCK",	 	   74,		 GPIO74_AP_JTAG_TCK},

    {"GPIO75_GPIO75",      		   75, 			   GPIO75_GPIO75},
    {"GPIO75_M_JTAG_TRST", 		   75,			GPIO75_M_JTAG_TRST},
    {"GPIO75_SD1_DATA1", 		   75,		   GPIO75_SD1_DATA1},
	{"GPIO75_PS_JTAG_TRST", 	   75,		  GPIO75_PS_JTAG_TRST},
	{"GPIO75_PHY_JTAG_TRST", 	   75,		 GPIO75_PHY_JTAG_TRST},
	{"GPIO75_AP_JTAG_TRST", 	   75,		  GPIO75_AP_JTAG_TRST},

	{"GPIO76_GPIO76", 			   76,		       GPIO76_GPIO76},
	{"GPIO76_M_JTAG_TMS", 		   76,	        GPIO76_M_JTAG_TMS},
	{"GPIO76_SD1_DATA2", 		   76,		   GPIO76_SD1_DATA2},
	{"GPIO76_PS_JTAG_TMS", 		   76, 		  GPIO76_PS_JTAG_TMS},
	{"GPIO76_PHY_JTAG_TMS", 	   76,		 GPIO76_PHY_JTAG_TMS},
	{"GPIO76_AP_JTAG_TMS", 		   76, 		  GPIO76_AP_JTAG_TMS},

	{"GPIO77_GPIO77", 			   77,			   GPIO77_GPIO77},
	{"GPIO77_M_JTAG_TDI", 		   77,			GPIO77_M_JTAG_TDI},
	{"GPIO77_SD1_DATA2", 		   77,		    GPIO77_SD1_DATA3},
	{"GPIO77_PS_JTAG_TDI", 		   77,		    GPIO77_PS_JTAG_TDI},
	{"GPIO77_PHY_JTAG_TDI", 	   77,		    GPIO77_PHY_JTAG_TDI},
	{"GPIO77_AP_JTAG_TDI", 		   77,		    GPIO77_AP_JTAG_TDI},

	{"GPIO78_GPIO78", 			   78,			   GPIO78_GPIO78},
	{"GPIO78_M_JTAG_TCK",		    78,		 GPIO78_M_JTAG_TCK},
	{"GPIO78_PS_JTAG_TCK",		   78,			   GPIO78_PS_JTAG_TCK},
	{"GPIO78_PHY_JTAG_TCK",		   78,			   GPIO78_PHY_JTAG_TCK},
	{"GPIO78_AP_JTAG_TCK",		   78,			   GPIO78_AP_JTAG_TCK},

	{"GPIO79_GPIO79", 			   79,			   GPIO79_GPIO79},
	{"GPIO79_M_JTAG_TDI", 		   79,			   GPIO79_M_JTAG_TDI},
	{"GPIO79_PS_JTAG_TDI",		    79,		 GPIO79_PS_JTAG_TDI},
	{"GPIO79_PHY_JTAG_TDI", 	   79,			   GPIO79_PHY_JTAG_TDI},
	{"GPIO79_AP_JTAG_TDI", 		   79,			   GPIO79_AP_JTAG_TDI},

	{"GPIO80_GPIO80",			   80,		   GPIO80_GPIO80},
	{"GPIO80_M_JTAG_TDO", 		   80,			   GPIO80_M_JTAG_TDO},
	{"GPIO80_PS_JTAG_TDO",		    80,		 GPIO80_PS_JTAG_TDO},
	{"GPIO80_PHY_JTAG_TDO", 	   80,		   GPIO80_PHY_JTAG_TDO},
	{"GPIO80_AP_JTAG_TDO", 		   80,		   GPIO80_AP_JTAG_TDO},

	{"GPIO81_GPIO81", 			   81,			   GPIO81_GPIO81},
	{"GPIO81_M_JTAG_TMS", 			81,		 GPIO81_M_JTAG_TMS},
	{"GPIO81_PS_JTAG_TMS", 		   81,			   GPIO81_PS_JTAG_TMS},
	{"GPIO81_PHY_JTAG_TMS", 	   81,			   GPIO81_PHY_JTAG_TMS},
	{"GPIO81_AP_JTAG_TMS", 		   81,			   GPIO81_AP_JTAG_TMS},

	{"GPIO82_GPIO82", 			   82,		       GPIO82_GPIO82},
	{"GPIO82_M_JTAG_TRST",		    82,	 GPIO82_M_JTAG_TRST},
	{"GPIO82_PS_JTAG_TRST",			82,		       GPIO82_PS_JTAG_TRST},
	{"GPIO82_PHY_JTAG_TRST", 	   82,		       GPIO82_PHY_JTAG_TRST},
	{"GPIO82_AP_JTAG_TRST", 	   82,		       GPIO82_AP_JTAG_TRST},

	{"GPIO83_GPIO83", 			   83,			   GPIO83_GPIO83},
	{"GPIO83_KEY_COL0",			    83,	 GPIO83_KEY_COL0},
	{"GPIO84_GPIO84", 			   84,			   GPIO84_GPIO84},
	{"GPIO84_KEY_COL1",			    84,	 GPIO84_KEY_COL1},
	{"GPIO85_GPIO85", 			   85,			   GPIO85_GPIO85},
	{"GPIO85_KEY_ROW0",			    85,	 GPIO85_KEY_ROW0},
	{"GPIO86_GPIO86", 			   86,			   GPIO86_GPIO86},
	{"GPIO86_KEY_ROW1",			    86,	 GPIO86_KEY_ROW1},
	{"GPIO87_GPIO87", 			   87,			   GPIO87_GPIO87},
	{"GPIO87_CAM_SPI_CS",		    87,	 GPIO87_CAM_SPI_CS},
	{"GPIO88_GPIO88", 			   88,			   GPIO88_GPIO88},
	{"GPIO88_CAM_SPI_CLK",		   88,  GPIO88_CAM_SPI_CLK},
	{"GPIO89_GPIO89", 			   89,			   GPIO89_GPIO89},
	{"GPIO89_CAM_SPI_DATA0",	   89,	GPIO89_CAM_SPI_DATA0},
	{"GPIO90_GPIO90", 			   90,			   GPIO90_GPIO90},
	{"GPIO90_CAM_SPI_DATA1", 	   90,	   GPIO90_CAM_SPI_DATA1},
	{"GPIO90_CAM_SPI_TXD", 	   		90,	   GPIO90_CAM_SPI_TXD},
	{"GPIO91_GPIO91", 			   91,			   GPIO91_GPIO91},
	{"GPIO91_CAM_SPI_DATA2",      91,	   GPIO91_CAM_SPI_DATA2},
	{"GPIO92_GPIO92", 			   92,			   GPIO92_GPIO92},
	{"GPIO92_CAM_SPI_DATA3", 	   92,	   GPIO92_CAM_SPI_DATA3},
	{"GPIO93_GPIO93", 			   93,			   GPIO93_GPIO93},
	{"GPIO93_SPIFC_CS",		 	   93,	   GPIO93_SPIFC_CS},
    {"GPIO94_GPIO94", 			   94,			   GPIO94_GPIO94},
    {"GPIO94_SPIFC_CLK", 		   94,	   GPIO94_SPIFC_CLK},
    {"GPIO95_GPIO95", 			   95,			   GPIO95_GPIO95},
    {"GPIO95_SPIFC_DATA0",	 	   95,	   GPIO95_SPIFC_DATA0},
    {"GPIO96_GPIO96", 			   96,			   GPIO96_GPIO96},
	{"GPIO96_SPIFC_DATA1",		      96,	   GPIO96_SPIFC_DATA1},
	{"GPIO97_GPIO97", 			   97,			   GPIO97_GPIO97},
	{"GPIO97_SPIFC_DATA2",		   97,	   GPIO97_SPIFC_DATA2},
	{"GPIO98_GPIO98", 			   98,			   GPIO98_GPIO98},
	{"GPIO98_SPIFC_DATA3",	 	   98,	   GPIO98_SPIFC_DATA3},
	{"GPIO99_GPIO99", 			   99,			   GPIO99_GPIO99},

	{"GPIO100_GPIO100", 		   100,		     GPIO100_GPIO100},
	{"GPIO100_RF_SPI_STR",		    100,	 GPIO100_RF_SPI_STR},
    {"GPIO101_GPIO101", 		   101,		     GPIO101_GPIO101},
    {"GPIO101_RF_SPI_CLK",		    101,	 GPIO101_RF_SPI_CLK},
    {"GPIO102_GPIO102", 		   102,		     GPIO102_GPIO102},
    {"GPIO102_RF_SPI_DATA", 	   102,	    GPIO102_RF_SPI_DATA},
    {"GPIO103_GPIO103", 		   103,			 GPIO103_GPIO103},

    {"GPIO104_GPIO104",			   104,		     GPIO104_GPIO104},
    {"GPIO104_TD_G0_GPIO2",		   104,		GPIO104_TD_G0_GPIO2},
    {"GPIO104_LTE_TPU_OUT0_5",	   104,		GPIO104_LTE_TPU_OUT0_5},
    {"GPIO104_W_G0_GPIO2",		   104,		GPIO104_W_G0_GPIO2},
    {"GPIO104_GSM_T_OUT_O_0",	   104,		GPIO104_GSM_T_OUT_O_0},
	{"GPIO104_RF0_MIX", 		   104, 	  GPIO104_RF0_MIX},

    {"GPIO105_GPIO105", 		   105,		     GPIO105_GPIO105},
    {"GPIO105_TD_G0_GPIO3",	       105,	    GPIO105_TD_G0_GPIO3},
    {"GPIO105_LTE_TPU_OUT0_6",	   105,	    GPIO105_LTE_TPU_OUT0_6},
    {"GPIO105_W_G0_GPIO3",	       105,	    GPIO105_W_G0_GPIO3},
    {"GPIO105_GSM_T_OUT_O_1",	   105,	    GPIO105_GSM_T_OUT_O_1},
    {"GPIO105_RF1_MIX", 		   105, 	  GPIO105_RF1_MIX},

    {"GPIO106_GPIO106", 		   106,			 GPIO106_GPIO106},
    {"GPIO106_TD_G0_GPIO4", 	   106,		 GPIO106_TD_G0_GPIO4},
    {"GPIO106_LTE_TPU_OUT0_7", 	   106,		 GPIO106_LTE_TPU_OUT0_7},
    {"GPIO106_W_G0_GPIO4",	 	   106,		 GPIO106_W_G0_GPIO4},
    {"GPIO106_GSM_T_OUT_O_2", 	   106,		 GPIO106_GSM_T_OUT_O_2},
	{"GPIO106_RF2_MIX", 		   106, 	  GPIO106_RF2_MIX},

    {"GPIO107_GPIO107", 		   107,			 GPIO107_GPIO107},
    {"GPIO107_TD_G0_GPIO5", 	   107,		 GPIO107_TD_G0_GPIO5},
    {"GPIO107_LTE_TPU_OUT0_8", 	   107,		 GPIO107_LTE_TPU_OUT0_8},
    {"GPIO107_W_G0_GPIO5",	 	   107,		 GPIO107_W_G0_GPIO5},
    {"GPIO107_GSM_T_OUT_O_3", 	   107,		 GPIO107_GSM_T_OUT_O_3},
	{"GPIO107_RF3_MIX", 		   107, 	  GPIO107_RF3_MIX},

    {"GPIO108_GPIO108", 		   108,			 GPIO108_GPIO108},
    {"GPIO108_TD_G0_GPIO6", 	   108,		 GPIO108_TD_G0_GPIO6},
    {"GPIO108_LTE_TPU_OUT0_9", 	   108,		 GPIO108_LTE_TPU_OUT0_9},
    {"GPIO108_W_G0_GPIO6",	 	   108,		 GPIO108_W_G0_GPIO6},
    {"GPIO108_GSM_T_OUT_O_4", 	   108,		 GPIO108_GSM_T_OUT_O_4},
	{"GPIO108_RF4_MIX", 		   108, 	  GPIO108_RF4_MIX},

	{"GPIO109_GPIO109", 		   109,			 GPIO109_GPIO109},
    {"GPIO109_TD_G0_GPIO7", 	   109,		 GPIO109_TD_G0_GPIO7},
    {"GPIO109_LTE_TPU_OUT0_10",    109,		 GPIO109_LTE_TPU_OUT0_10},
    {"GPIO109_W_G0_GPIO7",	 	   109,		 GPIO109_W_G0_GPIO7},
    {"GPIO109_GSM_T_OUT_O_5", 	   109,		 GPIO109_GSM_T_OUT_O_5},
    {"GPIO109_RF5_MIX",		       109, 	  GPIO109_RF5_MIX},

	{"GPIO110_GPIO110", 		   110,			 GPIO110_GPIO110},
    {"GPIO110_TD_G0_GPIO8", 	   110,		 GPIO110_TD_G0_GPIO8},
    {"GPIO110_LTE_TPU_OUT0_11",    110,		 GPIO110_LTE_TPU_OUT0_11},
    {"GPIO110_W_G0_GPIO8",	 	   110,		 GPIO110_W_G0_GPIO8},
    {"GPIO110_GSM_T_OUT_O_6", 	   110,		 GPIO110_GSM_T_OUT_O_6},
    {"GPIO110_RF6_MIX",		       110, 	  GPIO110_RF6_MIX},

	{"GPIO111_GPIO111", 		   111,			 GPIO111_GPIO111},
    {"GPIO111_TD_G0_GPIO9", 	   111,		 GPIO111_TD_G0_GPIO9},
    {"GPIO111_LTE_TPU_OUT0_12",    111,		 GPIO111_LTE_TPU_OUT0_12},
    {"GPIO111_W_G0_GPIO9",	 	   111,		 GPIO111_W_G0_GPIO9},
    {"GPIO111_GSM_T_OUT_O_7", 	   111,		 GPIO111_GSM_T_OUT_O_7},
	{"GPIO111_RF7_MIX",		       111, 	  GPIO111_RF7_MIX},

	{"GPIO112_GPIO112", 		   112,			 GPIO112_GPIO112},
    {"GPIO112_MIPI_RFFE_CLK0", 	   112,		 GPIO112_MIPI_RFFE_CLK0},
    {"GPIO112_TD_G0_GPIO10",	   112,		 GPIO112_TD_G0_GPIO10},
    {"GPIO112_LTE_TPU_OUT0_13",	   112,		 GPIO112_LTE_TPU_OUT0_13},
    {"GPIO112_W_G0_GPIO10", 	   112,		 GPIO112_W_G0_GPIO10},
    {"GPIO112_GSM_T_OUT_O_8", 	   112,		 GPIO112_GSM_T_OUT_O_8},

	{"GPIO113_GPIO113", 		   113, 		 GPIO113_GPIO113},
	{"GPIO113_MIPI_RFFE_DATA0",    113, 	 GPIO113_MIPI_RFFE_DATA0},
	{"GPIO113_TD_G0_GPIO11",	   113, 	 GPIO113_TD_G0_GPIO11},
	{"GPIO113_LTE_TPU_OUT0_14",	   113, 	 GPIO113_LTE_TPU_OUT0_14},
	{"GPIO113_W_G0_GPIO11", 	   113, 	 GPIO113_W_G0_GPIO11},
	{"GPIO113_GSM_T_OUT_O_9",	   113, 	 GPIO113_GSM_T_OUT_O_9},

	{"GPIO114_GPIO114", 		   114, 		 GPIO114_GPIO114},
	{"GPIO114_MIPI_RFFE_CLK1",	   114, 	 GPIO114_MIPI_RFFE_CLK1},
	{"GPIO114_ABB_I2C_SEL_PINMUX", 114, 	 GPIO114_ABB_I2C_SEL_PINMUX},
	{"GPIO114_TD_G0_GPIO12",	   114, 	 GPIO114_TD_G0_GPIO12},
	{"GPIO114_LTE_TPU_OUT0_15",    114, 	 GPIO114_LTE_TPU_OUT0_15},
	{"GPIO114_W_G0_GPIO12",		   114, 	 GPIO114_W_G0_GPIO12},
	{"GPIO114_GSM_T_OUT_O_10",	   114, 	 GPIO114_GSM_T_OUT_O_10},

	{"GPIO115_GPIO115", 		   115, 		 GPIO115_GPIO115},
	{"GPIO115_MIPI_RFFE_DATA1",	   115, 	 GPIO115_MIPI_RFFE_DATA1},
	{"GPIO115_ABB_I2C_SDA_PINMUX", 115, 	 GPIO115_ABB_I2C_SDA_PINMUX},
	{"GPIO115_TD_G1_GPIO0",		   115, 	 GPIO115_TD_G1_GPIO0},
	{"GPIO115_LTE_TPU_OUT1_0",	   115, 	 GPIO115_LTE_TPU_OUT1_0},
	{"GPIO115_W_G1_GPIO0",		   115, 	 GPIO115_W_G1_GPIO0},
	{"GPIO115_GSM_T_OUT_O_11",	   115, 	 GPIO115_GSM_T_OUT_O_11},

    {"GPIO116_GPIO116", 		   116,			 GPIO116_GPIO116},
    {"GPIO116_SIM_RST",		 	   116,				GPIO116_SIM_RST},
    {"GPIO117_GPIO117", 		   117,			 GPIO117_GPIO117},
	{"GPIO117_SIM_CLK",			   117,			GPIO117_SIM_CLK},
    {"GPIO118_GPIO118", 		   118,			 GPIO118_GPIO118},
    {"GPIO118_SIM_DATA",	 	   118,		 GPIO118_SIM_DATA},
    {"GPIO119_GPIO119", 		   119,			 GPIO119_GPIO119},
    {"GPIO119_EXT_INT8",	 	   119,		 GPIO119_EXT_INT8},
    {"GPIO119_M_JTAG_TDO",	 	   119,		 GPIO119_M_JTAG_TDO},
    {"GPIO119_URAT0_RTS",	 	   119,		 GPIO119_URAT0_RTS},
    {"GPIO119_PSJTAG_TDO",	 	   119,		 GPIO119_PSJTAG_TDO},
    {"GPIO119_PHYJTAG_TDO",	 	   119,		 GPIO119_PHYJTAG_TDO},
    {"GPIO119_APJTAG_TDO",	 	   119,		 GPIO119_APJTAG_TDO},
    {"GPIO119_PWM0",		 	   119,		 GPIO119_PWM0},

    {"GPIO120_GPIO120", 		   120,			 GPIO120_GPIO120},
    {"GPIO120_EXT_INT9",	 	   120,		 GPIO120_EXT_INT9},
    {"GPIO120_M_JTAG_TCK",	 	   120,		 GPIO120_M_JTAG_TCK},
    {"GPIO120_UART0_CTS",	 	   120,		 GPIO120_UART0_CTS},
    {"GPIO120_PSJTAG_TCK",	 	   120,		 GPIO120_PSJTAG_TCK},
    {"GPIO120_PHYJTAG_TCK",	 	   120,		 GPIO120_PHYJTAG_TCK},
    {"GPIO120_APJTAG_TCK",	 	   120,		 GPIO120_APJTAG_TCK},
    {"GPIO120_PWM1",		 	   120,		 GPIO120_PWM1},

    {"GPIO121_GPIO121", 		   121,			 GPIO121_GPIO121},
    {"GPIO121_EXT_INT10",	 	   121,		 GPIO121_EXT_INT10},
    {"GPIO121_M_JTAG_TRST",	 	   121,		 GPIO121_M_JTAG_TRST},
    {"GPIO121_PSJTAG_TRST",	 	   121,		 GPIO121_PSJTAG_TRST},
    {"GPIO121_PHYJTAG_TRST",	   121,		 GPIO121_PHYJTAG_TRST},
    {"GPIO121_APJTAG_TRST",	 	   121,		 GPIO121_APJTAG_TRST},
	{"GPIO121_UART2_RXD",		   121,		  GPIO121_UART2_RXD},

	{"GPIO122_GPIO122", 		   122, 		 GPIO122_GPIO122},
	{"GPIO122_EXT_INT11",		   122, 	 GPIO122_EXT_INT11},
	{"GPIO122_M_JTAG_TMS",	 	   122, 	 GPIO122_M_JTAG_TMS},
	{"GPIO122_PSJTAG_TMS",	 	   122, 	 GPIO122_PSJTAG_TMS},
	{"GPIO122_PHYJTAG_TMS",		   122, 	 GPIO122_PHYJTAG_TMS},
	{"GPIO122_APJTAG_TMS",	 	   122, 	 GPIO122_APJTAG_TMS},
	{"GPIO122_UART2_TXD",		   122, 	  GPIO122_UART2_TXD},

	{"GPIO123_GPIO123", 		   123, 		 GPIO123_GPIO123},
	{"GPIO123_EXT_INT12",		   123, 	 GPIO123_EXT_INT12},
	{"GPIO123_M_JTAG_TDI",		   123, 	 GPIO123_M_JTAG_TDI},
	{"GPIO123_PSJTAG_TDI",		   123, 	 GPIO123_PSJTAG_TDI},
	{"GPIO123_PHYJTAG_TDI", 	   123, 	 GPIO123_PHYJTAG_TDI},
	{"GPIO123_APJTAG_TDI",		   123, 	 GPIO123_APJTAG_TDI},
	{"GPIO123_UART2_RTS",		   123, 	  GPIO123_UART2_RTS},

	{"GPIO124_GPIO124", 		   124, 		 GPIO124_GPIO124},
	{"GPIO124_EXT_INT13",		   124, 	 GPIO124_EXT_INT13},
	{"GPIO124_UART2_CTS",		   124, 	  GPIO124_UART2_CTS},

	{"GPIO125_GPIO125", 		   125, 		 GPIO125_GPIO125},
	{"GPIO125_EXT_INT14",		   125, 	 GPIO125_EXT_INT14},
	{"GPIO125_UART1_RTS",		   125, 	  GPIO125_UART1_RTS},

	{"GPIO126_GPIO126", 		   126, 		 GPIO126_GPIO126},
	{"GPIO126_EXT_INT15",		   126, 	 GPIO126_EXT_INT15},
	{"GPIO126_KEY_COL2",		   126, 	  GPIO126_KEY_COL2},
	{"GPIO126_UART1_CTS",		   126, 	  GPIO126_UART1_CTS},

	{"GPIO127_GPIO127", 		   127, 		 GPIO127_GPIO127},
	{"GPIO127_EXT_INT8",		   127, 	 GPIO127_EXT_INT8},
	{"GPIO127_KEY_COL3",		   127, 	  GPIO127_KEY_COL3},

	{"GPIO128_GPIO128", 		   128, 		 GPIO128_GPIO128},
	{"GPIO128_EXT_INT9",		   128, 	 GPIO128_EXT_INT9},
	{"GPIO128_KEY_COL4",		   128, 	  GPIO128_KEY_COL4},

	{"GPIO129_GPIO129", 		   129, 		 GPIO129_GPIO129},
	{"GPIO129_EXT_INT10",		   129, 	 GPIO129_EXT_INT10},
	{"GPIO129_KEY_COL5",		   129, 	  GPIO129_KEY_COL5},

	{"GPIO130_GPIO130", 		   130, 		 GPIO130_GPIO130},
	{"GPIO130_EXT_INT11",		   130, 	 GPIO130_EXT_INT11},
	{"GPIO130_KEY_ROW2",		   130, 	  GPIO130_KEY_ROW2},

	{"GPIO131_GPIO131", 		   131, 		 GPIO131_GPIO131},
	{"GPIO131_EXT_INT12",		   131, 	 GPIO131_EXT_INT12},
	{"GPIO131_KEY_ROW3",		   131, 	  GPIO131_KEY_ROW3},

	{"GPIO132_GPIO132", 		   132, 		 GPIO132_GPIO132},
	{"GPIO132_EXT_INT13",		   132, 	 GPIO132_EXT_INT13},
	{"GPIO132_KEY_ROW4",		   132, 	  GPIO132_KEY_ROW4},

	{"GPIO133_GPIO133", 		   133, 		 GPIO133_GPIO133},
	{"GPIO133_SIM1_RST",		   133, 	 GPIO133_SIM1_RST},
	{"GPIO133_TD_G1_GPIO1",		   133, 	  GPIO133_TD_G1_GPIO1},
	{"GPIO133_LTE_TPU_OUT1_1", 	   133, 		 GPIO133_LTE_TPU_OUT1_1},
	{"GPIO133_W_G1_GPIO1",		   133, 	 GPIO133_W_G1_GPIO1},
	{"GPIO133_GSM_T_OUT_O_12",	   133, 	  GPIO133_GSM_T_OUT_O_12},
	{"GPIO133_RF12_MIX",		   133, 	  GPIO133_RF12_MIX},

	{"GPIO134_GPIO134", 		   134, 		 GPIO134_GPIO134},
	{"GPIO134_SIM1_CLK",		   134, 	 GPIO134_SIM1_CLK},
	{"GPIO134_TD_G1_GPIO2", 	   134, 	  GPIO134_TD_G1_GPIO2},
	{"GPIO134_LTE_TPU_OUT1_2",	   134, 		 GPIO134_LTE_TPU_OUT1_2},
	{"GPIO134_W_G1_GPIO2",		   134, 	 GPIO134_W_G1_GPIO2},
	{"GPIO134_GSM_T_OUT_O_13",	   134, 	  GPIO134_GSM_T_OUT_O_13},
	{"GPIO134_RF13_MIX",		   134, 	  GPIO134_RF13_MIX},

	{"GPIO135_GPIO135", 		   135, 		 GPIO135_GPIO135},
	{"GPIO135_SIM1_DATA",		   135, 	 GPIO135_SIM1_DATA},
	{"GPIO135_TD_G1_GPIO3", 	   135, 	  GPIO135_TD_G1_GPIO3},
	{"GPIO135_LTE_TPU_OUT1_3",	   135, 		 GPIO135_LTE_TPU_OUT1_3},
	{"GPIO135_W_G1_GPIO3",		   135, 	 GPIO135_W_G1_GPIO3},
	{"GPIO135_GSM_T_OUT_O_14",	   135, 	  GPIO135_GSM_T_OUT_O_14},
	{"GPIO135_RF14_MIX",	       135, 	  GPIO135_RF14_MIX},

    {"GPIO FUNCTION NOT EXIST",    ZX29_GPIO_NULL,	ZX29_GPIO_NULL},
};
void zx29_gpio_status_get(unsigned int gpio)
{
	int temp = 0, n = 0;

	temp = zx29_gpio_function_sel_get(gpio);
	printk("GPIO%d function, func[0x%x]\n",gpio,temp);


	for(n=0; n<ARRAY_SIZE(gpio_def); n++)
	{
		if(gpio_def[n].gpio_func == temp)
		{
			gpio_status_get.function = gpio_def[n].gpio_name;
			break;
		}
		if(gpio_def[n].gpio_num == ZX29_GPIO_NULL)
		{
			printk("GPIO%d function not exist, func[%d]\n",gpio,temp);
			gpio_status_get.function = gpio_def[n].gpio_name;
		}
	}

	temp=zx29_gpio_get_direction(gpio);

	if(temp==GPIO_IN)
	{
		gpio_status_get.direction = "GPIO_IN";
		temp=zx29_gpio_input_data(gpio);
		if(temp)
			gpio_status_get.level = "GPIO_HIGH";
		else
			gpio_status_get.level = "GPIO_LOW";
	}
	else
	{
		gpio_status_get.direction = "GPIO_OUT";
		temp=zx29_gpio_outputdata_get(gpio);
		if(temp)
			gpio_status_get.level = "GPIO_HIGH";
		else
			gpio_status_get.level = "GPIO_LOW";
	}
}

/*sectionally get gpio seting parameters in temp_buf[50]  */
static void temp_buf_get(void)
{
    unsigned char n = 0;
	while((temp_buf[buf] != ' ')&&(temp_buf[buf] != '#')&&(temp_buf[buf] != '\0'))
		{
			temp[n++] = temp_buf[buf++];
		}
	temp[n] = '\0';
	buf++;
}

/* analysis  seting parameters in temp_buf[50] to get setting parameters of gpio_num,gpio_function, gpio_dir and gpio_level */
static int parse_temp_buf(char *tempbuf)
{
	unsigned      gpio_num = 0, gpio_dir = 0,gpio_level = 0;
	unsigned int  gpio_func = 0,n = 0;
	unsigned char temp_k = 0,   gpio_flag = 1;
	int ret = 0;

	buf = 0;
/* get function setting parameters in"GPIO40_LTE_DATA_DONGLE0 OUT HIGH#"*/
	temp_buf_get();

	for(n=0; n<ARRAY_SIZE(gpio_def); n++)
	{
		if(!strcmp(gpio_def[n].gpio_name,temp))
		{
			gpio_num = gpio_def[n].gpio_num;
        	gpio_func = gpio_def[n].gpio_func;
			break;
		}
		if(!strcmp(gpio_def[n].gpio_name ,"GPIO FUNCTION NOT EXIST"))
		{
			printk("gpio_func INVALID INPUT\n");
			return -EINVAL;
		}
	}

	ret = zx29_gpio_function_sel(gpio_num, gpio_func);
	if(ret)
		return ret;

/*juge gpio is used as GPIO (GPIO40_GPIO40,the two strings besides the '_' are same) or multiplex function */
	temp_k = (strlen(temp)-1)/2;
	for(n=0;n<temp_k;n++)
    {
		if(temp[n] != temp[temp_k+1+n])
	 	 {
			gpio_flag = 0;
			break;
   	     }
    }

	if(!gpio_flag)
		return 0;

/* get direction setting parameters in"GPIO40_LTE_DATA_DONGLE0 OUT HIGH#"*/

	temp_buf_get();

	if(!strcmp(temp,""))/*just set GPIO function*/
		return 0;
	else if(!strcmp(temp,"IN"))
		gpio_dir = GPIO_IN;
	else if(!strcmp(temp,"OUT"))
		gpio_dir = GPIO_OUT;
	else
	{
 		printk("gpio_dir INVALID INPUT\n");
				return -EINVAL;
	}

	zx29_gpio_set_direction(gpio_num,gpio_dir);

	if(gpio_dir == GPIO_IN)
		return 0;

/* get level setting parameters in"GPIO40_LTE_DATA_DONGLE0 OUT HIGH#"*/
	temp_buf_get();

	if(!strcmp(temp,"HIGH"))
 		gpio_level = GPIO_HIGH;
	else if(!strcmp(temp,"LOW"))
 		gpio_level = GPIO_LOW;
	else
	{
 		printk("gpio_level INVALID INPUT\n");
		return -EINVAL;
	}

	zx29_gpio_output_data(gpio_num,gpio_level);

	return 0;
 }

unsigned int gpio_param_valid(unsigned int num)
{
	unsigned int n,valid = 0;

	for(n=0; n<ARRAY_SIZE(pin_info); n++)
	{	if(pin_info[n].gpio == num)
		{
		  valid = 1;
		  break;
		}
	}
	return valid;
}

static int dbg_gpio_show(struct seq_file *s, void *unused)
{

    unsigned int num;

    seq_printf(s,"The gpio module status:\n");

	for(num = 0; num <= ZX29_GPIO_MAX; num++)
	{
		if(gpio_param_valid(num))
		{
			zx29_gpio_status_get(num);
			seq_printf(s,"%-30s",gpio_status_get.function);
			seq_printf(s,"%-15s",gpio_status_get.direction);
			seq_printf(s,"%-15s\n",gpio_status_get.level);
		}
	}

	return 0;
}

ssize_t gpio_debug_write (struct file *file, const char __user *buf, size_t size, loff_t *p)
{
	int ret;

	if(copy_from_user(temp_buf, buf, size))
		printk("copy user failed\n");

  /*parse temp_buf*/
   ret=parse_temp_buf(temp_buf);

   if(!ret)
		printk("GPIO setting succeed\n");
   else
	{
		printk("GPIO setting failed\n");
		printk("please follow the format to input GPIO parameters :\"GPIO40_GPI40 OUT HIGH#\"\n");
	}
	return size;
}

static int dbg_gpio_open(struct inode *inode, struct file *file)
{
	return single_open(file, dbg_gpio_show, &inode->i_private);
}


static const struct file_operations debug_fops = {
	.open		= dbg_gpio_open,
	.read		= seq_read,
	.write		= gpio_debug_write,
	.llseek		= seq_lseek,
	.release	= single_release,
};

static void zx29_gpio_debuginit(void)
{
	(void) debugfs_create_file("zx29_gpio", S_IRUGO,
					NULL, NULL, &debug_fops);
}

late_initcall(zx29_gpio_debuginit);

#endif


