/*
 *  arch/arm/mach-zx297520v2/io.c
 *
 *  Copyright (C) 2015 ZTE-TSP
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/io.h>
#include <linux/export.h>
#include <linux/dma-mapping.h>

#include <asm/page.h>
#include <asm/mach/map.h>

#include <mach/board.h>
#include <mach/iomap.h>

#define ZX29_CHIP_DEVICE_TYPE(name, chip, mem_type) {		\
		.virtual = (unsigned long) ZX_##name##_BASE, 		\
		.pfn = __phys_to_pfn(chip##_##name##_PHYS), 		\
		.length = ZX_##name##_SIZE, 						\
		.type = mem_type, 									\
	 }

#define ZX29_DEVICE_TYPE(name, mem_type) \
		ZX29_CHIP_DEVICE_TYPE(name, ZX29, mem_type)
#define ZX29_DEVICE(name) 	ZX29_DEVICE_TYPE(name, MT_DEVICE)
#define ZX29_CACHE(name) 	ZX29_DEVICE_TYPE(name, MT_DEVICE_CACHED)

static struct map_desc zx29_io_desc[] __initdata = { 
	ZX29_DEVICE(GIC),
	ZX29_DEVICE(AP_PERIPHERAL),
/*	ZX29_DEVICE_TYPE(IRAM0, MT_MEMORY),*/
	ZX29_DEVICE(IRAM0),
	ZX29_DEVICE(IRAM1),
	ZX29_DEVICE(AHB_CFG),
	ZX29_DEVICE(USB),
	ZX29_DEVICE(HSIC),	
	ZX29_DEVICE(APB_CFG),
	ZX29_DEVICE(LSP),
	ZX29_DEVICE(GICC),
	ZX29_DEVICE(GSM_CFG),
	ZX29_DEVICE(GSM_MODEM),
#ifndef CONFIG_SYSTEM_RECOVERY
	ZX29_DEVICE(DDR_MODEM),
#if ZX_DDR_CAPBUF_SIZE > 0
#ifdef _USE_CAP_SYS
	ZX29_DEVICE(DDR_CAPBUF),
#else
	ZX29_CACHE(DDR_CAPBUF),
#endif	
#endif
#endif

#ifdef CONFIG_MEM_TRACKER
	ZX29_CACHE(MEM_TRACKER),
	ZX29_CACHE(KMALLOC_TRACKER),
#endif
};

extern void mem_trace_init(void);
extern void kmalloc_trace_init(void);

void __init zx29_map_io(void)
{
	iotable_init(zx29_io_desc, ARRAY_SIZE(zx29_io_desc));
	
#ifdef CONFIG_MEM_TRACKER
	mem_trace_init();
	kmalloc_trace_init();
#endif
}

