
#include <linux/module.h>
#include <linux/signal.h>
#include <linux/mm.h>
#include <linux/hardirq.h>
#include <linux/init.h>
#include <linux/kprobes.h>
#include <linux/uaccess.h>
#include <linux/page-flags.h>
#include <linux/sched.h>
#include <linux/highmem.h>
#include <linux/perf_event.h>
#include <asm/exception.h>
#include <asm/pgtable.h>
#include <asm/system_misc.h>
#include <asm/system_info.h>
#include <asm/tlbflush.h>
#include <asm/mach/map.h>
#include <linux/slab.h>
#include "fault.h"
#ifdef CONFIG_MMU
#ifdef CONFIG_KPROBES
static inline int notify_page_fault(struct pt_regs*regs,unsigned int fsr){int 
ret=(0x19f5+227-0x1ad8);if(!user_mode(regs)){preempt_disable();if(kprobe_running
()&&kprobe_fault_handler(regs,fsr))ret=(0x179f+348-0x18fa);preempt_enable();}
return ret;}
#else
static inline int notify_page_fault(struct pt_regs*regs,unsigned int fsr){return
(0xd4c+1898-0x14b6);}
#endif
void show_pte(struct mm_struct*mm,unsigned long addr){pgd_t*pgd;if(!mm)mm=&
init_mm;printk(KERN_ALERT"\x70\x67\x64\x20\x3d\x20\x25\x70" "\n",mm->pgd);pgd=
pgd_offset(mm,addr);printk(KERN_ALERT
"\x5b\x25\x30\x38\x6c\x78\x5d\x20\x2a\x70\x67\x64\x3d\x25\x30\x38\x6c\x6c\x78",
addr,(long long)pgd_val(*pgd));do{pud_t*pud;pmd_t*pmd;pte_t*pte;if(pgd_none(*pgd
))break;if(pgd_bad(*pgd)){printk("\x28\x62\x61\x64\x29");break;}pud=pud_offset(
pgd,addr);if(PTRS_PER_PUD!=(0x8ad+2588-0x12c8))printk(
"\x2c\x20\x2a\x70\x75\x64\x3d\x25\x30\x38\x6c\x6c\x78",(long long)pud_val(*pud))
;if(pud_none(*pud))break;if(pud_bad(*pud)){printk("\x28\x62\x61\x64\x29");break;
}pmd=pmd_offset(pud,addr);if(PTRS_PER_PMD!=(0x10f8+258-0x11f9))printk(
"\x2c\x20\x2a\x70\x6d\x64\x3d\x25\x30\x38\x6c\x6c\x78",(long long)pmd_val(*pmd))
;if(pmd_none(*pmd))break;if(pmd_bad(*pmd)){printk("\x28\x62\x61\x64\x29");break;
}if(PageHighMem(pfn_to_page(pmd_val(*pmd)>>PAGE_SHIFT)))break;pte=pte_offset_map
(pmd,addr);printk("\x2c\x20\x2a\x70\x74\x65\x3d\x25\x30\x38\x6c\x6c\x78",(long 
long)pte_val(*pte));
#ifndef CONFIG_ARM_LPAE
printk("\x2c\x20\x2a\x70\x70\x74\x65\x3d\x25\x30\x38\x6c\x6c\x78",(long long)
pte_val(pte[PTE_HWTABLE_PTRS]));
#endif
pte_unmap(pte);}while((0x2070+1685-0x2705));printk("\n");}
#else					
void show_pte(struct mm_struct*mm,unsigned long addr){}
#endif					
static void __do_kernel_fault(struct mm_struct*mm,unsigned long addr,unsigned 
int fsr,struct pt_regs*regs){if(fixup_exception(regs))return;bust_spinlocks(
(0x1844+603-0x1a9e));printk(KERN_ALERT
"\x55\x6e\x61\x62\x6c\x65\x20\x74\x6f\x20\x68\x61\x6e\x64\x6c\x65\x20\x6b\x65\x72\x6e\x65\x6c\x20\x25\x73\x20\x61\x74\x20\x76\x69\x72\x74\x75\x61\x6c\x20\x61\x64\x64\x72\x65\x73\x73\x20\x25\x30\x38\x6c\x78" "\n"
,(addr<PAGE_SIZE)?
"\x4e\x55\x4c\x4c\x20\x70\x6f\x69\x6e\x74\x65\x72\x20\x64\x65\x72\x65\x66\x65\x72\x65\x6e\x63\x65"
:"\x70\x61\x67\x69\x6e\x67\x20\x72\x65\x71\x75\x65\x73\x74",addr);show_pte(mm,
addr);die("\x4f\x6f\x70\x73",regs,fsr);bust_spinlocks((0x20f2+1496-0x26ca));
do_exit(SIGKILL);}static void __do_user_fault(struct task_struct*tsk,unsigned 
long addr,unsigned int fsr,unsigned int sig,int code,struct pt_regs*regs){struct
 siginfo si;
#ifdef CONFIG_DEBUG_USER
if(((user_debug&UDBG_SEGV)&&(sig==SIGSEGV))||((user_debug&UDBG_BUS)&&(sig==
SIGBUS))){printk(KERN_DEBUG
"\x25\x73\x3a\x20\x75\x6e\x68\x61\x6e\x64\x6c\x65\x64\x20\x70\x61\x67\x65\x20\x66\x61\x75\x6c\x74\x20\x28\x25\x64\x29\x20\x61\x74\x20\x30\x78\x25\x30\x38\x6c\x78\x2c\x20\x63\x6f\x64\x65\x20\x30\x78\x25\x30\x33\x78" "\n"
,tsk->comm,sig,addr,fsr);show_pte(tsk->mm,addr);show_regs(regs);}
#endif
tsk->thread.address=addr;tsk->thread.error_code=fsr;tsk->thread.trap_no=
(0x3fc+2315-0xcf9);si.si_signo=sig;si.si_errno=(0x839+5740-0x1ea5);si.si_code=
code;si.si_addr=(void __user*)addr;force_sig_info(sig,&si,tsk);}void do_bad_area
(unsigned long addr,unsigned int fsr,struct pt_regs*regs){struct task_struct*tsk
=current;struct mm_struct*mm=tsk->active_mm;if(user_mode(regs))__do_user_fault(
tsk,addr,fsr,SIGSEGV,SEGV_MAPERR,regs);else __do_kernel_fault(mm,addr,fsr,regs);
}
#ifdef CONFIG_MMU
#define VM_FAULT_BADMAP		65536
#define VM_FAULT_BADACCESS	131072
static inline bool access_error(unsigned int fsr,struct vm_area_struct*vma){
unsigned int mask=VM_READ|VM_WRITE|VM_EXEC;if(fsr&FSR_WRITE)mask=VM_WRITE;if(fsr
&FSR_LNX_PF)mask=VM_EXEC;return vma->vm_flags&mask?false:true;}static int 
__kprobes __do_page_fault(struct mm_struct*mm,unsigned long addr,unsigned int 
fsr,unsigned int flags,struct task_struct*tsk){struct vm_area_struct*vma;int 
fault;vma=find_vma(mm,addr);fault=VM_FAULT_BADMAP;if(unlikely(!vma))goto out;if(
unlikely(vma->vm_start>addr))goto check_stack;good_area:if(access_error(fsr,vma)
){fault=VM_FAULT_BADACCESS;goto out;}return handle_mm_fault(mm,vma,addr&
PAGE_MASK,flags);check_stack:if(vma->vm_flags&VM_GROWSDOWN&&addr>=
FIRST_USER_ADDRESS&&!expand_stack(vma,addr))goto good_area;out:return fault;}
static int __kprobes do_page_fault(unsigned long addr,unsigned int fsr,struct 
pt_regs*regs){struct task_struct*tsk;struct mm_struct*mm;int fault,sig,code;int 
write=fsr&FSR_WRITE;unsigned int flags=FAULT_FLAG_ALLOW_RETRY|
FAULT_FLAG_KILLABLE|(write?FAULT_FLAG_WRITE:(0x1d25+1449-0x22ce));if(
notify_page_fault(regs,fsr))return(0x7a4+7745-0x25e5);tsk=current;mm=tsk->mm;if(
interrupts_enabled(regs))local_irq_enable();if(!mm||pagefault_disabled())goto 
no_context;if(!down_read_trylock(&mm->mmap_sem)){if(!user_mode(regs)&&!
search_exception_tables(regs->ARM_pc))goto no_context;retry:down_read(&mm->
mmap_sem);}else{might_sleep();
#ifdef CONFIG_DEBUG_VM
if(!user_mode(regs)&&!search_exception_tables(regs->ARM_pc))goto no_context;
#endif
}fault=__do_page_fault(mm,addr,fsr,flags,tsk);if((fault&VM_FAULT_RETRY)&&
fatal_signal_pending(current))return(0x188b+2928-0x23fb);perf_sw_event(
PERF_COUNT_SW_PAGE_FAULTS,(0x860+3800-0x1737),regs,addr);if(!(fault&
VM_FAULT_ERROR)&&flags&FAULT_FLAG_ALLOW_RETRY){if(fault&VM_FAULT_MAJOR){tsk->
maj_flt++;perf_sw_event(PERF_COUNT_SW_PAGE_FAULTS_MAJ,(0x480+1288-0x987),regs,
addr);}else{tsk->min_flt++;perf_sw_event(PERF_COUNT_SW_PAGE_FAULTS_MIN,
(0x278+750-0x565),regs,addr);}if(fault&VM_FAULT_RETRY){flags&=~
FAULT_FLAG_ALLOW_RETRY;goto retry;}}up_read(&mm->mmap_sem);if(likely(!(fault&(
VM_FAULT_ERROR|VM_FAULT_BADMAP|VM_FAULT_BADACCESS))))return(0x15f+264-0x267);if(
fault&VM_FAULT_OOM){pagefault_out_of_memory();return(0x60a+8213-0x261f);}if(!
user_mode(regs))goto no_context;if(fault&VM_FAULT_SIGBUS){sig=SIGBUS;code=
BUS_ADRERR;}else{sig=SIGSEGV;code=fault==VM_FAULT_BADACCESS?SEGV_ACCERR:
SEGV_MAPERR;}__do_user_fault(tsk,addr,fsr,sig,code,regs);return
(0x690+3083-0x129b);no_context:__do_kernel_fault(mm,addr,fsr,regs);return
(0x862+5841-0x1f33);}
#else					
static int do_page_fault(unsigned long addr,unsigned int fsr,struct pt_regs*regs
){return(0xac6+2653-0x1523);}
#endif					
#ifdef CONFIG_MMU
static int __kprobes do_translation_fault(unsigned long addr,unsigned int fsr,
struct pt_regs*regs){unsigned int index;pgd_t*pgd,*pgd_k;pud_t*pud,*pud_k;pmd_t*
pmd,*pmd_k;if(addr<TASK_SIZE)return do_page_fault(addr,fsr,regs);if(
interrupts_enabled(regs))local_irq_enable();if(user_mode(regs))goto bad_area;
index=pgd_index(addr);pgd=cpu_get_pgd()+index;pgd_k=init_mm.pgd+index;if(
pgd_none(*pgd_k))goto bad_area;if(!pgd_present(*pgd))set_pgd(pgd,*pgd_k);pud=
pud_offset(pgd,addr);pud_k=pud_offset(pgd_k,addr);if(pud_none(*pud_k))goto 
bad_area;if(!pud_present(*pud))set_pud(pud,*pud_k);pmd=pmd_offset(pud,addr);
pmd_k=pmd_offset(pud_k,addr);
#ifdef CONFIG_ARM_LPAE
index=(0xa3a+3516-0x17f6);
#else
index=(addr>>SECTION_SHIFT)&(0x4dc+4717-0x1748);
#endif
if(pmd_none(pmd_k[index]))goto bad_area;copy_pmd(pmd,pmd_k);return
(0x14a1+595-0x16f4);bad_area:do_bad_area(addr,fsr,regs);return(0x309+327-0x450);
}
#else					
static int do_translation_fault(unsigned long addr,unsigned int fsr,struct 
pt_regs*regs){return(0xf8c+827-0x12c7);}
#endif					
static int do_sect_fault(unsigned long addr,unsigned int fsr,struct pt_regs*regs
){if(interrupts_enabled(regs))local_irq_enable();do_bad_area(addr,fsr,regs);
return(0x43f+2234-0xcf9);}static int do_bad(unsigned long addr,unsigned int fsr,
struct pt_regs*regs){return(0x600+1157-0xa84);}struct fsr_info{int(*fn)(unsigned
 long addr,unsigned int fsr,struct pt_regs*regs);int sig;int code;const char*
name;};
#ifdef CONFIG_ARM_LPAE
#include "fsr-3level.c"
#else
#include "fsr-2level.c"
#endif
void __init hook_fault_code(int nr,int(*fn)(unsigned long,unsigned int,struct 
pt_regs*),int sig,int code,const char*name){if(nr<(0x1607+1055-0x1a26)||nr>=
ARRAY_SIZE(fsr_info))BUG();fsr_info[nr].fn=fn;fsr_info[nr].sig=sig;fsr_info[nr].
code=code;fsr_info[nr].name=name;}
#ifdef CONFIG_MODEM_CODE_IS_MAPPING
static DECLARE_RWSEM(shrinker_rwsem);atomic_t _code_page_count=ATOMIC_INIT(
(0x2399+72-0x23e1));struct addr_info{struct list_head node;unsigned long vaddr;
unsigned long kaddr;unsigned long page_index;};enum modem_access_technology{GSM=
(0x1683+1171-0x1b16),UTRAN=(0xeb+6163-0x18fd),LTE=(0x1d59+2162-0x25c9),COM=
(0x114b+2982-0x1cee),NR_MODEM_ACCESS=(0x1028+1459-0x15d7)};struct list_head 
modem_page_list[NR_MODEM_ACCESS]={LIST_HEAD_INIT(modem_page_list[
(0xd99+3077-0x199e)]),LIST_HEAD_INIT(modem_page_list[(0xb55+1934-0x12e2)]),
LIST_HEAD_INIT(modem_page_list[(0x2ba+846-0x606)]),LIST_HEAD_INIT(
modem_page_list[(0x91+6745-0x1ae7)]),};unsigned int page_used[
(0x1785+1517-0x1d4a)];struct completion page_completion[(0x763+6693-0x2160)*
(0x128a+1740-0x1936)];static void unmap_pte_range(pmd_t*pmd,unsigned long addr,
unsigned long end){pte_t*pte;pte=pte_offset_kernel(pmd,addr);do{pte_t ptent=
ptep_get_and_clear(&init_mm,addr,pte);WARN_ON(!pte_none(ptent)&&!pte_present(
ptent));}while(pte++,addr+=PAGE_SIZE,addr!=end);}static void unmap_pmd_range(
pud_t*pud,unsigned long addr,unsigned long end){pmd_t*pmd;unsigned long next;pmd
=pmd_offset(pud,addr);do{next=pmd_addr_end(addr,end);if(pmd_none_or_clear_bad(
pmd))continue;unmap_pte_range(pmd,addr,next);}while(pmd++,addr=next,addr!=end);}
static void unmap_pud_range(pgd_t*pgd,unsigned long addr,unsigned long end){
pud_t*pud;unsigned long next;pud=pud_offset(pgd,addr);do{next=pud_addr_end(addr,
end);if(pud_none_or_clear_bad(pud))continue;unmap_pmd_range(pud,addr,next);}
while(pud++,addr=next,addr!=end);}static void unmap_page_range(unsigned long 
addr,unsigned long end){pgd_t*pgd;unsigned long next;BUG_ON(addr>=end);pgd=
pgd_offset_k(addr);do{next=pgd_addr_end(addr,end);if(pgd_none_or_clear_bad(pgd))
continue;unmap_pud_range(pgd,addr,next);}while(pgd++,addr=next,addr!=end);}void 
shrink_modem_mem(unsigned int access_type){int i=(0x465+5747-0x1ad8);unsigned 
long vaddr;struct addr_info*addr,*tmp_addr;struct list_head tmp_page_list;for(i=
(0xddb+5947-0x2516);i<NR_MODEM_ACCESS;i++){if(i==access_type)continue;down_write
(&shrinker_rwsem);list_replace_init(&modem_page_list[i],&tmp_page_list);up_write
(&shrinker_rwsem);list_for_each_entry_safe(addr,tmp_addr,&tmp_page_list,node){
list_del_init(&addr->node);page_completion[addr->page_index].done=
(0x1216+1765-0x18fb);page_used[addr->page_index/BITS_PER_LONG]&=~(
(0x750+5562-0x1d09)<<(addr->page_index%BITS_PER_LONG));vaddr=addr->vaddr&
PAGE_MASK;if(vaddr<cpps_global_var.cpko_text_start||vaddr>cpps_global_var.
modem_text_end){panic(
"\x61\x64\x64\x72\x5f\x69\x6e\x66\x6f\x3a\x20\x25\x30\x38\x78\x20\x69\x73\x20\x20\x64\x65\x73\x74\x72\x6f\x79"
,addr);}flush_cache_vunmap(vaddr,vaddr+PAGE_SIZE);unmap_page_range(vaddr,vaddr+
PAGE_SIZE);flush_tlb_kernel_range(vaddr,vaddr+PAGE_SIZE);
#ifdef CONFIG_DEBUG_RODATA
unsigned int flags;local_irq_save(flags);set_memory_rw(addr->kaddr,
(0xc78+2526-0x1655));local_irq_restore(flags);
#endif
free_page(addr->kaddr);kfree(addr);atomic_dec(&_code_page_count);};}}
EXPORT_SYMBOL(shrink_modem_mem);phys_addr_t virt_is_mapping(unsigned long addr){
pgd_t*pgd;pmd_t*pmd;pte_t*ptep,pte;unsigned long pfn;pgd=pgd_offset_k(addr);if(!
pgd_none(*pgd)){pmd=pmd_offset(pgd,addr);if(!pmd_none(*pmd)){ptep=pte_offset_map
(pmd,addr);pte=*ptep;if(pte_present(pte)){pfn=pte_pfn(pte);return __pfn_to_phys(
pfn);}}}return(0x190c+800-0x1c2c);}static int sync_pgd(unsigned long addr,
unsigned int fsr,struct pt_regs*regs){unsigned int index;pgd_t*pgd,*pgd_k;pud_t*
pud,*pud_k;pmd_t*pmd,*pmd_k;index=pgd_index(addr);pgd=cpu_get_pgd()+index;pgd_k=
init_mm.pgd+index;if(pgd_none(*pgd_k))goto bad_area;if(!pgd_present(*pgd))
set_pgd(pgd,*pgd_k);pud=pud_offset(pgd,addr);pud_k=pud_offset(pgd_k,addr);if(
pud_none(*pud_k))goto bad_area;if(!pud_present(*pud))set_pud(pud,*pud_k);pmd=
pmd_offset(pud,addr);pmd_k=pmd_offset(pud_k,addr);
#ifdef CONFIG_ARM_LPAE
index=(0x1dbc+1350-0x2302);
#else
index=(addr>>SECTION_SHIFT)&(0xc67+3102-0x1884);
#endif
if(pmd_none(pmd_k[index]))goto bad_area;copy_pmd(pmd,pmd_k);return
(0x639+7995-0x2574);bad_area:do_bad_area(addr,fsr,regs);return(0x974+1492-0xf48)
;}unsigned long*read_code_file(unsigned long page_index){unsigned long*code_buf;
ssize_t result;code_buf=get_zeroed_page(GFP_ATOMIC);if(!code_buf)panic(
"\x6d\x65\x6d\x65\x6f\x72\x79\x20\x6e\x6f\x74\x20\x65\x6e\x6f\x75\x67\x68\x21\x21"
);atomic_inc(&_code_page_count);if(IS_ERR(cpps_global_var.fp_code)||
cpps_global_var.fp_code==NULL){panic(
"\x6f\x70\x65\x6e\x20\x66\x69\x6c\x65\x20\x65\x72\x72\x6f\x72" "\n");}
mm_segment_t old_fs;old_fs=get_fs();set_fs(KERNEL_DS);loff_t pos;pos=page_index*
PAGE_SIZE+cpps_global_var.modem_offset;result=vfs_read(cpps_global_var.fp_code,(
char*)code_buf,PAGE_SIZE,&pos);if(result<(0xa91+2002-0x1263)){panic(
"\x72\x65\x61\x64\x20\x63\x6f\x64\x65\x20\x66\x69\x6c\x65\x20\x65\x72\x72\x6f\x72" "\n"
);}
#ifdef CONFIG_DEBUG_RODATA
unsigned int flags;local_irq_save(flags);set_memory_ro((unsigned long)code_buf,
(0x1175+5435-0x26af));local_irq_restore(flags);
#endif
set_fs(old_fs);return code_buf;}void read_code_mapping(unsigned long addr,
unsigned int fsr,struct pt_regs*regs){unsigned long offset;unsigned long vaddr;
const struct mem_type*mtype;unsigned long*vir_codebuf;unsigned long page_index;
unsigned long page_shift;if(virt_is_mapping(addr&PAGE_MASK)!=(0x1078+970-0x1442)
){sync_pgd(addr&PAGE_MASK,fsr,regs);return;}vaddr=addr&PAGE_MASK;offset=vaddr&(~
cpps_global_var.cpko_text_start);page_index=offset>>PAGE_SHIFT;page_shift=
page_index%BITS_PER_LONG;if((page_used[page_index/BITS_PER_LONG]>>page_shift)&
(0x8cd+1703-0xf73)){wait_for_completion(&page_completion[page_index]);sync_pgd(
vaddr,fsr,regs);return;}else page_used[page_index/BITS_PER_LONG]|=(
(0x262b+199-0x26f1)<<page_shift);local_irq_enable();vir_codebuf=read_code_file(
page_index);struct addr_info*addr_info;addr_info=kzalloc(sizeof(struct addr_info
),GFP_KERNEL);addr_info->kaddr=vir_codebuf;addr_info->vaddr=addr;addr_info->
page_index=page_index;down_write(&shrinker_rwsem);if(vaddr<cpps_global_var.
__utran_modem_text_start)list_add(&addr_info->node,&modem_page_list[GSM]);else 
if(vaddr<cpps_global_var.__lte_modem_text_start)list_add(&addr_info->node,&
modem_page_list[UTRAN]);else if(vaddr<cpps_global_var.__comm_modem_text_start)
list_add(&addr_info->node,&modem_page_list[LTE]);else list_add(&addr_info->node,
&modem_page_list[COM]);up_write(&shrinker_rwsem);local_irq_disable();mtype=
get_mem_type(MT_MEMORY);ioremap_page(vaddr,__pa(vir_codebuf),mtype);sync_pgd(
vaddr,fsr,regs);flush_icache_range(vaddr,vaddr+PAGE_SIZE);if(waitqueue_active(&
page_completion[page_index].wait))complete_all(&page_completion[page_index]);
return;}
#endif
asmlinkage void __exception do_DataAbort(unsigned long addr,unsigned int fsr,
struct pt_regs*regs){const struct fsr_info*inf=fsr_info+fsr_fs(fsr);struct 
siginfo info;
#ifdef CONFIG_MODEM_CODE_IS_MAPPING
if(addr!=(0x27b+2345-0xba4)&&addr>=cpps_global_var.cpko_text_start&&addr<=
cpps_global_var.modem_text_end){read_code_mapping(addr,fsr&~FSR_LNX_PF,regs);
return;}
#endif
if(!inf->fn(addr,fsr&~FSR_LNX_PF,regs))return;printk(KERN_ALERT
"\x55\x6e\x68\x61\x6e\x64\x6c\x65\x64\x20\x66\x61\x75\x6c\x74\x3a\x20\x25\x73\x20\x28\x30\x78\x25\x30\x33\x78\x29\x20\x61\x74\x20\x30\x78\x25\x30\x38\x6c\x78" "\n"
,inf->name,fsr,addr);info.si_signo=inf->sig;info.si_errno=(0x12f4+981-0x16c9);
info.si_code=inf->code;info.si_addr=(void __user*)addr;arm_notify_die("",regs,&
info,fsr,(0x88a+5335-0x1d61));}void __init hook_ifault_code(int nr,int(*fn)(
unsigned long,unsigned int,struct pt_regs*),int sig,int code,const char*name){if
(nr<(0x49d+2407-0xe04)||nr>=ARRAY_SIZE(ifsr_info))BUG();ifsr_info[nr].fn=fn;
ifsr_info[nr].sig=sig;ifsr_info[nr].code=code;ifsr_info[nr].name=name;}
asmlinkage void __exception do_PrefetchAbort(unsigned long addr,unsigned int 
ifsr,struct pt_regs*regs){const struct fsr_info*inf=ifsr_info+fsr_fs(ifsr);
struct siginfo info;
#ifdef CONFIG_MODEM_CODE_IS_MAPPING
if(addr!=(0x640+66-0x682)&&addr>=cpps_global_var.cpko_text_start&&addr<=
cpps_global_var.modem_text_end){read_code_mapping(addr,ifsr|FSR_LNX_PF,regs);
return;}
#endif
if(!inf->fn(addr,ifsr|FSR_LNX_PF,regs))return;printk(KERN_ALERT
"\x55\x6e\x68\x61\x6e\x64\x6c\x65\x64\x20\x70\x72\x65\x66\x65\x74\x63\x68\x20\x61\x62\x6f\x72\x74\x3a\x20\x25\x73\x20\x28\x30\x78\x25\x30\x33\x78\x29\x20\x61\x74\x20\x30\x78\x25\x30\x38\x6c\x78" "\n"
,inf->name,ifsr,addr);info.si_signo=inf->sig;info.si_errno=(0x1c51+223-0x1d30);
info.si_code=inf->code;info.si_addr=(void __user*)addr;arm_notify_die("",regs,&
info,ifsr,(0x1d0+4120-0x11e8));}
#ifndef CONFIG_ARM_LPAE
static int __init exceptions_init(void){if(cpu_architecture()>=CPU_ARCH_ARMv6){
hook_fault_code((0x764+4528-0x1910),do_translation_fault,SIGSEGV,SEGV_MAPERR,
"\x49\x2d\x63\x61\x63\x68\x65\x20\x6d\x61\x69\x6e\x74\x65\x6e\x61\x6e\x63\x65\x20\x66\x61\x75\x6c\x74"
);}if(cpu_architecture()>=CPU_ARCH_ARMv7){hook_fault_code((0x4d6+2200-0xd6b),
do_bad,SIGSEGV,SEGV_MAPERR,
"\x73\x65\x63\x74\x69\x6f\x6e\x20\x61\x63\x63\x65\x73\x73\x20\x66\x6c\x61\x67\x20\x66\x61\x75\x6c\x74"
);hook_fault_code((0x20c1+876-0x2427),do_bad,SIGSEGV,SEGV_MAPERR,
"\x73\x65\x63\x74\x69\x6f\x6e\x20\x61\x63\x63\x65\x73\x73\x20\x66\x6c\x61\x67\x20\x66\x61\x75\x6c\x74"
);}
#ifdef CONFIG_MODEM_CODE_IS_MAPPING
int index=(0x163a+491-0x1825);for(index=(0x206f+1293-0x257c);index<
(0x202+3890-0x110c)*(0xb4c+4316-0x1c08);index++)init_completion(&page_completion
[index]);
#endif
return(0xaab+3609-0x18c4);}arch_initcall(exceptions_init);
#endif

