/*******************************************************************************
* Ȩ (C)2016, ͨѶɷ޹˾
* 
* ļ:     ramdump_client_cap.c
* ļʶ:     ramdump_client_cap.c
* ժҪ:     ramdump capͻ쳣ֳݵʵ
* 
* ޸        汾      ޸ı        ޸          ޸
* ------------------------------------------------------------------------------
* 2019/10/10      V1.0        Create          00130574         
* 
*******************************************************************************/

/*******************************************************************************
*                                   ͷļ                                     *
*******************************************************************************/
#include "ramdump_pub.h"
#include "ramdump_oss.h"
#include <linux/module.h>

#ifdef __cplusplus
extern "C" {
#endif

/*******************************************************************************
*                                                                      *
*******************************************************************************/

/*******************************************************************************
*                                   궨                                     *
*******************************************************************************/

/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/

/*******************************************************************************
*                                                                  *
*******************************************************************************/

/*******************************************************************************
*                              ֲ̬                                *
*******************************************************************************/
static int ramdump_cap_init_flag;
static int ramdump_count;

#define RAMDUMP_ON_DEFAULT_VAL  (1)
#define ramdump_cap_cmm_buf  	(ZX_DDR_CAPBUF_BASE + ICP_CAP_BUF_LEN + TOOL_CAP_BUF_LEN)

/*******************************************************************************
*                                ȫֱ                                  *
*******************************************************************************/
/*
 * run time control dump or not, use ( echo "0" > ramdump_on ) to close ramdump
 */
int sysctl_ramdump_on_panic = RAMDUMP_ON_DEFAULT_VAL;

/*******************************************************************************
*                                ֲʵ                                  *
*******************************************************************************/
/*******************************************************************************
* :     ramdump_cap_icp_handle
* ˵:     
*   ()  buf: icp msg addr
*               len: icp msg len
*   ()  void
*   ֵ:     void
* ˵:     This function is used for ramdump client icp msg handle, common entry
*******************************************************************************/
static void ramdump_cap_icp_handle(void *buf, unsigned int len)
{
    ramdump_msg_t *icp_msg = (ramdump_msg_t *)buf;
   
	switch(icp_msg->msg_id)
    {
        case RAMDUMP_MSG_EXCEPT:
        {
            OSS_PANIC("trans server received forced dump request from Ap server!\n");

            break;
        }

        default:
		{
			OSS_PANIC("trans server received forced dump request from Ap server!\n");
		
			break;
		}
    }
}

/*******************************************************************************
* :    ramdump_oss_icp_create_channel
* ˵:     
*   () actorID: icp send core id
               chID:    icp channel id
               size:    icp channel size
*   () void 
*   ֵ:    int: if msg send success 
* ˵:    
*******************************************************************************/
static int ramdump_cap_icp_create_channel(
        ramdump_oss_icp_actorid actorID, 
        ramdump_oss_icp_channelid chID, 
        unsigned int size)
{
    return zDrvRpMsg_CreateChannel(actorID, chID, size);
}

/*******************************************************************************
* :    ramdump_oss_icp_regcallback
* ˵:     
*   () actorID: icp send core id
               chID:    icp channel id
               callback:icp callback fun
*   () void 
*   ֵ:    int: if msg send success 
* ˵:    
*******************************************************************************/
static int ramdump_cap_icp_regcallback (
        ramdump_oss_icp_actorid actorID, 
        unsigned int chID, 
        ramdump_oss_icp_callback callback)
{
    return zDrvRpMsg_RegCallBack(actorID,chID,callback);
}

/*******************************************************************************
* :     ramdump_cap_icp_init
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     This function is used for ramdump client icp init
*******************************************************************************/
static int ramdump_cap_icp_init(void)
{
    int ret = 0;
	
    ret = ramdump_cap_icp_create_channel(
            AP_ID, 
            RAMDUMP_CHANNEL, 
            RAMDUMP_CHANNEL_SIZE);

    if (ret != RAMDUMP_SUCCESS) 
        return ret;
    ret = ramdump_cap_icp_regcallback(
            AP_ID,
            RAMDUMP_CHANNEL, 
            ramdump_cap_icp_handle);

    if (ret != RAMDUMP_SUCCESS)
        return ret;
	
	return RAMDUMP_SUCCESS;
}

/*******************************************************************************
* :     ramdump_notify_server_panic
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     This function is used for cap notify ramdump server to panic
*******************************************************************************/
static void ramdump_notify_server_panic()
{
    int Rlt = 0;

    T_ZDrvRpMsg_Msg tMsg ={AP_ID, RAMDUMP_CHANNEL, 1, NULL, 0};

    Rlt = zDrvRpMsg_WriteLockIrq(&tMsg);
}

/*******************************************************************************
* :    ramdump_cap_store_ram_conf
* ˵:     
*   () mem: addr
*   () void 
*   ֵ:    unsigend char*: changed addr
* ˵:    This function is used to store ram conf
*******************************************************************************/
static unsigned char *ramdump_cap_store_ram_conf(unsigned char *mem)
{
	unsigned long cap_cmm_phy = 0;
	
	cap_cmm_phy = RAMDUMP_CAP_CMM_BUF_ADDR;
		
	mem += sprintf(
            mem, 
            "data.load.binary &ramdump_dir\\%s 0x%x--0x%x /noclear\n",
            "cap_ddr",
            (unsigned long)DDR_BASE_CAP_ADDR_PA, 
            (unsigned int)(DDR_BASE_CAP_ADDR_PA + DDR_BASE_LEN_CAP));
   	mem += sprintf(
            mem, 
            "data.load.binary &ramdump_dir\\%s 0x%x--0x%x /noclear\n",
            "cap.cmm",
            cap_cmm_phy, 
            (unsigned int)(cap_cmm_phy + RAMDUMP_CAP_CMM_BUF_LEN));
	return mem;
}
/*******************************************************************************
* :    ramdump_cap_cmm_create
* ˵:     
*   () void
*   () void
*   ֵ:    void
* ˵:    This function is used for server to generate cmm scripts
*******************************************************************************/
static void ramdump_cap_cmm_create(void)
{
    unsigned char *pcmm_buf = ramdump_cap_cmm_buf;

    // store the cmm BEGIN
    pcmm_buf += sprintf(pcmm_buf, "ENTRY &ramdump_dir\n");

	// store procmodes regs
    pcmm_buf = ramdump_arch_store_modes_regs(pcmm_buf);

	// store ram config 
    pcmm_buf = ramdump_cap_store_ram_conf(pcmm_buf);

	// store memory map control regs
    pcmm_buf = ramdump_arch_store_mm_regs(pcmm_buf);

    // store end symbol
    pcmm_buf += sprintf(pcmm_buf, "ENDDO\n");

}
/*******************************************************************************
*                                ȫֺʵ                                  *
*******************************************************************************/
/*******************************************************************************
* :     ramdump_ram_conf_table_add
* ˵:     
*   ()  ram_name:    dump ram name
                ram_start:   dump ram start(virtual addr)
                ram_size:    dump ram size
                ram_virt:    dump ram virt addr
                ram_flag:    dump ram flag(copy/exter/callback)
                ram_extra:   dump ram extra access addr
*   ()  void
*   ֵ:     void
* ˵:     This function is used to add dump ram conf into public table
*******************************************************************************/
void ramdump_ram_conf_table_add(
        char *ram_name, 
        unsigned long ram_phy, 
        unsigned long ram_size, 
        unsigned long ram_virt,
        unsigned long ram_flag,
        unsigned long ram_extra)
{
    ;
}

/*******************************************************************************
* :     ramdump_init
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     RAMDUMP_SUCCESS or RAMDUMP_FAILED
* ˵:     This function is used for ramdump init
*******************************************************************************/
int ramdump_init(void)
{
    int ret = 0;
	
    if (ramdump_cap_init_flag == RAMDUMP_TRUE)
        return RAMDUMP_SUCCESS;

	ret = ramdump_cap_icp_init();
	if (ret != RAMDUMP_ICP_SUCCESS) 
        return ret;

	OSS_PRINTF("Ramdump cap init success!\n");
    ramdump_cap_init_flag = RAMDUMP_TRUE;
	
    return RAMDUMP_SUCCESS;
}
module_init(ramdump_init);

/*******************************************************************************
* :     ramdump_entry
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     This function is used for ramdump entry
*******************************************************************************/
void ramdump_entry (void)
{
	 unsigned long flags;
	 if (sysctl_ramdump_on_panic == FALSE)
        return;

    /*
     * we need lock the irq, this can`t be interrupt.
     */
    OSS_LOCK(flags);

    if (!ramdump_cap_init_flag)
        while(TRUE); /* endless circle */

    if (++ramdump_count > 1)
        while(TRUE); /* endless circle */
   
    /*
     * save all regs first.
     */
    ramdump_arch_save_all_regs();
   
    //cmműĵ
    ramdump_cap_cmm_create();
	/* notify client ramdump */
    ramdump_notify_server_panic();
	ramdump_arch_clean_caches();
	
	while(TRUE);

    OSS_UNLOCK(flags);
}

#ifdef __cplusplus
}
#endif


MODULE_LICENSE("GPL");
