/*******************************************************************************
* Ȩ (C)2016, ͨѶɷ޹˾
* 
* ļ: 	ramdump_compress.c
* ļʶ: 	ramdump_compress.c
* ժҪ: 	ramdump쳣ֳݵʵ
* 
* ޸		  汾 	 ޸ı		 ޸			޸
* ------------------------------------------------------------------------------
* 2016/3/10 	 V1.0		 Create 		  Ծ 		 
* 
*******************************************************************************/

/*******************************************************************************
*									ͷļ									  *
*******************************************************************************/
#include <linux/lzo.h>
#include "ramdump_compress.h"
#include "ramdump_oss.h"

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _USE_VEHICLE_DC
/*******************************************************************************
*                                                                      *
*******************************************************************************/

/*******************************************************************************
*                                   궨                                     *
*******************************************************************************/

/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/
/*******************************************************************************
*                                ȫֱ                                  *
*******************************************************************************/
void *ramdump_lzo_mem = NULL;
unsigned int ramdump_compress_flag = 0;
extern unsigned char *ramdump_shared_mem_base;
/*******************************************************************************
*                                ֲʵ                                  *
*******************************************************************************/

/*******************************************************************************
* :     ramdump_lzma_free_workspace
* ˵:     
*   ()
*   ()  void
*   ֵ:     void
* ˵:     This function is used to add dump ram conf into public table
*******************************************************************************/
static void ramdump_lzo_free_workspace(void)
{
	ramdump_lzo_mem = NULL;
}

static int ramdump_lzo_alloc_workspace(void)
{
	ramdump_lzo_mem = ramdump_shared_mem_base + RAMDUMP_SHARED_MEM_LEN;

	return 0;
}

int ramdump_lzo_compress(unsigned char *data_in, size_t in_len, 
				unsigned char *data_out, size_t *out_len)
{
	size_t compress_size = 0;
	int ret = -1;	

	ret = lzo1x_1_compress(data_in, in_len, data_out, &compress_size, ramdump_lzo_mem);
	*out_len = compress_size;
	return ret;
}

int ramdump_lzo_decompress(unsigned char *data_in, size_t in_len, 
				unsigned char *data_out, size_t *out_len)
{
	int ret;

	ret = lzo1x_decompress_safe(data_in, in_len, data_out, out_len);
	return ret;
}

int ramdump_lzo_init(void)
{
	ramdump_lzo_alloc_workspace();
	ramdump_compress_flag = 1;

	return 0;
}
#endif

#ifdef __cplusplus
}
#endif

