/***************************************************************************************************/
/*Ϊ˽ftp·Ĳʱʵ˶еackйɵĶ*/
/*Ըftp*/
/***************************************************************************************************/

#include <linux/in.h>
#include <linux/ip.h>
#include <linux/udp.h>
#include <linux/tcp.h>
#include <linux/icmp.h>
#include <net/ip.h>
#include <linux/if_arp.h>

#include <linux/inetdevice.h>
#include <linux/netfilter.h>
#include <linux/netfilter_ipv4.h>
#include <linux/netfilter_arp.h>
#include <linux/netfilter_ipv4/ip_tables.h>
#include <linux/netfilter/xt_multiport.h>
#include <linux/netfilter/xt_iprange.h>
#include <linux/netfilter/nf_conntrack_tcp.h>
#include <net/checksum.h>
#include <net/dsfield.h>
#include <net/route.h>
#include <net/netfilter/nf_nat.h>
#include <net/netfilter/nf_nat_core.h>
#include <net/netfilter/nf_nat_rule.h>
#include <net/netfilter/nf_conntrack_helper.h>
#include <linux/module.h>

#include <linux/proc_fs.h>
#include <net/SI/fastnat.h>
#include <net/SI/fast6.h>

MODULE_LICENSE("GPL");
/**********************************************************************************************************************************/
/**********************************************************************************************************************************/
int ackdrop_maxnum = 0; //ack,0ʾùܲЧ

int ackdrop_tick_num = 40; //ʱtick

int fastnat_ack_param = 0;

#define TCP_FLAG_MASK __cpu_to_be32(0x00FF0000)

fast_entry_t *cur_timeout_entry;
struct ack_delay_stats_s ack_delay_stats = {0};

extern char ps_name[];

//ִжackĵԶʱԽСʱacḵĵ
int ackfilter(struct sk_buff *skb, fast_entry_t *nat_entry, fast_list_t *list_head)
{
    struct iphdr *iph = NULL;
    struct tcphdr *tcph = NULL;

    iph  = (struct iphdr *)(skb->data + ETH_HLEN);
    tcph = (struct tcphdr *)(skb->data + ETH_HLEN + iph->ihl * 4);
    
    // fastnat_ack_paramΪ1ackdrop_num1ʱack
    if ((fastnat_ack_param == 1) && (ackdrop_maxnum  >= 1))
    {
        // ѽӵtcpд
        if(nat_entry->ct->proto.tcp.state == TCP_CONNTRACK_ESTABLISHED)
        {
            // tcpݣtcp־λΪackΪwan0ʱݹ
            if((ntohs(iph->tot_len) == iph->ihl * 4 + tcph->doff * 4)
                && ((tcp_flag_word(tcph) & TCP_FLAG_MASK) == TCP_FLAG_ACK)
                && (!strcmp(skb->dev->name, ps_name)))
            {
                nat_entry->ackdrop_num++;

                ack_delay_stats.total_count++;

                // һӣÿackdrop_maxnumackתһ
                if (nat_entry->ackdrop_num == ackdrop_maxnum)
                {
                    ack_delay_stats.forword_count++;
                                
                    if(nat_entry->predrop_skb != NULL)
                    {
                        ack_delay_stats.drop_count++;
                        kfree_skb(nat_entry->predrop_skb);
                    }
                    nat_entry->predrop_skb = NULL;
                    nat_entry->ackstart_tick = 0;
                    nat_entry->ackdrop_num = 0;
                    // ǰĳʱΪʱŸtimeoutʱΪǰackʱѾЧˣҪʱ̵
                    if(cur_timeout_entry == nat_entry)
                        mod_timer(&nat_entry->timeout, jiffies + tcp_timeouts[nat_entry->ct->proto.tcp.state]);
                }
                else // δﵽƵʵĶackģͣ1
                {
                    if(nat_entry->predrop_skb != NULL)
                    {
                        ack_delay_stats.drop_count++;
                        kfree_skb(nat_entry->predrop_skb);
                        nat_entry->predrop_skb = skb;
                    }
                    else
                    {
                        // Եһackģִtimeout£Ч
                        nat_entry->predrop_skb = skb;
                        nat_entry->ackstart_tick = jiffies;
                    }
                    return 1;
                }
            }
        }
    }
    return 0;
}


//ڳʱacḵģԼ³ʱʱ̵㣻кΣ
int tcpack_timeout(fast_entry_t *entry, unsigned long *next_schedule, int *set_next)
{
    unsigned long timeout_at;

    // fastnat_ack_paramΪ1ackdrop_num1ʱack
    if ((fastnat_ack_param == 1) && (ackdrop_maxnum >= 1))
    {
        // ʱͶackģԽСack
        if(entry->predrop_skb != NULL )
        {
            timeout_at = entry->ackstart_tick + ackdrop_tick_num ;
            if(time_after_eq(jiffies, timeout_at))
            {
                // ackʱ͸ack
                ack_delay_stats.timeout_xmit_count++;

                dev_queue_xmit(entry->predrop_skb);
                entry->predrop_skb = NULL;
                entry->ackstart_tick = 0;
            }
            //¸ʱʱ̵
            else if((!*set_next) || time_before(timeout_at, *next_schedule))
            {
                // ¼ĳʱʱ
                cur_timeout_entry = entry;
                *next_schedule = timeout_at;
                if(!*set_next)
                {
                    *set_next = 1;
                }
            }
        }
    }
	return 0;
}

//ͷʱҪͬͷŻacḵģڴй¶
int tcpack_rel(fast_entry_t *entry)
{
    // ɾǰϹŵack
    if ((fastnat_ack_param == 1) && (ackdrop_maxnum >= 1))
    {
        if (entry->predrop_skb != NULL)
        {
            ack_delay_stats.timeout_drop_count++;

            kfree_skb(entry->predrop_skb);
            entry->predrop_skb = NULL;
        }
        entry->ackstart_tick = 0;
        entry->ackdrop_num = 0;
    }
	return 0;
}
