#include <linux/spinlock_types.h>
#include <linux/spinlock.h>

#include <linux/compiler.h>
#include <linux/kernel.h>
#include <linux/bug.h>



//#define SKB_TRACE /*for trace the max size and number*/



#define SKB_SYS_POOL_SMALL_8_NR     (0)     /*   8 Bytes,      0x1,  bit0 */
#define SKB_SYS_POOL_SMALL_16_NR    (0)    /*  16 Bytes,      0x2,  bit1 */
#define SKB_SYS_POOL_SMALL_24_NR    (0)     /*  24 Bytes,      0x4,  bit2 */
#define SKB_SYS_POOL_SMALL_32_NR    (0)     /*  32 Bytes,      0x8,  bit3 */
#define SKB_SYS_POOL_SMALL_40_NR    (0)     /*  40 Bytes,     0x10,  bit4 */
#define SKB_SYS_POOL_SMALL_48_NR    (0)     /*  48 Bytes,     0x20,  bit5 */
#define SKB_SYS_POOL_SMALL_56_NR    (0)    /*  56 Bytes,     0x40,  bit6 */
#define SKB_SYS_POOL_SMALL_64_NR    (0)     /*  64 Bytes,     0x80,  bit7 */
#define SKB_SYS_POOL_SMALL_72_NR    (0)     /*  72 Bytes,    0x100,  bit8 */
#define SKB_SYS_POOL_SMALL_80_NR    (0)     /*  80 Bytes,    0x200,  bit9 */
#define SKB_SYS_POOL_SMALL_88_NR    (0)     /*  88 Bytes,    0x400, bit10 */
#define SKB_SYS_POOL_SMALL_96_NR    (0)     /*  96 Bytes,    0x800, bit11 */
#define SKB_SYS_POOL_SMALL_104_NR   (0)     /* 104 Bytes,   0x1000, bit12 */
#define SKB_SYS_POOL_SMALL_112_NR   (0)     /* 112 Bytes,   0x2000, bit13 */
#define SKB_SYS_POOL_SMALL_120_NR   (0)     /* 120 Bytes,   0x4000, bit14 */
#define SKB_SYS_POOL_SMALL_128_NR   (0)     /* 128 Bytes,   0x8000, bit15 */
#define SKB_SYS_POOL_SMALL_136_NR   (0)     /* 136 Bytes,  0x10000, bit16 */
#define SKB_SYS_POOL_SMALL_144_NR   (0)     /* 144 Bytes,  0x20000, bit17 */
#define SKB_SYS_POOL_SMALL_152_NR   (0)     /* 152 Bytes,  0x40000, bit18 */
#define SKB_SYS_POOL_SMALL_160_NR   (0)     /* 160 Bytes,  0x80000, bit19 */
#define SKB_SYS_POOL_SMALL_168_NR   (0)     /* 168 Bytes, 0x100000, bit20 */
#define SKB_SYS_POOL_SMALL_176_NR   (0)     /* 176 Bytes, 0x200000, bit21 */
#define SKB_SYS_POOL_SMALL_184_NR   (0)     /* 184 Bytes, 0x400000, bit22 */
#define SKB_SYS_POOL_SMALL_192_NR   (0)     /* 192 Bytes, 0x800000, bit23 */

#define SKB_SYS_POOL_0_SIZE     (256) /*skb*/
#define SKB_SYS_POOL_0_NR        (1800)

#define SKB_SYS_POOL_1_SIZE     (1024)/*skb_data*/
#define SKB_SYS_POOL_1_NR        (100)

#define SKB_SYS_POOL_2_SIZE     (2000)
#define SKB_SYS_POOL_2_NR        (1700)

#define SKB_SYS_POOL_3_SIZE     (4096)
#define SKB_SYS_POOL_3_NR        (100)

#define SKB_SYS_POOL_4_SIZE     (0)
#define SKB_SYS_POOL_4_NR       (0)

#define SKB_SYS_POOL_5_SIZE     (0)
#define SKB_SYS_POOL_5_NR       (0)

#define SKB_SYS_POOL_6_SIZE     (0)
#define SKB_SYS_POOL_6_NR       (0)

#define SKB_SYS_POOL_7_SIZE     (0)
#define SKB_SYS_POOL_7_NR       (0)

#define test_bit(nr, val)   ((val) & (1UL<<(nr)))
#define set_bit(nr, val)    ((val) |= (1UL<<(nr)))
#define clear_bit(nr, val)  ((val) &= ~(1UL<<(nr)))
static spinlock_t  skb_sys_pool_spinlock;


typedef struct skb_pool_config_t skb_pool_config_t;
typedef struct skb_pool_t skb_pool_t;
typedef struct skb_pool_node_t skb_pool_node_t;


#ifdef SKB_DBG_POOL
# define skb_pool_magic_top(node, size)                                     \
    ((void *)((skb_addr_t)(node) + sizeof(skb_pool_node_impl_t) + round_up(size, SKB_POOL_ALIGN_SIZE)))
#endif

#ifdef SKB_DBG_POOL
# define SKB_POOL_MAGIC          (0x5A5A5A5A)
# define SKB_POOL_MAGIC_NR      (2)
# define SKB_POOL_MAGIC_SIZE    (sizeof(skb_addr_t) * SKB_POOL_MAGIC_NR)
#else
# define SKB_POOL_MAGIC_SIZE    (0)
#endif

#define skb_pool_ptr(node)                                                  \
    ((void *)((skb_addr_t)(node) + sizeof(skb_pool_node_impl_t)))

#define skb_pool_node(ptr)                                                  \
    ((skb_pool_node_impl_t *)((skb_addr_t)(ptr) - sizeof(skb_pool_node_impl_t)))

#define skb_pool_node_size(obj_size)                                        \
    (sizeof(skb_pool_node_impl_t) + round_up(obj_size, SKB_POOL_ALIGN_SIZE) + SKB_POOL_MAGIC_SIZE)

#define skb_pool_size(obj_size, obj_nr)                                     \
    (sizeof(skb_pool_impl_t) + skb_pool_node_size(obj_size)*(obj_nr))
    
#define is_aligned(x, a)    (((x) & ((typeof(x))(a) - 1)) == 0)

#define ptr_is_aligned(x)   ((x) != NULL && is_aligned((skb_addr_t)x, sizeof(skb_addr_t)))


/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/
typedef unsigned int  skb_count_t;
typedef unsigned int size_t;
typedef unsigned int u32;

#define SKB_POOL_ALIGN_SIZE     (sizeof(skb_addr_t))

typedef struct skb_pool_node_impl_t skb_pool_node_impl_t;

struct skb_pool_node_impl_t
{
    skb_pool_node_impl_t    *free_next;

#ifdef SKB_DBG_POOL
    struct list_head        alloc_node;
    const char              *file;
    unsigned long         tick;
    u32                        line;
    skb_addr_t              *magic_top;
    skb_addr_t              magic_bottom[SKB_POOL_MAGIC_NR];
#endif
} skb_align_data;

typedef struct
{
    skb_pool_node_impl_t    *free_head;
    size_t                  obj_size;

#ifdef SKB_POOL_AUTO_EXTEND
#ifdef SKB_DBG_POOL
    skb_count_t             obj_nr;
#endif
    skb_count_t             obj_cur_nr;
    skb_count_t             obj_max_nr;
    skb_count_t             obj_batch_nr;
#endif

#ifdef SKB_DBG_POOL
    struct list_head        alloc_head;
   /* skb_count_t             obj_cnt;
    skb_count_t             obj_used_cnt;
    skb_count_t             obj_max_used_cnt;*/
#endif

#ifdef SKB_TRACE
    size_t                     obj_real_size[2048];
    size_t                     obj_real_size_cnt;
    skb_count_t             obj_cnt;
    skb_count_t             obj_used_cnt;
    skb_count_t             obj_max_used_cnt;
#endif
} skb_pool_inner_t;
typedef unsigned long skb_addr_t;
#define skb_aligned(x)      __attribute__((aligned(x)))

#define skb_align_data          skb_aligned(sizeof(skb_addr_t))
typedef struct
{
    spinlock_t  lock;
    skb_pool_inner_t    inner;
} skb_align_data skb_pool_impl_t;


struct skb_pool_config_t
{
    void        *addr;      /* base address     */
    size_t      obj_size;   /* object size      */
    skb_count_t obj_nr;     /* object number    */
};


/*******************************************************************************
*                                ȫֱ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ȫֺ                                  *
*******************************************************************************/
skb_pool_inner_t *skb_pool_create_inner(
                    skb_pool_inner_t *inner,
                    size_t           obj_size,
                    skb_count_t      obj_nr,
                    skb_count_t      obj_max_nr,
                    skb_count_t      obj_batch_nr);


#ifdef SKB_DBG_POOL
int skb_pool_magic_check(skb_pool_node_impl_t *node)
{
    int cnt;

    BUG_ON(node == NULL);

    for (cnt = 0x00; cnt < SKB_POOL_MAGIC_NR; cnt++)
    {
        BUG_ON(node->magic_bottom[cnt] != SKB_POOL_MAGIC);
        BUG_ON*(node->magic_top + cnt) != SKB_POOL_MAGIC);
    }

    return 0;
}

static inline void skb_pool_magic_init(skb_pool_node_impl_t *node)
{
    int cnt;

    BUG_ON(node == NULL);

    for (cnt = 0x00; cnt < SKB_POOL_MAGIC_NR; cnt++)
    {
        node->magic_bottom[cnt] = SKB_POOL_MAGIC;
        *(node->magic_top + cnt) = SKB_POOL_MAGIC;
    }
}

#else
static inline int skb_pool_magic_check(skb_pool_node_impl_t *node) { return 0; }
static inline void skb_pool_magic_init(skb_pool_node_impl_t *node){ return 0; }
#endif

void skb_pool_add_inner(
                   skb_pool_inner_t    *inner,
                    skb_pool_node_impl_t *node,
                    unsigned int                  obj_nr)
{
    u32 obj_size;
    skb_count_t cnt;

    BUG_ON( inner == NULL ||node == NULL || obj_nr <= 0);

#ifdef SKB_POOL_AUTO_EXTEND
    BUG_ON((inner->obj_cur_nr + obj_nr) > inner->obj_max_nr);
    inner->obj_cur_nr += obj_nr;
#endif

#ifdef SKB_TRACE
    inner->obj_cnt += obj_nr;
#endif

    inner->free_head = node;
    for (cnt = 0x00, obj_size = inner->obj_size; cnt < obj_nr; cnt++)
    {
        node->free_next = (skb_pool_node_impl_t *)((skb_addr_t)(node) + skb_pool_node_size(obj_size));

#ifdef SKB_DBG_POOL
        node->magic_top = skb_pool_magic_top(node, obj_size);
        skb_pool_magic_init(node);
#endif

        node = node->free_next;
    }
    node = (skb_pool_node_impl_t *)((skb_addr_t)(node) - skb_pool_node_size(obj_size));
    node->free_next = NULL;

}

skb_pool_inner_t *skb_pool_create_inner(
                    skb_pool_inner_t *inner,
                    size_t           obj_size,
                    skb_count_t      obj_nr,
                    skb_count_t      obj_max_nr,
                    skb_count_t      obj_batch_nr)
{
    skb_pool_node_impl_t *node;

    BUG_ON(! ptr_is_aligned(inner) || obj_size <= 0 || obj_nr <= 0);

#ifdef SKB_POOL_AUTO_EXTEND
    BUG_ON(obj_nr + obj_batch_nr) > obj_max_nr);
#ifdef SKB_DBG_POOL
    inner->obj_nr = obj_nr;
#endif
    inner->obj_cur_nr = 0x00;
    inner->obj_max_nr = obj_max_nr;
    inner->obj_batch_nr = obj_batch_nr;
#endif

#ifdef SKB_TRACE
    inner->obj_cnt = 0x00;
    inner->obj_used_cnt = 0x00;
    inner->obj_max_used_cnt = 0x00;
#endif

#ifdef SKB_DBG_POOL
    INIT_LIST_HEAD(&inner->alloc_head);
#endif

    inner->obj_size = obj_size;
    node = (skb_pool_node_impl_t *)(inner + 1);
    skb_pool_add_inner(inner, node, obj_nr);

    return inner;
}


//#define SKB_SYS_POOL_SMALL

#ifdef SKB_SYS_POOL_SMALL

#if (SKB_SYS_POOL_SMALL_8_NR > 0)
     static u8 skb_sys_pool_small_8[skb_pool_size(  8,   SKB_SYS_POOL_SMALL_8_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_SMALL_16_NR > 0)
     static u8 skb_sys_pool_small_16[skb_pool_size( 16,  SKB_SYS_POOL_SMALL_16_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_SMALL_24_NR > 0)
     static u8 skb_sys_pool_small_24[skb_pool_size( 24,  SKB_SYS_POOL_SMALL_24_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_SMALL_32_NR > 0)
     static u8 skb_sys_pool_small_32[skb_pool_size( 32,  SKB_SYS_POOL_SMALL_32_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_SMALL_40_NR > 0)
     static u8 skb_sys_pool_small_40[skb_pool_size( 40,  SKB_SYS_POOL_SMALL_40_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_SMALL_48_NR > 0)
     static u8 skb_sys_pool_small_48[skb_pool_size( 48,  SKB_SYS_POOL_SMALL_48_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_SMALL_56_NR > 0)
     static u8 skb_sys_pool_small_56[skb_pool_size( 56,  SKB_SYS_POOL_SMALL_56_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_SMALL_64_NR > 0)
     static u8 skb_sys_pool_small_64[skb_pool_size( 64,  SKB_SYS_POOL_SMALL_64_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_SMALL_72_NR > 0)
     static u8 skb_sys_pool_small_72[skb_pool_size( 72,  SKB_SYS_POOL_SMALL_72_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_SMALL_80_NR > 0)
     static u8 skb_sys_pool_small_80[skb_pool_size( 80,  SKB_SYS_POOL_SMALL_80_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_SMALL_88_NR > 0)
     static u8 skb_sys_pool_small_88[skb_pool_size( 88,  SKB_SYS_POOL_SMALL_88_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_SMALL_96_NR > 0)
     static u8 skb_sys_pool_small_96[skb_pool_size( 96,  SKB_SYS_POOL_SMALL_96_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_SMALL_104_NR > 0)
     static u8 skb_sys_pool_small_104[skb_pool_size(104, SKB_SYS_POOL_SMALL_104_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_SMALL_112_NR > 0)
     static u8 skb_sys_pool_small_112[skb_pool_size(112, SKB_SYS_POOL_SMALL_112_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_SMALL_120_NR > 0)
     static u8 skb_sys_pool_small_120[skb_pool_size(120, SKB_SYS_POOL_SMALL_120_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_SMALL_128_NR > 0)
     static u8 skb_sys_pool_small_128[skb_pool_size(128, SKB_SYS_POOL_SMALL_128_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_SMALL_136_NR > 0)
     static u8 skb_sys_pool_small_136[skb_pool_size(136, SKB_SYS_POOL_SMALL_136_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_SMALL_144_NR > 0)
     static u8 skb_sys_pool_small_144[skb_pool_size(144, SKB_SYS_POOL_SMALL_144_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_SMALL_152_NR > 0)
     static u8 skb_sys_pool_small_152[skb_pool_size(152, SKB_SYS_POOL_SMALL_152_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_SMALL_160_NR > 0)
     static u8 skb_sys_pool_small_160[skb_pool_size(160, SKB_SYS_POOL_SMALL_160_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_SMALL_168_NR > 0)
     static u8 skb_sys_pool_small_168[skb_pool_size(168, SKB_SYS_POOL_SMALL_168_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_SMALL_176_NR > 0)
     static u8 skb_sys_pool_small_176[skb_pool_size(176, SKB_SYS_POOL_SMALL_176_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_SMALL_184_NR > 0)
     static u8 skb_sys_pool_small_184[skb_pool_size(184, SKB_SYS_POOL_SMALL_184_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_SMALL_192_NR > 0)
     static u8 skb_sys_pool_small_192[skb_pool_size(192, SKB_SYS_POOL_SMALL_192_NR)] skb_align_data;
#endif

#endif  // #ifdef SKB_SYS_POOL_SMALL

#if (SKB_SYS_POOL_0_NR > 0)
     static u8 skb_sys_pool_0[skb_pool_size(SKB_SYS_POOL_0_SIZE, SKB_SYS_POOL_0_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_1_NR > 0)
     static u8 skb_sys_pool_1[skb_pool_size(SKB_SYS_POOL_1_SIZE, SKB_SYS_POOL_1_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_2_NR > 0)
     static u8 skb_sys_pool_2[skb_pool_size(SKB_SYS_POOL_2_SIZE, SKB_SYS_POOL_2_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_3_NR > 0)
     static u8 skb_sys_pool_3[skb_pool_size(SKB_SYS_POOL_3_SIZE, SKB_SYS_POOL_3_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_4_NR > 0)
     static u8 skb_sys_pool_4[skb_pool_size(SKB_SYS_POOL_4_SIZE, SKB_SYS_POOL_4_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_5_NR > 0)
     static u8 skb_sys_pool_5[skb_pool_size(SKB_SYS_POOL_5_SIZE, SKB_SYS_POOL_5_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_6_NR > 0)
     static u8 skb_sys_pool_6[skb_pool_size(SKB_SYS_POOL_6_SIZE, SKB_SYS_POOL_6_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_7_NR > 0)
     static u8 skb_sys_pool_7[skb_pool_size(SKB_SYS_POOL_7_SIZE, SKB_SYS_POOL_7_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_8_NR > 0)
     static u8 skb_sys_pool_8[skb_pool_size(SKB_SYS_POOL_8_SIZE, SKB_SYS_POOL_8_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_9_NR > 0)
     static u8 skb_sys_pool_9[skb_pool_size(SKB_SYS_POOL_9_SIZE, SKB_SYS_POOL_9_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_10_NR > 0)
     static u8 skb_sys_pool_10[skb_pool_size(SKB_SYS_POOL_10_SIZE, SKB_SYS_POOL_10_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_11_NR > 0)
     static u8 skb_sys_pool_11[skb_pool_size(SKB_SYS_POOL_11_SIZE, SKB_SYS_POOL_11_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_12_NR > 0)
     static u8 skb_sys_pool_12[skb_pool_size(SKB_SYS_POOL_12_SIZE, SKB_SYS_POOL_12_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_13_NR > 0)
     static u8 skb_sys_pool_13[skb_pool_size(SKB_SYS_POOL_13_SIZE, SKB_SYS_POOL_13_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_14_NR > 0)
     static u8 skb_sys_pool_14[skb_pool_size(SKB_SYS_POOL_14_SIZE, SKB_SYS_POOL_14_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_15_NR > 0)
     static u8 skb_sys_pool_15[skb_pool_size(SKB_SYS_POOL_15_SIZE, SKB_SYS_POOL_15_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_16_NR > 0)
     static u8 skb_sys_pool_16[skb_pool_size(SKB_SYS_POOL_16_SIZE, SKB_SYS_POOL_16_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_17_NR > 0)
     static u8 skb_sys_pool_17[skb_pool_size(SKB_SYS_POOL_17_SIZE, SKB_SYS_POOL_17_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_18_NR > 0)
     static u8 skb_sys_pool_18[skb_pool_size(SKB_SYS_POOL_18_SIZE, SKB_SYS_POOL_18_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_19_NR > 0)
     static u8 skb_sys_pool_19[skb_pool_size(SKB_SYS_POOL_19_SIZE, SKB_SYS_POOL_19_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_20_NR > 0)
     static u8 skb_sys_pool_20[skb_pool_size(SKB_SYS_POOL_20_SIZE, SKB_SYS_POOL_20_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_21_NR > 0)
     static u8 skb_sys_pool_21[skb_pool_size(SKB_SYS_POOL_21_SIZE, SKB_SYS_POOL_21_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_22_NR > 0)
     static u8 skb_sys_pool_22[skb_pool_size(SKB_SYS_POOL_22_SIZE, SKB_SYS_POOL_22_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_23_NR > 0)
     static u8 skb_sys_pool_23[skb_pool_size(SKB_SYS_POOL_23_SIZE, SKB_SYS_POOL_23_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_24_NR > 0)
     static u8 skb_sys_pool_24[skb_pool_size(SKB_SYS_POOL_24_SIZE, SKB_SYS_POOL_24_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_25_NR > 0)
     static u8 skb_sys_pool_25[skb_pool_size(SKB_SYS_POOL_25_SIZE, SKB_SYS_POOL_25_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_26_NR > 0)
     static u8 skb_sys_pool_26[skb_pool_size(SKB_SYS_POOL_26_SIZE, SKB_SYS_POOL_26_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_27_NR > 0)
     static u8 skb_sys_pool_27[skb_pool_size(SKB_SYS_POOL_27_SIZE, SKB_SYS_POOL_27_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_28_NR > 0)
     static u8 skb_sys_pool_28[skb_pool_size(SKB_SYS_POOL_28_SIZE, SKB_SYS_POOL_28_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_29_NR > 0)
     static u8 skb_sys_pool_29[skb_pool_size(SKB_SYS_POOL_29_SIZE, SKB_SYS_POOL_29_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_30_NR > 0)
     static u8 skb_sys_pool_30[skb_pool_size(SKB_SYS_POOL_30_SIZE, SKB_SYS_POOL_30_NR)] skb_align_data;
#endif

#if (SKB_SYS_POOL_31_NR > 0)
     static u8 skb_sys_pool_31[skb_pool_size(SKB_SYS_POOL_31_SIZE, SKB_SYS_POOL_31_NR)] skb_align_data;
#endif
#define array_start(a)      (&(a)[0])
#define array_nr(a)         (sizeof(a) / sizeof((a)[0]))
#define array_end(a)        (&(a)[array_nr(a)])
#define array_index(a, e)   ((e) - array_start(a))

 static struct skb_pool_config_t  skb_sys_pool_config[] = 
{
#ifdef SKB_SYS_POOL_SMALL

#if (SKB_SYS_POOL_SMALL_8_NR > 0)
    {
        (void *)array_start(skb_sys_pool_small_8),  /* base address     */
        8,                                          /* object size      */
        SKB_SYS_POOL_SMALL_8_NR,                    /* object number    */
    },
#endif

#if (SKB_SYS_POOL_SMALL_16_NR > 0)
    {
        (void *)array_start(skb_sys_pool_small_16), /* base address     */
        16,                                         /* object size      */
        SKB_SYS_POOL_SMALL_16_NR,                   /* object number    */
    },
#endif

#if (SKB_SYS_POOL_SMALL_24_NR > 0)
    {
        (void *)array_start(skb_sys_pool_small_24), /* base address     */
        24,                                         /* object size      */
        SKB_SYS_POOL_SMALL_24_NR,                   /* object number    */
    },
#endif

#if (SKB_SYS_POOL_SMALL_32_NR > 0)
    {
        (void *)array_start(skb_sys_pool_small_32), /* base address     */
        32,                                         /* object size      */
        SKB_SYS_POOL_SMALL_32_NR,                   /* object number    */
    },
#endif

#if (SKB_SYS_POOL_SMALL_40_NR > 0)
    {
        (void *)array_start(skb_sys_pool_small_40), /* base address     */
        40,                                         /* object size      */
        SKB_SYS_POOL_SMALL_40_NR,                   /* object number    */
    },
#endif

#if (SKB_SYS_POOL_SMALL_48_NR > 0)
    {
        (void *)array_start(skb_sys_pool_small_48), /* base address     */
        48,                                         /* object size      */
        SKB_SYS_POOL_SMALL_48_NR,                   /* object number    */
    },
#endif

#if (SKB_SYS_POOL_SMALL_56_NR > 0)
    {
        (void *)array_start(skb_sys_pool_small_56), /* base address     */
        56,                                         /* object size      */
        SKB_SYS_POOL_SMALL_56_NR,                   /* object number    */
    },
#endif

#if (SKB_SYS_POOL_SMALL_64_NR > 0)
    {
        (void *)array_start(skb_sys_pool_small_64), /* base address     */
        64,                                         /* object size      */
        SKB_SYS_POOL_SMALL_64_NR,                   /* object number    */
    },
#endif

#if (SKB_SYS_POOL_SMALL_72_NR > 0)
    {
        (void *)array_start(skb_sys_pool_small_72), /* base address     */
        72,                                         /* object size      */
        SKB_SYS_POOL_SMALL_72_NR,                   /* object number    */
    },
#endif

#if (SKB_SYS_POOL_SMALL_80_NR > 0)
    {
        (void *)array_start(skb_sys_pool_small_80), /* base address     */
        80,                                         /* object size      */
        SKB_SYS_POOL_SMALL_80_NR,                   /* object number    */
    },
#endif

#if (SKB_SYS_POOL_SMALL_88_NR > 0)
    {
        (void *)array_start(skb_sys_pool_small_88), /* base address     */
        88,                                         /* object size      */
        SKB_SYS_POOL_SMALL_88_NR,                   /* object number    */
    },
#endif

#if (SKB_SYS_POOL_SMALL_96_NR > 0)
    {
        (void *)array_start(skb_sys_pool_small_96), /* base address     */
        96,                                         /* object size      */
        SKB_SYS_POOL_SMALL_96_NR,                   /* object number    */
    },
#endif

#if (SKB_SYS_POOL_SMALL_104_NR > 0)
    {
        (void *)array_start(skb_sys_pool_small_104),/* base address     */
        104,                                        /* object size      */
        SKB_SYS_POOL_SMALL_104_NR,                  /* object number    */
    },
#endif

#if (SKB_SYS_POOL_SMALL_112_NR > 0)
    {
        (void *)array_start(skb_sys_pool_small_112),/* base address     */
        112,                                        /* object size      */
        SKB_SYS_POOL_SMALL_112_NR,                  /* object number    */
    },
#endif

#if (SKB_SYS_POOL_SMALL_120_NR > 0)
    {
        (void *)array_start(skb_sys_pool_small_120),/* base address     */
        120,                                        /* object size      */
        SKB_SYS_POOL_SMALL_120_NR,                  /* object number    */
    },
#endif

#if (SKB_SYS_POOL_SMALL_128_NR > 0)
    {
        (void *)array_start(skb_sys_pool_small_128),/* base address     */
        128,                                        /* object size      */
        SKB_SYS_POOL_SMALL_128_NR,                  /* object number    */
    },
#endif

#if (SKB_SYS_POOL_SMALL_136_NR > 0)
    {
        (void *)array_start(skb_sys_pool_small_136),/* base address     */
        136,                                        /* object size      */
        SKB_SYS_POOL_SMALL_136_NR,                  /* object number    */
    },
#endif

#if (SKB_SYS_POOL_SMALL_144_NR > 0)
    {
        (void *)array_start(skb_sys_pool_small_144),/* base address     */
        144,                                        /* object size      */
        SKB_SYS_POOL_SMALL_144_NR,                  /* object number    */
    },
#endif

#if (SKB_SYS_POOL_SMALL_152_NR > 0)
    {
        (void *)array_start(skb_sys_pool_small_152),/* base address     */
        152,                                        /* object size      */
        SKB_SYS_POOL_SMALL_152_NR,                  /* object number    */
    },
#endif

#if (SKB_SYS_POOL_SMALL_160_NR > 0)
    {
        (void *)array_start(skb_sys_pool_small_160),/* base address     */
        160,                                        /* object size      */
        SKB_SYS_POOL_SMALL_160_NR,                  /* object number    */
    },
#endif

#if (SKB_SYS_POOL_SMALL_168_NR > 0)
    {
        (void *)array_start(skb_sys_pool_small_168),/* base address     */
        168,                                        /* object size      */
        SKB_SYS_POOL_SMALL_168_NR,                  /* object number    */
    },
#endif

#if (SKB_SYS_POOL_SMALL_176_NR > 0)
    {
        (void *)array_start(skb_sys_pool_small_176),/* base address     */
        176,                                        /* object size      */
        SKB_SYS_POOL_SMALL_176_NR,                  /* object number    */
    },
#endif

#if (SKB_SYS_POOL_SMALL_184_NR > 0)
    {
        (void *)array_start(skb_sys_pool_small_184),/* base address     */
        184,                                        /* object size      */
        SKB_SYS_POOL_SMALL_184_NR,                  /* object number    */
    },
#endif

#if (SKB_SYS_POOL_SMALL_192_NR > 0)
    {
        (void *)array_start(skb_sys_pool_small_192),/* base address     */
        192,                                        /* object size      */
        SKB_SYS_POOL_SMALL_192_NR,                  /* object number    */
    },
#endif

#endif  // #ifdef SKB_SYS_POOL_SMALL

#if (SKB_SYS_POOL_0_NR > 0)
    {
        (void *)array_start(skb_sys_pool_0),        /* base address     */
        SKB_SYS_POOL_0_SIZE,                        /* object size      */
        SKB_SYS_POOL_0_NR,                          /* object number    */
    },
#endif

#if (SKB_SYS_POOL_1_NR > 0)
    {
        (void *)array_start(skb_sys_pool_1),        /* base address     */
        SKB_SYS_POOL_1_SIZE,                        /* object size      */
        SKB_SYS_POOL_1_NR,                          /* object number    */
    },
#endif

#if (SKB_SYS_POOL_2_NR > 0)
    {
        (void *)array_start(skb_sys_pool_2),        /* base address     */
        SKB_SYS_POOL_2_SIZE,                        /* object size      */
        SKB_SYS_POOL_2_NR,                          /* object number    */
    },
#endif

#if (SKB_SYS_POOL_3_NR > 0)
    {
        (void *)array_start(skb_sys_pool_3),        /* base address     */
        SKB_SYS_POOL_3_SIZE,                        /* object size      */
        SKB_SYS_POOL_3_NR,                          /* object number    */
    },
#endif

#if (SKB_SYS_POOL_4_NR > 0)
    {
        (void *)array_start(skb_sys_pool_4),        /* base address     */
        SKB_SYS_POOL_4_SIZE,                        /* object size      */
        SKB_SYS_POOL_4_NR,                          /* object number    */
    },
#endif

#if (SKB_SYS_POOL_5_NR > 0)
    {
        (void *)array_start(skb_sys_pool_5),        /* base address     */
        SKB_SYS_POOL_5_SIZE,                        /* object size      */
        SKB_SYS_POOL_5_NR,                          /* object number    */
    },
#endif

#if (SKB_SYS_POOL_6_NR > 0)
    {
        (void *)array_start(skb_sys_pool_6),        /* base address     */
        SKB_SYS_POOL_6_SIZE,                        /* object size      */
        SKB_SYS_POOL_6_NR,                          /* object number    */
    },
#endif

#if (SKB_SYS_POOL_7_NR > 0)
    {
        (void *)array_start(skb_sys_pool_7),        /* base address     */
        SKB_SYS_POOL_7_SIZE,                        /* object size      */
        SKB_SYS_POOL_7_NR,                          /* object number    */
    },
#endif

#if (SKB_SYS_POOL_8_NR > 0)
    {
        (void *)array_start(skb_sys_pool_8),        /* base address     */
        SKB_SYS_POOL_8_SIZE,                        /* object size      */
        SKB_SYS_POOL_8_NR,                          /* object number    */
    },
#endif

#if (SKB_SYS_POOL_9_NR > 0)
    {
        (void *)array_start(skb_sys_pool_9),        /* base address     */
        SKB_SYS_POOL_9_SIZE,                        /* object size      */
        SKB_SYS_POOL_9_NR,                          /* object number    */
    },
#endif

#if (SKB_SYS_POOL_10_NR > 0)
    {
        (void *)array_start(skb_sys_pool_10),       /* base address     */
        SKB_SYS_POOL_10_SIZE,                       /* object size      */
        SKB_SYS_POOL_10_NR,                         /* object number    */
    },
#endif

#if (SKB_SYS_POOL_11_NR > 0)
    {
        (void *)array_start(skb_sys_pool_11),       /* base address     */
        SKB_SYS_POOL_11_SIZE,                       /* object size      */
        SKB_SYS_POOL_11_NR,                         /* object number    */
    },
#endif

#if (SKB_SYS_POOL_12_NR > 0)
    {
        (void *)array_start(skb_sys_pool_12),       /* base address     */
        SKB_SYS_POOL_12_SIZE,                       /* object size      */
        SKB_SYS_POOL_12_NR,                         /* object number    */
    },
#endif

#if (SKB_SYS_POOL_13_NR > 0)
    {
        (void *)array_start(skb_sys_pool_13),       /* base address     */
        SKB_SYS_POOL_13_SIZE,                       /* object size      */
        SKB_SYS_POOL_13_NR,                         /* object number    */
    },
#endif

#if (SKB_SYS_POOL_14_NR > 0)
    {
        (void *)array_start(skb_sys_pool_14),       /* base address     */
        SKB_SYS_POOL_14_SIZE,                       /* object size      */
        SKB_SYS_POOL_14_NR,                         /* object number    */
    },
#endif

#if (SKB_SYS_POOL_15_NR > 0)
    {
        (void *)array_start(skb_sys_pool_15),       /* base address     */
        SKB_SYS_POOL_15_SIZE,                       /* object size      */
        SKB_SYS_POOL_15_NR,                         /* object number    */
    },
#endif

#if (SKB_SYS_POOL_16_NR > 0)
    {
        (void *)array_start(skb_sys_pool_16),       /* base address     */
        SKB_SYS_POOL_16_SIZE,                       /* object size      */
        SKB_SYS_POOL_16_NR,                         /* object number    */
    },
#endif

#if (SKB_SYS_POOL_17_NR > 0)
    {
        (void *)array_start(skb_sys_pool_17),       /* base address     */
        SKB_SYS_POOL_17_SIZE,                       /* object size      */
        SKB_SYS_POOL_17_NR,                         /* object number    */
    },
#endif

#if (SKB_SYS_POOL_18_NR > 0)
    {
        (void *)array_start(skb_sys_pool_18),       /* base address     */
        SKB_SYS_POOL_18_SIZE,                       /* object size      */
        SKB_SYS_POOL_18_NR,                         /* object number    */
    },
#endif

#if (SKB_SYS_POOL_19_NR > 0)
    {
        (void *)array_start(skb_sys_pool_19),       /* base address     */
        SKB_SYS_POOL_19_SIZE,                       /* object size      */
        SKB_SYS_POOL_19_NR,                         /* object number    */
    },
#endif

#if (SKB_SYS_POOL_20_NR > 0)
    {
        (void *)array_start(skb_sys_pool_20),       /* base address     */
        SKB_SYS_POOL_20_SIZE,                       /* object size      */
        SKB_SYS_POOL_20_NR,                         /* object number    */
    },
#endif

#if (SKB_SYS_POOL_21_NR > 0)
    {
        (void *)array_start(skb_sys_pool_21),       /* base address     */
        SKB_SYS_POOL_21_SIZE,                       /* object size      */
        SKB_SYS_POOL_21_NR,                         /* object number    */
    },
#endif

#if (SKB_SYS_POOL_22_NR > 0)
    {
        (void *)array_start(skb_sys_pool_22),       /* base address     */
        SKB_SYS_POOL_22_SIZE,                       /* object size      */
        SKB_SYS_POOL_22_NR,                         /* object number    */
    },
#endif

#if (SKB_SYS_POOL_23_NR > 0)
    {
        (void *)array_start(skb_sys_pool_23),       /* base address     */
        SKB_SYS_POOL_23_SIZE,                       /* object size      */
        SKB_SYS_POOL_23_NR,                         /* object number    */
    },
#endif

#if (SKB_SYS_POOL_24_NR > 0)
    {
        (void *)array_start(skb_sys_pool_24),       /* base address     */
        SKB_SYS_POOL_24_SIZE,                       /* object size      */
        SKB_SYS_POOL_24_NR,                         /* object number    */
    },
#endif

#if (SKB_SYS_POOL_25_NR > 0)
    {
        (void *)array_start(skb_sys_pool_25),       /* base address     */
        SKB_SYS_POOL_25_SIZE,                       /* object size      */
        SKB_SYS_POOL_25_NR,                         /* object number    */
    },
#endif

#if (SKB_SYS_POOL_26_NR > 0)
    {
        (void *)array_start(skb_sys_pool_26),       /* base address     */
        SKB_SYS_POOL_26_SIZE,                       /* object size      */
        SKB_SYS_POOL_26_NR,                         /* object number    */
    },
#endif

#if (SKB_SYS_POOL_27_NR > 0)
    {
        (void *)array_start(skb_sys_pool_27),       /* base address     */
        SKB_SYS_POOL_27_SIZE,                       /* object size      */
        SKB_SYS_POOL_27_NR,                         /* object number    */
    },
#endif

#if (SKB_SYS_POOL_28_NR > 0)
    {
        (void *)array_start(skb_sys_pool_28),       /* base address     */
        SKB_SYS_POOL_28_SIZE,                       /* object size      */
        SKB_SYS_POOL_28_NR,                         /* object number    */
    },
#endif

#if (SKB_SYS_POOL_29_NR > 0)
    {
        (void *)array_start(skb_sys_pool_29),       /* base address     */
        SKB_SYS_POOL_29_SIZE,                       /* object size      */
        SKB_SYS_POOL_29_NR,                         /* object number    */
    },
#endif

#if (SKB_SYS_POOL_30_NR > 0)
    {
        (void *)array_start(skb_sys_pool_30),       /* base address     */
        SKB_SYS_POOL_30_SIZE,                       /* object size      */
        SKB_SYS_POOL_30_NR,                         /* object number    */
    },
#endif

#if (SKB_SYS_POOL_31_NR > 0)
    {
        (void *)array_start(skb_sys_pool_31),       /* base address     */
        SKB_SYS_POOL_31_SIZE,                       /* object size      */
        SKB_SYS_POOL_31_NR,                         /* object number    */
    },
#endif
};

#ifdef SKB_SYS_POOL_SMALL
# define SKB_SYS_POOL_SMALL_INDEX(size) (((size) - 1)>>3)
# define SKB_SYS_POOL_SMALL_MIN_SIZE    (8)
# define SKB_SYS_POOL_SMALL_MAX_SIZE    (192)

# define SKB_SYS_POOL_SMALL_NR          (24)
# define SKB_SYS_POOL_LARGE_NR          (8)
#else
# define SKB_SYS_POOL_SMALL_NR          (0)
# define SKB_SYS_POOL_LARGE_NR          (32)
#endif
#define SKB_SYS_POOL_NR     (SKB_SYS_POOL_SMALL_NR + SKB_SYS_POOL_LARGE_NR)


static unsigned long skb_sys_pool_bitmap;
static skb_pool_inner_t *skb_sys_pool_inner[SKB_SYS_POOL_NR];

static skb_count_t skb_sys_pool_large_nr;
static size_t skb_sys_pool_large_size[SKB_SYS_POOL_LARGE_NR];

static inline int skb_sys_pool_match_by_inner(skb_pool_inner_t **inner)
{
    BUG_ON(
        inner < array_start(skb_sys_pool_inner) ||
        inner >= array_end(skb_sys_pool_inner));

    return array_index(skb_sys_pool_inner, inner);
}

static inline int skb_sys_pool_match_by_size(u32 size)
{
    int index;
    int large_nr;

#ifdef SKB_SYS_POOL_SMALL
    if (size <= SKB_SYS_POOL_SMALL_MAX_SIZE)
    {
        index = SKB_SYS_POOL_SMALL_INDEX(size);
        for (; index < SKB_SYS_POOL_SMALL_NR; index++)
        {
            if (test_bit(index, skb_sys_pool_bitmap))
                return index;
        }
    }
#endif

    for (index = 0x00; index < skb_sys_pool_large_nr; index++)
    {
        if (size > skb_sys_pool_large_size[index])
            continue;

        large_nr = skb_sys_pool_large_nr + SKB_SYS_POOL_SMALL_NR;
        for (index += SKB_SYS_POOL_SMALL_NR; index < large_nr; index++)
        {
            if (test_bit(index, skb_sys_pool_bitmap))
                return index;
        }
    }

    return -1;
}

size_t skb_sys_pool_size(const void *ptr)
{
    int index;
    skb_pool_node_impl_t *node;

    node = skb_pool_node(ptr);
    index = skb_sys_pool_match_by_inner((skb_pool_inner_t **)node->free_next);

    return  skb_sys_pool_inner[index]->obj_size;
}

void *skb_sys_pool_alloc(
                    size_t      size
#ifdef SKB_DBG_POOL
                    ,const char *file,
                    u32         line
#endif
                    )
{
    int index;
    unsigned long flags;
    skb_pool_inner_t *inner;
    skb_pool_node_impl_t *node;

    BUG_ON( size <= 0);

    spin_lock_irqsave(&skb_sys_pool_spinlock, flags);

    index = skb_sys_pool_match_by_size(size);
    BUG_ON( index == -1 ||skb_sys_pool_inner[index] == NULL);

    inner = skb_sys_pool_inner[index];
    node = inner->free_head;
    BUG_ON( node == NULL);

#ifdef SKB_TRACE
   if (size < 2048)
    {
        inner->obj_real_size[size] =  inner->obj_real_size[size]++;

        inner->obj_used_cnt++;
        if (inner->obj_max_used_cnt < inner->obj_used_cnt)
            inner->obj_max_used_cnt = inner->obj_used_cnt;
    }
   else
    {
        if (inner->obj_real_size_cnt >=2048)
            inner->obj_real_size_cnt = 0;
         inner->obj_real_size[ inner->obj_real_size_cnt] = size;
         inner->obj_real_size_cnt++;

         inner->obj_used_cnt++;
        if (inner->obj_max_used_cnt < inner->obj_used_cnt)
            inner->obj_max_used_cnt = inner->obj_used_cnt;


    }
#endif

    inner->free_head = node->free_next;
    node->free_next = (skb_pool_node_impl_t *)&skb_sys_pool_inner[index];
    if (inner->free_head == NULL)
        clear_bit(index, skb_sys_pool_bitmap);

#ifdef SKB_DBG_POOL
    list_add_tail(&node->alloc_node, &inner->alloc_head);
#endif

    spin_unlock_irqrestore(&skb_sys_pool_spinlock, flags);

#ifdef SKB_DBG_POOL
    BUG_ON(skb_pool_magic_check(node) != 0;

    node->file  = file;
    node->line  = line;
    node->tick  = jiffies;
#endif

    return skb_pool_ptr(node);
}

extern  *memset(void *s, int c, size_t count);

/*******************************************************************************
* :     ϵͳڴ벢
* ˵:     
*   ()  size:   ڴС
                file:   ļ
                line:   к
*   ()  void
*   ֵ:     벢ڴַ
* ˵:     void
*******************************************************************************/
 void *skb_sys_pool_zalloc(
                    size_t      size
#ifdef SKB_DBG_POOL
                    ,const char *file,
                    u32         line
#endif
                    )
{
    void *ptr;

#ifdef SKB_DBG_POOL
    ptr = skb_sys_pool_alloc(size, file, line);
#else
    ptr = skb_sys_pool_alloc(size);
#endif

    if (ptr)
        memset(ptr, 0x00, size);

    return ptr;
}

/*******************************************************************************
* :     ϵͳڴͷ
* ˵:     
*   ()  ptr:    ͷŵڴַ
                file:   ļ
                line:   к
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
 void skb_sys_pool_free(
                    void        *ptr
#ifdef SKB_DBG_POOL
                    ,const char *file,
                    u32         line
#endif
                    )
{
    int index;
    unsigned long flags;
    skb_pool_inner_t *inner;
    skb_pool_node_impl_t *node;

    BUG_ON(ptr == NULL);

    spin_lock_irqsave(&skb_sys_pool_spinlock, flags);

    node = skb_pool_node(ptr);
    index = skb_sys_pool_match_by_inner((skb_pool_inner_t **)node->free_next);
    BUG_ON(index == -1 ||  skb_sys_pool_inner[index] == NULL);

    inner = skb_sys_pool_inner[index];
    node->free_next = inner->free_head;
    inner->free_head = node;

    if (!test_bit(index, skb_sys_pool_bitmap))
        set_bit(index, skb_sys_pool_bitmap);

#ifdef SKB_TRACE
    inner->obj_used_cnt--;
#endif

#ifdef SKB_DBG_POOL
    list_del(&node->alloc_node);
#endif

    spin_unlock_irqrestore(&skb_sys_pool_spinlock, flags);

#ifdef SKB_DBG_POOL
    BUG_ON(skb_pool_magic_check(node) != 0);
#endif
}



void skb_sys_pool_init_impl(skb_pool_config_t *cfg, skb_count_t cfg_nr)
{
    u32 cnt;
#ifdef SKB_SYS_POOL_SMALL
    u32 index;
#endif

   BUG_ON( cfg == NULL || cfg_nr > SKB_SYS_POOL_NR);

#ifdef SKB_SYS_POOL_SMALL
    for (cnt = 0x00; cnt < cfg_nr; cnt++, cfg++)
    {
        if (cfg->obj_size > SKB_SYS_POOL_SMALL_MAX_SIZE)
            break;

        index = SKB_SYS_POOL_SMALL_INDEX(cfg->obj_size);
        skb_sys_pool_inner[index] = 
            skb_pool_create_inner(
                (skb_pool_inner_t *)cfg->addr,
                cfg->obj_size,
                cfg->obj_nr,
                cfg->obj_nr,
                0x00);
        set_bit(index, skb_sys_pool_bitmap);
    }

    cfg_nr -= cnt;
#endif

    for (cnt = 0x00; cnt < cfg_nr; cnt++, cfg++)
    {
        skb_sys_pool_inner[cnt + SKB_SYS_POOL_SMALL_NR] = 
            skb_pool_create_inner(
                (skb_pool_inner_t *)cfg->addr,
                cfg->obj_size,
                cfg->obj_nr,
                cfg->obj_nr,
                0x00);
        skb_sys_pool_large_size[cnt] = cfg->obj_size;
        skb_sys_pool_large_nr++;
        set_bit(cnt + SKB_SYS_POOL_SMALL_NR, skb_sys_pool_bitmap);

        if (cnt && cnt > 1)
            BUG_ON( cfg->obj_size <= skb_sys_pool_large_size[cnt - 1]);
    }
}

int __init skb_sys_pool_init(void)
{
   // while(!g_loop);
    spin_lock_init(&skb_sys_pool_spinlock);

    skb_sys_pool_init_impl(array_start(skb_sys_pool_config), array_nr(skb_sys_pool_config));

    return 0;
}

core_initcall(skb_sys_pool_init);

