#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/fs.h>
#include <linux/init.h>
#include <linux/delay.h>
#include <linux/irq.h>
#include <linux/kprobes.h>
#include <linux/fs.h>
#include <linux/kmod.h>
#include <linux/timer.h>
#include <linux/timex.h>
#include <linux/rtc.h>
#include <linux/proc_fs.h> 
#include <asm/uaccess.h>
#include <asm/irq.h>
#include <asm/io.h>
#include <linux/string.h>
#include <linux/skbuff.h>
#include <linux/sched.h>

#include <net/sock.h>
#include <net/inet_sock.h>
#include <net/tcp_states.h>
#include <linux/ipv6.h>
#include <linux/inet.h>
#include <net/netfilter/nf_conntrack_tuple.h>

#include <net/SI/netioc_proc.h>
#include <net/SI/netioctl.h>
#include <net/SI/errno_track.h>
#include <net/SI/sock_track.h>
#include <net/SI/fast_common.h>

int sock_track_switch = 0;

extern struct nf_conntrack_tuple tuple_info;
extern int getconn_type;


void ip4_num_to_str(unsigned char *addr, char *buf)
{
    sprintf(buf, "%d.%d.%d.%d", addr[0], addr[1], addr[2], addr[3]);
}

void ip6_num_to_str(unsigned char *addr, char *buf)
{
    unsigned short *tmp = (unsigned short *)addr;
    sprintf(buf, "%4x:%4x:%4x:%4x:%4x:%4x:%4x:%4x",
        ntohs(tmp[0]), ntohs(tmp[1]), ntohs(tmp[2]), ntohs(tmp[3]), ntohs(tmp[4]), ntohs(tmp[5]), ntohs(tmp[6]), ntohs(tmp[7]));
}

static char *tcp_err_str(int err_type)
{
    switch(err_type)
    {
    case TCP_ACCEPT_QUEUE_FULL:
        return "accept queue full";
    case TCP_REQ_QUEUE_FULL:
        return "request queue full";
    case TCP_RECV_BUFF_FULL:
        return "receive buffer full";
    case TCP_SEND_BUFF_FULL:
        return "send buffer full";
    case TCP_RECV_WINDOW_FULL:
        return "receive windows full";
    case TCP_RST_SEND:
        return "send reset";
    case TCP_FIN_SEND:
        return "send fin";
    case TCP_RST_RECV:
        return "receive reset";
    case TCP_FIN_RECV:
        return "receive fin";
    default:
        break;
    }

    return "no error";
}


static char *tcp_state_str(struct sock *sk)
{
    switch(sk->sk_state)
    {
    case TCP_ESTABLISHED:
        return "ESTABLISHED";
    case TCP_SYN_SENT:
        return "SYN_SEND";
    case TCP_SYN_RECV:
        return "SYN_RECV";
    case TCP_FIN_WAIT1:
        return "FIN_WAIT1";
    case TCP_FIN_WAIT2:
        return "FIN_WAIT2";
    case TCP_TIME_WAIT:
        return "TIME_WAIT";
    case TCP_CLOSE:
        return "CLOSE";
    case TCP_CLOSE_WAIT:
        return "CLOSE_WAIT";
    case TCP_LAST_ACK:
        return "LAST_ACK";
    case TCP_LISTEN:
        return "LISTEN";
    case TCP_CLOSING:   
        return "CLOSING";
    default:
        break;
    }

    return "UNKNOWN STATE";
}



/*ԪҪsock*/
int sock_is_expected(struct sock *sk)
{
    struct inet_sock *inet = NULL;

    if(9 != getconn_type)
        return 0;

    if(NULL == sk)
        return 1;
            
    inet = inet_sk(sk);
    if(tuple_info.dst.protonum && tuple_info.dst.protonum != sk->sk_protocol)
    {
        return 0;
    }

    if(tuple_info.src.l3num && sk->sk_family != tuple_info.src.l3num)
    {
        return 0;
    }

    if(tuple_info.dst.u.all && tuple_info.dst.u.all != inet->inet_daddr){
        return 0;
    }

    if(tuple_info.src.u.all && tuple_info.src.u.all != inet->inet_sport ){
        return 0;      
    }     

    if(AF_INET == sk->sk_family)
    {
        if(inet->inet_saddr && tuple_info.src.u3.ip && inet->inet_saddr != tuple_info.src.u3.ip)
        {
            return 0;
        }
        if(inet->inet_daddr && tuple_info.dst.u3.ip && inet->inet_daddr != tuple_info.dst.u3.ip)
        {
            return 0;
        }
    }
    else if(AF_INET6 == sk->sk_family)
    {
        if(NULL != inet->pinet6 && (( 0 != memcmp(tuple_info.src.u3.in6.s6_addr, inet->pinet6->saddr.s6_addr, 16))
            || ( 0 != memcmp(tuple_info.dst.u3.in6.s6_addr, inet->pinet6->daddr.s6_addr, 16))))
        {//cov_2 tuple_info.src.u3.in6.s6_addr &&tuple_info.dst.u3.in6.s6_addr &&
            return 0;
        }
    }

    return 1;
}

int tcp_sock_track(struct sock *sk, int err_type, char *function, int linenum)
{
#if 0
    struct inet_sock *inet = NULL;

    char mytmp[SOCK_TRACK_STR_LEN] = {0};
	char mybkp[2 * SOCK_TRACK_STR_LEN] = {0};
	struct timex  txc;
	struct rtc_time tm;
	int len = 0;
    char local_ip[256] = {0};
    char remote_ip[256] = {0};

    if(!sock_track_switch)
    {
        return 0;
    }

    if(!sock_is_expected(sk))
    {
        return 0;
    }

    if(err_type < 0 || err_type >= TCP_ERR_MAX)
    {
        return -1;
    }

    do_gettimeofday(&(txc.time));
	rtc_time_to_tm(txc.time.tv_sec,&tm);
	memset(mytmp, 0, sizeof(mytmp));
	sprintf(mytmp,"[%04d-%02d-%02d %02d:%02d:%02d][%s][%d][tcp err: %s]",
        tm.tm_year+1900,tm.tm_mon+1, tm.tm_mday,tm.tm_hour,tm.tm_min,tm.tm_sec,
        function, linenum, tcp_err_str(err_type));
	strncat(mybkp, mytmp, strlen(mytmp)); 	

  	memset(mytmp, 0, sizeof(mytmp));
    if(sk)
    {
        inet = inet_sk(sk);
        if(sk->sk_family == AF_INET)
        {
            ip4_num_to_str((unsigned char *)&(inet->inet_saddr), local_ip);
            ip4_num_to_str((unsigned char *)&(inet->inet_daddr), remote_ip);
            sprintf(mytmp, "local_ip: %s, local_port: %d, remote_ip: %s, remote_port: %d, state: %s", 
                local_ip, ntohs(inet->inet_sport), 
                remote_ip, ntohs(inet->inet_dport),
                tcp_state_str(sk));
        }
        else if(sk->sk_family == AF_INET6)
        {
            if(NULL != inet->pinet6)
            {
                ip6_num_to_str(inet->pinet6->saddr.s6_addr, local_ip);
                ip6_num_to_str(inet->pinet6->daddr.s6_addr, remote_ip);
                sprintf(mytmp, "local_ip: %s, local_port: %d, remote_ip: %s, remote_port: %d, state: %s", 
                    local_ip, ntohs(inet->inet_sport), 
                    remote_ip, ntohs(inet->inet_dport),
                    tcp_state_str(sk));
            }
        }

        strncat(mybkp,mytmp,strlen(mytmp)); 	
	    memset(mytmp, 0, sizeof(mytmp));
    }

    errno_write_file(mybkp);
#endif	
    return 0;
}

