/*******************************************************************************
 * Copyright (C) 2016, ZIXC Corporation.
 *
 * File Name:cmd_compat_write.c
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Author:        zangxiaofeng
 * Date:          2013-3-13
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/


/****************************************************************************
* 	                                     Include files
****************************************************************************/
#include <common.h>
#include <command.h>
#include <net.h>
#include <jffs2/load_kernel.h>
#include "downloader_config.h"
#include "downloader_nand.h"
#include "downloader_serial.h"
#include "errno.h"
#include <boot_mode.h>
#include "pub_flags.h"

/****************************************************************************
*							Global Function Prototypes
****************************************************************************/
//T_IMG_SIZE img_size[IMG_NUM] = {{"uboot",0,0},{"imagefs",0,0},{"rootfs",0,0},{"caprootfs",0,0},{"oem",0,0}};
T_IMG_SIZE img_size[IMG_NUM_MAX];
int img_num = 0;
int flags_partiton_write = 0;
extern int g_iftype;
extern partition_table_t * g_partition_table_dl;
/*******************************************************************************
 * Function:do_compat_write
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 int do_compat_write(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
    partition_entry_t *part = NULL;
    char *par = NULL;
	char *par_tmp = NULL;
    char ack[64]={0};
	unsigned int offset = 0;
	unsigned int size = 0;
	unsigned int ret = 0;
	unsigned int i = 0;
	unsigned int len = 0;
	unsigned int found = 0;
	flags_partiton_write = 1;
	
	if(argc<4)
    {
        return cmd_usage(cmdtp);
    }

	par = argv[1];
    offset = (unsigned int)simple_strtoul (argv[2], NULL, 16);
	size = (unsigned int)simple_strtoul (argv[3], NULL, 16);
	part = downloader_get_part_dl(par);
	if(part == NULL)
	{
		sprintf(ack,"FAIL INVALID PARTITION TYPE");
        downloader_serial_write(ack, strlen(ack)+1);
	    return -1;
	}

	/*record image size*/
	len = strlen(par);
/* Started by AICoder, pid:q5743g3f62rd9291419e086de0327502c5d710ce */
	par_tmp = (char *)malloc(len + 1);
	if (par[len - 1] == '2') {
		strncpy(par_tmp, par, len - 1);
		par_tmp[len - 1] = '\0';
	} else {
		strcpy(par_tmp, par);
	}
/* Ended by AICoder, pid:q5743g3f62rd9291419e086de0327502c5d710ce */
	
/* Started by AICoder, pid:ye4dcm700en8c6e14cdf0ac390813e36dc075765 */
	for(i=0; i<img_num; i++)
	{
	    if(strcmp((char *)img_size[i].name, par_tmp) == 0 && strlen((char *)img_size[i].name) == strlen(par_tmp))
	    {
	        found = 1;
	        if(strcmp(par_tmp,par) == 0)
	        {
	            img_size[i].size_a = size;
	            printf("partition is %s,size_a is 0x%x.\n",par,size);
	        }
	        else
	        {
	            img_size[i].size_b = size;
	            printf("partition is %s,size_b is 0x%x.\n",par,size);
	        }
	        
	        break;
	    }
	}  
	if (!found)
	{   
	    strcpy(img_size[img_num].name,par_tmp);
	    if(strcmp(par_tmp,par) == 0)
	    {
	        img_size[img_num].size_a = size;
	        printf("partition is %s,size_a is 0x%x.\n",par,size);
	    }
	    else
	    {
	        img_size[img_num].size_b = size;
	        printf("partition is %s,size_b is 0x%x.\n",par,size);
	    }
	    
	    img_num += 1;
	}
	free(par_tmp);
/* Ended by AICoder, pid:ye4dcm700en8c6e14cdf0ac390813e36dc075765 */
	
#if defined (CONFIG_ZX297520V3E_VEHICLE_DC) || defined (CONFIG_ZX297520V3E_VEHICLE_DC_REF)
	if(g_nor_flag == 1)
	{
        if(memcmp(par,"zloader",7) == 0)
		{
			g_iftype = IF_TYPE_NOR;
			nand_init();
			ret = do_nor_write(part, par, offset,size);	
			/*лʼspi_nand*/
			g_iftype = IF_TYPE_SPI_NAND;
			nand_init();
			downloader_nand_erase(part,part->part_size);
			memcpy((char *)(DOWNLOADER_BUFFER_BASE+0x8000),g_partition_table_dl,4096);
	        ret = downloader_nand_write(part, 0, 0x9000,(unsigned char *)DOWNLOADER_BUFFER_BASE);
			return ret;
		}
	}
#endif

	if((read_boot_flashtype() == IF_TYPE_NOR) 
		&& (strcmp((const char *)part->part_type,"nand") == 0))
	{
        ret = do_nor_write(part, par, offset,size);
		return ret;
	}
    
	if(strcmp((const char *)part->part_type,"nand") == 0)
	{
	    ret = do_nand_write(part, par, offset, size);
		return ret;
	}
	else if (strcmp((const char *)part->part_type,"fs") == 0)
	{
	    ret = do_yaffs_write(part, par, offset, size);
		return ret;
	}
	else if (strcmp((const char *)part->part_type,"ddr") == 0)
	{
	    ret = do_ram_write(offset, size);
		return ret;
	}
	else if (strcmp((const char *)part->part_type,"raw") == 0)
	{
	    ret = do_raw_write(offset, size);
		return ret;
	}
	else
	{
	    sprintf(ack,"FAIL INVALID PARTITION TYPE");
        downloader_serial_write(ack, strlen(ack)+1);
	    return -1;
	}
}
U_BOOT_CMD(
	compat_write, CONFIG_SYS_MAXARGS, 0, do_compat_write,
	"download: compat_write [partition][offset][size]",
	""
);











