#!/bin/bash


#########可修改---开始#########
#分区大小，单位MB，可以是带小数
if [ $# -eq 0 ]; then
  INPUT_MTD_SIZE=32
else
  INPUT_MTD_SIZE=$1
fi

#擦除块大小
MTD_ERASE_SIZE=0x40000

#flash页大小
MTD_PAGE_SIZE=4096

#子页subpage大小
MTD_SUBPAGE_SIZE=4096

#BEB保留数，每1024预留多少个给坏快
BEB_RESERVE_LIMIT=20
#########可修改---结束#########

function gen_mtd_para()
{
    MTD_NAME=$1
    MTD_SIZE_MB=$2
    MTD_SIZE_KB=$(awk "BEGIN { print $MTD_SIZE_MB * 1024 }")
    BLOCK_SIZE_KB=$[$MTD_ERASE_SIZE / 1024]
    BLOCK_CNT_1MB=$[0x100000 / $MTD_ERASE_SIZE]
    MTD_BLOCK_CNT=$(awk "BEGIN { print $MTD_SIZE_MB * $BLOCK_CNT_1MB }")
    BEB_RESERVE_CNT=$(awk "BEGIN { print int($BEB_RESERVE_LIMIT * $MTD_BLOCK_CNT / 1024) }")
    if [ $BEB_RESERVE_CNT -lt 2 ]; then
        BEB_RESERVE_CNT=2
    fi
    MAX_LEB_CNT=$[$MTD_BLOCK_CNT - $BEB_RESERVE_CNT - 4]
    if [ $MTD_SUBPAGE_SIZE -lt $MTD_PAGE_SIZE ]; then
        LEB_SIZE=$[$MTD_ERASE_SIZE - $MTD_PAGE_SIZE]
    else
        LEB_SIZE=$[$MTD_ERASE_SIZE - $MTD_PAGE_SIZE - $MTD_PAGE_SIZE]
    fi
    LEB_SIZE_KB=$[$LEB_SIZE / 1024]
    VOL_SIZE_KB=$[$LEB_SIZE_KB * $MAX_LEB_CNT]
    VOL_SIZE_MB0=$(awk "BEGIN { print $VOL_SIZE_KB / 1024 }")
    VOL_SIZE_MB=$(awk "BEGIN { print int($VOL_SIZE_KB / 1024) }")

    echo "$MTD_NAME MKUBIFS_ARGS=\"-m $MTD_PAGE_SIZE -e $LEB_SIZE -c $MAX_LEB_CNT -x zlib -F\""
    echo "$MTD_NAME UBINIZE_ARGS=\"-m $MTD_PAGE_SIZE -p $MTD_ERASE_SIZE -s $MTD_SUBPAGE_SIZE\""
    #echo "$MTD_NAME vol_size=\"${VOL_SIZE_MB}MiB\""
}

echo "generate $INPUT_MTD_SIZE MB parameter"
gen_mtd_para  ubifs  $INPUT_MTD_SIZE

