#ifndef COMMON_H
#define COMMON_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdarg.h>

#include <utime.h>
#include <unistd.h>

#include <sys/types.h>
#include <sys/stat.h>
#include "png.h"

#define MKDIR(d,m) mkdir(d,m)

#if (PNG_LIBPNG_VER < 10004)
# error libpng version 1.0.4 or later is required.
#endif

#if (PNG_LIBPNG_VER == 10207) || (PNG_LIBPNG_VER == 10206) || \
    (PNG_LIBPNG_VER == 10017) || (PNG_LIBPNG_VER == 10016)
# error Libpng versions 1.2.7, 1.2.6, 1.0.17, and 1.0.16
# error have a bug that will cause png2bmp to crash.
# error Update your libpng to latest version.
# error "http://www.libpng.org/pub/png/libpng.html"
#endif

#if !defined(PNG_READ_tRNS_SUPPORTED) || !defined(PNG_WRITE_tRNS_SUPPORTED)
# error This software requires tRNS chunk support.
#endif

#ifndef png_jmpbuf					/* pngconf.h (libpng 1.0.6 or later) */
# define png_jmpbuf(png_ptr) ((png_ptr)->jmpbuf)
#endif


#define PATHDELIM		'/'
#define IsPathDelim(c)	((c)==PATHDELIM)
#define IsOptChar(c)	((c)=='-')
#define IsDBCSLead(c)	(0)

typedef char           CHAR;
typedef unsigned char  BYTE;
typedef short          SHORT;
typedef unsigned short WORD;
typedef int            INT;
typedef unsigned int   UINT;
typedef long           LONG;
typedef unsigned long  DWORD;
typedef enum { FALSE = 0, TRUE = 1 } BOOL;

typedef png_color PALETTE;
typedef struct tagIMAGE {
	LONG    width;
	LONG    height;
	UINT    pixdepth;
	UINT    palnum;
	BOOL    topdown;
	BOOL    alpha;
	/* ----------- */
	DWORD   rowbytes;
	DWORD   imgbytes;
	PALETTE *palette;
	BYTE    **rowptr;
	BYTE    *bmpbits;
	/* ----------- */
	png_color_8 sigbit;
} IMAGE;

extern int quietmode;
extern int errorlog;
extern const char errlogfile[];

void xxprintf(const char *, ...);
void set_status(const char *, ...);
void feed_line(void);
void init_progress_meter(png_structp, png_uint_32, png_uint_32);
void row_callback(png_structp, png_uint_32, int);

FILE *binary_stdio(int);
char *suffix(const char *);
char *basname(const char *);
char *addslash(char *);
char *delslash(char *);
char *path_skiproot(const char *);
char *path_nextslash(const char *);

void png_my_error(png_structp, png_const_charp);
void png_my_warning(png_structp, png_const_charp);
BOOL imgbuf_alloc(IMAGE *);
void imgbuf_free(IMAGE *);
void imgbuf_init(IMAGE *);
int parsearg(int *, char **, int, char **, char *);
char **envargv(int *, char ***, const char *);
int tokenize(char *, const char *);
int makedir(const char *);
int renbak(const char *);
int cpyftime(const char *, const char *);


#endif /* COMMON_H */
