#!/bin/bash
#LYNQ_MODIFY_ZXW_TASK944_XF.Li_20250123_START
if [ x"$4" = x"lynq" ]; then
  echo "lynq nand type"
  if [ x"$LYNQ_NAND_TYPE" = x"M22" ]; then
    NAND_PAGESIZE=$LYNQ_M22_PAGESIZE
    NAND_ERASEBLOCK=$LYNQ_M22_ERASEBLOCK
  else
    NAND_PAGESIZE=$PAGESIZE
    NAND_ERASEBLOCK=$ERASEBLOCK
  fi
else
  echo "default nand type"
  NAND_PAGESIZE=$PAGESIZE
  NAND_ERASEBLOCK=$ERASEBLOCK
fi

if [ x"$NAND_PAGESIZE" = x"" ]; then
  NAND_PAGESIZE=0x800
fi

if [ x"$NAND_ERASEBLOCK" = x"" ]; then
  NAND_ERASEBLOCK=0x20000
fi
#LYNQ_MODIFY_ZXW_TASK944_XF.Li_20250123_END
JFFS2_COMPRESS_TYPE=$3
COMPR_OPT="-X lzma"

if [ x"$JFFS2_COMPRESS_TYPE" = x"zlib" ]; then
  COMPR_OPT="-X zlib"
fi

if [ x"$JFFS2_COMPRESS_TYPE" = x"lzo" ]; then
  COMPR_OPT="-X lzo"
fi
#LYNQ_MODIFY_ZXW_TASK944_XF.Li_20250123_START
mkfs.jffs2_lzma -v $COMPR_OPT --pagesize=$NAND_PAGESIZE --eraseblock=$NAND_ERASEBLOCK --little-endian --no-cleanmarkers --squash -d $1 -o $2
#LYNQ_MODIFY_ZXW_TASK944_XF.Li_20250123_END
if [ $? -ne 0 ]; then
  echo "mkfs.jffs2_lzma error"
  exit -1
else
  echo "mkfs.jffs2_lzma ok"
fi

exit 0
