/*******************************************************************************
* 版权所有 (C)2016, 中兴通讯股份有限公司。
* 
* 文件名称:     usb_dev.c
* 文件标识:     usb_dev.c
* 内容摘要:     usb设备访问工具
* 
* 修改日期        版本号      修改标记        修改人          修改内容
* ------------------------------------------------------------------------------
* 2016/3/10      V1.0        Create                             创建
* 
*******************************************************************************/

/*******************************************************************************
*                                   头文件                                     *
*******************************************************************************/
#include<stdlib.h>
#include<stdio.h>
#include<string.h>
#include<sys/types.h>
#include<sys/stat.h>
#include<fcntl.h>
#include<errno.h>
#include<getopt.h>
#include<stdarg.h>
#include<termios.h>
#include<stddef.h>
#include<dirent.h>
#include <unistd.h>

#include "devUsb.h"

/*******************************************************************************
*                                   宏定义                                     *
*******************************************************************************/
#define USB_DIR_FILE_NAME_SIZE (512)
#define USB_DIR_BASE           ("/sys/bus/usb/devices")
#define SUCCESS                (0)
#define FAIL                   (-1)

/*******************************************************************************
*                                  变量定义                                    *
*******************************************************************************/

/*******************************************************************************
*                                数据类型定义                                  *
*******************************************************************************/

/*******************************************************************************
*                                函数声明                                  *
*******************************************************************************/
static int dev_get_usbsys_val(const char *sys_filename, int base);
static int dev_strStartsWith(const char *line, const char *src);
static int dev_get_ttyport_by_syspath(char *syspath);

/*******************************************************************************
*                              局部静态变量声明                                *
*******************************************************************************/
static char sys_filename[USB_DIR_FILE_NAME_SIZE] = {0};

/*******************************************************************************
*                                全局变量定义                                  *
*******************************************************************************/
int g_usb_dev = -1;

/*******************************************************************************
*                                局部函数实现                                  *
*******************************************************************************/
static int dev_get_usbsys_val(const char *sys_filename, int base)
{
	char buff[64] = {0};
	int ret_val = -1;
	int fd = -1;

	fd = open(sys_filename, O_RDONLY);
	if (fd < 0) {
		// printf("failed to open usbsys, error is %s\n", strerror(errno));
		return FAIL;
	}

	if (read(fd, buff, sizeof(buff)) <= 0) {
		printf("[%s] read:%s failed\n", __func__, sys_filename);
	}
	else {
		ret_val = strtoul(buff, NULL, base);
	}
	close(fd);

	return ret_val;
}

static int dev_strStartsWith(const char *line, const char *src)
{
	int ret = -1;

	for ( ; *line != '\0' && *src != '\0'; line++, src++) {
		if (*line != *src) {
			return FAIL;
		}
	}
	ret = atoi(line);
	return ret;
}

static int dev_get_ttyport_by_syspath(char *syspath)
{
	DIR *usbdir = NULL;
	struct dirent *dent = NULL;
	int usb_port = -1;

	usbdir = opendir(syspath);
	if (usbdir == NULL) {
		printf("%s: open [%s] busdir failed\n", __func__, syspath);
		return FAIL;
	}

	while ((dent = readdir(usbdir)) != NULL)
	{
		usb_port = dev_strStartsWith(dent->d_name, "ttyUSB");
		if ( usb_port >= 0) {
			closedir(usbdir);
			usbdir = NULL;
			return usb_port;
		}
	}

	if (usbdir) {
		closedir(usbdir);
		usbdir = NULL;
	}
	return FAIL;
}

int dev_get_device(int *pPortInfo)
{
	DIR *usbdir = NULL;
	struct dirent *dent = NULL;
	int idVendor = 0, idProduct = 0;
	int bConfigurationValue = 0;
	int num = 0;
	usbdir = opendir(USB_DIR_BASE);
	if (usbdir == NULL)
		return -1;

	while ((dent = readdir(usbdir)) != NULL){
		if (strcmp(dent->d_name, ".") == 0 || strcmp(dent->d_name, "..") == 0) {
			continue;
		}

        snprintf(sys_filename, sizeof(sys_filename), "%s/%s/idVendor", USB_DIR_BASE, dent->d_name);
        if ((idVendor = dev_get_usbsys_val(sys_filename, 16)) <= 0) {
            continue;
        }

		snprintf(sys_filename, sizeof(sys_filename), "%s/%s/idProduct", USB_DIR_BASE, dent->d_name);
		if ((idProduct = dev_get_usbsys_val(sys_filename, 16)) <= 0) {
			continue;
		}

		snprintf(sys_filename, sizeof(sys_filename), "%s/%s/bConfigurationValue", USB_DIR_BASE, dent->d_name);
		if ((bConfigurationValue = dev_get_usbsys_val(sys_filename, 10)) <= 0) {
			continue;
		}

		if (idVendor == pPortInfo[0] && idProduct == pPortInfo[1]){
			snprintf(sys_filename, sizeof(sys_filename), "%s/%s/%s:%d.%d", USB_DIR_BASE, dent->d_name, dent->d_name, bConfigurationValue, pPortInfo[2]);
			g_usb_dev = dev_get_ttyport_by_syspath(sys_filename);
            printf("port found: /dev/ttyUSB%d -- %s\n", g_usb_dev, sys_filename);
			closedir(usbdir);
			usbdir = NULL;
			return 0;
		}
        usleep(10000);
	}
	if (usbdir) {
		closedir(usbdir);
		usbdir = NULL;
	}
	printf("Can not find port.\n");

	return -1;
}

