#ifndef _DOWNLOAD_H_
#define _DOWNLOAD_H_

#include "define.h"

// BI层最大支持线程数
#define TSP_THREAD_NUM      64

// 下载文件类型
#define FLASH                   (0x01)
#define EXTSRAM                 (0x02)
#define FPGA                    (0x03)
#define RAMIMAGE                (0x04)
#define NVBACKUP                (0x05)
#define ZPHY_ERFC_CA_NUMBER     2

// 串行口参数配置
#define READ_INTERVAL_TIMEOUT           (0)
#define READ_TOTAL_TIMEOUT_MULTIPLIER   (0)
#define READ_TOTAL_TIMEOUT_CONSTANT     (0)
#define WRITE_TOTAL_TIMEOUT_MULTIPLIER  (0)
#define WRITE_TOTAL_TIMEOUT_CONSTANT    (1000)

// 收发数据包大小
#define READ_QUEUE      (4096)
#define WRITE_QUEUE     (4096)

// 波特率设置选项
#define NO_OF_PARAMS    (7)
#define COM_PORT        (1)
#define BAUD_RATE       (2)
#define PARITY          (3)
#define STOP_BITS       (4)
#define DATA_BITS       (5)
#define READ_INTVL      (6)
#define TOTAL_TIME      (7)

//
//#define BUFFERLEN             1100
#define AT_CMD_TYPE_TEST      1000
#define AT_CMD_TYPE_AT        1001
#define INFO_PACKET_LEN       1024
// 下载的配置文件选项
#define VERSION_NUM           4

#define CONFIG_SECTION_CFG                  _T("Configuration")
#define CONFIG_SECTION_VERSION              _T("Version")
#define CONFIG_SECTION_CHIPDETAILS          _T("ChipDetails")
#define CONFIG_SECTION_ARM_BIN              _T("ArmBin")
#define CONFIG_SECTION_ZSP_BIN              _T("ZspBin")
#define CONFIG_SECTION_ZSPCC_BIN            _T("ZspCCBin")
#define CONFIG_SECTION_ARM1_BIN             _T("Arm1Bin")
#define CONFIG_SECTION_TDNV_BIN             _T("TDNVBin")
#define CONFIG_SECTION_AP_BIN               _T("APBin")
#define CONFIG_SECTION_RAMDISK_BIN          _T("RAMDiskBin")
#define CONFIG_SECTION_PHY_FILES_INFO       _T("AMT_PHY_FILES_INFO")
#define CONFIG_SECTION_DOWNLOAD_IMAGE       _T("DownloadImage")
#define CONFIG_SECTION_NV_BACKUP            _T("NVBackup")
#define CONFIG_SECTION_INDEX_LIST           _T("IndexList")
#define CONFIG_SECTION_IN_SOFTVERSION       _T("SoftVersionIn")
#define CONFIG_SECTION_OUT_SOFTVERSION      _T("SoftVersionOut")
#define CONFIG_SECTION_SSID_FLAG            _T("SSIDFlag")
#define CONFIG_SECTION_SSID                 _T("SSID")

#define CONFIG_SECTION_BUILD_DATE           _T("BuildDate")
#define CONFIG_SECTION_BUILD_TIME           _T("BuildTime")
#define CONFIG_SECTION_RALETIVEPATHBOOT     _T("RaletivePathBOOT")
#define CONFIG_SECTION_RALETIVEPATHAT       _T("RaletivePathAT")
#define CONFIG_SECTION_RALETIVEPATHATLC     _T("RaletivePathATLC")
#define CONFIG_SECTION_RALETIVEPATHLOG      _T("RaletivePathLOG")
#define CONFIG_SECTION_RALETIVEPATHFT       _T("RaletivePathFT")
#define CONFIG_KEY_VERSION                  _T("Version")
#define CONFIG_KEY_FILE                     _T("File")
#define CONFIG_KEY_STARTADDRESS             _T("StartAddress")
#define CONFIG_KEY_ENDADDRESS               _T("EndAddress")
#define CONFIG_KEY_TYPE                     _T("Type")
#define CONFIG_KEY_DEBUGINFO                _T("DebugInfo")
#define CONFIG_KEY_OPENLOGPORT              _T("IsOpenLogPort")
#define CONFIG_KEY_NVBACKUPCOUNT            _T("NVItemCount")
#define CONFIG_KEY_TLFILE                   _T("TLFile")
#define CONFIG_KEY_TLSTARTADDRESS           _T("TLStartAddress")
#define CONFIG_KEY_TDPSTARTADDRESS          _T("TDPStartAddress")
#define CONFIG_KEY_FLASHSTARTADDRESS        _T("FlashStartAddress")
#define CONFIG_KEY_COUNT                    _T("Count")
#define CONFIG_KEY_MANUID                   _T("ManuID")
#define CONFIG_KEY_DEVICEID                 _T("DeviceID")
#define CONFIG_KEY_TDPPATH                  _T("TDPPath")
#define CONFIG_KEY_RELATIVEPATH             _T("UseRelativePath")
#define CONFIG_KEY_READFROMFILE             _T("ReadFromFile")
#define CONFIG_KEY_FILESYSTEM               _T("FileSystem")
#define CONFIG_KEY_LENGTH                   _T("Length")
#define CONFIG_KEY_BUILD_DATE               _T("BuildDate")
#define CONFIG_KEY_BUILD_TIME               _T("BuildTime")
#define CONFIG_KEY_SN_INDEX                 _T("SNIndex")
// ....by wong
#define CONFIG_KEY_HARDWARE_SN_INDEX        _T("HARDWARE_SNIndex")
#define CONFIG_KEY_IMEI_INDEX               _T("IMEIIndex")
#define CONFIG_KEY_WIFI_MAC_INDEX           _T("WIFIIndex")
#define CONFIG_KEY_RJ45_MAC_INDEX           _T("RJ45MACIndex")
#define CONFIG_KEY_TESTINFO_INDEX           _T("TestInfoIndex")
#define CONFIG_KEY_SN_BACKUP_INDEX          _T("SNBackupIndex")
#define CONFIG_KEY_IMEI_BACKUP_INDEX        _T("IMEIBackupIndex")
#define CONFIG_KEY_TESTINFO_BACKUP_INDEX    _T("TestInfoBackupIndex")
#define CONFIG_KEY_BBACKUPAREA              _T("bBackupArea")
#define CONFIG_KEY_RALETIVEPATH             _T("RaletivePath")
#define CONFIG_KEY_ATVERSION                _T("AtVersion")
#define CONFIG_KEY_TESTINFODOWNLOAD			_T("TestInfoDLPV")

//#define CONFIG_KET_ISBOOTROM				_T("IsBootRom")
#define CONFIG_KEY_USBORUARTPORT            _T("USBORUARTPORT")
#define CONFIG_KEY_BOOTSTAGE1FILE           _T("BootStage1File")   //add zxw 20130422 for 296301
#define CONFIG_KEY_BOOTSTAGE1STARTADDRESS   _T("BootStage1StartAddress")
#define CONFIG_KEY_BOOTSTAGE2FILE           _T("BootStage2File")   //add zxw 20120422 for 296301
#define CONFIG_KEY_BOOTSTAGE2STARTADDRESS   _T("BootStage2StartAddress")
#define CONFIG_KEY_PARTITIONFILE            _T("PartitionFile")   //add zxw 20120422 for 296301
#define CONFIG_KEY_PARTITIONSTARTADDRESS    _T("PartitionStartAddress")
#define CONFIG_KEY_PARTITIONNAME            _T("PartitionName")
#define CONFIG_KEY_PARTITIONTYPE            _T("PartitionType")
#define CONFIG_KEY_STARTAMTCMD              _T("StartAMTCMD")
#define CONFIG_KEY_ISDOWNLOAD_PV            _T("ISDownLoadPV")
#define CONFIG_KEY_PHY_FILE_NUMS            _T("FileNumber")
////////////////////////////////////////////////////////////////////////////////////////////////////


// For CDownload
#define BI_TSP_ERROR_BASE_CDownload         (BI_TSP_ERROR_BASE_CTransmit + 10000)

typedef enum
{
    TYPE_BOOT,              // 从TYPE_BOOT到TYPE_TEST_AUTO
    TYPE_BOOT_AUTO,         // 属于老版本设计的思路，其初衷
    TYPE_EVB_TEST,          // 是按照EVB、FWP、DATACARD进行
    TYPE_EVB_LOG,           // 分类，根据配置界面（校准的脚本）
    TYPE_FWP_TEST,          // 设置对应的值，达到找到对应端口
    TYPE_FWP_LOG,           // 的目的。这种做法看似简单，但
    TYPE_DATACARD_TEST,     // 带来了维护方面的困难，因此，
    TYPE_DATACARD_LOG,      // 将采用新的方法进行兼容性过度
    TYPE_TEST_AUTO,
    TYPE_AT,                // 过度的准则是：在配置文件中设置对应端口的匹配信息
    TYPE_LOG,               // 所有项目通过这对统一的入口与端口对接
    TYPE_FT,                // 打开FT的AT口
    TYPE_BOOT_P93B,         // P93B的Boot口
    TYPE_AT_P93B,           // P93B的AT口
    TYPE_AT_LC,
    TYPE_INVALID = 99,
} enCOMTYPE;

typedef enum
{
    TYPE_GPIB = 0,
    TYPE_LAN,

} enTransferType;

typedef enum
{
	OFF_STATE =0,
	ON_STATE,
	ERR_STATE,

} enBootFlag;
// BOOT口列表
#define TYPE_BOOT_LIST  TYPE_BOOT, TYPE_BOOT_P93B
// AT口列表
#define TYPE_AT_LIST    TYPE_EVB_TEST, TYPE_FWP_TEST, TYPE_DATACARD_TEST, TYPE_AT, TYPE_FT, TYPE_AT_P93B
// LOT口列表
#define TYPE_LOG_LIST   TYPE_EVB_LOG, TYPE_FWP_LOG, TYPE_DATACARD_LOG

typedef struct _COMSTRUCT
{
#pragma pack(1)
    BYTE    byByteSize;
    BYTE    byParity;
    BYTE    byStopBits;
    DWORD   dwBaudRate;
    DWORD   dwReadInterval;
    DWORD   dwTotalTime;
#pragma pack()
} COMSTRUCT;

typedef struct
{
    int   cmd;
    unsigned char   Msg[INFO_PACKET_LEN];
}Msg_PACKET;

// start =============================================================================================
#define DLTYPE_CONTROL_BEGIN() \
typedef enum{ \
DLTYPE_OWNERSTATE_START	= 0x00, \

#define DLTYPE_CONTROL_END() \
DLTYPE_OWNERSTATE_END = 0X11, \
}enDLTYPE_CONTROL;
//  CDownload绑定状态位索引
// 下载类型绑定状态位,enDownloadType高字合计2个字节空间,支持16个小bool位控制从BI传入BL
// 如: 免PV的标志位IsNoPVDownLoad变量传入
// 若已经使用某一位,则不可再复用

#define STATEFLAG(x) (1<<x)

DLTYPE_CONTROL_BEGIN()						// start 在此内部添加[下载类型绑定状态位]传入BL
	DLTYPE_OWNERSTATE_NONEPV			= STATEFLAG(0),		// 免PV控制开关
	DLTYPE_OWNERSTATE_NONEPV_ERASEAUTO	= STATEFLAG(1),
	DLTYPE_OWNERSTATE_NONEPV_ERASEALL	= STATEFLAG(2),
	// TODO

DLTYPE_CONTROL_END()						// end
// end    =============================================================================================


//CDownload
typedef enum
{
	DOWNLOAD_TYPE_AMT,
    DOWNLOAD_TYPE_AMT_MODEM,        //modem 小系统
    DOWNLOAD_TYPE_AMT_AP,           // ＡＰ小系统
    DOWNLOAD_TYPE_IMAGE,            // 版本文件
    DOWNLOAD_TYPE_NV_IMAGE,         // NV镜像文件
    DOWNLOAD_TYPE_NV,               // NV 备份文件
    DOWNLOAD_TYPE_SN,               // SN文件
    DOWNLOAD_TYPE_IMEI,             // IMEI文件
    DOWNLOAD_TYPE_TESTINFO,         // TESTINFO文件
    DOWNLOAD_TYPE_SN_BACKUP,        // SN Backup文件
    DOWNLOAD_TYPE_IMEI_BACKUP,      // IMEI Backup文件
    DOWNLOAD_TYPE_TESTINFO_BACKUP,  // TESTINFO Backup文件
    DOWNLOAD_TYPE_IN_SOFTVERSION,      // SoftVersion文件
    DOWNLOAD_TYPE_MAC_WIFI,
    DOWNLOAD_TYPE_SSID_FLAG,
    DOWNLOAD_TYPE_SSID,
    DOWNLOAD_TYPE_FS_FLAG,
	DOWNLOAD_TYPE_OUT_SOFTVERSION,     // SoftVersion文件
	DOWNLOAD_TYPE_HARDWARE_SN,		// HARDWARE_SN 下载硬件版本号
	DOWNLOAD_TYPE_TESTINFO_DL_PV,		// 下载PV版本的生产测试标志位
	DOWNLOAD_TYPE_TESTINFO_DL_RELEASE,	// 下载发货版本的生产测试标志位
	DOWNLOAD_TYPE_TESTINFO_DL_AMT,		// 下载AMT版本的生产测试标志位
	DOWNLOAD_TYPE_MAC_RJ45,
} enDownloadType;

typedef enum
{
    METHOD_NORMAL,              // 只备份工作区
    METHOD_WORK_BACKUP,         // 根据标志位，备份工作区、备份区
    METHOD_WRITE_TO_FILE,       // 备份时，若板号不为空，则将NV数据写入文件
} enDownloadNVBackupMethod;

// 待下载镜像文件信息 CDownload
typedef struct
{
    BOOL    bDownload;              // 上/下载功能标志，TRUE = 下载；FALSE = 上载
    char * strFileName;            // 文件路径
    BOOL    bUseRelativePath;       // 文件路径是否为相对路径；TRUE = 相对路径；FALSE = 绝对路径
    BOOL    bReadFromFile;          // 下载时，是否直接从文件读取；TRUE = 数据取自文件；FALSE = 数据取自内存
  //  BOOL    bFileSystem;            // 镜像文件是否为文件系统；TRUE = 文件系统文件；FALSE = 非文件系统文件
    BOOL    bAutoDeleteImageCache;  // 是否自动回收镜像缓存
    BYTE   *pImageCache;            // 镜像缓存
	//  DWORD   dwStartAddress;         // 下载/上载绝对起始地址

    DWORD   dwOffset;               // 相对于文件/缓存的偏移 
	DWORD   dwLength;               // 下载/上载数据长度
    int     nType;                  // 下载类型
	char    PartitionName[16];    	//分区名  add zxw 20130422
	char    FileName[16];
    char    PartitionType[16] ;
    DWORD   nPartitionOffset;
	//新增文件的CRC校验值
	ULONG   ulCRCValue;
	
} stFileItem;

// NV备份信息
typedef struct
{
    enDownloadType   nType;         // NV备份的类型
    BYTE            *pBuffer;       // NV备份的缓存
    DWORD            dwStartAddress;// NV备份的下载地址
    DWORD            dwLength;      // NV备份的长度
} stNVItem;

typedef struct
{
    unsigned long dwResult;
} stResult;

//////////////////////////////////////////////////////////////////////////
typedef unsigned int UINT32;
typedef   signed int SINT32;
typedef unsigned short UINT16;
typedef   signed short SINT16;

// 分区表相关的信息
#define MAX_ENTRY          16

// add cxh 7510 下载分区文件类型
#define nand                      (0x01) 
#define fs                        (0x02)
//#define NV                        (0x03) 
#define zftl                      (0x03)
#define ddr                       (0x04)
#define raw                       (0x05)
#define zloader                   (0x06)

// 合并BIN文件中Masterhead结构
typedef struct
{
	BYTE   FileId[16];
    BYTE   chVersionIN[32];
    BYTE   chVersionOUT[32];
	DWORD  nTotalFileNum; 
    DWORD  nFlashType;
    DWORD  nNVCoalition; 
    DWORD   iFileSize;      
    DWORD   iCkeckSum;
    DWORD   iImageStructOffset;
    DWORD   tloaderOffset;
    DWORD   tloaderLength;
    DWORD   tBootOffset;
    DWORD   tBootLength;
    DWORD   PartitionOffset;
    DWORD   PartitionLength;
    BYTE    UnUsed[80];          //预留区
}stBinMasterInfo;


typedef struct  
{
    BYTE	PartitionName[16]; 
    BYTE    PartitionType[16];
    unsigned int    PartitionSize;
    unsigned int    PartitionOffset;  
}partition_entry;

typedef struct 
{
    unsigned int       iPartitionMagic;
    BYTE               PlatformName[16];
    unsigned int       iPartitionVersion;     /* 分区版本 */
    unsigned int       iPartitionEntrys;      /* 总的分区个数 */
    unsigned int       iPartitionCrc;
    partition_entry    PartitionTable[MAX_ENTRY];
}partition_table;


// 合并BIN文件的文件头部信息 CDownload
typedef struct
{
    BYTE    nTotalFileNum;          // BIN文件中包含的子文件总数量
    BYTE    UnUsed[15];             // 未使用
} stBinInfo;

// 合并BIN文件的每个文件信息 CDownload
typedef struct
{
    DWORD   dwOffset;               // 子文件相对于BIN文件起始的偏移
    DWORD   dwLength;               // 子文件长度
    DWORD   dwStartAddress;         // 子文件待下载的绝对地址
    DWORD    nType;                  // 子文件的类型
    BYTE    bFileSystem;            // 子文件的文件系统标志
	
} stBinFileHeader;

typedef struct  
{
    BYTE  FileName[64];
    BYTE  PartitionName[16];
	BYTE PartitionType[16];
    unsigned int iFileLength;
	unsigned int iPartitionOffset;
    unsigned int iFileOffset; // 子文件相对于BIN文件起始的偏移
    //相对于分区起始地址的偏移
    BYTE  UnUsed[20];
}stBinImageHead;

typedef enum
{
	HDT_W_MAIN = 0,
	HDT_W_ASSIST,
	HDT_W_MAANDAS,
}E_HDT_WAGCTYPE;

typedef struct
{
    int  iErrorCode;
    char cBarcode[21];
} stDLDBInfo;

typedef enum
{
    STAT_SYNC,                  // 0
    STAT_START_BYTE,            // 1
    STAT_NO_MODIFY_REG,         // 2
    STAT_ADDRESS,               // 3
    STAT_DATA_LEN,              // 4
    STAT_DATAPACKET,            // 5
    STAT_LINK_EST,              // 6
    STAT_DEVICEINFO,            // 7
    STAT_CONFIGTDP,             // 8
    STAT_PROG_DEV_ST_ADDR,      // 9
    STAT_PROG_DEV_END_ADDR,     // 10
    STAT_SET_PACKET_SIZE,       // 11
    STAT_CHANGE_CONFIG,         // 12
    STAT_ERASE_SEG_ST_ADDR,     // 13
    STAT_ERASE_SEG_END_ADDR,    // 14
    STAT_DEV_BASE_ADDR,         // 15
    STAT_EXECUTE_CODE,          // 16
    STAT_TERMINATE,             // 17
    STAT_RVRS_DWNLD,            // 18
    STAT_UPLD_DATA_SIZE,        // 19
    STAT_SUCCESS,               // 20
	STAT_CRC_ON,   
	STAT_CRC_OFF, 
    // New stat add code here
} enSTAT;


//Bootrom & TLoader公用下载协议
#define CMD_SYNC_BYTE_BOOTROM        0x5A
#define CMD_SYNC_BYTE_ACK_BOOTROM    0xA5
#define CMD_SEND_REG_CONFIG_BOOTROM  0x6A
#define CMD_SEND_DATA_BOOTROM        0x7A
#define CMD_STARTUP_BOOTROM          0x8A

//7520V2 bootrom&TLoader新增回复命令
#define CMD_SEND_ADDRESS_LEN_ACK_BOOTROM    0xA1
#define CMD_SEND_DATA_ACK_BOOTROM           0xA7
#define CMD_STARTUP_ACK_BOOTROM             0xA8


//TBoot运行同步协议
#define CMD_SYNC_TBOOT				 0x5A
#define CMD_SYNC_ACK_TBOOT			 0xA7

#define PACKET_SIZE_BOOT        131072 
//#define PACKET_SIZE_BOOT        131072 

#define PACKET_SIZE_TL          1024
#define PACKET_SIZE_TDP         4096

#define PACKET_SIZE_FLASH      	4096

//#define PACKET_SIZE_FLASH      2097152
#define PACKET_SIZE_IMAGE       131072
#define PACKET_SIZE_FILESYSTEM  135168

//partiiton协议
typedef enum  
{  // STAT_TBOOT_OK,
    STAT_SYNC_PARTIITON,
    STAT_SET_PARTITION_CMD,
    STAT_SEND_PARTIITON,
    STAT_EXIT,

}enParpSTAT;

typedef struct
{
    enSTAT  mNextTRUE;
    enSTAT  mNextFALSE;
} stSTAT;

typedef struct DownloadConfig
{  
    enSTAT      mStartState;
    BOOL        mbExecuteCode; //下载后，是否启动运行，暂时无用  zxw 20130422    
    stFileItem  mCurrentFile;
    DWORD       mPacketSize; //数据包大小，新方案由UE侧上传，暂无用处  zxw 20130422  //这个还是有用的，大小不超过2M就可以
} stDownloadConfig;

// 执行擦除NVRW
BOOL ExecuteEraseNVRW(const char *softwarepath);
// 下载boot和tloader
BOOL DoDownloadBootForDL(BOOL bCheckPartition, const char *softwarepath);
// 下载主流程
int PrimaryDoDownload(const char *softwarepath);

#endif
