/*
 * arch/arm/mach-zx297510/include/mach/gpio.h
 *
 *  Copyright (C) 2013 ZTE-TSP
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 *
 *    ******************** NOTICE **********************
 * There is only some pins can be used, pin[96] can not be used.
 * Gpio[51:48] in pin list controlled by AO domain register[28:25], and stanby domain register[28:25] control gpio[28:25].
 * We look gpio number from 25 to 28 in gpio driver as stanby domain gpio[28:25]. gpio[28:25] in pin list is unique.
 */

#ifndef __ASM_ARCH_ARM_GPIO_H
#define __ASM_ARCH_ARM_GPIO_H

#include<linux/version.h>
#include<mach/gpio-names.h>

struct zx29_ap_platform_data {
    union{
        struct{
            int ufi_resetkey;
            int power_on_int;
            int ufi_wps;
            int wifi_host_wake;
            int charger_pg;
        }gpio;
    }ap;
};

#if (LINUX_VERSION_CODE < KERNEL_VERSION(3,4,0))
#define gpio_get_value	__gpio_get_value
#define gpio_set_value	__gpio_set_value
#define gpio_cansleep	__gpio_cansleep
#define gpio_to_irq	__gpio_to_irq
#endif

#define ARCH_NR_GPIOS  (151)
#define BASE_GPIO      (0)
#define NGPIO        (ARCH_NR_GPIOS-BASE_GPIO)
#define EXT_INT_GPIO_MIN 2
#define EXT_INT_GPIO_MAX 17

/*GPIO FOR SPI*/
#define GPIO_AP_SPI_CS      AO_GPIO_2
#define GPIO_AP_SPI_CLK     AO_GPIO_3
#define GPIO_AP_SPI_RXD    AO_GPIO_4
#define GPIO_AP_SPI_TXD     AO_GPIO_5

/*GPIO FOR APP*/ 
#define GPIO_AP_UFI_RESETKEY       AO_GPIO_13
#define GPIO_AP_POWER_ON_INT      AO_GPIO_14
#define GPIO_AP_UFI_WPS                AO_GPIO_17
#define GPIO_AP_WIFI_HOST_WAKE    AO_GPIO_16
#define GPIO_AP_CHARGER_PG          AO_GPIO_11


#define GPIO_AP_CHARGER_CE1   SDB_GPIO_148
#define GPIO_AP_CHARGER_CE2   SDB_GPIO_149
#define GPIO_AP_CHARGER_IUSB1 SDB_GPIO_52
#define GPIO_AP_CHARGER_IUSB2 SDB_GPIO_53
#define GPIO_AP_CHARGER_IUSB3 SDB_GPIO_54
#define GPIO_AP_CHARGER_CHG   AO_GPIO_12

extern void zx29_gpio1v8_function_sel(unsigned int pin_num, unsigned int value);
extern void zx29_gpio1v8_set_direction(unsigned int pin_num, unsigned int value);
extern void zx29_gpio1v8_output_data(unsigned int pin_num, unsigned int value);
extern unsigned int zx29_gpio1v8_input_data(unsigned int pin_num);
extern unsigned int zx29_gpio1v8_function_sel_get(unsigned int pin_num);
extern unsigned int zx29_gpio1v8_get_direction(unsigned int pin_num);
extern void zx29_gpio1v8_pd_enable(unsigned int pin_num);
extern void zx29_gpio1v8_pd_disable(unsigned int pin_num);
extern void zx29_gpio1v8_pu_enable(unsigned int pin_num);
extern void zx29_gpio1v8_pu_disable(unsigned int pin_num);


extern void zx29_gpio_config(unsigned gpio, unsigned value);
extern void zx29_gpio_set_inttype(unsigned int gpio, unsigned int type);

extern void jtag_config(unsigned int jtag_num, unsigned int function);


#include<asm-generic/gpio.h>

#endif
