/*
 * arch/arm/mach-zx297510/include/mach/memory.h
 *
 *  Copyright (C) 2013 ZTE-TSP
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef IOMAP_H
#define IOMAP_H

#include <asm/pgtable.h>


/**************************************************************************************
                               physical address                          
***************************************************************************************/
/*
 * cortex-A9 private peripheral physical base addresses.
 */
#define A9_PERIPHERAL_BASE    0x00800000
#define A9_PERIPHERAL_SIZE    SZ_4M

#define A9_GIC_ICC_BASE       0x00800100
#define A9_GLOBAL_TIMER_BASE  0x00800200
#define A9_TIMER_WDT_BASE     0x00800600
#define A9_GIC_ICD_BASE       0x00801000
#define A9_CRPM_BASE  		  0x00803000

#define L2CACHE_CONFIG_BASE   0x00c00000
#define L2CACHE_CONFIG_SIZE   SZ_4K

/*
 * shared peripheral physical base addresses.
 */
/*A1 platform */
#define ZX297510_A1_BASE      0x00100000  /*A1 platform space base address*/
#define ZX297510_A1_SIZE      SZ_256K

#define ZX297510_A1CRM_BASE   0x00101000    
#define ZX297510_A1CRM_SIZE   SZ_4K

#define ZX297510_UART0_BASE   0x00102000    
#define ZX297510_UART0_SIZE   SZ_4K

#define ZX297510_UART1_BASE   0x00103000    
#define ZX297510_UART1_SIZE   SZ_4K

#define ZX297510_SSP_BASE     0x00104000
#define ZX297510_SSP_SIZE     SZ_4K

#define ZX297510_I2C0_BASE     0x00106000
#define ZX297510_I2C0_SIZE     SZ_4K

#define ZX297510_TIMER2_BASE  0x00108000
#define ZX297510_TIMER2_SIZE  SZ_4K

#define ZX297510_TIMER3_BASE  0x00109000
#define ZX297510_TIMER3_SIZE  SZ_4K

#define ZX297510_RTC_BASE     0x0010B000
#define ZX297510_RTC_SIZE     SZ_4K

#define ZX297510_SOCCRM_BASE  0x0010C000
#define ZX297510_SOCCRM_SIZE  SZ_4K

#define ZX297510_TOP_BASE     0x0010D000
#define ZX297510_TOP_SIZE     SZ_8K

/*A2 platform  AHB */
#define ZX297510_A2AHB_BASE    0x01200000  /*A2 platform  AHB space base adress*/
#define ZX297510_A2AHB_SIZE    SZ_1M

#define ZX297510_NAND_REG      0x01207000
#define ZX297510_NAND_REG_SIZE SZ_4K

#define ZX297510_NAND_MEM      0x01208000
#define ZX297510_NAND_MEM_SIZE SZ_4K

#define ZX297510_USB0_CFG_BASE 0x01240000
#define ZX297510_USB0_CFG_SIZE SZ_256K

#define ZX297510_USB1_CFG_BASE 0x01280000
#define ZX297510_USB1_CFG_SIZE SZ_256K

/*A2 platform  APB */
#define ZX297510_A2APB_BASE    0x01300000  /*A2 platform  APB space base adress*/
#define ZX297510_A2APB_SIZE    SZ_1M

#define ZX297510_DMA0_BASE     0x01301000
#define ZX297510_DMA0_SIZE     SZ_4K

#define ZX297510_DMA1_BASE 0x01302000
#define ZX297510_DMA1_SIZE SZ_4K

#define ZX297510_SOC_SYS_BASE  0x01303000
#define ZX297510_SOC_SYS_SIZE  SZ_4K

#define ZX297510_STB_GPIO_BASE 0x01305000
#define ZX297510_STB_GPIO_SIZE SZ_4K

/*A2 platform  LSP */
#define ZX297510_A2LSP_BASE    0x01400000  /*A2 platform  LSP space base adress*/
#define ZX297510_A2LSP_SIZE    SZ_1M

#define ZX297510_LSPCPRM_BASE  0x01400000
#define ZX297510_LSPCPRM_SIZE  SZ_4K

#define ZX297510_SDMMC0_BASE   0x01408000
#define ZX297510_SDMMC0_SIZE   SZ_4K

#define ZX297510_TIMER0_BASE   0x0140E000
#define ZX297510_TIMER0_SIZE   SZ_4K

#define ZX297510_TIMER1_BASE   0x0140F000
#define ZX297510_TIMER1_SIZE   SZ_4K

#define ZX297510_SDMMC1_BASE   0x01415000
#define ZX297510_SDMMC1_SIZE   SZ_4K

/*ICP1*/
#define ZX297510_ICP1_BASE     0x60001000
#define ZX297510_ICP1_SIZE     SZ_4K

/*
 * Internal Memory.
 */
#define ZX297510_SRAM02_BASE	0x90000000	/* Internal SRAM0&SRAM2 base address */
#define ZX297510_SRAM02_SIZE	SZ_128K		/* Internal SRAM0&SRAM2 size (128Kb) */

#define ZX297510_SRAM13_BASE	0x10000000	/* Internal SRAM1&SRAM3 base address */
#define ZX297510_SRAM13_SIZE	SZ_128K		/* Internal SRAM1&SRAM3 size (128Kb) */

#define ZX297510_SRAM6_BASE	    0x90020000	/* Internal SRAM6 base address */
#define ZX297510_SRAM6_SIZE	    SZ_32K		/* Internal SRAM6 size (32Kb) */


/**************************************************************************************
                                virtual address                          
***************************************************************************************/

/*virtual address 0xf8000000--0xfeffffff  for static io remap*/
#define ZX29_ADDR_BASE	(0xf8000000)


#ifndef __ASSEMBLY__
#define ZX29_ADDR(x)	((void __iomem __force *)ZX29_ADDR_BASE + (x))
#else
#define ZX29_ADDR(x)	(ZX29_ADDR_BASE + (x))
#endif


#define A9_PERIPHERAL_VA	 ZX29_ADDR(0x00000000)
#define L2CACHE_CONFIG_VA    ZX29_ADDR(0x00400000)

#define ZX29_A1_VA           ZX29_ADDR(0x00800000)
#define ZX29_A2AHB_VA        ZX29_ADDR(0x00900000)
#define ZX29_A2APB_VA        ZX29_ADDR(0x00a00000)
#define ZX29_A2LSP_VA        ZX29_ADDR(0x00b00000)	 

#define ZX29_IRAM02_VA       ZX29_ADDR(0x00c00000)
#define ZX29_IRAM6_VA        ZX29_ADDR(0x00d00000)

  
#define ZX29_TOP_VA	       (ZX297510_TOP_BASE - ZX297510_A1_BASE + ZX29_A1_VA) 

#define ZX29_SOC_SYS_VA    (ZX297510_SOC_SYS_BASE - ZX297510_A2APB_BASE + ZX29_A2APB_VA)


#define ZX29_SOCCRM_MOD_VA	   (ZX297510_SOCCRM_BASE - ZX297510_A1_BASE + ZX29_A1_VA)


#define ZX29_POWER_DOMAIN_VA  (ZX297510_TOP_BASE - ZX297510_A1_BASE + ZX29_A1_VA + 0x200 )

#define ZX29_POWER_DOMAIN_ISO			(ZX29_POWER_DOMAIN_VA + 0x41*4)	
#define ZX29_POWER_DOMAIN_RST			(ZX29_POWER_DOMAIN_VA + 0x40*4)
#define ZX29_POWER_DOMAIN_POWERON		(ZX29_POWER_DOMAIN_VA + 0x42*4)

#define ZX29_SOC_MOD_CLKEN0				(ZX29_SOCCRM_MOD_VA + 0xc)
#define ZX29_SOC_MOD_CLKEN1				(ZX29_SOCCRM_MOD_VA + 0x10)
#define ZX29_SOC_MOD_RSTEN				(ZX29_SOCCRM_MOD_VA + 0x18)
#define ZX29_SOC_MOD_RSTEN1				(ZX29_SOCCRM_MOD_VA + 0x64)
#define ZX29_SOC_MOD_USBSTATECTRL		(ZX29_SOCCRM_MOD_VA + 0x5c)




#endif
