/*
 * arch/arm/mach-zx297510/zx-cpuidle.h
 *
 * Copyright (c) 2013, ZTE Corporation.
 * write by zxp
 *
 */

#ifndef __MACH_ZX_CPU_IDLE_H
#define __MACH_ZX_CPU_IDLE_H

#ifdef CONFIG_ZX_PM_DEBUG
#define DEBUG_CPU_NUM	4
/*record idle states info*/
struct zx_idle_stats
{
	unsigned int cpu_ready_count[DEBUG_CPU_NUM];
	unsigned int tear_down_count[DEBUG_CPU_NUM];
	unsigned long long cpu_wants_lp2_time[DEBUG_CPU_NUM];
	unsigned long long in_lp2_time[DEBUG_CPU_NUM];
	unsigned int lp2_count[DEBUG_CPU_NUM];
	unsigned int lp2_completed_count[DEBUG_CPU_NUM];
	unsigned int lp3_count[DEBUG_CPU_NUM];
	//unsigned int lp2_count_bin[32];
	//unsigned int lp2_completed_count_bin[32];
	unsigned int lp2_int_count[NR_IRQS];
	unsigned int last_lp2_int_count[NR_IRQS];
	unsigned int idle_count;
};
#endif

#define	ZX_IDLE_CSTATE_LP3			0
#define	ZX_IDLE_CSTATE_LP2			1
#define	ZX_IDLE_MAX_CSTATE			2

/* 
  *cpuidle functions
  */
extern int __init zx_cpuidle_init(void);
extern s64 idle_get_sleeptime(void);
#ifdef CONFIG_ZX_PM_DEBUG
extern int __init idle_debug_init(void);
#endif
extern int __init zx_fill_cpuidle_data(struct cpuidle_driver *drv);
extern int zx_enter_idle(struct cpuidle_device *dev,
			struct cpuidle_driver *drv,
			      int index);
extern int zx_pm_idle_enter(int index);

#endif /* __MACH_ZX_CPU_IDLE_H */

