#ifndef _MACH_ZX297502_DMA_H
#define _MACH_ZX297502_DMA_H

#define DMA_CHAN_NUM		16

#define DMAC0_REUSE      		8        //DMA reuse flag
#define DMAC1_REUSE		16
#define CORE_ID_ARM0 		0
#define CORE_ID_ARM1 		1
#define CORE_ID_A9 			2

#define DMA_CHANNEL_CONFIG(perpheralID,coreID,isUsed)		{perpheralID,coreID,isUsed,NULL,NULL}

typedef enum
{
	DMAC0,
	DMAC1,
	DMAC_NUM,
}dmac_id;

/*DMA peripheral definition*/
typedef enum
{
    /*DMAC0 peripheral */
    /*ext_dma_sel=1*/
	DMAC0_CH_UART0_TX = 0,
	DMAC0_CH_UART0_RX,    	
	DMAC0_CH_UART1_TX,    	
	DMAC0_CH_UART1_RX,    	
	DMAC0_CH_SSP0_TX,     	
	DMAC0_CH_SSP0_RX,     	
	DMAC0_CH_GPRS0,       	
	DMAC0_CH_USIM0,       	
	DMAC0_CH_USIM1,       	
	DMAC0_CH_I2S0_RX,     	
	DMAC0_CH_I2S1_TX,     	
	DMAC0_CH_I2S1_RX,     	
	DMAC0_CH_SD0_TX,      	
	DMAC0_CH_SD0_RX,      	
	DMAC0_CH_SD1_TX,
	DMAC0_CH_SD1_RX,   
	/* ext_dma_sel=0*/
	DMAC0_CH_I2S0_TX ,//  16
	
	DMAC0_CH_MEMORY,//17
/*DMAC1 peripheral*/
/*ext_dma_sel=1*/
	DMAC1_CH_START = 18,
	DMAC1_CH_TD_DMA0 = DMAC1_CH_START,
	DMAC1_CH_TD_DMA1,				
	DMAC1_CH_TD_DMA2,				
	DMAC1_CH_TD_DMA3,				
	DMAC1_CH_RX_FIR_COEF_RAM,		
	DMAC1_CH_RX_CQI_RAM,			
	DMAC1_CH_RX_PDSCH_NO_RAM,	
	DMAC1_CH_RX_MBSFN_NO_RAM,	
	DMAC1_CH_RX_NORAM,			
	DMAC1_CH_RX_TPMI,				
	DMAC1_CH_RX_COS_WINDOW, 	
	DMAC1_CH_C_DTR_RAM, 	
	DMAC1_CH_TX_HARQ_RAM,			
	DMAC1_CH_GPRS1,
	DMAC1_CH_TD_CSR0,	
	DMAC1_CH_TD_CSR1,	
/* ext_dma_sel=0*/
	DMAC1_CH_RX_PDSCH_CIR_RAM = 34,
	DMAC1_CH_RX_PDSCH_CIR_MAX,
	DMAC1_CH_RX_MBSFN_CIR_RAM,
	DMAC1_CH_RX_MBSFN_CIR_MAX,
	
	DMAC1_CH_MEMORY = 38,// used for allocate M2M channel on DMAC1
	DMA_CH_ALL,
}
dma_peripheral_id;
typedef enum
{
    DMA_INT_ERR,			//transmission error
    DMA_INT_END,			//transmission done

    MAX_DMA_INT
}
dma_int_status;/*dma_int_status;*/
typedef void (*dma_callback_func)(unsigned int channel, dma_int_status status,void *data);
//typedef    void (*dma_callback_func)(zx297510_dma_chan *chan);

/*dma channel config define*/
typedef struct 
{
    unsigned int peripheralID;
    unsigned int ownner;
    unsigned int isUsed;
    void *		data;
    dma_callback_func channelCbk;
} 
dma_chan_config;
/*DMAC0 channel config*/
#define DMAC0_CFG_CH0		DMA_CHANNEL_CONFIG(DMAC0_CH_UART0_TX,CORE_ID_ARM0,TRUE)
#define DMAC0_CFG_CH1		DMA_CHANNEL_CONFIG(DMAC0_CH_UART0_RX,CORE_ID_ARM0,TRUE)
#define DMAC0_CFG_CH2		DMA_CHANNEL_CONFIG(DMAC0_CH_UART1_TX,CORE_ID_ARM0,TRUE)
#define DMAC0_CFG_CH3		DMA_CHANNEL_CONFIG(DMAC0_CH_UART1_RX,CORE_ID_ARM0,TRUE)
#define DMAC0_CFG_CH4		DMA_CHANNEL_CONFIG(DMAC0_CH_SSP0_TX,CORE_ID_A9,TRUE)
#define DMAC0_CFG_CH5		DMA_CHANNEL_CONFIG(DMAC0_CH_SSP0_RX,CORE_ID_A9,TRUE)
#define DMAC0_CFG_CH6		DMA_CHANNEL_CONFIG(DMAC0_CH_GPRS0,CORE_ID_ARM0,TRUE)
#define DMAC0_CFG_CH7		DMA_CHANNEL_CONFIG(DMAC0_CH_USIM0,CORE_ID_ARM0,TRUE)
#define DMAC0_CFG_CH8		DMA_CHANNEL_CONFIG(DMAC0_CH_USIM1,CORE_ID_ARM0,TRUE)
#define DMAC0_CFG_CH9		DMA_CHANNEL_CONFIG(DMAC0_CH_I2S0_RX,CORE_ID_ARM0,TRUE)
#define DMAC0_CFG_CH10		DMA_CHANNEL_CONFIG(DMAC0_CH_I2S1_TX,CORE_ID_ARM0,TRUE)
#define DMAC0_CFG_CH11		DMA_CHANNEL_CONFIG(DMAC0_CH_I2S1_RX,CORE_ID_ARM0,TRUE)
#define DMAC0_CFG_CH12		DMA_CHANNEL_CONFIG(DMAC0_CH_SD0_TX,CORE_ID_A9,FALSE)
#define DMAC0_CFG_CH13		DMA_CHANNEL_CONFIG(DMAC0_CH_SD0_RX,CORE_ID_A9,FALSE)
#define DMAC0_CFG_CH14		DMA_CHANNEL_CONFIG(DMAC0_CH_SD1_TX,CORE_ID_A9,FALSE)
#define DMAC0_CFG_CH15		DMA_CHANNEL_CONFIG(DMAC0_CH_SD1_RX,CORE_ID_A9,FALSE)
/*DMAC1 channel config*/
#define DMAC1_CFG_CH0		DMA_CHANNEL_CONFIG(DMAC1_CH_TD_DMA0,CORE_ID_ARM1,TRUE)
#define DMAC1_CFG_CH1		DMA_CHANNEL_CONFIG(DMAC1_CH_TD_DMA1,CORE_ID_ARM1,TRUE)
#define DMAC1_CFG_CH2		DMA_CHANNEL_CONFIG(DMAC1_CH_TD_DMA2,CORE_ID_ARM1,TRUE)
#define DMAC1_CFG_CH3		DMA_CHANNEL_CONFIG(DMAC1_CH_TD_DMA3,CORE_ID_ARM1,TRUE)
#define DMAC1_CFG_CH4		DMA_CHANNEL_CONFIG(DMAC1_CH_RX_FIR_COEF_RAM,CORE_ID_ARM1,TRUE)
#define DMAC1_CFG_CH5		DMA_CHANNEL_CONFIG(DMAC1_CH_RX_CQI_RAM,CORE_ID_ARM1,TRUE)
#define DMAC1_CFG_CH6		DMA_CHANNEL_CONFIG(DMAC1_CH_RX_PDSCH_NO_RAM,CORE_ID_ARM1,TRUE)
#define DMAC1_CFG_CH7		DMA_CHANNEL_CONFIG(DMAC1_CH_RX_MBSFN_NO_RAM,CORE_ID_ARM1,TRUE)
#define DMAC1_CFG_CH8		DMA_CHANNEL_CONFIG(DMAC1_CH_RX_NORAM,CORE_ID_ARM1,TRUE)
#define DMAC1_CFG_CH9		DMA_CHANNEL_CONFIG(DMAC1_CH_RX_TPMI,CORE_ID_ARM1,TRUE)
#define DMAC1_CFG_CH10		DMA_CHANNEL_CONFIG(DMAC1_CH_RX_COS_WINDOW,CORE_ID_ARM1,TRUE)
#define DMAC1_CFG_CH11		DMA_CHANNEL_CONFIG(DMAC1_CH_C_DTR_RAM,CORE_ID_ARM1,TRUE)
#define DMAC1_CFG_CH12		DMA_CHANNEL_CONFIG(DMAC1_CH_TX_HARQ_RAM,CORE_ID_ARM1,TRUE)
#define DMAC1_CFG_CH13		DMA_CHANNEL_CONFIG(DMAC1_CH_GPRS1,CORE_ID_ARM1,TRUE)
#define DMAC1_CFG_CH14		DMA_CHANNEL_CONFIG(DMAC1_CH_TD_CSR0,CORE_ID_ARM1,TRUE)
#define DMAC1_CFG_CH15		DMA_CHANNEL_CONFIG(DMAC1_CH_TD_CSR1,CORE_ID_ARM1,TRUE)


/*----DMA Transfer Control Set------*/
typedef enum
{
    DMA_DISABLE = 0,//disable DMA transmission
    DMA_ENABLE = 1,//enable DMA transmission
    DMA_ENABLE_ALL
}
dam_enable;

/*----DMA Request mode set------*/
typedef enum
{
    DMA_PERIPHERAL_REQ = 0,		//peripheral request
    DMA_SOFT_REQ = 1,			//soft request for single transfer
    
    DMA_REQ_MOD_ALL
}
dma_req_mod;

/*----DMA SingleRequest mode set------*/
typedef enum
{
    DMA_SOFT_SINGLE_REQ_DISABLE = 0,		//soft request for single transfer
    DMA_SOFT_SINGLE_REQ_ENABLE = 1,			//soft request for burst transfer
    
    DMA_SINGLE_REQ_MOD_ALL
}dma_single_req_mod;


/*----DMA Source or Dest address mode------*/
typedef enum
{
    DMA_ADDRMOD_RAM = 0,			//RAM mode, address will increase during transmission
    DMA_ADDRMOD_FIFO = 1,			//FIFO mode, address will not change during transmission

    DMA_ADDRMOD_ALL
}dma_addr_mod;

/*----DMA IRQ Mode------*/
typedef enum
{
	DMA_ALL_IRQ_DISABLE = 0,		//Disable DMA Interrupt request
	DMA_TC_IRQ_ENABLE = 1,			//Enable dma complete interrupt 
	DMA_ERR_IRQ_ENABLE =2,			//Enable dma error interrupt
	DMA_ALL_IRQ_ENABLE = 3, 		//Enable DMA Interrupt request
	
	DMA_IRQMOD_ALL
}dma_irq_mod;

/*----DMA Burst Size------*/
typedef enum
{
    DMA_BURST_SIZE_8BIT = 0,
    DMA_BURST_SIZE_16BIT = 1,
    DMA_BURST_SIZE_32BIT = 2,
    DMA_BURST_SIZE_64BIT = 3,
    DMA_BURST_SIZE_128BIT = 4,
    
    DMA_BURST_SIZE_ALL
}dma_burst_size;


/*----DMA Burst Len------*/
typedef enum
{
    DMA_BURST_LEN_1 = 0,			// 1 tranfer in each burst
    DMA_BURST_LEN_2 ,			// 2 tranfers in each burst
    DMA_BURST_LEN_3 ,			// 3 tranfers in each burst
    DMA_BURST_LEN_4 ,			// 4 tranfers in each burst
    DMA_BURST_LEN_5 ,			// 5 tranfers in each burst
    DMA_BURST_LEN_6 ,			// 6 tranfers in each burst
    DMA_BURST_LEN_7 ,			// 7 tranfers in each burst
    DMA_BURST_LEN_8 ,			// 8 tranfers in each burst
    DMA_BURST_LEN_9 ,			// 9 tranfers in each burst
    DMA_BURST_LEN_10,			// 10 tranfers in each burst
    DMA_BURST_LEN_11 ,			// 11 tranfers in each burst
    DMA_BURST_LEN_12 ,			// 12 tranfers in each burst
    DMA_BURST_LEN_13 ,			// 13 tranfers in each burst
    DMA_BURST_LEN_14 ,			// 14 tranfers in each burst
    DMA_BURST_LEN_15 ,			// 15 tranfers in each burst
    DMA_BURST_LEN_16 ,			// 16 tranfers in each burst

    DMA_BURST_LEN_ALL
}dma_burst_len;

typedef enum
{
    DMA_INT_TO_PHY,
    DMA_INT_TO_PS,
    DMA_INT_TO_A9,
    DMA_INT_TO_ZSP,
    
    DMA_INT_SEL_ALL
}dma_int_sel;

typedef enum
{
    CHNNL_DISABLE,
    CHNNL_ENABLE,

    MAX_CHNNL_STATUS
} dma_chan_satus;

typedef enum 
{
    SYS_RST_ACTIVE=0,
    SYS_RST_RELEASE=1
}
sys_reset_state;


/* Attention!!Here  only accept physical SrcAddr and DestAddr.
If your address is from the main memory,Maybe you can
use kmalloc function to get a consistent memory region 
and use dma_map_single to get the velevant physical address
*/
typedef struct
{
    unsigned int 	SrcAddr;				//DMA source address
    unsigned int 	DestAddr;				//DMA Destination address
    unsigned short 	Count;					//Count (Bytes)
    unsigned int  	SrcYPara;				//fixed to be 0
    unsigned int  	SrcZPara;				//fixed to be 0
    unsigned int  	DestYPara;				//fixed to be 0
    unsigned int  	DestZPara;				//fixed to be 0


    unsigned int  LLI;						//if not cyclic mode, LLI must be 0
    struct
    {
        dma_req_mod		BurstReqMod;	    //DMA Request mode
        dma_addr_mod 	SrcMod;		      	//DMA Source address mode
        dma_addr_mod 	DestMod;		 	//DMA Destination address mode
        dma_irq_mod		IrqMod;
        dma_burst_size 	SrcBurstSize;		//DMA burst size
        dma_burst_len	SrcBurstLen;
        dma_burst_size 	DestBurstSize;		//DMA burst size
        dma_burst_len	DestBurstLen;
        dma_int_sel		IntSel;
    }
    CONTROL;

	
void *data;
dma_callback_func CallBack;
}
dma_chan_def;
/*group order define*/
typedef enum
{
    DMA_GROUP_1234_5678 = 0,		
    DMA_GROUP_2341_5678 ,			
    DMA_GROUP_3412_5678 ,			
    DMA_GROUP_4123_5678 ,			
    DMA_GROUP_1234_6785 ,		
    DMA_GROUP_2341_6785 ,			
    DMA_GROUP_3412_6785 ,			
    DMA_GROUP_4123_6785 ,			
    DMA_GROUP_1234_7856 ,		
    DMA_GROUP_2341_7856 ,			
    DMA_GROUP_3412_7856 ,			
    DMA_GROUP_4123_7856 ,			
    DMA_GROUP_1234_8567 ,		
    DMA_GROUP_2341_8567 ,			
    DMA_GROUP_3412_8567 ,			
    DMA_GROUP_4123_8567 ,			
    DMA_GROUP_5678_1234 ,		
    DMA_GROUP_5678_2341 ,			
    DMA_GROUP_5678_3412 ,			
    DMA_GROUP_5678_4123 ,			
    DMA_GROUP_6785_1234 ,		
    DMA_GROUP_6785_2341 ,			
    DMA_GROUP_6785_3412 ,			
    DMA_GROUP_6785_4123 ,			
    DMA_GROUP_7856_1234 ,		
    DMA_GROUP_7856_2341 ,			
    DMA_GROUP_7856_3412 ,			
    DMA_GROUP_7856_4123 ,			
    DMA_GROUP_8567_1234 ,		
    DMA_GROUP_8567_2341 ,			
    DMA_GROUP_8567_3412 ,			
    DMA_GROUP_8567_4123 ,			
    DMA_GROUP_ALL
}
dma_group_order;

/*----DMA Group Arbi Mode------*/
typedef enum
{
    DMA_MODE_RR = 0,			/**/
    DMA_MODE_8PRI,			/**/
    DMA_MODE_4PRI,			/**/
    DMA_MODE_2PRI,			/**/
    DMA_MODE_ALL
}
dma_group_mode;

/*dma channel reg define*/
typedef struct
{
    unsigned int src_addr;     				/**< offset:0x0,   	R/W      		 */
    unsigned int dest_addr;   				/**< offset:0x4,   	R/W      		 */
    unsigned int count;              		/**< offset:0x8,   	R/W      		 */
    unsigned int src_ypara;     			/**< offset:0xc,   	R/W      		 */
    unsigned int src_zpara;    				/**< offset:0x10,  R/W      		 */
    unsigned int dest_ypara;  				/**< offset:0x14,  R/W      		 */
    unsigned int dest_zpara;				/**< offset:0x18,  R/W      		 */
    unsigned int lli;               		/**< offset:0x1c,  	R/W      		 */
    unsigned int control;                               		/**< offset:0x20,  	R/W      	 */
    volatile unsigned int Reserved[7];   	
}
dma_chan_reg;

/*dma device reg module define*/
typedef struct 
{
    dma_chan_reg  channel[DMA_CHAN_NUM*2];
    unsigned int  int_tc_status;         		/**< offset:0x800,   	R       	 */
    unsigned int  int_src_err_status;     		/**< offset:0x804,   	R       	 */
    unsigned int  int_dest_err_status;    		/**< offset:0x808,   	R       	 */
    unsigned int  int_cfg_err_status;     		/**< offset:0x80c,   	R       	 */
    unsigned int  raw_int_tc_status;      		/**< offset:0x810,		R/C      	 */
    unsigned int  raw_int_src_err_status;  		/**< offset:0x814,  	R/C      	 */
    unsigned int  raw_int_dest_err_status; 		/**< offset:0x818,  	R/C      	 */
    unsigned int  raw_int_cfg_err_status;  		/**< offset:0x81c,  	R/C      	 */
    unsigned int  working_status;       		/**< offset:0x820,   	R       	 */
    unsigned int  group_order;          		/**< offset:0x824,  	R/W      	 */
    unsigned int  arbit_mode;           		/**< offset:0x828,  	R/W      	 */
    unsigned int  irq_type;             		/**< offset:0x82c,  	R/W      	 */
}
dma_regs;
/*----DMA channel para  for lli ------*/
typedef struct
{
	/* ͼĴ 	   |ַƫ     | д   |Ĵ */
	volatile unsigned int src_addr;			/**< offset:0x0,	R/W 			ݵԴַĴ */
	volatile unsigned int dest_addr;			/**< offset:0x4,	R/W 			ݵĿַĴ */
	volatile unsigned int count;				/**< offset:0x8,	R/W 			Դ/ĿݵXά: Src X countDest X countĴ */
	volatile unsigned int src_ypara; 			/**< offset:0xc,	R/W 			ԴݵYά: Y countY modifyĴ */
	volatile unsigned int src_zpara;			/**< offset:0x10,  R/W				ԴݵZά: Z countZ modifyĴ */
	volatile unsigned int dest_ypara; 		/**< offset:0x14,  R/W				ĿݵYά: Y countY modifyĴ */
	volatile unsigned int dest_zpara;			/**< offset:0x18 	R				λ*/
	volatile unsigned int lli;				/**< offset:0x1C,  R/W			    ַͨĴ һΪ0*/
	volatile unsigned int control;			/**< offset:0x20,  R/W				ͨƼĴ */
}dma_lli_para;

signed int zx29_dma_request(dma_peripheral_id peripheralID);
signed int	zx29_dma_config(unsigned int channel,dma_chan_def *tChanPar);
signed int zx29_dma_start(unsigned int channel);
signed int zx29_dma_stop(unsigned int channel);

signed int  zx29_dma_set_priority(dmac_id dmaID, dma_group_order groupOrder,  dma_group_mode  groupMode);
signed int  zx29_dma_configLLI(unsigned int channelID,dma_chan_def * channelaPara, unsigned int LLIParaCnt);






















#endif 

