
/*
|| xjy @20150312add for usb
*/
#ifndef _ZX29_USB_H
#define _ZX29_USB_H

//#include <linux/delay.h>

#include "iomap.h"
#include <mach/spinlock.h>

#define reg32(addr)			(*(volatile unsigned long*)(addr))

#define ZX29_POWER_DOMAIN_ISO			(ZX_SOC_SYS_BASE + 0x110)	
#define ZX29_POWER_DOMAIN_RST			(ZX_SOC_SYS_BASE + 0x10C)
#define ZX29_POWER_DOMAIN_POWERON		(ZX_SOC_SYS_BASE + 0x114)
#define ZX29_USB20_MOD_CFG0             (ZX_SOC_SYS_BASE + 0x20)

#define ZX29_SOC_USB_RSTEN  (ZX_TOP_CRM_BASE + 0x80)
#define ZX29_SOC_USB_RESET_STATE  (ZX_TOP_CRM_BASE + 0x84)

#define ZX29_SOC_USB_CLK  (ZX_TOP_CRM_BASE + 0x6c)

typedef  void (*usb_detect_callback)(T_TYPE_USB_DETECT);

typedef enum _T_TYPE_USB_DETECT
{
	TYPE_COMPUTER=0x1,
	TYPE_ADAPTER=0x2,
}T_TYPE_USB_DETECT;

//ص֪ͨcharger עӿ
void dwc_chg_Regcallback(usb_detect_callback	fn);

//charger ֪ͨγӿ
void dwc_otg_chg_inform(int inform);
void dwc_otg_hal_exit_psm(void);
void dwc_otg_hal_init_psm(void);

#if 1
static volatile void mndelay(unsigned int n)
{
	volatile unsigned i = 0, j;
	n= n*63000;
	for(i =0; i< n; i++){
		j = i;
	}
}
#endif

#define USB_ISO_EN_MASK 8
int dwc_otg_open_power_psm(void);
static inline void zx29_usbdev_init(void)
{
	unsigned i = 0;
	unsigned int value;
	
	//printk("Wait some times BEFORE usb power up\n");
	//mndelay(2);
	
	//dwc_otg_open_power_psm();
	
	dwc_otg_hal_exit_psm();
	mndelay(5000);
	dwc_otg_hal_init_psm();
	
	printk("Wait some times AFTER usb power up\n");
	mndelay(500);
	printk("Start USB init\n");


	#if 0
    reg32(ZX29_TOP_VA + 0x600) |= 1<<30;
//add pll config
/*
pll_624_208ӳüĴ
*/
    reg32(ZX29_TOP_VA + 0x2c)  = 1;    //pll_624 lock need delay time
/*
pll_480ӳüĴ
*/
    reg32(ZX29_TOP_VA + 0x108)  = 1;    //pll_480 lock need delay time for HSIC
//open pll_624
    reg32(ZX29_TOP_VA+ 0xc) &= 0xf8ffffff;
    reg32(ZX29_TOP_VA+0x8) &= 0x7fffffff;
    
//  pll lock  
    i = 255;
    while(i--);

    i = 0;
    while((reg32(ZX29_TOP_VA+0x8)&0x40000000) ==0)
    {
        i++;
        dwc_udelay(100);
        if(i>50000) break;
    }

#endif

#if 0
	reg32(ZX29_POWER_DOMAIN_ISO) |= (1<<13);
        dwc_udelay(10);
        reg32(ZX29_POWER_DOMAIN_RST) |= (1<<13);
        dwc_udelay(10);
        reg32(ZX29_POWER_DOMAIN_POWERON) &= ~(1<<13);
        dwc_udelay(10);
        
        reg32(ZX29_POWER_DOMAIN_POWERON) |= (1<<13);
        dwc_udelay(10);
        reg32(ZX29_POWER_DOMAIN_RST) &= ~(1<<13);
        dwc_udelay(10);
    //ͷUSB13bit for usb ctrl
        reg32(ZX29_POWER_DOMAIN_ISO) &= ~(1<<13);
        dwc_udelay(10);


#else
       reg_spin_lock();
	value = ioread32(ZX29_POWER_DOMAIN_ISO);
	value |= (1<<USB_ISO_EN_MASK);
	iowrite32(value,ZX29_POWER_DOMAIN_ISO);
	reg_spin_unlock();
	mndelay(10);

       reg_spin_lock();
	value = ioread32(ZX29_POWER_DOMAIN_RST);
	value |= (1<<USB_ISO_EN_MASK);
	iowrite32(value,ZX29_POWER_DOMAIN_RST);
	reg_spin_unlock();
	mndelay(10);

       reg_spin_lock();
	value = ioread32(ZX29_POWER_DOMAIN_POWERON);
	value   &= ~(1<<USB_ISO_EN_MASK);
	iowrite32(value,ZX29_POWER_DOMAIN_POWERON);
	reg_spin_unlock();
	mndelay(10);

	reg_spin_lock();
	value = ioread32(ZX29_POWER_DOMAIN_POWERON);
	value  |= (1<<USB_ISO_EN_MASK);
	iowrite32(value,ZX29_POWER_DOMAIN_POWERON);
	reg_spin_unlock();
	mndelay(10);

	reg_spin_lock();
	value = ioread32(ZX29_POWER_DOMAIN_RST);
	value  &= ~(1<<USB_ISO_EN_MASK);
	iowrite32(value,ZX29_POWER_DOMAIN_RST);
	reg_spin_unlock();
	mndelay(10);

	reg_spin_lock();
	value = ioread32(ZX29_POWER_DOMAIN_ISO);
	value  &= ~(1<<USB_ISO_EN_MASK);
	iowrite32(value,ZX29_POWER_DOMAIN_ISO);
	reg_spin_unlock();
	mndelay(10);
	
#endif

#if 0
          //usb  ahb clock enable
        reg32(ZX29_SOC_MOD_CLKEN0)&=~(1<<28);
        dwc_udelay(20);
        reg32(ZX29_SOC_MOD_CLKEN0)|=(1<<28);
        //usb  phy clock enable
        reg32(ZX29_SOC_MOD_CLKEN1)&=~(1<<17);
        dwc_udelay(20);
        reg32(ZX29_SOC_MOD_CLKEN1)|=(1<<17);

        // usb  ahb reset  ߺ
        reg32(ZX29_SOC_MOD_RSTEN)&=~(1<<27);
        dwc_udelay(20);
        reg32(ZX29_SOC_MOD_RSTEN)|=(1<<27);
        dwc_udelay(20);

        // usb  work reset
        reg32(ZX29_SOC_MOD_RSTEN)&=~(1<<28);
        dwc_udelay(20);
        reg32(ZX29_SOC_MOD_RSTEN)|=(1<<28);

        //release usb  phy reset 
        reg32(ZX29_SOC_MOD_RSTEN1) &= ~(1<<6);
        dwc_udelay(20);        
        reg32(ZX29_SOC_MOD_RSTEN1) |= 1<<6;

        dwc_udelay(100);
        i = 0;
        while((reg32(ZX29_SOC_MOD_USBSTATECTRL)&0x10) == 0)
        {
             i++;
             dwc_udelay(20);
             if(i>50000) break;

       }
#endif 
}
#endif
