/*
 * linux/arch/arm/mach-zx297510/board-zx297520v2.c
 *
 *  Copyright (C) 2015 ZTE-TSP
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/types.h>
#include <linux/init.h>
#include <linux/mm.h>
#include <linux/clk.h>
#include <linux/err.h>
#include <linux/module.h>
#include <linux/platform_device.h>
#include <linux/spi/spi.h>
#include <linux/mtd/physmap.h>
#include <linux/syscalls.h>

#include <asm/setup.h>
#include <asm/mach-types.h>
#include <asm/irq.h>
#include <asm/uaccess.h>

#include <asm/mach/arch.h>
#include <asm/mach/map.h>
#include <asm/mach/irq.h>
#include <asm/hardware/cache-l2x0.h>

#include <mach/board.h>
#include <mach/gpio.h>
#include <mach/iomap.h>
#include <mach/irqs.h>
#include <mach/debug.h>
#include <mach/spinlock.h>
#include <mach/pcu.h>
#include <linux/gpio.h>

//++
#include <mach/gpio_cfg.h>
//++

#include <linux/delay.h>
#include <linux/dev_info.h>
#include <mach/pwr_ctrl.h>


/* LCM manufacturer ID */
#define LCM_ID_LEAD         0x7C
#define LCM_ID_ST7789V		0x85

extern struct sys_timer zx29_timer;
#if (defined CONFIG_SPI_ZX29) || (defined CONFIG_SPI_GPIO)
extern void __init spi_add_devices(void);
#endif
void zx_write_bits(void __iomem *reg_addr, unsigned char offset, unsigned char width, unsigned long value)
{
	unsigned int temp, mask;

	mask = (1 << width) - 1;
	temp = ioread32(reg_addr);
	temp &= ~(mask << offset);
	temp |= (value << offset);
	iowrite32(temp, reg_addr);
}

int lcd_get_info(struct lcd_info *info)
{
    if(info == NULL)
        return -EINVAL;

#ifdef CONFIG_FB_LEADT15DS26
	sprintf(info->manu, "lead");
    sprintf(info->ic, "T15DDS26");
    sprintf(info->resolution, "128*128");
#else
	sprintf(info->manu, "unknown");
    sprintf(info->ic, "unknown");
    sprintf(info->resolution, "unknown");
#endif

    return 0;
}

int wifi_get_info(struct wifi_info *info)
{
    if(info == NULL)
        return -EINVAL;
	
#ifdef CONFIG_RTL8192CD
	sprintf(info->manu, "RealTek");
    sprintf(info->ic, "RTL81XX");
#else
    sprintf(info->manu, "unknown");
    sprintf(info->ic, "unknown");
#endif

    return 0;
}

extern char g_maf_id;
extern char g_dev_id;
int flash_get_info(struct flash_ddr_info *info)
{
	char manuf = g_maf_id;
	char dev   = g_dev_id;

	if( NULL==info )
		return 1;
	
 	if(manuf == 0x2C) {
		sprintf( info->manu, "MICRON" );
		sprintf( info->model, "MT29F2G08U0B");
	}
	else if((manuf == 0xAD)&&(dev == 0xAC)) {
		sprintf( info->manu, "HYNIX" );
		sprintf( info->model, "H9TA4GG2GDMCPR");
	}
	else if((manuf == 0xAD)&&(dev == 0xAA)) {
		sprintf( info->manu, "JSC" );
		sprintf( info->model, "JSFBAB3YHABB");
	}
	else if(manuf == 0x01) {
		if(dev == 0xAC) {
			sprintf( info->manu, "JSC" );
			sprintf( info->model, "JSFCBB3Y75BBD");
		}
		else if(dev == 0xA1) {
			sprintf( info->manu, "JSC" );
			sprintf( info->model, "JSFAA3Y7ABB");
		}
	}
	else if(manuf == 0xC8) {
		if(dev == 0xAC) {
			sprintf( info->manu, "ESMT" );
			sprintf( info->model, "FM6BD4G2GA");
		}
		else if(dev == 0xAA) {
			sprintf( info->manu, "ESMT" );
			sprintf( info->model, "FM6BD2G1GA");
		}
		else if(dev == 0xC1) {
			sprintf( info->manu, "GD" );
			sprintf( info->model, "GD5F1GQ4R");
		}
		else if(dev == 0x41) {
			sprintf( info->manu, "GD" );
			sprintf( info->model, "GD5F1GQ5R");
		}
		else if(dev == 0xC2) {
			sprintf( info->manu, "GD" );
			sprintf( info->model, "GD5F2GQ4R");
		}
		else if(dev == 0xC4) {
			sprintf( info->manu, "GD" );
			sprintf( info->model, "GD5F4GQ4R");
		}
		else if(dev == 0xE1) {
			sprintf( info->manu, "GD" );
			sprintf( info->model, "GD5F1GQ4R");
		}
		else if(dev == 0xE2) {
			sprintf( info->manu, "GD" );
			sprintf( info->model, "GD5F2GQ4R");
		}
		else if(dev == 0xE4) {
			sprintf( info->manu, "GD" );
			sprintf( info->model, "GD5F4GQ4R");
		}
	}
	else if(manuf == 0xA1) {
		if(dev == 0xC1) {
			sprintf( info->manu, "PAROGON" );
			sprintf( info->model, "PN26Q01A");
		}
		else if(dev == 0xC2) {
			sprintf( info->manu, "PAROGON" );
			sprintf( info->model, "PN26Q02A");
		}
	}
	else if(manuf == 0xEF) {
		if(dev == 0xBA) {
			sprintf( info->manu, "WINBOND" );
			sprintf( info->model, "W25N01G");
		}
		else if(dev == 0xBB) {
			sprintf( info->manu, "WINBOND" );
			sprintf( info->model, "W25N02G");
		}
	}
	else if (manuf == 0x98) {
		if(dev == 0xB2) {
			sprintf( info->manu, "TOSHIBA" );
			sprintf( info->model, "TC58CYG0S3HRAIG");
		}
		else if(dev == 0xBB) {
			sprintf( info->manu, "TOSHIBA" );
			sprintf( info->model, "TC58CYG1S3HRAIG");
		}
	}
	else {
		sprintf( info->manu, "unknown" );
		sprintf( info->model, "unknown");
	}	

	if(dev == 0xAA||dev==0xC2||dev==0xE2||dev==0xBB)
		sprintf( info->size, "256MiB" );
	else if(dev == 0xAC||dev==0xC4||dev==0xE4)
		sprintf( info->size, "512MiB" );
	else if(dev == 0xA1||dev==0xC1||dev==0xE1||dev==0xBA)
		sprintf( info->size, "128MiB" );
	else
		sprintf( info->size, "unknown" );

	return 0;
}  

unsigned long ddr_freq_get(void)
{
	unsigned long rdata =readl(ZX_MATRIX_CRM_BASE + 0x50) & 0x3;
	unsigned long ddrfreq=0;
		
	switch(rdata)
	{
		case 0:
		{
			ddrfreq =312000000;
			break;
		}	
		 case 1:
	        {
			ddrfreq =400000000;
			break;
	        }
		 case 2:
	        {
			ddrfreq =208000000;
			break;
	        }		 
		default:
		{
			ddrfreq =156000000;	
			break;
		}
	}
	
	return ddrfreq;
}
	
unsigned long ddr_read_mr(unsigned long mr)
{
	unsigned long rdata;
	unsigned long rautoen;
	unsigned long raxigateen;

	rautoen=readl(ZX_DDR_CTRL_BASE + 0x030);
	raxigateen=readl(ZX_MATRIX_CRM_BASE + 0x100);
	
	zx_write_bits(ZX_MATRIX_CRM_BASE + 0x100,0,4,0);
	zx_write_bits(ZX_DDR_CTRL_BASE     + 0x030,0,2,0);
	rdata = readl(ZX_SOC_SYS_BASE + 0x40) >> 16;/*bit16 valid*/

	writel( (mr << 8),ZX_DDR_CTRL_BASE + 0x14);
	writel( ((1 << 31) | (1 << 4) | 1),ZX_DDR_CTRL_BASE + 0x10);

	while((readl(ZX_SOC_SYS_BASE + 0x40) >> 16) == rdata);

	rdata = readl(ZX_SOC_SYS_BASE + 0x40) & 0xff;

	writel( rautoen,ZX_DDR_CTRL_BASE + 0x030);
	writel( raxigateen,ZX_MATRIX_CRM_BASE + 0x100);	

	return rdata;
}

int ddr_get_info(struct flash_ddr_info *info)
{
	unsigned long ddr_id;
	unsigned long ddr_freq;

	if( NULL==info )
		return 1;

	ddr_id = ddr_read_mr(5);	/*read mr5*/
	ddr_freq= ddr_freq_get();	
	
	if(ddr_id == 0x05) {
		sprintf( info->manu, "NANYA" );/**/
		sprintf( info->size, "256MiB" );
		sprintf( info->model, "LPDDR2" );
		sprintf( info->freq, "%dHz", ddr_freq );	
	}
	else if (ddr_id == 0xf8) {
		sprintf( info->manu, "DOSILICON" );/*о*/
		sprintf( info->size, "256MiB" );
		sprintf( info->model, "LPDDR2" );
		sprintf( info->freq, "%dHz", ddr_freq );
	}
	else {
		sprintf( info->manu, "unknown" );
		sprintf( info->size, "unknown" );
		sprintf( info->model, "unknown" );
		sprintf( info->freq, "unknown" );	
	}
	return 0;
}


int cpu_get_info(struct cpu_info *info)
{
	if( NULL==info )
		return 1;

	sprintf(info->manu, "SANECHIPS");
	sprintf(info->model, "ZX297520V3");
	
	return 0;
}
SYSCALL_DEFINE3(get_lcdinfo, char __user *, manu, char __user *, ic, char __user *, resolution)
{
	int err = 0;
	struct lcd_info 		lcd;

	err = lcd_get_info(&lcd);

	if(err)
		return -EINVAL;

	if (manu)
		err |= copy_to_user(manu, &lcd.manu, sizeof(lcd.manu));
	if (ic)
		err |= copy_to_user(ic, &lcd.ic, sizeof(lcd.ic));
	if (resolution)
		err |= copy_to_user(resolution, &lcd.resolution, sizeof(lcd.resolution));
	
	return err ? -EFAULT : 0;

}
SYSCALL_DEFINE2(get_wifiinfo, char __user *, manu, char __user *, ic)
{
	int err = 0;
	struct wifi_info 		wifi;

	err = wifi_get_info(&wifi);

	if(err)
		return -EINVAL;

	if (manu)
		err |= copy_to_user(manu, &wifi.manu, sizeof(wifi.manu));
	if (ic)
		err |= copy_to_user(ic, &wifi.ic, sizeof(wifi.ic));
	
	return err ? -EFAULT : 0;

}
SYSCALL_DEFINE3(get_flashinfo, char __user *, manu, char __user *, model, char __user *, sizes)
{
	int err = 0;
	struct flash_ddr_info 		flash;

	err = flash_get_info(&flash);

	if(err)
		return -EINVAL;

	if (manu)
		err |= copy_to_user(manu, &flash.manu, sizeof(flash.manu));
	if (model)
		err |= copy_to_user(model, &flash.model, sizeof(flash.model));
	if (sizes)
		err |= copy_to_user(sizes, &flash.size, sizeof(flash.size));
	
	return err ? -EFAULT : 0;

}
SYSCALL_DEFINE4(get_ddrinfo, char __user *, manu, char __user *, model, char __user *, sizes, char __user *, freq)
{
	int err = 0;
	struct flash_ddr_info 		ddr;

	err = ddr_get_info(&ddr);

	if(err)
		return -EINVAL;

	if (manu)
		err |= copy_to_user(manu, &ddr.manu, sizeof(ddr.manu));
	if (model)
		err |= copy_to_user(model, &ddr.model, sizeof(ddr.model));
	if (sizes)
		err |= copy_to_user(sizes, &ddr.size, sizeof(ddr.size));
	if (freq)
		err |= copy_to_user(freq, &ddr.freq, sizeof(ddr.freq));	
	
	return err ? -EFAULT : 0;

}
SYSCALL_DEFINE2(get_cpuinfo, char __user *, manu, char __user *, model)
{
	int err = 0;
	struct cpu_info 		cpu;

	err = cpu_get_info(&cpu);

	if(err)
		return -EINVAL;

	if (manu)
		err |= copy_to_user(manu, &cpu.manu, sizeof(cpu.manu));
	if (model)
		err |= copy_to_user(model, &cpu.model, sizeof(cpu.model));

	return err ? -EFAULT : 0;
}
unsigned char cid_reserved = 0;
SYSCALL_DEFINE1(set_cidstate, unsigned char, cid)
{
	cid_reserved = cid;
	return 0;
}
extern int zAti_CidIsUsed(unsigned char bCid);
SYSCALL_DEFINE1(get_cidstate, unsigned char, cid)
{
#ifndef CONFIG_SYSTEM_RECOVERY
#ifndef CONFIG_SYSTEM_CAP
#ifndef _USE_TestHarness
#ifdef USE_CPPS_KO
	if(cpps_callbacks.zAti_CidIsUsed(cid))
#else
	if(zAti_CidIsUsed(cid))
#endif
		return 1;
	if((cid_reserved & (1<<(cid-1))) && cid_reserved != 255)//15ʾƷ̬cidԤⲿҲ붯̬
		return 1;
#endif
#endif
#endif		
	return 0;
}
int get_cid_state(unsigned char cid)
{
	return sys_get_cidstate(cid);
}
EXPORT_SYMBOL(get_cid_state);
typedef void (*set_pdp_state_CB)(unsigned char cid, unsigned int state);
typedef int (*get_ipv6_prefix_CB)(unsigned char cid, int len, unsigned char *prefix, unsigned char *prefix_len);
set_pdp_state_CB g_psnet_set_RA_state = NULL;
get_ipv6_prefix_CB g_psnet_get_prefix = NULL;
SYSCALL_DEFINE2(set_pdp_state, unsigned char, cid, unsigned int, state)
{
	if(g_psnet_set_RA_state != NULL){
		g_psnet_set_RA_state(cid, state);
	}
	return 0;
}

SYSCALL_DEFINE2(get_ipv6_prefix, unsigned char, cid, char __user *, prefix)
{
	if(g_psnet_get_prefix != NULL){
		int ret = 0;
		unsigned char prefix_str[64] = {0};
		unsigned char prefix_len = 0;
		ret = g_psnet_get_prefix(cid, sizeof(prefix_str), prefix_str, &prefix_len);
		if(ret > 0 && prefix_len > 0 && copy_to_user(prefix, prefix_str, ret) == 0)
			return prefix_len;
	}
	return 0;
}

#define  VSIM_MAX_MSG_LEN	1024
typedef struct {
    unsigned short usMsgCmd;               /* Ϣ */  
    unsigned short usDataLen;                /* Ϣȣͷ */  
    unsigned char aucDataBuf[VSIM_MAX_MSG_LEN];  /* Ϣ */  
} VSIM_MSG_BUF;
typedef int (*vsim_async_CB)(unsigned char *msg);
typedef int (*vsim_sync_CB)(unsigned char *in_msg, unsigned char *out_msg);
vsim_async_CB g_vsim_read = NULL;
vsim_async_CB g_vsim_write = NULL;
vsim_sync_CB g_vsim_proc = NULL;
SYSCALL_DEFINE1(vsim_read, char __user *, buf)
{
	VSIM_MSG_BUF msg = {0};
	if(g_vsim_read != NULL){
		if(g_vsim_read(&msg)){
			if(copy_to_user(buf, &msg, sizeof(msg)) == 0)
				return 1;
		}
	}
	printk("vsim_read fnc=0x%p failed\n",g_vsim_read);
	return 0;
}
SYSCALL_DEFINE1(vsim_write, char __user *, buf)
{
	VSIM_MSG_BUF msg = {0};
	if(g_vsim_write != NULL){
		if(copy_from_user(&msg, buf, sizeof(msg)) == 0){
			return g_vsim_write(&msg);
		}
	}
	printk("vsim_write fnc=0x%p failed\n",g_vsim_write);
	return 0;
}
SYSCALL_DEFINE2(vsim_proc, char __user *, inbuf, char __user *, outbuf)
{
	VSIM_MSG_BUF msg_in = {0};
	VSIM_MSG_BUF msg_out = {0};
	if(g_vsim_proc != NULL){
		if(copy_from_user(&msg_in, inbuf, sizeof(msg_in)) == 0){
			if(g_vsim_proc(&msg_in, &msg_out)){
				if(copy_to_user(outbuf, &msg_out, sizeof(msg_out)) == 0)
					return 1;
			}
		}
	}
	printk("vsim_proc fnc=0x%p failed\n",g_vsim_proc);
	return 0;
}

typedef int (*set_xlat_CB)(unsigned char *ip_info, unsigned char *dev_name);
set_xlat_CB g_set_xlat_cb = NULL;
SYSCALL_DEFINE2(set_xlat, char __user *, ip_info, char __user *, dev_name)
{
	unsigned char info[40] = {0};
	unsigned char dev[16] = {0};
	if(g_set_xlat_cb != NULL){
		if(copy_from_user(&info, ip_info, sizeof(info)) == 0 
			&& copy_from_user(&dev, dev_name, sizeof(dev)) == 0 ){
			return g_set_xlat_cb(&info, &dev);
		}
	}
	return 0;
}

#if 0
SYSCALL_DEFINE5(get_devinfo, struct lcd_info __user *, lcd_dev, 
						struct wifi_info __user *, wifi_dev, 
						struct flash_ddr_info __user *, flash_dev, 
						struct flash_ddr_info __user *, ddr_dev, 
						struct cpu_info __user *, cpu_dev)
{
	int err = 0;
	struct lcd_info 		lcd;
	struct wifi_info 		wifi;
	struct flash_ddr_info 	flash;
	struct flash_ddr_info 	ddr;
	struct cpu_info 		cpu;

	err = lcd_get_info(&lcd);
	err += wifi_get_info(&wifi);
	err += flash_get_info(&flash);
	err += ddr_get_info(&ddr);
	err += cpu_get_info(&cpu);

	if(err)
		return -EINVAL;

	if (lcd_dev)
		err |= copy_to_user(lcd_dev, lcd, sizeof(struct lcd_info));
	if (wifi_dev)
		err |= copy_to_user(wifi_dev, wifi, sizeof(struct wifi_info));
	if (flash_dev)
		err |= copy_to_user(flash_dev, flash, sizeof(struct flash_ddr_info));
	if (ddr_dev)
		err |= copy_to_user(ddr_dev, ddr, sizeof(struct flash_ddr_info));
	if (cpu_dev)
		err |= copy_to_user(cpu_dev, cpu, sizeof(struct cpu_info));
	
	return err ? -EFAULT : 0;

}
#endif

/*
 *do someting you like to do early
 *it is invoked between mmu initialize finish and irq initialize start
 */
static void __init board_init_early(void)
{
	softspinlock_init();

	zx29_clock_init();

	pcu_init();
}

/*
 *initiate board based on zx297520v2
 */
static void __init board_init(void)
{
#ifdef CONFIG_CACHE_L2X0
	/* set RAM latencies */
	/* 0-1cycle 1-2cycles ...
	 * bit10..8  : write
	 * bit6..4   : read
	 * bit2..0   : setup
	 */
	//iowrite32(0x111, ZX_L2CACHE_CONFIG_BASE + L2X0_TAG_LATENCY_CTRL);
	//iowrite32(0x911, ZX_L2CACHE_CONFIG_BASE + L2X0_DATA_LATENCY_CTRL);

	/**  bit16  	: 0-8way  1-16way
	  *  bit19..17  : 1-16KB  2-32KB ...
	  *  bit21      : 1-enable parity(ż)
	  *  bit22      : 1-ignore internal shared attribute
	  *  bit25      : ?
	  *  bit28		: 1-data prefetch
	  *  bit29		: 1-instruction prefetch
	  *  bit30		: 1-enable early BRESP(write response)
	  *
	  */
	l2x0_init(ZX_L2CACHE_CONFIG_BASE, 0x72320000, 0x800f0fff);
#endif
#if defined (CONFIG_RDAWFMAC) ||defined (CONFIG_RDAWFMAC_MODULE)
	extern void rda_wifi_enable(int bval);
	extern int rda_wifi_init(void);
	extern void rda_wifi_deinit(void);
	int ret;
    ret = rda_wifi_init();
	if(ret < 0)
	{
        printk("%s,rda_wifi_init failed\n",__func__);        
    }
	else
	{
		rda_wifi_enable(0);
		rda_wifi_deinit();
		//mdelay(200);
		//rda_wifi_enable(1);
		//mdelay(200);
	}
#endif
#if defined (CONFIG_ESP8089) ||defined (CONFIG_ESP8089_MODULE)
	extern void esp_wifi_enable(int bval);
	extern int esp_wifi_init(void);
	extern void esp_wifi_deinit(void);
	int ret;
    ret = esp_wifi_init();
	if(ret < 0)
	{
        printk("%s,rda_wifi_init failed\n",__func__);        
    }
	else
	{
		esp_wifi_enable(0);
		esp_wifi_deinit();
		//mdelay(200);
		//rda_wifi_enable(1);
		//mdelay(200);
	}
#endif

#if( (defined CONFIG_SLIC_TW) || (defined CONFIG_SLIC))
	pwr_buck3v3_on(POWER_SLIC);
	printk("buck3v3 on, slic power up.\n");

#endif

#if  (defined CONFIG_RTL8192CD) || (defined CONFIG_NET_ZX29_GMAC)
	pwr_buck3v3_on(POWER_WIFI);
	printk("buck3v3 on, wifi power up.\n");
#endif
	//youchen@2024-06-20 add for lynq nv config begin
	modify_zx29_device_table();
	//youchen@2024-06-20 add for lynq nv config end
	platform_add_devices(zx29_device_table, zx29_device_table_num);

#if (defined CONFIG_SPI_ZX29) || (defined CONFIG_SPI_GPIO)
	spi_add_devices();
#endif
    i2c_add_devices();
#if  (defined CONFIG_RTL8192CD) || (defined CONFIG_SSV6X5X)
    //int RTL_8192CHIP_ENABLE = 71;
    int ret;
    ret = gpio_request(PIN_WIFI_CHIP_ENABLE, "wifi_chip_enable");
    if(ret<0)
    {
        printk("request wifi enable gpio failed\n");
        gpio_free(PIN_WIFI_CHIP_ENABLE);
    }
    else
    {
        //zx29_gpio_config(RTL_8192CHIP_ENABLE, GPIO71_GPIO71);
        zx29_gpio_config(PIN_WIFI_CHIP_ENABLE, PIN_WIFI_CHIP_ENABLE_SEL);
#ifdef CONFIG_MIFI_WIFI
	   gpio_direction_output(PIN_WIFI_CHIP_ENABLE, 0);
	   printk("wifi enable gpio success low%d\n",PIN_WIFI_CHIP_ENABLE);
#else
		gpio_direction_output(PIN_WIFI_CHIP_ENABLE, 1);
		printk("wifi enable gpio success high%d\n",PIN_WIFI_CHIP_ENABLE);
#endif
    }
#endif

#ifdef CONFIG_IP175L_PHY
    int val;
    val = gpio_request(ZX29_GPIO_124, "switch_lan_enable");
    if(val < 0)
    {
        printk("request switch lan enable gpio failed\n");
        gpio_free(ZX29_GPIO_124);
    }
    else
    {
        zx29_gpio_config(ZX29_GPIO_124, GPIO124_GPIO124);
		gpio_direction_output(ZX29_GPIO_124, 1);
    }
#endif
}

MACHINE_START(ZX297520V3, "TSP ZX297520V3")
	.atag_offset  	= 0x100,
#if NEW_LINUX_FRAME
	.init_time	  	= zx29_timer_init,
#else
	.timer		  	= &zx29_timer,
#endif
	.map_io		  	= zx29_map_io,
	.init_early	  	= board_init_early,
	.init_irq  	  	= zx29_init_irq,
	.init_machine 	= board_init,
	.restart 		= zx29_restart,
MACHINE_END
