/*
 * arch/arm/mach-zx297520v2/include/mach/spinlock.h
 *
 *  Copyright (C) 2015 ZTE-TSP
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef _SPINLOCK_H
#define _SPINLOCK_H


/****************************************************************************
* 	                                        Include files
****************************************************************************/

/****************************************************************************
* 	                                        Macros
****************************************************************************/

/****************************************************************************
* 	                                        Types
****************************************************************************/

#define SHARED_DEVICE_REG1          (ZX_MATRIX_CRM_BASE + 0x170)
#define SHARED_DEVICE_REG2          (ZX_MATRIX_CRM_BASE + 0x174)
#define SHARED_DEVICE_REG3          (ZX_MATRIX_CRM_BASE + 0x178)
#define SHARED_DEVICE_REG4          (ZX_MATRIX_CRM_BASE + 0x17C)
#define SHARED_DEVICE_REG5          (ZX_MATRIX_CRM_BASE + 0x180)
#define SHARED_DEVICE_REG6          (ZX_MATRIX_CRM_BASE + 0x184)
#define SHARED_DEVICE_REG7          (ZX_MATRIX_CRM_BASE + 0x188)
#define SHARED_DEVICE_REG8          (ZX_MATRIX_CRM_BASE + 0x18C)

#define SPINLOCK_IOC_MAGIC     'S'

/*ioctl cmd usd by device*/
#define SPINLOCK_GET_STATUS       _IOWR(SPINLOCK_IOC_MAGIC, 1, char *)



typedef enum
{
	CORE_ID_PS=210,
	CORE_ID_PHY=211,
	CORE_ID_ZSP=212,
	CORE_ID_M0=213,
	CORE_ID_AP=214,
	CORE_ID_NUM = 215
} zte_coreid;
/* ʶӲ*/
typedef enum
{
	PCU_HWLOCK  = 0,/*PCU*/
	CLK_HWLOCK  = 1,/*Clock*/
	REGLOCK_HWLOCK,
	SOFTLOCK_HWLOCK,
	HWLOCK_NUM
} emhw_lock_id;

/* ʶ*/
typedef enum
{
	I2C0_SFLOCK = 0,/*i2c0*/
	I2C1_SFLOCK = 1,/*i2c1*/
	I2C2_SFLOCK = 2,/*pmic-i2c*/
	NAND_SFLOCK = 3,/*NAND*/
	SD0_SFLOCK, /*for sd0*/
	SD1_SFLOCK, /*for sd1*/
	ADC_SFLOCK, /*for adc*/
	UART_SFLOCK,
	PMIC_SFLOCK,
#ifdef CONFIG_SYSVIPC_CROSS_SHM
	SHM_SFLOCK, 
#else
	SFLOCK_ID9,
#endif
	EFUSE_SFLOCK,
	SFLOCK_ID11,
	SFLOCK_ID12,
	SFLOCK_ID13,
	SFLOCK_ID14,
	SFLOCK_ID15,
	SFLOCK_ID16,
	SFLOCK_ID17,
	SFLOCK_ID18,
	SFLOCK_ID19,
	SFLOCK_ID20,
	SFLOCK_ID21,
	SFLOCK_ID22,
	SFLOCK_ID23,
	SFLOCK_ID24,
	SFLOCK_ID25,
	SFLOCK_ID26,
	SFLOCK_ID27,
	SFLOCK_ID28,
	SFLOCK_ID29,
	SFLOCK_ID30,
	REG_SFLOCK = 31,/*REG*/
	SFLOCK_NUM
} emsf_lock_id;
/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/

/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/
/*******************************************************************************
 * Function: hw_spin_lock
 * Description:ȡӲid 0~2
 *			id 3ʹãⲿá
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 void  hw_spin_lock(emhw_lock_id hwid);
/*******************************************************************************
 * Function: hw_spin_unlock
 * Description:ͷӲid 0~2
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 void  hw_spin_unlock(emhw_lock_id hwid);
/*******************************************************************************
 * Function: soft_spin_lock
 * Description:ӿ
 * Parameters:
 *   Input:	sfid: id
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
  void  soft_spin_lock(emsf_lock_id sfid);
/*******************************************************************************
 * Function: soft_spin_unlock
 * Description:soft_spin_lockӦͷӿڡ
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 void  soft_spin_unlock(emsf_lock_id sfid);

/*******************************************************************************
 * Function: soft_spin_lock_psm
 * Description:ӿ
 * Parameters:
 *   Input:	sfid: id
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
  void  soft_spin_lock_psm(emsf_lock_id sfid);
  void  soft_spin_lock_nand_psm(emsf_lock_id sfid);

/*******************************************************************************
 * Function: soft_spin_unlock_psm
 * Description:soft_spin_lock_psmӦͷӿڡ
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 void  soft_spin_unlock_psm(emsf_lock_id sfid);

/*******************************************************************************
 * Function: softspinlock_init
 * Description:ʼ
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 int softspinlock_init(void);

/*******************************************************************************
 * Function: reg_spin_lock
 * Description:ӿ
 * Parameters:
 *   Input:	sfid: id
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
  void  reg_spin_lock(void);
/*******************************************************************************
 * Function:reg_spin_unlock
 * Description:reg_spin_lockӦͷӿڡ
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 void  reg_spin_unlock(void);
#ifdef _USE_VEHICLE_DC
int  soft_spin_lock_printf(emsf_lock_id sfid);
#endif
#endif/*_SYS_H*/

