/*
 * linux/arch/arm/mach-zx297510/board-zx297510.c
 *
 *  Copyright (C) 2013 ZTE-TSP
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/types.h>
#include <linux/init.h>
#include <linux/mm.h>
#include <linux/clk.h>
#include <linux/err.h>
#include <linux/module.h>
#include <linux/platform_device.h>
#include <linux/spi/spi.h>
#include <linux/mtd/physmap.h>

#include <asm/setup.h>
#include <asm/mach-types.h>
#include <asm/irq.h>

#include <asm/mach/arch.h>
#include <asm/mach/map.h>
#include <asm/mach/irq.h>
#include <asm/hardware/gic.h>
#include <asm/hardware/cache-l2x0.h>

#include <mach/board.h>
#include <mach/gpio.h>
#include <mach/clock.h>
#include <mach/iomap.h>
#include <mach/irqs.h>
#include <mach/debug.h>
#include <mach/spinlock.h>

#include <linux/delay.h>
extern struct sys_timer zx297510_timer;

/*
 *do someting you like to do early 
 *it is invoked between mmu initialize finish and irq initialize start
 */
static void __init evb_init_early(void)
{
	struct clk *pclk;
	int ret;
	
	softspinlock_init();
	
	zx297510_clock_init(periph_clocks_lookups, periph_clocks_lookups_num);

	/*config lsp apb clock   ahb:lsp_apb=2:1 */
	pclk = clk_get(NULL,"lsp_apb_clk");
	if (IS_ERR(pclk))
		ZDRV_ASSERT(0);
	
	ret = clk_set_rate(pclk,39000000);           
	if (ret)
		ZDRV_ASSERT(0);
}

/*
 * static io map 
 * in order to save page space, we set map_desc item with large address space, 
 * such as: module group, bus space and so on.
 */
static struct map_desc zx297510_io_desc[] __initdata = { 
	{
		.virtual	= (unsigned long)A9_PERIPHERAL_VA,
		.pfn		= __phys_to_pfn(A9_PERIPHERAL_BASE),
		.length	    = A9_PERIPHERAL_SIZE,
		.type		= MT_DEVICE,
	},
	{
		.virtual	= (unsigned long)L2CACHE_CONFIG_VA,
		.pfn		= __phys_to_pfn(L2CACHE_CONFIG_BASE),
		.length     = L2CACHE_CONFIG_SIZE,
		.type		= MT_DEVICE,
	},
	{
		.virtual	= (unsigned long)ZX29_A1_VA,
		.pfn		= __phys_to_pfn(ZX297510_A1_BASE),
		.length     = ZX297510_A1_SIZE,
		.type		= MT_DEVICE,
	},
	{
		.virtual	= (unsigned long)ZX29_A2AHB_VA,
		.pfn		= __phys_to_pfn(ZX297510_A2AHB_BASE),
		.length	    = ZX297510_A2AHB_SIZE,
		.type		= MT_DEVICE,
	},
	{
		.virtual	= (unsigned long)ZX29_A2APB_VA,
		.pfn		= __phys_to_pfn(ZX297510_A2APB_BASE),
		.length	    = ZX297510_A2APB_SIZE,
		.type		= MT_DEVICE,
	},
	{
		.virtual	= (unsigned long)ZX29_A2LSP_VA,
		.pfn		= __phys_to_pfn(ZX297510_A2LSP_BASE),
		.length	    = ZX297510_A2LSP_SIZE,
		.type		= MT_DEVICE,
	},
	{
		.virtual	= (unsigned long)ZX29_IRAM02_VA,
		.pfn		= __phys_to_pfn(ZX297510_SRAM02_BASE),
		.length	    = ZX297510_SRAM02_SIZE,
		.type		= MT_DEVICE,
	},
	{
		.virtual	= (unsigned long)ZX29_IRAM6_VA,
		.pfn		= __phys_to_pfn(ZX297510_SRAM6_BASE),
		.length	    = ZX297510_SRAM6_SIZE,
		.type		= MT_MEMORY,
	},
};

void __init zx297510_map_io(void)
{
	/* Map peripherals */
	iotable_init(zx297510_io_desc, ARRAY_SIZE(zx297510_io_desc));
}



  


/*
 *initiate board based on zx297510  
 */
static void __init board_init(void)
{
#ifdef CONFIG_CACHE_L2X0
	/* set RAM latencies to 1 cycle */
	/*iowrite32(0, l2x0_base + L2X0_TAG_LATENCY_CTRL);
	iowrite32(0, l2x0_base + L2X0_DATA_LATENCY_CTRL);*/

	/* 16KB way size, 16-way associativity,
	 *evmon/share disable,parity enabled. 
	 * Bits:  .... ...0 0110 0011 0000 .... .... .... */
	l2x0_init(L2CACHE_CONFIG_VA, 0x00630000, 0xfe000fff);
#endif

	platform_add_devices(zx297510_platform_devices, zx297510_platform_devices_num);
    spi_add_devices();
//	i2c_add_devices();			/* dj	*/
	zx297510_regulator_init();
}

MACHINE_START(ZX297510, "ZTE-TSP ZX297510EVB")
	/* Maintainer: xuzhiguo/ZTE-TSP */
	.atag_offset  =0x100, 
	.timer		  = &zx297510_timer,
	.map_io		  = zx297510_map_io,
	.init_early	  = evb_init_early,
	.init_irq  	  = zx297510_init_irq,
	.handle_irq	  = gic_handle_irq,
	.init_machine = board_init,
	.restart = zx297510_restart,
MACHINE_END
