/*
 *  zx-pm.h - power management interface.
 *
 *  Written by zxp.
 *
 */

#ifndef _ZX_PM_H
#define _ZX_PM_H

#include <linux/io.h>
#include <linux/irq.h>
#include <linux/cpuidle.h>

#include <mach/iomap.h>

#include <mach/pcu.h>
#include <mach/zx297510-pm.h>
#include <mach/zx-sleep.h>
#include <mach/zx-pm-context.h>
#include <mach/zx-pm-helpers.h>
#include <mach/zx-cpuidle.h>
#include <mach/zx-cpufreq.h>

#ifdef CONFIG_ZX_PM_DEBUG

#define zte_pm_attr(_name) \
static struct kobj_attribute _name##_attr = 	\
{                           \
	.attr	= 				\
	{                       \
		.name = __stringify(_name),	\
		.mode = 0644,			\
	},					\
	.show	= _name##_show,			\
	.store	= _name##_store,		\
}

/* /sys/zte_pm */
extern struct kobject *pm_debug_kobj;
#endif

#endif /*_ZX_PM_H*/
