/*
 * arch/arm/mach-zx297520v2/zx297520v2_devices.c
 *
 *  Copyright (C) 2015 ZTE-TSP
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 */
#include <asm/mach/arch.h>
#include <asm/mach/map.h>

#include <linux/dma-mapping.h>
#include <linux/platform_device.h>
#include <linux/soc/zte/rpm/rpmsg.h>
#include <linux/i2c.h>

#include <mach/board.h>
#include <mach/iomap.h>
#include <mach/irqs.h>
#include <mach/i2c.h>
#include <mach/gpio.h>
#include <mach/zx29_mmc.h>
#include <mach/zx29_uart_def.h>

#ifdef CONFIG_SPI_ZX29
#include <linux/spi/spi.h>
#include <mach/spi.h>
#endif

#ifdef CONFIG_CHARGER_ZX234502
#include <linux/power/zx234502_charger.h>
#endif
#ifdef CONFIG_LEDS_GPIO
#include <linux/leds.h>
#endif
#ifdef CONFIG_MMC_ZX29
#include <linux/mmc/host.h>
#endif
#ifdef CONFIG_KEYBOARD_ZX_INT
#include <linux/input.h>
#include <linux/gpio_keys.h>
#endif
#ifdef CONFIG_KEYBOARD_ZX_4x4
#include <linux/input.h>
#include <linux/input/zx297520v2_keypad_4x4.h>
#endif

#ifdef CONFIG_MFD_ZX234290_I2C
#include <linux/mfd/zx234290.h>
#endif


struct zx297520v2_uart_platdata  zx297520v2_evb_platdata =
 	{
		.uart0ctsrts = 0,
		.uart0autobaud = 0,
		.uart2autobaud = 0,
};
/* --------------------------------------------------------------------
 *  UART
 * -------------------------------------------------------------------- */
#ifdef CONFIG_SERIAL_ZX29_UART
/* UART0*/
static struct resource uart0_resources[] = {
	[0] = {
		.start	= ZX29_UART0_PHYS,
		.end	= ZX29_UART0_PHYS + SZ_4K - 1,
		.flags	= IORESOURCE_MEM,
	},
	[1] = {
		.start	= UART0_MIX_INT,
		.end	= UART0_MIX_INT,
		.flags	= IORESOURCE_IRQ,
	},
};

static struct platform_device zx297520v2_uart0_device = {
	.name		= "zx29_uart",
	.id		= 0,
	.resource	= uart0_resources,
	.num_resources	= ARRAY_SIZE(uart0_resources),
	.dev = {
		.platform_data = &zx297520v2_evb_platdata,
	}
};
/* UART2*/
static struct resource uart2_resources[] = {
	[0] = {
		.start	= ZX29_UART2_PHYS,
		.end	= ZX29_UART2_PHYS + SZ_4K - 1,
		.flags	= IORESOURCE_MEM,
	},
	[1] = {
		.start	= UART2_MIX_INT,
		.end	= UART2_MIX_INT,
		.flags	= IORESOURCE_IRQ,
	},
};

static struct platform_device zx297520v2_uart2_device = {
	.name		= "zx29_uart",
	.id		= 2,
	.resource	= uart2_resources,
	.num_resources	= ARRAY_SIZE(uart2_resources),
	.dev = {
		.platform_data = &zx297520v2_evb_platdata,
	}
};
#endif

/* --------------------------------------------------------------------
 *	DMA -- Direct Memory Access
* -------------------------------------------------------------------- */
#ifdef CONFIG_ZX29_DMA
static struct resource dma_res[] = {
	[0] = {
		.start	= (u32)ZX_DMA_PS_BASE,
		.end	= (u32)ZX_DMA_PS_BASE + SZ_4K - 1,
		.flags  = IORESOURCE_MEM,
	},
	[1] = {
		.start = PS_DMA_INT,
		.end   = PS_DMA_INT,
		.flags = IORESOURCE_IRQ,
	},
};
static struct platform_device zx297520v2_dma_device = {
	.name = "zx29_dma",
	.id = 0,
	.resource = dma_res,
	.num_resources	= ARRAY_SIZE(dma_res),
};
#endif

/* --------------------------------------------------------------------
 *  MMC / SD
 * -------------------------------------------------------------------- */
#ifdef CONFIG_MMC_ZX29
static struct resource sdmmc0_resources[] = {
	[0] = {
		.start	= ZX_SD0_BASE,
		.end	= ZX_SD0_BASE + SZ_4K - 1,
		.flags	= IORESOURCE_MEM,
	},
	[1] = {
		.start	= SD0_INT,
		.end	= SD0_INT,
		.flags	= IORESOURCE_IRQ,
	},
};

struct dw_mci_board zx297520_sdmmc0_platdata = {
	.num_slots	= 1,
#ifdef CONFIG_RTL8192CD
	.quirks = DW_MCI_QUIRK_BROKEN_CARD_DETECTION | DW_MCI_QUIRK_SDIO \
	| DW_MCI_QUIRK_UNALIGN_DMA_SZ | DW_MCI_QUIRK_UNALIGN_DMA_START,
	.caps	= (MMC_CAP_4_BIT_DATA | MMC_CAP_MMC_HIGHSPEED | MMC_CAP_SD_HIGHSPEED |MMC_CAP_UHS_SDR50 | MMC_CAP_SDIO_IRQ |MMC_CAP_NONREMOVABLE),
#else
	.quirks = DW_MCI_QUIRK_BROKEN_CARD_DETECTION | DW_MCI_QUIRK_SDIO,
	.caps	= (MMC_CAP_4_BIT_DATA | MMC_CAP_MMC_HIGHSPEED | MMC_CAP_SD_HIGHSPEED |MMC_CAP_UHS_SDR50),
#endif
#ifdef CONFIG_MIFI_WIFI
	.bus_hz = 52000000,
#else
	.bus_hz = 100000000,
#endif
	.pm_caps = MMC_PM_KEEP_POWER | MMC_PM_IGNORE_PM_NOTIFY,//	tmp disable for sdio
};
static struct platform_device zx297520_sdmmc0_device = {
	.name		= "zx29_sd",
	.id		= 0,
	.resource	= sdmmc0_resources,
	.num_resources	= ARRAY_SIZE(sdmmc0_resources),
	.dev		= {
		.coherent_dma_mask	= 0xffffffffUL,
		.platform_data		= &zx297520_sdmmc0_platdata,
	},
};
static struct resource sdmmc1_resources[] = {
	[0] = {
		.start	= ZX_SD1_BASE,
		.end	= ZX_SD1_BASE + SZ_4K - 1,
		.flags	= IORESOURCE_MEM,
	},
	[1] = {
		.start	= SD1_INT,
		.end	= SD1_INT,
		.flags	= IORESOURCE_IRQ,
	},
};

struct dw_mci_board zx297520_sdmmc1_platdata = {
	.num_slots	= 1,
	.quirks = DW_MCI_QUIRK_BROKEN_CARD_DETECTION,
	.bus_hz = 26000000,
	.caps	= (MMC_CAP_4_BIT_DATA | MMC_CAP_MMC_HIGHSPEED | MMC_CAP_SD_HIGHSPEED),
//	.pm_caps = MMC_PM_KEEP_POWER | MMC_PM_IGNORE_PM_NOTIFY, disable for sd, to confirm
	//.init = sdmmc_init, 
	//.setpower = sdmmc_set_power,
};
static struct platform_device zx297520_sdmmc1_device = {
	.name		= "zx29_sd",
	.id		= 1,
	.resource	= sdmmc1_resources,
	.num_resources	= ARRAY_SIZE(sdmmc1_resources),
	.dev		= {
		.coherent_dma_mask	= 0xffffffffUL,
		.platform_data		= &zx297520_sdmmc1_platdata,
	},
};
#endif

/* --------------------------------------------------------------------
 *  NAND
 * -------------------------------------------------------------------- */
#ifdef CONFIG_MTD_ZXIC_SPIFC
 static struct resource spi_nand_resource[] = {
	  [0] = {
		  .start  = ZX_SPIFC0_BASE,
		  .end	  = ZX_SPIFC0_BASE + SZ_4K - 1,
		  .flags  = IORESOURCE_MEM,
		  .name   = "spifc_reg",
	  },
	  [2] = {
		  .start  = SPI_FC0_INT,
		  .end	  = SPI_FC0_INT,
		  .flags  = IORESOURCE_IRQ,

	  },
  };
#endif
#ifdef CONFIG_MTD_NAND_DENALI
static struct resource denali_nand_resource[] = {
	[0] = {
		.start	= ZX_NAND_REG_BASE,
		.end	= ZX_NAND_REG_BASE + SZ_4K - 1,
		.flags	= IORESOURCE_MEM,
		.name   = "denali_reg",
	},
	[1] = {
		.start	= ZX_NAND_DATA_BASE,
		.end	= ZX_NAND_DATA_BASE + SZ_4K - 1,
		.flags	= IORESOURCE_MEM,
		.name   = "nand_data",
	},
    [2] = {
		.start	= NAND_INT,
		.end	= NAND_INT,
		.flags	= IORESOURCE_IRQ,

	},
};
struct denali_nand_data {
	struct mtd_partition *parts;
	int (*dev_ready)(struct mtd_info *mtd);
	u32 nr_parts;
	u8 ale;		/* address line number connected to ALE */
	u8 cle;		/* address line number connected to CLE */
	u8 width;	/* buswidth */
	u8 chip_delay;
};
static struct denali_nand_data zx297520_nand_data = {
	.cle		= 0,
	.ale		= 1,
	.width		= 8,
};
struct platform_device zx297520_device_nand = {
	.name		= "denali-nand-dt",
	.id		= -1,
	.dev		= {
		.platform_data	= &zx297520_nand_data,
	},
	.num_resources	= ARRAY_SIZE(denali_nand_resource),
	.resource	= denali_nand_resource,
};
#endif

#ifdef CONFIG_MTD_ZXIC_SPIFC
struct platform_device zx297520_device_spi_nand = {
	.name		= "spi-nand-dt",
	.id		= -1,
	.num_resources	= ARRAY_SIZE(spi_nand_resource),
	.resource	= spi_nand_resource,
};
#endif
/* --------------------------------------------------------------------
 *  I2C
 * -------------------------------------------------------------------- */
#ifdef CONFIG_I2C_ZX29

static struct zx29_i2c_platform_data zx29_pmic_i2c_platform_data = {
	.bus_clk_rate   = 300000,
};
static struct zx29_i2c_platform_data zx29_i2c0_platform_data = {
	.bus_clk_rate	 = 300000,
};

static struct resource pmic_i2c_resources[] = {
	[0] = {
		.start	= (u32)ZX_PMIC_I2C_BASE,
		.end	= (u32)ZX_PMIC_I2C_BASE + SZ_4K - 1,
		.flags	= IORESOURCE_MEM,
	},
	[1] = {
		.start	= I2C0_INT,
		.end	= I2C0_INT,
		.flags	= IORESOURCE_IRQ,
	},
};
static struct resource i2c0_resources[] = {
	[0] = {
		.start	= (u32)ZX_I2C1_BASE,
		.end	= (u32)ZX_I2C1_BASE + SZ_4K - 1,
		.flags	= IORESOURCE_MEM,
	},
	[1] = {
		.start	= I2C1_INT,
		.end	= I2C1_INT,
		.flags	= IORESOURCE_IRQ,
	},
};

static struct platform_device zx297520v2_pmic_i2c_device = {
	.name		= "zx29_i2c",
	.id 	    = 0,
	.resource	= pmic_i2c_resources,
	.num_resources	= ARRAY_SIZE(pmic_i2c_resources),
	.dev = {
		.platform_data = &zx29_pmic_i2c_platform_data,
	},
};
static struct platform_device zx297520v2_i2c0_device = {
	.name		= "zx29_i2c",
	.id 	    = 1,
	.resource	= i2c0_resources,
	.num_resources	= ARRAY_SIZE(i2c0_resources),
	.dev = {
		.platform_data = &zx29_i2c0_platform_data,
	},
};
#endif

/* --------------------------------------------------------------------
 *  SPI
 * -------------------------------------------------------------------- */
#ifdef CONFIG_SPI_ZX29
static struct resource spi_resources[] = {
	[0]={
		.start	= ZX_SSP0_BASE,
		.end	= ZX_SSP0_BASE + SZ_32 - 1,
		.name	= "registers",
		.flags	= IORESOURCE_MEM,
	},
	[1]={
		.start	= SSP0_INT,
		.end	= SSP0_INT,
		.name	= "interrupt",
		.flags	= IORESOURCE_IRQ,
	},
};

static struct zx297520v2_spi_controller spi_data ={
	.bus_id = 0,
	.num_chipselect = 1,
	.enable_dma = 0,
	.autosuspend_delay=0,
};

static struct platform_device zx29_ssp_device = {
	.name		= "zx29_ssp",
	.id 	= 0,
	.dev	={
			.platform_data = &spi_data,
		},
	.resource	= spi_resources,
	.num_resources	= ARRAY_SIZE(spi_resources),	
};
#endif

/* --------------------------------------------------------------------
 *  USB
 * -------------------------------------------------------------------- */
#ifdef CONFIG_DWC_OTG_USB
/* USB 20*/
static struct resource usb0_resources[] = {
	[0] = {
		.start	= ZX29_USB_PHYS,
		.end	= ZX29_USB_PHYS + SZ_256K - 1,
		.flags	= IORESOURCE_MEM,
	},
	[1] = {
		.name   = "usb_int",
		.start	= USB_INT,
		.end	= USB_INT,
		.flags	= IORESOURCE_IRQ,
	},
	[2] = {
	 	 .name   = "usb_powerdown_up",
		 .start  = USB_POWERDWN_UP_INT,
		 .end	 = USB_POWERDWN_UP_INT,
		 .flags  = IORESOURCE_IRQ,
	},
	[3] = {
	 	 .name   = "usb_powerdown_down",
		 .start  = USB_POWERDWN_DOWN_INT,
		 .end	 = USB_POWERDWN_DOWN_INT,
		 .flags  = IORESOURCE_IRQ,
	},
};

static struct platform_device zx297520v2_usb0_device = {
	.name		= "zx29_hsotg",
	.id		= 0,
	.resource	= usb0_resources,
	.num_resources	= ARRAY_SIZE(usb0_resources),
};
#endif

#ifdef CONFIG_USB_DWC_OTG_HCD
 /* HSIC*/
static struct resource usb1_resources[] = {
 [0] = {
	 .start  = ZX29_HSIC_PHYS,
	 .end	 = ZX29_HSIC_PHYS + SZ_256K - 1,
	 .flags  = IORESOURCE_MEM,
 },
 [1] = {
 	 .name   = "hsic_int",
	 .start  = HSIC_INT,
	 .end	 = HSIC_INT,
	 .flags  = IORESOURCE_IRQ,
 },
 [2] = {
 	 .name   = "hsic_powerdown_up",
	 .start  = HSIC_POWERDWN_UP_INT,
	 .end	 = HSIC_POWERDWN_UP_INT,
	 .flags  = IORESOURCE_IRQ,
 },
 [3] = {
 	 .name   = "hsic_powerdown_down",
	 .start  = HSIC_POWERDWN_DOWN_INT,
	 .end	 = HSIC_POWERDWN_DOWN_INT,
	 .flags  = IORESOURCE_IRQ,
 },
};

static struct platform_device zx297520v2_usb1_device = {
 .name		 = "zx29_hsic",
 .id	 = 1,
 .resource	 = usb1_resources,
 .num_resources  = ARRAY_SIZE(usb1_resources),
};
#endif

/* --------------------------------------------------------------------
 * ICP
 * -------------------------------------------------------------------- */
#ifdef CONFIG_RPM_ZX29
 /*ICP_M0/ICP_ARM0*/
static struct zx29_rpmsg_platform_data rpmsg_m0_platform_data = {
	.iram_send_base	= (u32)ICP_IRAM_APM0_BASEADDR,
	.iram_send_size	= ICP_IRAM_APM0_SIZE,
  	.iram_recv_base	= (u32)ICP_IRAM_M0AP_BASEADDR,
	.iram_recv_size	= ICP_IRAM_M0AP_SIZE,
  	.ddr_send_base	= (u32)ICP_DDR_APM0_BASEADDR,
  	.ddr_send_size	= ICP_DDR_APM0_SIZE,
  	.ddr_recv_base	= (u32)ICP_DDR_M0AP_BASEADDR,
  	.ddr_recv_size	= ICP_DDR_M0AP_SIZE,
  	.max_channel_cnt= CHANNEL_AP2M0_MAXID,
};

static struct resource icp_m0_resources[] = {
	[0] = {
		.start	= ICP_M02AP_INT,
		.end	= ICP_M02AP_INT,
		.flags	= IORESOURCE_IRQ,
	},
	[1] = {
		.start	= (u32)ZX29_ICP_APM0_REG,
		.end	= (u32)ZX29_ICP_APM0_REG + 0x30,
		.flags	= IORESOURCE_MEM,
		.name 	= "icp",
	},

};

static struct zx29_rpmsg_platform_data rpmsg_ps_platform_data = {
	.iram_send_base	= (u32)ICP_IRAM_APPS_BASEADDR,
	.iram_send_size	= ICP_IRAM_APPS_SIZE,
  	.iram_recv_base	= (u32)ICP_IRAM_PSAP_BASEADDR,
	.iram_recv_size	= ICP_IRAM_PSAP_SIZE,
  	.ddr_send_base	= (u32)ICP_DDR_APPS_BASEADDR,
  	.ddr_send_size	= ICP_DDR_APPS_SIZE,
  	.ddr_recv_base	= (u32)ICP_DDR_PSAP_BASEADDR,
  	.ddr_recv_size	= ICP_DDR_PSAP_SIZE,
  	.max_channel_cnt= CHANNEL_AP2PS_MAXID,
};

static struct resource icp_ps_resources[] = {
	[0] = {
		.start	= ICP_PS2AP_INT,
		.end	= ICP_PS2AP_INT,
		.flags	= IORESOURCE_IRQ,
	},
	[1] = {
		.start	= (u32)ZX29_ICP_APPS_REG,
		.end	= (u32)ZX29_ICP_APPS_REG + 0x30,
		.flags	= IORESOURCE_MEM,
		.name 	= "icp",
	},
};

/* a9 <--> m0 */
static struct platform_device zx297520v2_icp_m0_device = {
	.name		= "icp",
	.id			= 0,
	.resource	= icp_m0_resources,
	.num_resources	= ARRAY_SIZE(icp_m0_resources),
	.dev = {
		.platform_data = &rpmsg_m0_platform_data,
	},
};

/* a9 <--> ps */
static struct platform_device zx297520v2_icp_ps_device = {
	.name		= "icp",
	.id			= 1,
	.resource	= icp_ps_resources,
	.num_resources	= ARRAY_SIZE(icp_ps_resources),
	.dev = {
		.platform_data = &rpmsg_ps_platform_data,
	},
};
#endif

/* --------------------------------------------------------------------
 *	WDT -- ap watchdog timer
* -------------------------------------------------------------------- */
#ifdef CONFIG_ZX29_WATCHDOG
static struct resource wdt_res[] = {
	[0] = {
		.start	= (u32)ZX_AP_WDT_BASE,
		.end	= (u32)ZX_AP_WDT_BASE + SZ_4K - 1,
		.flags  = IORESOURCE_MEM,
	},
	[1] = {
		.start = WDT_INT,
		.end   = WDT_INT,
		.flags = IORESOURCE_IRQ,
	},
};
static struct platform_device zx297520v2_wdt_device = {
	.name = "zx29_ap_wdt",
	.id = 0,
	.resource = wdt_res,
	.num_resources	= ARRAY_SIZE(wdt_res),
};
#endif

#ifdef CONFIG_LEDS_GPIO

struct gpio_led leds[]={
	{
		.name = "sms_led",
		.gpio = ZX29_GPIO_42,
		.func = GPIO42_GPIO42,
		.active_low = 0,
	},
	{
		.name = "modem_b_led",
		.gpio = ZX29_GPIO_43,
		.func = GPIO43_GPIO43,
		.active_low = 0,
	},
	{
		.name = "modem_g_led",
		.gpio = ZX29_GPIO_44,
		.func = GPIO44_GPIO44,
		.active_low = 0,
	},
	{
		.name = "modem_r_led",
		.gpio = ZX29_GPIO_45,
		.func = GPIO45_GPIO45,
		.active_low = 0,
	},
	{
		.name = "wifi_led",
		.gpio = ZX29_GPIO_70,
		.func = GPIO70_GPIO70,
		.active_low = 0,
	},
	{
		.name = "battery_r_led",
		.gpio = ZX29_GPIO_72,
		.func = GPIO72_GPIO72,
		.active_low = 0,
	},
	{
		.name = "battery_g_led",
		.gpio = ZX29_GPIO_73,
		.func = GPIO73_GPIO73,
		.active_low = 0,
	}
};

static struct gpio_led_platform_data leds_data =
{
	.num_leds =sizeof(leds)/sizeof(leds[0]) ,
	.leds = leds,

};

static struct platform_device leds_device =
{
	.name		= "leds-gpio",
	.id		= 1,
	.dev		= {
		.platform_data	= &leds_data,
	},
};
#endif


#ifdef CONFIG_KEYBOARD_ZX_INT
/* --------------------------------------------------------------------
 *  Keypad (power_on, ufi, ufi_reset) for ufi
 * -------------------------------------------------------------------- */
static struct gpio_keys_button zx297520v2_keypad[] = {
	#if 1
	[0] = {
		.gpio		= ZX29_GPIO_52,		/* power */
		.active_low	= 1,				/*Ƿ͵ƽЧ1: Ϊ͵ƽ  0: Ϊߵƽ*/
		.desc       = "kpd_power",
		.code       = KEY_POWER         /*116*/,
		.gpio_sel_gpio = GPIO52_GPIO52,
		.gpio_sel_int = GPIO52_EXT_INT2,
		.use_pmu_pwron = 1,             /*true: use pmu pwron interrupt fase: use zx297520v2 ext int*/
		},
	#endif

	#if 1
	[1] = {
		.gpio		= ZX29_GPIO_75,		/* wps */
		.active_low	= 1,
		.desc       = "kpd_wps",
		.code       = KEY_KPEQUAL       /*117*/,
		.gpio_sel_gpio = GPIO75_GPIO75,
		.gpio_sel_int = GPIO75_EXT_INT13,
		},
	#endif

    #if 1
	[2] = {
		.gpio		= ZX29_GPIO_76,		/* reset */
		.active_low	= 1,
		.desc       = "kpd_reset",
		.code       = KEY_KPPLUSMINUS   /*118*/,
		.gpio_sel_gpio = GPIO76_GPIO76,
		.gpio_sel_int = GPIO76_EXT_INT14,
		},
	#endif

};

static struct gpio_keys_platform_data zx297520v2_keypad_data = {
	.buttons	= zx297520v2_keypad,
	.nbuttons	= ARRAY_SIZE(zx297520v2_keypad),
};

static struct platform_device zx297520v2_keypad_device ={
	.name 	= 	"zx297520v2_keypad",
		.id 	=	-1,
		.dev	={
					.platform_data = &zx297520v2_keypad_data,
				}
};
#endif

#ifdef CONFIG_KEYBOARD_ZX_4x4
static struct zx297520v2_4x4_keypad_platform_data zx297520v2_4x4_keypad_data = {
	KEYPAD_INT,

	{
		KEY_RESERVED,	//KBC0 KBR0
		KEY_ESC,	    //KBC0 KBR1
		KEY_1,	        //KBC0 KBR2
		KEY_2,	        //KBC0 KBR3

		KEY_3,	        //KBC1 KBR0
		KEY_4,	        //KBC1 KBR1
		KEY_5,	        //KBC1 KBR2
		KEY_6,	        //KBC1 KBR3

		KEY_7,	        //KBC2 KBR0
		KEY_8,	        //KBC2 KBR1
		KEY_9,	        //KBC2 KBR2
		KEY_0,	        //KBC2 KBR3

		KEY_MINUS,	    //KBC3 KBR0
		KEY_EQUAL,	    //KBC3 KBR1
		KEY_BACKSPACE,	//KBC3 KBR2
        KEY_TAB,	    //KBC3 KBR3
	}
};

static struct platform_device zx297520v2_4x4_keypad_device ={
	.name 	= 	"zx297520v2_keypad",
	.id 	=	0,
	.dev	={
					.platform_data = &zx297520v2_4x4_keypad_data,
			}
};
#endif

#ifdef CONFIG_NET_ZX29_GMAC
/* gmac*/
#if 0
static struct resource gmac_resources[] = {
	[0] = {
		.start	= ZX_GMAC_BASE,
		.end	= ZX_GMAC_BASE + SZ_8K - 1,
		.flags	= IORESOURCE_MEM,
	},
	[1] = {
		.start	= GMAC_INT,
		.end	= GMAC_INT,
		.flags	= IORESOURCE_IRQ,
	},
};
#endif
#if 1
static struct resource gmac_resources[] = {
	[0] = {
		.start	= ZX_GMAC_BASE,
		.end	= ZX_GMAC_BASE + SZ_8K - 1,
		.flags	= IORESOURCE_MEM,
	},
	[1] = {
		.name   = "gmac_int",
		.start	= GMAC_INT,
		.end	= GMAC_INT,
		.flags	= IORESOURCE_IRQ,
	},
	[2] = {
		.name   = "ext_int",
		.start	= EX6_INT,
		.end	= EX6_INT,
		.flags	= IORESOURCE_IRQ,
	},
};
#endif
static struct platform_device zx297520v2_gmac_device = {
	.name		= "zx29_gmac",
	.id		= 0,
	.resource	= gmac_resources,
	.num_resources	= ARRAY_SIZE(gmac_resources),
	.dev	 = {
			.platform_data = NULL,
		    }
};
#endif
/* --------------------------------------------------------------------
 *	----------  for  solution integration department ---------   end
* -------------------------------------------------------------------- */


/*
 *  device tab used by board_init()
 */
struct platform_device *zx297520v2_device_table[] __initdata={
/* --------------------------------------------------------------------
 *	----------  for  solution integration department ---------   start
* -------------------------------------------------------------------- */
#ifdef CONFIG_SERIAL_ZX29_UART
	&zx297520v2_uart0_device,
	&zx297520v2_uart2_device,
#endif
#ifdef CONFIG_MTD_NAND_DENALI
	&zx297520_device_nand,
#endif
#ifdef CONFIG_DWC_OTG_USB
	&zx297520v2_usb0_device,
#endif
#ifdef CONFIG_USB_DWC_OTG_HCD
	&zx297520v2_usb1_device,
#endif
#ifdef CONFIG_MTD_ZXIC_SPIFC
	&zx297520_device_spi_nand,
#endif

#ifdef CONFIG_ZX29_DMA
	&zx297520v2_dma_device,
#endif

#ifdef CONFIG_MMC_ZX29
    &zx297520_sdmmc0_device,
    &zx297520_sdmmc1_device,
#endif

#ifdef CONFIG_I2C_ZX29
	&zx297520v2_pmic_i2c_device,
	&zx297520v2_i2c0_device,
#endif

#ifdef CONFIG_SPI_ZX29
	&zx29_ssp_device,
#endif

#ifdef CONFIG_RPM_ZX29
	&zx297520v2_icp_m0_device,
	&zx297520v2_icp_ps_device,
#endif

#ifdef CONFIG_ZX29_WATCHDOG
	&zx297520v2_wdt_device,
#endif

#ifdef CONFIG_KEYBOARD_ZX_INT
    &zx297520v2_keypad_device,
#endif
#ifdef CONFIG_KEYBOARD_ZX_4x4
	&zx297520v2_4x4_keypad_device,
#endif


#ifdef CONFIG_LEDS_GPIO
       &leds_device,
#endif

#ifdef CONFIG_NET_ZX29_GMAC
 	&zx297520v2_gmac_device,
#endif
};

unsigned int zx297520v2_device_table_num=ARRAY_SIZE(zx297520v2_device_table);

#ifdef CONFIG_SPI_ZX29
static struct spi_board_info zx29_spi_devices[] = {
};
void __init spi_add_devices(void)
{
	unsigned  devices_num = ARRAY_SIZE(zx29_spi_devices);
    int ret = 0;
	
	if (devices_num){
		ret = spi_register_board_info(zx29_spi_devices, devices_num);
		printk("spi_register_board_info success,ret=%d\n",ret);
		if(ret)
			BUG();
	}	
}
#endif

#ifdef CONFIG_CHARGER_ZX234502

#define ZX234502_BAT_VOLTAGE_LEN  21

struct zx234502_bat_calibration zx234502_bat_volage_charge[]=
{
	{4100,100}, {4090,95}, {4080,90}, {4070,85}, {4060,80}, {4050,75},
	{4012,70}, {3973,65}, {3935,60}, {3896,55}, {3860,50}, {3817,45},
	{3775,40}, {3733,35}, {3692,30}, {3650,25}, {3610,20}, {3570,15},
	{3530,12}, {3590,10}, {3450,5}
};

struct zx234502_bat_calibration zx234502_bat_volage_discharge[]=
{
	{4100,100}, {4090,95}, {4080,90}, {4070,85}, {4060,80}, {4050,75},
	{4012,70}, {3973,65}, {3935,60}, {3896,55}, {3860,50}, {3817,45},
	{3775,40}, {3733,35}, {3692,30}, {3650,25}, {3610,20}, {3570,15},
	{3530,12}, {3590,10}, {3450,5}
};

static struct  zx234502_platform_data zx234502_charger_platform = {
	.gpio_int		=	55,  //gpio55
	.gpio_int_fun_sel = GPIO55_EXT_INT5,
	.charging         =  &zx234502_bat_volage_charge,
	.charging_size = ZX234502_BAT_VOLTAGE_LEN,
	.discharging      =  &zx234502_bat_volage_discharge,
	.discharging_size = ZX234502_BAT_VOLTAGE_LEN,
	.ts_flag = TRUE,
	.boost_flag = FALSE,
	.boost_cur_gpio1 = 39,/*GPIO39*/
	.boost_gpio1_fun_sel = GPIO39_GPIO39,
	.boost_cur_gpio2 = 40,/*GPIO40*/
	.boost_gpio2_fun_sel = GPIO40_GPIO40,
	.boost_cur_gpio3 = 41,/*GPIO41*/
	.boost_gpio3_fun_sel = GPIO41_GPIO41,
	.boost_loadswitch_gpio = 38,/*GPIO38*/
	.boost_loadswitch_fun_sel = GPIO38_GPIO38,

};
static struct i2c_board_info zx297510_i2c1_devices[] = {

};

#endif

#if 1
/*
 *  I2C  device tab used by board_init()
 */
#ifdef CONFIG_MFD_ZX234290_I2C
static struct  zx234290_board zx234290_platform = {
	.irq_gpio_num	    =	ZX29_GPIO_50, //EX0_INT,
    .irq_gpio_func      =   GPIO50_EXT_INT0,
	.pshold_gpio_num    =   ZX29_GPIO_51,
	.pshold_gpio_func   =   GPIO51_GPIO51,
	.irq_base	= 	ENT_ZX234290_IRQ_BASE,
};
#endif

static struct i2c_board_info zx297520_i2c0_devices[] = {
#ifdef CONFIG_MFD_ZX234290_I2C
	[0]={
		I2C_BOARD_INFO("zx234290", 0x12),
		.irq		= EX0_INT,
		.platform_data 	= &zx234290_platform,
	},
#endif

};

static struct i2c_board_info zx297520_i2c1_devices[] = {
#ifdef CONFIG_CHARGER_ZX234502
		[0]={
			I2C_BOARD_INFO("zx234502-charger", 0x13),
			.irq		= EX5_INT,
			.platform_data	= &zx234502_charger_platform,
		},
#endif

};

void __init i2c_add_devices(void)
{
	unsigned  devices_num = 0;
    int ret = 0;

	/*
	  *i2c devices on bus 0
	  */
	devices_num = ARRAY_SIZE(zx297520_i2c0_devices);
	if (devices_num){
		ret = i2c_register_board_info(0,zx297520_i2c0_devices, devices_num);
		if(ret)
			BUG();
	}

	/*
	  *i2c devices on bus 1
	  */
	devices_num = ARRAY_SIZE(zx297520_i2c1_devices);
	if (devices_num){
		ret = i2c_register_board_info(1,zx297520_i2c1_devices, devices_num);
		if(ret)
			BUG();
	}
}
#endif
