/* * Copyright (c) 2011 Qualcomm Atheros, Inc. * */
#ifndef _FAST_6_H
#define _FAST_6_H

#include <linux/in.h>
#include <linux/ip.h>
#include <linux/udp.h>
#include <linux/tcp.h>
#include <linux/icmp.h>
#include <net/ip.h>
#include <linux/if_arp.h>

#include <linux/inetdevice.h>
#include <linux/netfilter.h>
#include <linux/netfilter_ipv6.h>
#include <linux/netfilter_arp.h>
//#include <linux/netfilter_ipv4/ip_tables.h>
#include <linux/netfilter/xt_multiport.h>
#include <linux/netfilter/xt_iprange.h>
#include <linux/netfilter/nf_conntrack_tcp.h>
#include <net/checksum.h>
#include <net/dsfield.h>
#include <net/route.h>
#include <net/netfilter/nf_nat.h>
#include <net/netfilter/nf_nat_core.h>
#include <net/netfilter/nf_nat_rule.h>
#include <net/netfilter/nf_conntrack_helper.h>
#include <linux/module.h>

#include <linux/proc_fs.h>

#include <net/SI/fast_common.h>

/* *******************************궨******************************* */
/* *******************************궨******************************* */
/* *******************************궨******************************* */

/* *****************************ṹ嶨***************************** */
/* *****************************ṹ嶨***************************** */
/* *****************************ṹ嶨***************************** */
struct ip6_opthdr
{
    unsigned char nxt;
    unsigned char len;
};

struct ip6_hdr
{
    union
    {
        struct ip6_hdrctl
        {
            uint32_t ip6_un1_flow;   /* 4 bits version, 8 bits TC,
                    20 bits flow-ID */
            uint16_t ip6_un1_plen;   /* payload length */
            uint8_t  ip6_un1_nxt;    /* next header */
            uint8_t  ip6_un1_hlim;   /* hop limit */
        } ip6_un1;
        uint8_t ip6_un2_vfc;       /* 4 bits version, top 4 bits tclass */
    } ip6_ctlun;
    struct in6_addr ip6_src;      /* source address */
    struct in6_addr ip6_dst;      /* destination address */
};

#define ip6_vfc   ip6_ctlun.ip6_un2_vfc
#define ip6_flow  ip6_ctlun.ip6_un1.ip6_un1_flow
#define ip6_plen  ip6_ctlun.ip6_un1.ip6_un1_plen
#define ip6_nxt   ip6_ctlun.ip6_un1.ip6_un1_nxt
#define ip6_hlim  ip6_ctlun.ip6_un1.ip6_un1_hlim
#define ip6_hops  ip6_ctlun.ip6_un1.ip6_un1_hlim

/* ********************************************************** */
/* ********************************************************** */
/* ********************************************************** */
extern spinlock_t fast6_spinlock; //Ĳ
extern fast_list_t working_list6 ;
extern struct hlist_nulls_head *working_hash6;

/* *****************************ӿ***************************** */
/* *****************************ӿ***************************** */
/* *****************************ӿ***************************** */
int fast6_get_tuple(struct sk_buff *skb, struct nf_conntrack_tuple *tuple);

int fast6_recv(struct sk_buff *skb);

unsigned int napt6_handle(unsigned int hooknum,
            struct sk_buff *skb,
            const struct net_device *in,
            const struct net_device *out, int (*okfn) (struct sk_buff *));

#endif //_FAST_6_H

