#include <linux/init.h>
#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/stat.h>
#include <linux/fs.h>
#include <linux/kdev_t.h>
#include <linux/cdev.h>
#include <linux/slab.h>
#include <linux/device.h>
#include <asm/uaccess.h>

#include "pub_flags.h"


MODULE_LICENSE("GPL v2");
MODULE_AUTHOR("flags_utils");


#define DEVICE_NAME "chardevnode"
#define DEVICE_MINOR_NUM 2
#define DEV_MAJOR 0
#define DEV_MINOR 0
#define REGDEV_SIZE 3000
#define LED_NUM 2

#define FLAGS_UTILS_GET	_IOWR('b', 1, T_FLAGS_INFO)
#define FLAGS_UTILS_SET	_IOWR('b', 2, T_FLAGS_INFO)


extern int flags_get(T_FLAGS_INFO *p_flags_info);
extern int flags_set(T_FLAGS_INFO *p_flags_info);


int numdev_major = DEV_MAJOR;
int numdev_minor = DEV_MINOR;

module_param(numdev_major,int,S_IRUSR);
module_param(numdev_minor,int,S_IRUSR);

static struct class *myclass;

struct reg_dev
{
    char *data;
    unsigned long size;
    
    struct cdev cdev;
};
struct reg_dev *my_devices;


static int chardevnode_open(struct inode *inodes, struct file *files)
{
    printk(KERN_EMERG "chardevnode_open success! \n");
    return 0;
}
static int chardevnode_release (struct inode *inodes, struct file *files)
{
    printk(KERN_EMERG "chardevnode_release success! \n");
    return 0;
}

static long chardevnode_unlocked_ioctl(struct file *files, unsigned int cmd, unsigned long arg)
{
	void __user *ubuf = (void __user *)arg;
		
	switch (cmd) {
		case FLAGS_UTILS_GET:
			{
				T_FLAGS_INFO flags_info_get = {0};
		
				if (0 != flags_get(&flags_info_get))
				{
					printk(KERN_ERR "flags utils ioctl get fail \n");
					return -EFAULT;
				}
				
				if (copy_to_user(ubuf, &flags_info_get, sizeof(flags_info_get)))
				{
					printk(KERN_ERR "flags utils ioctl copy to fail \n");
					return -EFAULT;
				}
				break;
			}
		case FLAGS_UTILS_SET:
			{
				T_FLAGS_INFO flags_info_set = {0};
				
				if (copy_from_user(&flags_info_set, ubuf, sizeof(flags_info_set)))
				{
					printk(KERN_ERR "flags utils ioctl copy from fail \n");
					return -EFAULT;
				}
				
				if (0 != flags_set(&flags_info_set))
				{
					printk(KERN_ERR "flags utils ioctl set fail \n");
					return -EFAULT;
				}
				break;
			}
		default:
			{
				printk(KERN_ERR "flags utils ioctl does not support cmd[0x%x]\n", cmd);
				return -EOPNOTSUPP;
			}
	}

    return 0;
}

static ssize_t chardevnode_read(struct file *files, char __user *buf , size_t count, loff_t *f_ops)
{
    return 0;
}
static ssize_t chardevnode_write(struct file *files, const char __user *buf, size_t count, loff_t *f_ops)
{
    return 0;
}
static loff_t chardevnode_llseek(struct file *files, loff_t offset, int ence)
{
    return 0;
}
struct file_operations my_fops = {
    .owner   = THIS_MODULE,
    .open     = chardevnode_open,
    .release = chardevnode_release,
    .unlocked_ioctl = chardevnode_unlocked_ioctl,
    .read     = chardevnode_read,
    .write     = chardevnode_write,
    .llseek     = chardevnode_llseek,
};


static void reg_init_cdev(struct reg_dev *dev,int index){
    int err;
    int devno = MKDEV(numdev_major,numdev_minor+index);
    
    cdev_init(&dev->cdev,&my_fops);
    dev->cdev.owner = THIS_MODULE;
    dev->cdev.ops = &my_fops;
    
    err = cdev_add(&dev->cdev,devno,1);
    if(err){
        printk(KERN_EMERG "cdev_add %d is fail! %d\n",index,err);
    }
    else{
        printk(KERN_EMERG "cdev_add %d is success!\n",numdev_minor+index);
    }
}


static int scdev_init(void)
{
    int ret = 0,i;
    dev_t num_dev;
    
    printk(KERN_EMERG "numdev_major is %d\n", numdev_major);
    printk(KERN_EMERG "numdev_minor is %d\n", numdev_minor);
    
    if(numdev_major){
        num_dev = MKDEV(numdev_major,numdev_minor);
        ret = register_chrdev_region(num_dev, DEVICE_MINOR_NUM, DEVICE_NAME);
    }
    else{
        ret = alloc_chrdev_region(&num_dev, numdev_minor, DEVICE_MINOR_NUM,DEVICE_NAME);
        numdev_major = MAJOR(num_dev);
        printk(KERN_EMERG "adev_region req %d !\n", numdev_major);
    }
    if(ret<0){
        printk(KERN_EMERG "register_chrdev_region req %d is failed!\n", numdev_major);        
    }
    myclass = class_create(THIS_MODULE, DEVICE_NAME);
    
    my_devices = kmalloc(DEVICE_MINOR_NUM * sizeof(struct reg_dev), GFP_KERNEL);
    if(!my_devices){
        ret = -ENOMEM;
        goto fail;
    }
    memset(my_devices, 0, DEVICE_MINOR_NUM * sizeof(struct reg_dev));
    
    for(i=0; i<DEVICE_MINOR_NUM; i++){
        my_devices[i].data = kmalloc(REGDEV_SIZE,GFP_KERNEL);
        memset(my_devices[i].data,0,REGDEV_SIZE);
	
        reg_init_cdev(&my_devices[i],i);
        device_create(myclass,NULL,MKDEV(numdev_major,numdev_minor+i),NULL,DEVICE_NAME"%d",i);
    }
        
    printk(KERN_EMERG "scdev_init!\n");
    return 0;

fail:
    unregister_chrdev_region(MKDEV(numdev_major,numdev_minor),DEVICE_MINOR_NUM);
    printk(KERN_EMERG "kmalloc is fail!\n");
    
    return ret;
}

static void scdev_exit(void)
{
    int i;
    printk(KERN_EMERG "scdev_exit!\n");
    
    for(i=0;i<DEVICE_MINOR_NUM;i++){
        cdev_del(&(my_devices[i].cdev));
        device_destroy(myclass,MKDEV(numdev_major,numdev_minor+i));
    }
    class_destroy(myclass);
    kfree(my_devices);

    unregister_chrdev_region(MKDEV(numdev_major,numdev_minor),DEVICE_MINOR_NUM);
}


module_init(scdev_init);
module_exit(scdev_exit);

