DESCRIPTION = "nvserver"
#nvserver依赖libnvram库
DEPENDS     = "libmtd libnvram libflags libsd-daemon libdebug-info"
SECTION     = "app"
LICENSE     = "zte"
PV = "1.0.0"
PR = "r0"

CLASS_COM = " \
    ${@bb.utils.contains('DISTRO_FEATURES', 'procd', 'openwrt openwrt-services', '', d)} \
    ${@bb.utils.contains('DISTRO_FEATURES', 'systemd', 'systemd', '', d)} \
"
inherit ${CLASS_COM}

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}/platform:"
SRC_URI = " \
    file://nvserver \
    ${@bb.utils.contains("DISTRO_FEATURES", "procd", "file://nvserver.init","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "systemd", "file://nvserver.service","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "file://nvserver.sysvinit","", d)} \
    "

LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"
S = "${WORKDIR}"

#引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc
include ${BSPDIR}/sources/meta-zxic/conf/pub.inc
CFLAGS_append = "${ZXIC_EXTRA_CFLAGS}"

#编译
do_compile() {
	make -C nvserver
}

#库文件的安装
do_install() {
	install -d ${D}${bindir}/
	install -m 0755 ${S}/nvserver/nvserver ${D}${bindir}/

	if ${@bb.utils.contains('DISTRO_FEATURES','procd','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/nvserver.init ${D}${sysconfdir}/init.d/nvserver
	fi

	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
		install -d ${D}${systemd_unitdir}/system
		install -m 0644 ${WORKDIR}/nvserver.service ${D}${systemd_unitdir}/system
	fi

	if ${@bb.utils.contains('DISTRO_FEATURES','sysvinit','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/nvserver.sysvinit ${D}${sysconfdir}/init.d/nvserver
		install -d ${D}${sysconfdir}/rcS.d
		ln -s ../init.d/nvserver ${D}${sysconfdir}/rcS.d/S16nvserver
		ln -s ../init.d/nvserver ${D}${sysconfdir}/rcS.d/K84nvserver
	fi

	#install elfs
	install -d ${ELFS-PATH}/
	install -m 0755 ${S}/nvserver/nvserver ${ELFS-PATH}/
}
#清库
do_cleanlibs () {
	rm -fr ${ELFS-PATH}/nvserver
}

addtask  cleanlibs after do_clean  before do_cleansstate

#rootfs包含的文件
FILES_${PN} = "\
    ${bindir}/ \
    ${@bb.utils.contains("DISTRO_FEATURES", "procd", "${sysconfdir}/","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "${sysconfdir}/","", d)} \
    "
SYSTEMD_SERVICE_${PN}     = "nvserver.service"
SYSTEMD_AUTO_ENABLE_${PN} = "enable"

RDEPENDS_${PN} = "libmtd libnvram libflags libsd-daemon"

