DESCRIPTION = "zxic_mmi"
DEPENDS     = "libnvram libsofttimer libatutils libsoftap openssl"
SECTION     = "app"
LICENSE     = "zte"
PV = "1.0.0"
PR = "r0"

CLASS_COM = " \
    ${@bb.utils.contains('DISTRO_FEATURES', 'procd', 'openwrt openwrt-services', '', d)} \
    ${@bb.utils.contains('DISTRO_FEATURES', 'systemd', 'systemd', '', d)} \
"
inherit ${CLASS_COM}

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}/platform:"
SRC_URI = " \
          file://zxic_mmi \
		  ${@bb.utils.contains("DISTRO_FEATURES", "procd", "file://zxic_mmi.init","", d)} \
		  ${@bb.utils.contains("DISTRO_FEATURES", "systemd", "file://zxic_mmi.service","", d)} \
		  ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "file://zxic_mmi.sysvinit","", d)} \
          "
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"
S = "${WORKDIR}"
S_SRC_PATH = "${S}/zxic_mmi"
#引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc

#inherit autotools pkgconfig systemd

do_compile() {
	#echo "TOPDIR = ${TOPDIR}"
	
	make -C ${S_SRC_PATH}  CONFIG_MMI_LCD=${CONFIG_MMI_LCD}
}

do_install () {
	install -d ${D}${bindir}/
	install -m 0755 ${S_SRC_PATH}/zxic_mmi ${D}${bindir}/
	
	if ${@bb.utils.contains('DISTRO_FEATURES','procd','true','false',d)}; then
		#install -Dm 0755 ${WORKDIR}/zxic_mmi.init ${D}${sysconfdir}/init.d/zxic_mmi
		ls
	fi

	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
		install -d ${D}${systemd_unitdir}/system
		install -m 0644 ${WORKDIR}/zxic_mmi.service ${D}${systemd_unitdir}/system
		ls
	fi
	
	if ${@bb.utils.contains('DISTRO_FEATURES','sysvinit','true','false',d)}; then
		#install -Dm 0755 ${WORKDIR}/zxic_mmi.sysvinit ${D}${sysconfdir}/init.d/zxic_mmi
		#install -d ${D}${sysconfdir}/rcS.d
		#ln -s ../init.d/zxic_mmi ${D}${sysconfdir}/rcS.d/S40zxic_mmi
		ls
	fi

	#install elfs
	install -d ${ELFS-PATH}/
	install -m 0755 ${S_SRC_PATH}/zxic_mmi ${ELFS-PATH}/
}

do_cleanlibs () {
	rm -fr ${ELFS-PATH}/zxic_mmi
}

addtask  cleanlibs after do_clean  before do_cleansstate

FILES_${PN} = "\
    ${bindir}/ \
    ${@bb.utils.contains("DISTRO_FEATURES", "procd", "${sysconfdir}/init.d/zxic_mmi","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "${sysconfdir}/","", d)} \
    "
SYSTEMD_SERVICE_${PN}     = "zxic_mmi.service"
SYSTEMD_AUTO_ENABLE_${PN} = "enable"

RDEPENDS_${PN} = " libnvram libsofttimer libatutils libsoftap openssl"
