DESCRIPTION = "fdk-aac-master"
DEPENDS     = ""
SECTION     = "lib"
LICENSE     = "zte"
PV          = "0.1.5"
PR          = "r0"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}/platform:"
#SRC_URI = " \
#          file://fdk-aac-master \
#          "
SRC_URI = " \
          https://sourceforge.net/projects/opencore-amr/files/fdk-aac/fdk-aac-${PV}.tar.gz \
		  file://0001-fix-for-sanchips-device.patch \
          "

SRC_URI[md5sum] = "f70d394960da66fbf40a2946625690eb"
SRC_URI[sha256sum] = "2164592a67b467e5b20fdcdaf5bd4c50685199067391c6fcad4fa5521c9b4dd7"			  
		  
S = "${WORKDIR}"
#引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc

do_configure () {	
	cd fdk-aac-${PV} && ./build_sc.sh
}

#库和头文件的安装
do_install () {
	install -d ${D}${libdir}/

	install -d ${D}/usr/include
	install -d ${D}/usr/include/fdk-aac	

	install -m 0755 ${S}/fdk-aac-${PV}/pkgs/lib/*.a   ${D}${libdir}/
	
	install -m 0644 ${S}/fdk-aac-${PV}/pkgs/include/fdk-aac/*.h ${D}/usr/include/fdk-aac
		
	#install elfs
	install -d ${ELFS-PATH}/
	install -m 0755 ${S}/fdk-aac-${PV}/pkgs/lib/*.a ${ELFS-PATH}/

}

#清库
do_cleanlibs () {
	rm -fr ${ELFS-PATH}/libfdk-aac.a
}

#rootfs包含的文件
FILES_${PN}       += "${libdir}/*.so"
FILES_${PN}-dbg   += "${libdir}/.debug"
FILES_SOLIBSDEV   = ""
INSANE_SKIP_${PN} = "dev-so"
