DESCRIPTION = "ffmpeg"
DEPENDS     = "fdk-aac-master vo-amrwbenc opencore-amr"
SECTION     = "lib"
LICENSE     = "zte"
PV          = "3.2.14"
PR          = "r0"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"

#配置code路径信息。
#FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}/platform:"
#SRC_URI = " \
#          file://ffmpeg-${PV} \
#          "
SRC_URI = " \
          https://www.ffmpeg.org/releases/ffmpeg-${PV}.tar.gz \
		  file://0001-fix-for-sanchips-device.patch \
		  file://0001-fix-for-msm.patch \
          "

SRC_URI[md5sum] = "e0568845434f6fdeb67f4c3a67717e5b"
SRC_URI[sha256sum] = "d611182010c8cba1b63deade32467810af905e0f265e4683fbfb22fcbc165bb6"		  
		  
S = "${WORKDIR}"
#引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc

do_configure () {	
	cd ffmpeg-${PV} && ./build_sc_phone.sh
}
#编译
#do_compile () {
#}

#库和头文件的安装
do_install () {
	install -d ${D}${libdir}/

	install -d ${D}/usr/include
	install -d ${D}/usr/include/libavcodec
	install -d ${D}/usr/include/libavformat
	install -d ${D}/usr/include/libavutil	

	install -m 0755 ${S}/ffmpeg-3.2.14/pkgs/*.a   ${D}${libdir}/
	
	install -m 0644 ${S}/ffmpeg-3.2.14/pkgs/include/libavcodec/*.h ${D}/usr/include/libavcodec
	install -m 0644 ${S}/ffmpeg-3.2.14/pkgs/include/libavformat/*.h ${D}/usr/include/libavformat
	install -m 0644 ${S}/ffmpeg-3.2.14/pkgs/include/libavutil/*.h ${D}/usr/include/libavutil
		
	#install elfs
	install -d ${ELFS-PATH}/
	install -m 0755 ${S}/ffmpeg-3.2.14/pkgs/*.a ${ELFS-PATH}/

}

#清库
do_cleanlibs () {
	rm -fr ${ELFS-PATH}/libavcodec.a
	rm -fr ${ELFS-PATH}/libavformat.a
	rm -fr ${ELFS-PATH}/libavutil.a
}

#rootfs包含的文件
FILES_${PN}       += "${libdir}/*.so"
FILES_${PN}-dbg   += "${libdir}/.debug"
FILES_SOLIBSDEV   = ""
INSANE_SKIP_${PN} = "dev-so"

