#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <stdint.h>
#include <stdbool.h>
#include <errno.h>
#include <stdlib.h>
#include <ctype.h>
#include <tinyalsa/asoundlib.h>
#include <sound/asound.h>
#include <tinyalsa/audio_mixer_ctrl.h>

#define ARRAY_SIZE(a) (sizeof (a) / sizeof ((a)[0]))

struct audio_para_conf {
	const char *control;
	char *values[2];
};


#if defined _USE_CODEC_TI3100


enum t_output_vol {
    T_OUTPUT_VOL_MINUS_63_5DB = 0,
    T_OUTPUT_VOL_MINUS_63DB = 1,
    T_OUTPUT_VOL_MINUS_27DB = 73,
    T_OUTPUT_VOL_MINUS_24DB = 79,
    T_OUTPUT_VOL_MINUS_21DB = 85,
    T_OUTPUT_VOL_MINUS_18DB = 91,
    T_OUTPUT_VOL_MINUS_15DB = 97,
    T_OUTPUT_VOL_MINUS_12DB = 103,
    T_OUTPUT_VOL_MINUS_9DB = 109,
    T_OUTPUT_VOL_MINUS_6DB = 115,
    T_OUTPUT_VOL_MINUS_3DB = 121,
    T_OUTPUT_VOL_MINUS_2DB = 123,
    T_OUTPUT_VOL_MINUS_1DB = 125,
    T_OUTPUT_VOL_0DB = 127,
    T_OUTPUT_VOL_1DB = 129,
    T_OUTPUT_VOL_2DB = 131,
    T_OUTPUT_VOL_3DB = 133,
    T_OUTPUT_VOL_6DB = 139,
    T_OUTPUT_VOL_9DB = 145,
    T_OUTPUT_VOL_12DB = 151,
    T_OUTPUT_VOL_24DB = 175,
};

enum t_input_vol {
    T_INPUT_VOL_MINUS_12DB = 0,
	T_INPUT_VOL_MINUS_7DB = 10,
    T_INPUT_VOL_MINUS_6DB = 12,
    T_INPUT_VOL_MINUS_5DB = 14,
    T_INPUT_VOL_MINUS_4DB = 16,
    T_INPUT_VOL_MINUS_3DB = 18,
    T_INPUT_VOL_MINUS_2DB = 20,
    T_INPUT_VOL_MINUS_1DB = 22,
    T_INPUT_VOL_0DB = 24,
    T_INPUT_VOL_1DB = 26,
    T_INPUT_VOL_2DB = 28,
    T_INPUT_VOL_3DB = 30,
    T_INPUT_VOL_20DB = 64,
};

static struct audio_para_conf init_default_para[] = {  //ʼ
	{"Mic PGA Capture Volume", {"40"}},
	{"ADC Mute", {"0"}},
	{"ADC Fine Capture Volume", {"0"}},
	{"Speaker Analog Playback Volume", {"127"}},
	{"Speaker Driver Playback Switch", {"1"}},
	{"DAC Left Input", {"Mono"}},
	{"DAC Right Input", {"Mono"}},
	{"Output Right From Right DAC", {"1"}},
	{"Output Left From Left DAC", {"1"}},
	{"HP Analog Playback Volume", {"127", "127"}},
	{"HP Driver Playback Switch", {"1", "1"}}, //7dB
};

#ifdef _USE_7520V3_PHONE_TYPE_FWP
static struct audio_para_conf  common_out_para_audio[] = {  //Ӧ
	{"Speaker Analog Playback Volume", {"127"}},
	{"Speaker Driver Playback Switch", {"1"}},
	{"DAC Left Input", {"Mono"}},
	{"DAC Right Input", {"Mono"}},
	{"Output Right From Right DAC", {"1"}},
	{"Output Left From Left DAC", {"1"}},
	{"HP Analog Playback Volume", {"127", "127"}},
	{"HP Driver Playback Switch", {"1", "1"}}, //7dB
};

static struct audio_para_conf  common_in_para_audio[] = {  //Ӧ
	{"Mic PGA Capture Volume", {"12"}},
	{"ADC Mute", {"0"}},
	{"ADC Fine Capture Volume", {"0"}},

};

static struct audio_para_conf  hp_outpath_para_audio[] = {  //ӦHpͨ
	{"Speaker Switch", {"0"}},
	{"HP Left Switch", {"1"}},
	{"HP Right Switch", {"1"}},
	{"HP Driver Playback Volume", {"0", "0"}},
};

static struct audio_para_conf  spk_outpath_para_audio[] = { //ӦSpkͨ
	{"Speaker Switch", {"1"}},
	{"Speaker Driver Playback Volume", {"2"}}, //18dB
	{"HP Left Switch", {"0"}},
	{"HP Right Switch", {"0"}},
};

static  struct  audio_para_conf  main_mic_inpath_para_audio[] = { //ӦMic1lp_Mic1lmͨ
	{"MIC1LM P-Terminal", {"Off"}},
	{"MIC1RP P-Terminal", {"Off"}},
	{"MIC1LP P-Terminal", {"FFR 10 Ohm"}},
	{"MIC1LM M-Terminal", {"FFR 10 Ohm"}},

};

static  struct  audio_para_conf  aux_mic_inpath_para_audio[] = {//ӦMic1rpͨ
	{"MIC1LM P-Terminal", {"Off"}},
	{"MIC1RP P-Terminal", {"FFR 10 Ohm"}},
	{"MIC1LP P-Terminal", {"Off"}},
	{"MIC1LM M-Terminal", {"Off"}},
};

static struct audio_para_conf  handset_inoutpath_para_voice[] = {  //ӦHpͨMic1lp_Mic1lmͨ
	{"Mic PGA Capture Volume", {"12"}},
	//{"ADC Mute", {"0"}},
	//{"ADC Fine Capture Volume", {"0"}},
	{"DAC Left Input", {"Mono"}},
	{"DAC Right Input", {"Mono"}},
	{"Output Right From Right DAC", {"1"}},
	{"Output Left From Left DAC", {"1"}},
	{"HP Analog Playback Volume", {"127", "127"}},
	{"HP Driver Playback Switch", {"1", "1"}}, //7dB	
	{"Speaker Switch", {"0"}},
	{"DAC Playback Volume", {"129", "129"}},
	{"HP Left Switch", {"1"}},
	{"HP Right Switch", {"1"}},
	{"HP Driver Playback Volume", {"5", "5"}},
	{"MIC1LM P-Terminal", {"Off"}},
	{"MIC1RP P-Terminal", {"Off"}},
	{"MIC1LP P-Terminal", {"FFR 10 Ohm"}},
	{"MIC1LM M-Terminal", {"FFR 10 Ohm"}},
	{"ADC Capture Volume", {"24"}},
#ifndef USE_CAP_SUPPORT     
        
	{"voice processing path select", {"handset"}},  // handset speak headset bluetooth
#endif	
};

static struct audio_para_conf  headset_inoutpath_para_voice[] = {  //ӦHpͨ Mic1rpͨ
	{"Mic PGA Capture Volume", {"40"}},
	//{"ADC Mute", {"0"}},
	//{"ADC Fine Capture Volume", {"0"}},
	{"DAC Left Input", {"Mono"}},
	{"DAC Right Input", {"Mono"}},
	{"Output Right From Right DAC", {"1"}},
	{"Output Left From Left DAC", {"1"}},
	{"HP Analog Playback Volume", {"127", "127"}},
	{"HP Driver Playback Switch", {"1", "1"}}, //7dB	
	{"Speaker Switch", {"0"}},
	{"DAC Playback Volume ", {"129", "129"}},
	{"HP Left Switch", {"1"}},
	{"HP Right Switch", {"1"}},
	{"HP Driver Playback Switch", {"7", "7"}}, //7dB
	{"MIC1LM P-Terminal", {"Off"}},
	{"MIC1RP P-Terminal", {"FFR 10 Ohm"}},
	{"MIC1LP P-Terminal", {"Off"}},
	{"MIC1LM M-Terminal", {"Off"}},
	{"ADC Capture Volume", {"24"}},
#ifndef USE_CAP_SUPPORT     
	{"voice processing path select", {"headset"}}, // handset speak headset bluetooth
#endif	
};

static struct audio_para_conf  spk_inoutpath_para_voice[] = { //ӦSpkͨMic1lp_Mic1lmͨ
	{"Mic PGA Capture Volume", {"12"}},
	//{"ADC Mute", {"0"}},
	//{"ADC Fine Capture Volume", {"0"}},
	{"Speaker Analog Playback Volume", {"127"}},
	{"Speaker Driver Playback Switch", {"1"}},
	{"DAC Left Input", {"Mono"}},
	{"DAC Right Input", {"Mono"}},
	{"Output Right From Right DAC", {"1"}},
	{"Output Left From Left DAC", {"1"}},
	{"DAC Playback Volume", {"124", "124"}}, //-1.5dB
	{"Speaker Switch", {"1"}},
	{"Speaker Driver Playback Volume", {"0"}}, //18dB
	{"HP Left Switch", {"0"}},
	{"HP Right Switch", {"0"}},
	{"MIC1LM P-Terminal", {"Off"}},
	{"MIC1RP P-Terminal", {"Off"}},
	{"MIC1LP P-Terminal", {"FFR 10 Ohm"}},
	{"MIC1LM M-Terminal", {"FFR 10 Ohm"}},
	{"ADC Capture Volume", {"24"}},
#ifndef USE_CAP_SUPPORT     

	{"voice processing path select", {"speak"}}, // handset speak headset bluetooth
#endif	
};

#else 
static struct audio_para_conf  common_out_para_audio[] = {  //Ӧ
	{"Speaker Analog Playback Volume", {"127"}},
	{"Speaker Driver Playback Switch", {"1"}},
	{"DAC Left Input", {"Mono"}},
	{"DAC Right Input", {"Mono"}},
	{"Output Right From Right DAC", {"1"}},
	{"Output Left From Left DAC", {"1"}},
	{"HP Analog Playback Volume", {"127", "127"}},
	{"HP Driver Playback Switch", {"1", "1"}}, //7dB
};

static struct audio_para_conf  common_in_para_audio[] = {  //Ӧ
	{"Mic PGA Capture Volume", {"40"}},
	{"ADC Mute", {"0"}},
	{"ADC Fine Capture Volume", {"0"}},

};

static struct audio_para_conf  hp_outpath_para_audio[] = {  //ӦHpͨ
	{"Speaker Switch", {"0"}},
	{"HP Left Switch", {"1"}},
	{"HP Right Switch", {"1"}},
	{"HP Driver Playback Volume", {"0", "0"}},
};

static struct audio_para_conf  spk_outpath_para_audio[] = { //ӦSpkͨ
	{"Speaker Switch", {"1"}},
	{"Speaker Driver Playback Volume", {"2"}}, //18dB
	{"HP Left Switch", {"0"}},
	{"HP Right Switch", {"0"}},
};

static  struct  audio_para_conf  main_mic_inpath_para_audio[] = { //ӦMic1lp_Mic1lmͨ
	{"MIC1LM P-Terminal", {"Off"}},
	{"MIC1RP P-Terminal", {"Off"}},
	{"MIC1LP P-Terminal", {"FFR 10 Ohm"}},
	{"MIC1LM M-Terminal", {"FFR 10 Ohm"}},

};

static  struct  audio_para_conf  aux_mic_inpath_para_audio[] = {//ӦMic1rpͨ
	{"MIC1LM P-Terminal", {"Off"}},
	{"MIC1RP P-Terminal", {"FFR 10 Ohm"}},
	{"MIC1LP P-Terminal", {"Off"}},
	{"MIC1LM M-Terminal", {"Off"}},
};

static struct audio_para_conf  handset_inoutpath_para_voice[] = {  //ӦHpͨMic1lp_Mic1lmͨ
	{"Mic PGA Capture Volume", {"40"}},//analog gain control from 0 dB to 59.5 dB in steps of 0.5 dB
	{"ADC Mute", {"0"}},//ADC muting
	{"DAC Mute", {"0","0"}},//DAC muting and setting up a master gain control to control both channels occurs
	//{"ADC Fine Capture Volume", {"0"}},
	{"DAC Left Input", {"Mono"}},
	{"DAC Right Input", {"Mono"}},
	{"Output Right From Right DAC", {"1"}},
	{"Output Left From Left DAC", {"1"}},//"1" means DAC_L is firstly routed to the left-channel mixer amplifier, then routed HPL driver
	{"HP Analog Playback Volume", {"114", "114"}},//Analog Volume Control for Headphone and Speaker Outputs(D0~D6)
	{"HP Driver Playback Switch", {"1", "1"}}, // HPL/HPR driver is not muted
	{"Speaker Switch", {"0"}},//Analog Volume Control for Speaker Outputs(D7)
	{"DAC Playback Volume", {"135", "135"}},//DAC volume: -127 to 48??//0627ԽԽ
	{"HP Left Switch", {"1"}},//Analog Volume Control for Headphone Outputs(D7)
	{"HP Right Switch", {"1"}},
	{"HP Driver Playback Volume", {"9", "9"}},//HPL/HPR driver is 9dB(0~9)
	{"MIC1LM P-Terminal", {"Off"}},
	{"MIC1RP P-Terminal", {"Off"}},
	{"MIC1LP P-Terminal", {"FFR 10 Ohm"}},
	{"MIC1LM M-Terminal", {"FFR 10 Ohm"}},
	{"ADC Capture Volume", {"24"}},
#ifndef USE_CAP_SUPPORT
	{"voice processing path select", {"handset"}},  // handset speak headset bluetooth
#endif	
};

static struct audio_para_conf  headset_inoutpath_para_voice[] = {  //ӦHpͨ Mic1rpͨ
	{"Mic PGA Capture Volume", {"40"}},
	{"ADC Mute", {"0"}},
	{"DAC Mute", {"0","0"}},	
	//{"ADC Fine Capture Volume", {"0"}},
	{"DAC Left Input", {"Mono"}},
	{"DAC Right Input", {"Mono"}},
	{"Output Right From Right DAC", {"1"}},
	{"Output Left From Left DAC", {"1"}},
	{"HP Analog Playback Volume", {"127", "127"}},
	{"HP Driver Playback Switch", {"1", "1"}}, //7dB	
	{"Speaker Switch", {"0"}},
	{"DAC Playback Volume ", {"129", "129"}},
	{"HP Left Switch", {"1"}},
	{"HP Right Switch", {"1"}},
	{"HP Driver Playback Switch", {"7", "7"}}, //7dB
	{"MIC1LM P-Terminal", {"Off"}},
	{"MIC1RP P-Terminal", {"FFR 10 Ohm"}},
	{"MIC1LP P-Terminal", {"Off"}},
	{"MIC1LM M-Terminal", {"Off"}},
	{"ADC Capture Volume", {"24"}},
#ifndef USE_CAP_SUPPORT     
	{"voice processing path select", {"headset"}}, // handset speak headset bluetooth
#endif	
};

static struct audio_para_conf  spk_inoutpath_para_voice[] = { //ӦSpkͨMic1lp_Mic1lmͨ
	{"Mic PGA Capture Volume", {"20"}},
	{"ADC Mute", {"0"}},
	{"DAC Mute", {"0","0"}},
	//{"ADC Fine Capture Volume", {"0"}},
	{"Speaker Analog Playback Volume", {"116"}},
	{"Speaker Driver Playback Switch", {"1"}},
	{"DAC Left Input", {"Mono"}},
	{"DAC Right Input", {"Mono"}},
	{"Output Right From Right DAC", {"1"}},
	{"Output Left From Left DAC", {"1"}},
	{"DAC Playback Volume", {"130", "130"}}, //
	{"Speaker Switch", {"1"}},
	{"Speaker Driver Playback Volume", {"1"}}, //12dB //0~3 is 6dB~24dB(6-dB Steps)
	{"HP Left Switch", {"0"}},
	{"HP Right Switch", {"0"}},
	{"MIC1LM P-Terminal", {"Off"}},
	{"MIC1RP P-Terminal", {"Off"}},
	{"MIC1LP P-Terminal", {"FFR 10 Ohm"}},
	{"MIC1LM M-Terminal", {"FFR 10 Ohm"}},
	{"ADC Capture Volume", {"24"}},
#ifndef USE_CAP_SUPPORT     
        
	{"voice processing path select", {"speak"}}, // handset speak headset bluetooth
#endif	
};

#endif
static struct audio_para_conf output_dac_vol = 	{"DAC Playback Volume", {"129","129"}};

static struct audio_para_conf input_adc_vol = {"ADC Capture Volume", {"24"}};

static struct audio_para_conf dac_mute = {"DAC Mute", {"1", "1"}};
static struct audio_para_conf adc_mute = {"ADC Mute", {"1"}};

static struct audio_para_conf spk_path_onoff[] = {
	{"Speaker Switch", {"0"}},
};
static struct audio_para_conf rcv_path_onoff[] = {
	{"HP Left Switch", {"0"}},
	{"HP Right Switch", {"0"}},
};
static struct audio_para_conf earp_path_onoff[] = {
	{"HP Left Switch", {"0"}},
	{"HP Right Switch", {"0"}},
};
static int output_vol_conversion(int vol)
{
	switch(vol){
	case T_AUDIO_OUTPUT_VOL_LEVEL_0:
		return T_OUTPUT_VOL_MINUS_63_5DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_1:
		return T_OUTPUT_VOL_MINUS_27DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_2:
		return T_OUTPUT_VOL_MINUS_24DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_3:
		return T_OUTPUT_VOL_MINUS_21DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_4:
		return T_OUTPUT_VOL_MINUS_18DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_5:
		return T_OUTPUT_VOL_MINUS_15DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_6:
		return T_OUTPUT_VOL_MINUS_12DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_7:
		return T_OUTPUT_VOL_MINUS_9DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_8:
		return T_OUTPUT_VOL_MINUS_6DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_9:
		return T_OUTPUT_VOL_MINUS_3DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_10:
		return T_OUTPUT_VOL_0DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_11:
		return T_OUTPUT_VOL_3DB;
	default:
		return T_OUTPUT_VOL_0DB;
	}
}


static int input_vol_conversion(int vol)
{
	switch(vol) {
	case T_AUDIO_INPUT_VOL_LEVEL_0:
		return T_INPUT_VOL_MINUS_12DB;
	case T_AUDIO_INPUT_VOL_LEVEL_1:
		return T_INPUT_VOL_MINUS_7DB;
	case T_AUDIO_INPUT_VOL_LEVEL_2:
		return T_INPUT_VOL_MINUS_6DB;
	case T_AUDIO_INPUT_VOL_LEVEL_3:
		return T_INPUT_VOL_MINUS_5DB;
	case T_AUDIO_INPUT_VOL_LEVEL_4:
		return T_INPUT_VOL_MINUS_4DB;
	case T_AUDIO_INPUT_VOL_LEVEL_5:
		return T_INPUT_VOL_MINUS_3DB;
	case T_AUDIO_INPUT_VOL_LEVEL_6:
		return T_INPUT_VOL_MINUS_2DB;
	case T_AUDIO_INPUT_VOL_LEVEL_7:
		return T_INPUT_VOL_MINUS_1DB;
	case T_AUDIO_INPUT_VOL_LEVEL_8:
		return T_INPUT_VOL_0DB;
	case T_AUDIO_INPUT_VOL_LEVEL_9:
		return T_INPUT_VOL_1DB;
	case T_AUDIO_INPUT_VOL_LEVEL_10:
		return T_INPUT_VOL_2DB;
	case T_AUDIO_INPUT_VOL_LEVEL_11:
		return T_INPUT_VOL_3DB;
	default:
		return T_INPUT_VOL_0DB;
	}
}
#elif defined _USE_CODEC_ES8311
static struct audio_para_conf init_default_para[] = {  //ʼ

};

static struct audio_para_conf  common_out_para_audio[] = {  //Ӧ
    //{"DAC Soft Mute Control", {"0"}},


};


static struct audio_para_conf  common_in_para_audio[] = {  //Ӧ

	//{"Mic Gain Control", {"0"}},

};

static struct audio_para_conf  hp_outpath_para_audio[] = {  //ӦHpͨ
	{"MIC PGA GAIN", {"10"}},
	{"ADC SCALE", {"1"}},
	{"DMIC TYPE", {"dmic at high level"}},
	{"ADC RAMP RATE", {"4"}},
	{"ADC SDP MUTE", {"0"}},
	{"ADC INVERTED", {"0"}},
	{"ADC SYNC", {"0"}},
	{"ADC RAM CLR", {"0"}},
	{"ADC VOLUME", {"191"}},
	{"ALC ENABLE", {"0"}},
	{"ALC AUTOMUTE TYPE", {"automute disabled"}},
	{"ALC WIN SIZE", {"0"}},
	{"ALC MAX LEVEL", {"0"}},
	{"ALC MIN LEVEL", {"0"}},
	{"ALC AUTOMUTE WINSIZE", {"0"}},
	{"ALC AUTOMUTE GATE THRESHOLD", {"0"}},
	{"ALC AUTOMUTE VOLUME", {"0"}},
	{"ADC FS MODE", {"0"}},
	{"DAC SDP MUTE", {"0"}},
	{"DAC DEM  MUTE", {"0"}},
	{"DAC INVERT", {"0"}},
	{"DAC RAM CLR", {"0"}},
	{"DAC DSM MUTE", {"mute to 8"}},
	{"DAC OFFSET", {"0"}},
	{"DAC VOLUME", {"191"}},
	{"DRC ENABLE", {"0"}},
	{"DRC WIN SIZE", {"0"}},
	{"DRC MAX LEVEL", {"0"}},
	{"DRC MIN LEVEL", {"0"}},
	{"DAC RAMP RATE", {"4"}},
	{"AEC MODE", {"adc left, adc right"}},
	{"ADC DATA TO DAC TEST MODE", {"disable"}},
	{"MCLK INVERT", {"0"}},
	{"BCLK INVERT", {"0"}},
	{"MCLK SOURCE", {"from mclk pin"}},
	
	{"DMIC MUX", {"DMIC DISABLE"}},
	{"SDP OUT MUX", {"FROM ADC OUT"}},
	{"DAC SDP SRC MUX", {"SELECT SDP LEFT DATA"}},



};

static struct audio_para_conf  spk_outpath_para_audio[] = { //ӦSpkͨ
	{"MIC PGA GAIN", {"10"}},
	{"ADC SCALE", {"1"}},
	{"DMIC TYPE", {"dmic at high level"}},
	{"ADC RAMP RATE", {"4"}},
	{"ADC SDP MUTE", {"0"}},
	{"ADC INVERTED", {"0"}},
	{"ADC SYNC", {"0"}},
	{"ADC RAM CLR", {"0"}},
	{"ADC VOLUME", {"191"}},
	{"ALC ENABLE", {"0"}},
	{"ALC AUTOMUTE TYPE", {"automute disabled"}},
	{"ALC WIN SIZE", {"0"}},
	{"ALC MAX LEVEL", {"0"}},
	{"ALC MIN LEVEL", {"0"}},
	{"ALC AUTOMUTE WINSIZE", {"0"}},
	{"ALC AUTOMUTE GATE THRESHOLD", {"0"}},
	{"ALC AUTOMUTE VOLUME", {"0"}},
	{"ADC FS MODE", {"0"}},
	{"DAC SDP MUTE", {"0"}},
	{"DAC DEM  MUTE", {"0"}},
	{"DAC INVERT", {"0"}},
	{"DAC RAM CLR", {"0"}},
	{"DAC DSM MUTE", {"mute to 8"}},
	{"DAC OFFSET", {"0"}},
	{"DAC VOLUME", {"191"}},
	{"DRC ENABLE", {"0"}},
	{"DRC WIN SIZE", {"0"}},
	{"DRC MAX LEVEL", {"0"}},
	{"DRC MIN LEVEL", {"0"}},
	{"DAC RAMP RATE", {"4"}},
	{"AEC MODE", {"adc left, adc right"}},
	{"ADC DATA TO DAC TEST MODE", {"disable"}},
	{"MCLK INVERT", {"0"}},
	{"BCLK INVERT", {"0"}},
	{"MCLK SOURCE", {"from mclk pin"}},
	
	{"DMIC MUX", {"DMIC DISABLE"}},
	{"SDP OUT MUX", {"FROM ADC OUT"}},
	{"DAC SDP SRC MUX", {"SELECT SDP LEFT DATA"}},


};

static  struct  audio_para_conf  main_mic_inpath_para_audio[] = { //ӦMic1lp_Mic1lmͨ

    {"MIC PGA GAIN", {"10"}},
	{"ADC SCALE", {"1"}},
	{"DMIC TYPE", {"dmic at high level"}},
	{"ADC RAMP RATE", {"4"}},
	{"ADC SDP MUTE", {"0"}},
	{"ADC INVERTED", {"0"}},
	{"ADC SYNC", {"0"}},
	{"ADC RAM CLR", {"0"}},
	{"ADC VOLUME", {"191"}},
	{"ALC ENABLE", {"0"}},
	{"ALC AUTOMUTE TYPE", {"automute disabled"}},
	{"ALC WIN SIZE", {"0"}},
	{"ALC MAX LEVEL", {"0"}},
	{"ALC MIN LEVEL", {"0"}},
	{"ALC AUTOMUTE WINSIZE", {"0"}},
	{"ALC AUTOMUTE GATE THRESHOLD", {"0"}},
	{"ALC AUTOMUTE VOLUME", {"0"}},
	{"ADC FS MODE", {"0"}},
	{"DAC SDP MUTE", {"0"}},
	{"DAC DEM  MUTE", {"0"}},
	{"DAC INVERT", {"0"}},
	{"DAC RAM CLR", {"0"}},
	{"DAC DSM MUTE", {"mute to 8"}},
	{"DAC OFFSET", {"0"}},
	{"DAC VOLUME", {"191"}},
	{"DRC ENABLE", {"0"}},
	{"DRC WIN SIZE", {"0"}},
	{"DRC MAX LEVEL", {"0"}},
	{"DRC MIN LEVEL", {"0"}},
	{"DAC RAMP RATE", {"4"}},
	{"AEC MODE", {"adc left, adc right"}},
	{"ADC DATA TO DAC TEST MODE", {"disable"}},
	{"MCLK INVERT", {"0"}},
	{"BCLK INVERT", {"0"}},
	{"MCLK SOURCE", {"from mclk pin"}},
	
	{"DMIC MUX", {"DMIC DISABLE"}},
	{"SDP OUT MUX", {"FROM ADC OUT"}},
	{"DAC SDP SRC MUX", {"SELECT SDP LEFT DATA"}},

};

static  struct  audio_para_conf  aux_mic_inpath_para_audio[] = {//ӦMic1rpͨ

   {"MIC PGA GAIN", {"10"}},
	{"ADC SCALE", {"1"}},
	{"DMIC TYPE", {"dmic at high level"}},
	{"ADC RAMP RATE", {"4"}},
	{"ADC SDP MUTE", {"0"}},
	{"ADC INVERTED", {"0"}},
	{"ADC SYNC", {"0"}},
	{"ADC RAM CLR", {"0"}},
	{"ADC VOLUME", {"191"}},
	{"ALC ENABLE", {"0"}},
	{"ALC AUTOMUTE TYPE", {"automute disabled"}},
	{"ALC WIN SIZE", {"0"}},
	{"ALC MAX LEVEL", {"0"}},
	{"ALC MIN LEVEL", {"0"}},
	{"ALC AUTOMUTE WINSIZE", {"0"}},
	{"ALC AUTOMUTE GATE THRESHOLD", {"0"}},
	{"ALC AUTOMUTE VOLUME", {"0"}},
	{"ADC FS MODE", {"0"}},
	{"DAC SDP MUTE", {"0"}},
	{"DAC DEM  MUTE", {"0"}},
	{"DAC INVERT", {"0"}},
	{"DAC RAM CLR", {"0"}},
	{"DAC DSM MUTE", {"mute to 8"}},
	{"DAC OFFSET", {"0"}},
	{"DAC VOLUME", {"191"}},
	{"DRC ENABLE", {"0"}},
	{"DRC WIN SIZE", {"0"}},
	{"DRC MAX LEVEL", {"0"}},
	{"DRC MIN LEVEL", {"0"}},
	{"DAC RAMP RATE", {"4"}},
	{"AEC MODE", {"adc left, adc right"}},
	{"ADC DATA TO DAC TEST MODE", {"disable"}},
	{"MCLK INVERT", {"0"}},
	{"BCLK INVERT", {"0"}},
	{"MCLK SOURCE", {"from mclk pin"}},
	
	{"DMIC MUX", {"DMIC DISABLE"}},
	{"SDP OUT MUX", {"FROM ADC OUT"}},
	{"DAC SDP SRC MUX", {"SELECT SDP LEFT DATA"}},


	
};

static struct audio_para_conf  handset_inoutpath_para_voice[] = {  //ӦHpͨMic1lp_Mic1lmͨ
    {"MIC PGA GAIN", {"10"}},
	{"ADC SCALE", {"1"}},
	{"DMIC TYPE", {"dmic at high level"}},
	{"ADC RAMP RATE", {"4"}},
	{"ADC SDP MUTE", {"0"}},
	{"ADC INVERTED", {"0"}},
	{"ADC SYNC", {"0"}},
	{"ADC RAM CLR", {"0"}},
	{"ADC VOLUME", {"191"}},
	{"ALC ENABLE", {"0"}},
	{"ALC AUTOMUTE TYPE", {"automute disabled"}},
	{"ALC WIN SIZE", {"0"}},
	{"ALC MAX LEVEL", {"0"}},
	{"ALC MIN LEVEL", {"0"}},
	{"ALC AUTOMUTE WINSIZE", {"0"}},
	{"ALC AUTOMUTE GATE THRESHOLD", {"0"}},
	{"ALC AUTOMUTE VOLUME", {"0"}},
	{"ADC FS MODE", {"0"}},
	{"DAC SDP MUTE", {"0"}},
	{"DAC DEM  MUTE", {"0"}},
	{"DAC INVERT", {"0"}},
	{"DAC RAM CLR", {"0"}},
	{"DAC DSM MUTE", {"mute to 8"}},
	{"DAC OFFSET", {"0"}},
	{"DAC VOLUME", {"191"}},
	{"DRC ENABLE", {"0"}},
	{"DRC WIN SIZE", {"0"}},
	{"DRC MAX LEVEL", {"0"}},
	{"DRC MIN LEVEL", {"0"}},
	{"DAC RAMP RATE", {"4"}},
	{"AEC MODE", {"adc left, adc right"}},
	{"ADC DATA TO DAC TEST MODE", {"disable"}},
	{"MCLK INVERT", {"0"}},
	{"BCLK INVERT", {"0"}},
	{"MCLK SOURCE", {"from mclk pin"}},
	
	{"DMIC MUX", {"DMIC DISABLE"}},
	{"SDP OUT MUX", {"FROM ADC OUT"}},
	{"DAC SDP SRC MUX", {"SELECT SDP LEFT DATA"}},


	
};

static struct audio_para_conf  headset_inoutpath_para_voice[] = {  //ӦHpͨ Mic1rpͨ
      {"MIC PGA GAIN", {"10"}},
	{"ADC SCALE", {"1"}},
	{"DMIC TYPE", {"dmic at high level"}},
	{"ADC RAMP RATE", {"4"}},
	{"ADC SDP MUTE", {"0"}},
	{"ADC INVERTED", {"0"}},
	{"ADC SYNC", {"0"}},
	{"ADC RAM CLR", {"0"}},
	{"ADC VOLUME", {"191"}},
	{"ALC ENABLE", {"0"}},
	{"ALC AUTOMUTE TYPE", {"automute disabled"}},
	{"ALC WIN SIZE", {"0"}},
	{"ALC MAX LEVEL", {"0"}},
	{"ALC MIN LEVEL", {"0"}},
	{"ALC AUTOMUTE WINSIZE", {"0"}},
	{"ALC AUTOMUTE GATE THRESHOLD", {"0"}},
	{"ALC AUTOMUTE VOLUME", {"0"}},
	{"ADC FS MODE", {"0"}},
	{"DAC SDP MUTE", {"0"}},
	{"DAC DEM  MUTE", {"0"}},
	{"DAC INVERT", {"0"}},
	{"DAC RAM CLR", {"0"}},
	{"DAC DSM MUTE", {"mute to 8"}},
	{"DAC OFFSET", {"0"}},
	{"DAC VOLUME", {"191"}},
	{"DRC ENABLE", {"0"}},
	{"DRC WIN SIZE", {"0"}},
	{"DRC MAX LEVEL", {"0"}},
	{"DRC MIN LEVEL", {"0"}},
	{"DAC RAMP RATE", {"4"}},
	{"AEC MODE", {"adc left, adc right"}},
	{"ADC DATA TO DAC TEST MODE", {"disable"}},
	{"MCLK INVERT", {"0"}},
	{"BCLK INVERT", {"0"}},
	{"MCLK SOURCE", {"from mclk pin"}},
	
	{"DMIC MUX", {"DMIC DISABLE"}},
	{"SDP OUT MUX", {"FROM ADC OUT"}},
	{"DAC SDP SRC MUX", {"SELECT SDP LEFT DATA"}},
};

static struct audio_para_conf  spk_inoutpath_para_voice[] = { //ӦSpkͨMic1lp_Mic1lmͨ

     {"MIC PGA GAIN", {"10"}},
	{"ADC SCALE", {"1"}},
	{"DMIC TYPE", {"dmic at high level"}},
	{"ADC RAMP RATE", {"4"}},
	{"ADC SDP MUTE", {"0"}},
	{"ADC INVERTED", {"0"}},
	{"ADC SYNC", {"0"}},
	{"ADC RAM CLR", {"0"}},
	{"ADC VOLUME", {"191"}},
	{"ALC ENABLE", {"0"}},
	{"ALC AUTOMUTE TYPE", {"automute disabled"}},
	{"ALC WIN SIZE", {"0"}},
	{"ALC MAX LEVEL", {"0"}},
	{"ALC MIN LEVEL", {"0"}},
	{"ALC AUTOMUTE WINSIZE", {"0"}},
	{"ALC AUTOMUTE GATE THRESHOLD", {"0"}},
	{"ALC AUTOMUTE VOLUME", {"0"}},
	{"ADC FS MODE", {"0"}},
	{"DAC SDP MUTE", {"0"}},
	{"DAC DEM  MUTE", {"0"}},
	{"DAC INVERT", {"0"}},
	{"DAC RAM CLR", {"0"}},
	{"DAC DSM MUTE", {"mute to 8"}},
	{"DAC OFFSET", {"0"}},
	{"DAC VOLUME", {"191"}},
	{"DRC ENABLE", {"0"}},
	{"DRC WIN SIZE", {"0"}},
	{"DRC MAX LEVEL", {"0"}},
	{"DRC MIN LEVEL", {"0"}},
	{"DAC RAMP RATE", {"4"}},
	{"AEC MODE", {"adc left, adc right"}},
	{"ADC DATA TO DAC TEST MODE", {"disable"}},
	{"MCLK INVERT", {"0"}},
	{"BCLK INVERT", {"0"}},
	{"MCLK SOURCE", {"from mclk pin"}},
	
	{"DMIC MUX", {"DMIC DISABLE"}},
	{"SDP OUT MUX", {"FROM ADC OUT"}},
	{"DAC SDP SRC MUX", {"SELECT SDP LEFT DATA"}},
};


static struct audio_para_conf output_dac_vol = {
	//"Playback Volume", {"255"}
	{"DAC VOLUME", {"191"}},

	
};

static struct audio_para_conf input_adc_vol = {
	//"Capture Volume", {"255"}
	{"ADC VOLUME", {"191"}},

};

static struct audio_para_conf dac_mute = {
	//"DAC MUTE", {"1"}
	{"DAC SDP MUTE", {"0"}},
	{"DAC DEM  MUTE", {"0"}},


};
static struct audio_para_conf adc_mute = {
	//"Input Boost Stage PGA Mute Switch", {"0"}
	{"ADC SDP MUTE", {"0"}},

	
};

static struct audio_para_conf spk_path_onoff[] = {
	//{"Mono Mixer PCM Playback Switch", {"0"}},
	{"DAC SDP MUTE", {"0"}},
	{"DAC DEM  MUTE", {"0"}},


};

static struct audio_para_conf rcv_path_onoff[] = {
	//{"Mono Mixer PCM Playback Switch", {"0"}},
	{"ADC SDP MUTE", {"0"}},

};

static struct audio_para_conf earp_path_onoff[] = {
	//{"Speaker Mixer PCM Playback Switch", {"0"}},
	{"DAC SDP MUTE", {"0"}},
	{"DAC DEM  MUTE", {"0"}},
};

/* yu.dong@20240627 [T106BUG-615]CODEC 8311 using voice_demo to set codec volume has no effect start */

/* yu.dong@20240716 [T106BUG-615]Abnormal whistling tone heard on the side of the phone when dialing in 3G network start */
enum t_input_vol {
    T_INPUT_VOL_MINUS_96DB = 0,
    T_INPUT_VOL_MINUS_95DB = 2,
    T_INPUT_VOL_MINUS_90DB = 12,
    T_INPUT_VOL_MINUS_85DB = 22,
    T_INPUT_VOL_MINUS_80DB = 32,
    T_INPUT_VOL_MINUS_75DB = 42,
    T_INPUT_VOL_MINUS_70DB = 52,
    T_INPUT_VOL_MINUS_65DB = 62,
    T_INPUT_VOL_MINUS_60DB = 72,
    T_INPUT_VOL_MINUS_55DB = 82,
    T_INPUT_VOL_MINUS_50DB = 92,
    T_INPUT_VOL_MINUS_45DB = 102,
    T_INPUT_VOL_MINUS_40DB = 112,
    T_INPUT_VOL_MINUS_35DB = 122,
    T_INPUT_VOL_MINUS_30DB = 132,
    T_INPUT_VOL_MINUS_25DB = 142,
    T_INPUT_VOL_MINUS_20DB = 152,
    T_INPUT_VOL_MINUS_15DB = 162,
    T_INPUT_VOL_MINUS_10DB = 172,
    T_INPUT_VOL_MINUS_7DB  = 178,
    T_INPUT_VOL_MINUS_6DB  = 180,
    T_INPUT_VOL_MINUS_5DB  = 182,
    T_INPUT_VOL_MINUS_4DB  = 184,
    T_INPUT_VOL_MINUS_3DB  = 186,
    T_INPUT_VOL_MINUS_2DB  = 188,
    T_INPUT_VOL_MINUS_1DB  = 190,
    T_INPUT_VOL_0DB        = 192
};

static int input_vol_conversion(int vol)
{
    switch(vol) {
    case T_AUDIO_INPUT_VOL_LEVEL_0:
        return T_INPUT_VOL_MINUS_96DB;
    case T_AUDIO_INPUT_VOL_LEVEL_1:
        return T_INPUT_VOL_MINUS_30DB;
    case T_AUDIO_INPUT_VOL_LEVEL_2:
        return T_INPUT_VOL_MINUS_25DB;
    case T_AUDIO_INPUT_VOL_LEVEL_3:
        return T_INPUT_VOL_MINUS_20DB;
    case T_AUDIO_INPUT_VOL_LEVEL_4:
        return T_INPUT_VOL_MINUS_15DB;
    case T_AUDIO_INPUT_VOL_LEVEL_5:
        return T_INPUT_VOL_MINUS_10DB;
    case T_AUDIO_INPUT_VOL_LEVEL_6:
        return T_INPUT_VOL_MINUS_7DB;
    case T_AUDIO_INPUT_VOL_LEVEL_7:
        return T_INPUT_VOL_MINUS_4DB;
    case T_AUDIO_INPUT_VOL_LEVEL_8:
        return T_INPUT_VOL_MINUS_3DB;
    case T_AUDIO_INPUT_VOL_LEVEL_9:
        return T_INPUT_VOL_MINUS_2DB;
    case T_AUDIO_INPUT_VOL_LEVEL_10:
        return T_INPUT_VOL_MINUS_1DB;
    case T_AUDIO_INPUT_VOL_LEVEL_11:
        return T_INPUT_VOL_0DB;
    default:
        return T_INPUT_VOL_MINUS_30DB;
    }
}
/* yu.dong@20240716 [T106BUG-615]Abnormal whistling tone heard on the side of the phone when dialing in 3G network end */

enum t_output_vol {
    T_OUTPUT_VOL_MINUS_96DB = 0,
    T_OUTPUT_VOL_MINUS_95DB = 2,
    T_OUTPUT_VOL_MINUS_90DB = 12,
    T_OUTPUT_VOL_MINUS_85DB = 22,
    T_OUTPUT_VOL_MINUS_80DB = 32,
    T_OUTPUT_VOL_MINUS_75DB = 42,
    T_OUTPUT_VOL_MINUS_70DB = 52,
    T_OUTPUT_VOL_MINUS_65DB = 62,
    T_OUTPUT_VOL_MINUS_60DB = 72,
    T_OUTPUT_VOL_MINUS_55DB = 82,
    T_OUTPUT_VOL_MINUS_50DB = 92,
    T_OUTPUT_VOL_MINUS_45DB = 102,
    T_OUTPUT_VOL_MINUS_40DB = 112,
    T_OUTPUT_VOL_MINUS_35DB = 122,
    T_OUTPUT_VOL_MINUS_30DB = 132,
    T_OUTPUT_VOL_MINUS_25DB = 142,
    T_OUTPUT_VOL_MINUS_20DB = 152,
    T_OUTPUT_VOL_MINUS_15DB = 162,
    T_OUTPUT_VOL_MINUS_10DB = 172,
    T_OUTPUT_VOL_MINUS_7DB  = 178,
    T_OUTPUT_VOL_MINUS_6DB  = 180,
    T_OUTPUT_VOL_MINUS_5DB  = 182,
    T_OUTPUT_VOL_MINUS_4DB  = 184,
    T_OUTPUT_VOL_MINUS_3DB  = 186,
    T_OUTPUT_VOL_MINUS_2DB  = 188,
    T_OUTPUT_VOL_MINUS_1DB  = 190,
    T_OUTPUT_VOL_0DB        = 192
};

 static int output_vol_conversion(int vol)
{
    switch(vol){
    case T_AUDIO_OUTPUT_VOL_LEVEL_0:
        return T_OUTPUT_VOL_MINUS_96DB;
    case T_AUDIO_OUTPUT_VOL_LEVEL_1:
        return T_OUTPUT_VOL_MINUS_45DB;
    case T_AUDIO_OUTPUT_VOL_LEVEL_2:
        return T_OUTPUT_VOL_MINUS_40DB;
    case T_AUDIO_OUTPUT_VOL_LEVEL_3:
        return T_OUTPUT_VOL_MINUS_35DB;
    case T_AUDIO_OUTPUT_VOL_LEVEL_4:
        return T_OUTPUT_VOL_MINUS_30DB;
    case T_AUDIO_OUTPUT_VOL_LEVEL_5:
        return T_OUTPUT_VOL_MINUS_25DB;
    case T_AUDIO_OUTPUT_VOL_LEVEL_6:
        return T_OUTPUT_VOL_MINUS_20DB;
    case T_AUDIO_OUTPUT_VOL_LEVEL_7:
        return T_OUTPUT_VOL_MINUS_15DB;
    case T_AUDIO_OUTPUT_VOL_LEVEL_8:
        return T_OUTPUT_VOL_MINUS_10DB;
    case T_AUDIO_OUTPUT_VOL_LEVEL_9:
        return T_OUTPUT_VOL_MINUS_6DB;
    case T_AUDIO_OUTPUT_VOL_LEVEL_10:
        return T_OUTPUT_VOL_MINUS_3DB;
    case T_AUDIO_OUTPUT_VOL_LEVEL_11:
        return T_OUTPUT_VOL_0DB;
    default:
        return T_OUTPUT_VOL_0DB;
    }
}

/* yu.dong@20240627 [T106BUG-615]CODEC 8311 using voice_demo to set codec volume has no effect end */

//l.yang modify for bug id T106BUG-337 2023/11/9 start
#elif defined _USE_CODEC_TI3104

static struct audio_para_conf init_default_para[] = {  //

};

static struct audio_para_conf  common_out_para_audio[] = {  //
    //{"DAC Soft Mute Control", {"0"}},
};


static struct audio_para_conf  common_in_para_audio[] = {  //
	//{"Mic Gain Control", {"0"}},
};

static struct audio_para_conf  hp_outpath_para_audio[] = {  //Hp
	{"Line Playback Switch", {"1","1"}},
	{"PCM Playback Volume", {"110","110"}},
	{"Line Playback Volume", {"8","8"}},
	{"Line DAC Playback Volume", {"110","110"}},
};

static struct audio_para_conf  spk_outpath_para_audio[] = { //Spk
	{"Line Playback Switch", {"1","1"}},
	{"PCM Playback Volume", {"110","110"}},
	{"Line Playback Volume", {"8","8"}},
	{"Line DAC Playback Volume", {"110","110"}},
};

static  struct  audio_para_conf  main_mic_inpath_para_audio[] = { //Mic1lp_Mic1lm
	{"MicBias VG", {"1"}},
	{"PGA Capture Volume", {"50","50"}}, //yu.dong@20240821 [AUDIO] Fix audio return tone problem on speakerphone
	{"PGA Capture Switch", {"1","1"}},
	{"ADC HPF Cut-off", {"1","1"}},

	{"Left PGA Mixer Mic2L Switch",{"1"}},
	{"Left PGA Mixer Mic2R Switch",{"1"}},
	{"Right PGA Mixer Mic2L Switch",{"1"}},
	{"Right PGA Mixer Mic2R Switch",{"1"}},
};

static  struct  audio_para_conf  aux_mic_inpath_para_audio[] = {//Mic1rp
	{"MicBias VG", {"1"}},
	{"PGA Capture Volume", {"50","50"}}, //yu.dong@20240821 [AUDIO] Fix audio return tone problem on speakerphone
	{"PGA Capture Switch", {"1","1"}},
	{"ADC HPF Cut-off", {"1","1"}},

	{"Left PGA Mixer Mic2L Switch",{"1"}},
	{"Left PGA Mixer Mic2R Switch",{"1"}},
	{"Right PGA Mixer Mic2L Switch",{"1"}},
	{"Right PGA Mixer Mic2R Switch",{"1"}},
};

static struct audio_para_conf  handset_inoutpath_para_voice[] = {  //HpMic1lp_Mic1lm
	//in
	//#0x2d b6 pga mute
	{"MicBias VG", {"1"}},
	{"PGA Capture Volume", {"50","50"}}, //yu.dong@20240821 [AUDIO] Fix audio return tone problem on speakerphone
	{"PGA Capture Switch", {"1","1"}},
	{"ADC HPF Cut-off", {"1","1"}},

	{"Left PGA Mixer Mic2L Switch",{"1"}},
	{"Left PGA Mixer Mic2R Switch",{"1"}},
	{"Right PGA Mixer Mic2L Switch",{"1"}},
	{"Right PGA Mixer Mic2R Switch",{"1"}},

	//out
	{"Line Playback Switch", {"1","1"}},
	{"PCM Playback Volume", {"110","110"}},
	{"Line Playback Volume", {"8","8"}},
	{"Line DAC Playback Volume", {"110","110"}},

	//voice
	#ifndef USE_CAP_SUPPORT
	{"voice processing path select", {"handset"}},  // handset speak headset bluetooth
	#endif
};

static struct audio_para_conf  headset_inoutpath_para_voice[] = {  //Hp Mic1rp
	//in
	//#0x2d b6 pga mute
	{"MicBias VG", {"1"}},
	{"PGA Capture Volume", {"50","50"}}, //yu.dong@20240821 [AUDIO] Fix audio return tone problem on speakerphone
	{"PGA Capture Switch", {"1","1"}},
	{"ADC HPF Cut-off", {"1","1"}},

	{"Left PGA Mixer Mic2L Switch",{"1"}},
	{"Left PGA Mixer Mic2R Switch",{"1"}},
	{"Right PGA Mixer Mic2L Switch",{"1"}},
	{"Right PGA Mixer Mic2R Switch",{"1"}},

	//out
	{"Line Playback Switch", {"1","1"}},
	{"PCM Playback Volume", {"110","110"}},
	{"Line Playback Volume", {"8","8"}},
	{"Line DAC Playback Volume", {"110","110"}},

	//voice
	#ifndef USE_CAP_SUPPORT
	{"voice processing select", {"headset"}}, // handset speak headset bluetooth
	#endif
};

static struct audio_para_conf  spk_inoutpath_para_voice[] = { //SpkMic1lp_Mic1lm
	//in
	//#0x2d b6 pga mute
	{"MicBias VG", {"1"}},
	{"PGA Capture Volume", {"50","50"}}, //yu.dong@20240821 [AUDIO] Fix audio return tone problem on speakerphone
	{"PGA Capture Switch", {"1","1"}},
	{"ADC HPF Cut-off", {"1","1"}},

	{"Left PGA Mixer Mic2L Switch",{"1"}},
	{"Left PGA Mixer Mic2R Switch",{"1"}},
	{"Right PGA Mixer Mic2L Switch",{"1"}},
	{"Right PGA Mixer Mic2R Switch",{"1"}},

	//out
	{"Line Playback Switch", {"1","1"}},
	{"PCM Playback Volume", {"110","110"}},
	{"Line Playback Volume", {"8","8"}},
	{"Line DAC Playback Volume", {"110","110"}},
	//voice

	#ifndef USE_CAP_SUPPORT
	{"voice processing path select", {"speak"}}, // handset speak headset bluetooth
	#endif
};

static struct audio_para_conf output_dac_vol = {
   {"PCM Playback Volume", {"110","110"}},
};

static struct audio_para_conf input_adc_vol = {
	{"PGA Capture Volume", {"50","50"}}, //yu.dong@20240821 [AUDIO] Fix audio return tone problem on speakerphone
};

static struct audio_para_conf dac_mute = {
	"Line Playback Switch", {"0","0"}
};

static struct audio_para_conf adc_mute = {
    "MicBias VG", {"0"}
};

static struct audio_para_conf spk_path_onoff[] = {
	{"Mono Mixer PCM Playback Switch", {"0"}},
};

static struct audio_para_conf rcv_path_onoff[] = {
	{"Mono Mixer PCM Playback Switch", {"0"}},
};

static struct audio_para_conf earp_path_onoff[] = {
	{"Speaker Mixer PCM Playback Switch", {"0"}},
};

static int output_vol_conversion(int vol)
{
	return 120;
}

static int input_vol_conversion(int vol)
{
	return 100;
}
//l.yang modify for bug id T106BUG-337 2023/11/9 end

#elif defined _USE_CODEC_ES8374


enum t_output_vol {
    T_OUTPUT_VOL_MINUS_96DB = 0,
	T_OUTPUT_VOL_MINUS_95DB = 2,
	T_OUTPUT_VOL_MINUS_90DB = 12,
	T_OUTPUT_VOL_MINUS_85DB = 22,
    T_OUTPUT_VOL_MINUS_80DB = 32,
    T_OUTPUT_VOL_MINUS_75DB = 42,
    T_OUTPUT_VOL_MINUS_70DB = 52,
    T_OUTPUT_VOL_MINUS_65DB = 62,
    T_OUTPUT_VOL_MINUS_60DB = 72,
    T_OUTPUT_VOL_MINUS_55DB = 82,
    T_OUTPUT_VOL_MINUS_50DB = 92,
    T_OUTPUT_VOL_MINUS_45DB = 102,
    T_OUTPUT_VOL_MINUS_40DB = 112,
    T_OUTPUT_VOL_MINUS_35DB = 122,
    T_OUTPUT_VOL_MINUS_30DB = 132,
    T_OUTPUT_VOL_MINUS_25DB = 142,
    T_OUTPUT_VOL_MINUS_20DB = 152,
    T_OUTPUT_VOL_MINUS_15DB = 162,
    T_OUTPUT_VOL_MINUS_10DB = 172,
    T_OUTPUT_VOL_MINUS_7DB  = 178,
    T_OUTPUT_VOL_MINUS_6DB  = 180,
    T_OUTPUT_VOL_MINUS_5DB  = 182,
    T_OUTPUT_VOL_MINUS_4DB  = 184,
    T_OUTPUT_VOL_MINUS_3DB  = 186,
    T_OUTPUT_VOL_MINUS_2DB  = 188,
    T_OUTPUT_VOL_MINUS_1DB  = 190,
    T_OUTPUT_VOL_0DB        = 192
};

enum t_input_vol {
    T_INPUT_VOL_MINUS_96DB = 0,
	T_INPUT_VOL_MINUS_95DB = 2,
	T_INPUT_VOL_MINUS_90DB = 12,
	T_INPUT_VOL_MINUS_85DB = 22,
    T_INPUT_VOL_MINUS_80DB = 32,
    T_INPUT_VOL_MINUS_75DB = 42,
    T_INPUT_VOL_MINUS_70DB = 52,
    T_INPUT_VOL_MINUS_65DB = 62,
    T_INPUT_VOL_MINUS_60DB = 72,
    T_INPUT_VOL_MINUS_55DB = 82,
    T_INPUT_VOL_MINUS_50DB = 92,
    T_INPUT_VOL_MINUS_45DB = 102,
    T_INPUT_VOL_MINUS_40DB = 112,
    T_INPUT_VOL_MINUS_35DB = 122,
    T_INPUT_VOL_MINUS_30DB = 132,
    T_INPUT_VOL_MINUS_25DB = 142,
    T_INPUT_VOL_MINUS_20DB = 152,
    T_INPUT_VOL_MINUS_15DB = 162,
    T_INPUT_VOL_MINUS_10DB = 172,
    T_INPUT_VOL_MINUS_7DB  = 178,
    T_INPUT_VOL_MINUS_6DB  = 180,
    T_INPUT_VOL_MINUS_5DB  = 182,
    T_INPUT_VOL_MINUS_4DB  = 184,
    T_INPUT_VOL_MINUS_3DB  = 186,
    T_INPUT_VOL_MINUS_2DB  = 188,
    T_INPUT_VOL_MINUS_1DB  = 190,
    T_INPUT_VOL_0DB        = 192
};


static struct audio_para_conf init_default_para[] = {  //ʼ
	{"DMIC MUX", {"0"}},	
	{"SDP OUT MUX", {"0"}},
	{"ALC MUX", {"0"}},	
	{"D2SE MIC BOOST GAIN", {"1"}},
	{"LIN PGA GAIN", {"6"}},	
	{"ADC Capture Volume", {"192"}},	
	{"ALC Capture Max PGA", {"15"}},
	{"DAC MUTE", {"0"}},  	  
	{"DAC Playback Volume", {"120"}},	
	{"DAC SDP SRC MUX",  {"0"}},  
	{"DAC SRC MUX",  {"0"}} 
};

//#ifdef  _USE_7520V3_PHONE_TYPE_C31F
#if ( defined _USE_7520V3_PHONE_TYPE_C31F || defined _USE_7520V3_PHONE_TYPE_WTWD )

static struct audio_para_conf  common_out_para_audio[] = {  //Ӧ
	{"DAC MUTE", {"0"}},  	  
	//{"DAC Playback Volume", {"120"}},	
	{"DAC SDP SRC MUX",  {"0"}},  
	{"DAC SRC MUX",  {"0"}} 
};

static struct audio_para_conf  common_in_para_audio[] = {  //Ӧ
	{"DMIC MUX", {"0"}},	
	{"SDP OUT MUX", {"0"}},
	{"ADC Soft Ramp", {"0"}},	
	{"ADC HPF COEFFICIENT", {"5"}},
#if 0	
	{"ALC MUX", {"1"}},	
	{"ALC Capture Target Volume", {"5"}},
	{"ALC Capture Max PGA", {"11"}},
	{"ALC Capture Min PGA", {"2"}},
	{"ALC Capture Hold Time", {"0"}},
	{"ALC Capture Decay Time", {"0"}},
	{"ALC Capture Attack Time", {"0"}},
	{"ALC WIN SIZE", {"6"}},
	{"ALC Capture NG Threshold", {"14"}},
	{"ALC Capture NG Type", {"0"}},
	{"ALC Capture NG Switch", {"0"}},
#endif
	{"D2SE MIC BOOST GAIN", {"1"}},
	{"LIN PGA GAIN", {"6"}},	
	{"ADC Capture Volume", {"192"}},	
};

#ifdef _USE_7520V3_PHONE_TYPE_WTWD
static struct audio_para_conf  hp_outpath_para_audio[] = {  //ӦHpͨ
	{"MONO MIXER DAC TO MONO OUT Switch", {"0"}},
	{"SPEAKER MIXER DAC TO SPEAKER OUT Switch", {"1"}}, 	
	{"SPEAKER MIXER GAIN", {"41"}},		//1d	
	{"SPEAKER OUTPUT Volume", {"0"}},	//1e
	{"DAC Playback Volume", {"192"}}, //38
};
#else
static struct audio_para_conf  hp_outpath_para_audio[] = {  //ӦHpͨ
	{"SPEAKER MIXER DAC TO SPEAKER OUT Switch", {"0"}}, 		
	{"MONO OUT GAIN", {"4"}},      
	{"MONO MIXER DAC TO MONO OUT Switch", {"1"}},
	{"audio path select",{"handset"}},
};

#endif
/*
static struct audio_para_conf  spk_outpath_para_audio[] = { //ӦSpkͨ
	{"MONO MIXER DAC TO MONO OUT Switch", {"0"}},	
	{"SPEAKER MIXER GAIN", {"4"}},			
	{"SPEAKER OUTPUT Volume", {"4"}},		
	{"SPEAKER MIXER DAC TO SPEAKER OUT Switch", {"1"}} 	
};
*/

static struct audio_para_conf  spk_outpath_para_audio[] = {  //ӦSpkͨ
	{"SPEAKER MIXER DAC TO SPEAKER OUT Switch", {"0"}}, 		
	{"MONO OUT GAIN", {"11"}},      
	{"MONO MIXER DAC TO MONO OUT Switch", {"1"}},
	{"audio path select",{"speak"}},
};

static  struct  audio_para_conf  main_mic_inpath_para_audio[] = { //ӦLin1-Rin1ͨ
	{"DIFFERENTIAL MUX", {"1"}},
};

static  struct  audio_para_conf  aux_mic_inpath_para_audio[] = {//ӦLin2-Rin2ͨ
	{"DIFFERENTIAL MUX", {"2"}},	
};

#ifdef _USE_7520V3_PHONE_TYPE_WTWD

static struct audio_para_conf  handset_inoutpath_para_voice[] = {  //ӦHpͨMic1lp_Mic1lmͨ
#ifndef USE_CAP_SUPPORT

	//{"voice processing path select", {"headset"}},  // handset speak headset bluetooth
	{"voice processing path select", {"handset"}},	// handset speak headset bluetooth
#endif	
	{"DIFFERENTIAL MUX", {"1"}},	
	{"DMIC MUX", {"0"}},	
	{"SDP OUT MUX", {"0"}},
	{"ADC Soft Ramp", {"0"}},
	{"ADC HPF COEFFICIENT", {"5"}},

	{"ALC MUX", {"0"}}, 
	{"D2SE MIC BOOST GAIN", {"1"}},
	{"LIN PGA GAIN", {"6"}},	
	{"ADC Capture Volume", {"192"}},	
			
	{"MONO MIXER DAC TO MONO OUT Switch", {"0"}},
	{"SPEAKER MIXER DAC TO SPEAKER OUT Switch", {"1"}}, 	
	{"SPEAKER MIXER GAIN", {"32"}},	//old 41		
	{"SPEAKER OUTPUT Volume", {"0"}},	//1
	{"DAC Playback Volume", {"192"}}, //38
};

#else
static struct audio_para_conf  handset_inoutpath_para_voice[] = {  //ӦHpͨMic1lp_Mic1lmͨ
#ifndef USE_CAP_SUPPORT

	{"voice processing path select", {"handset"}},  // handset speak headset bluetooth
#endif	
	{"DIFFERENTIAL MUX", {"1"}},	
	{"DMIC MUX", {"0"}},	
	{"SDP OUT MUX", {"0"}},
	{"ADC Soft Ramp", {"0"}},
	{"ADC HPF COEFFICIENT", {"5"}},

	{"ALC MUX", {"0"}},	
#if 0
	{"ALC Capture Target Volume", {"7"}},
	{"ALC Capture Max PGA", {"13"}},
	{"ALC Capture Min PGA", {"8"}},
	{"ALC Capture Hold Time", {"0"}},
	{"ALC Capture Decay Time", {"1"}},
	{"ALC Capture Attack Time", {"2"}},
	{"ALC WIN SIZE", {"6"}},
	{"ALC Capture NG Threshold", {"14"}},
	{"ALC Capture NG Type", {"0"}},
	{"ALC Capture NG Switch", {"0"}},
#endif	
	{"D2SE MIC BOOST GAIN", {"1"}},
	{"LIN PGA GAIN", {"6"}},	
	{"ADC Capture Volume", {"192"}},	
	{"SPEAKER MIXER DAC TO SPEAKER OUT Switch", {"0"}}, 		
	{"MONO OUT GAIN", {"11"}}, 
    {"DAC Playback Volume", {"192"}}, 
	{"MONO MIXER DAC TO MONO OUT Switch", {"1"}},
};
#endif
static struct audio_para_conf  headset_inoutpath_para_voice[] = {  //ӦHpͨ Mic1rpͨ
	{"DIFFERENTIAL MUX", {"1"}},	
	{"DMIC MUX", {"0"}},	
	{"SDP OUT MUX", {"0"}},
	{"ADC Soft Ramp", {"0"}},
	{"ADC HPF COEFFICIENT", {"5"}},

	{"ALC MUX", {"0"}},	
#if 0
	{"ALC Capture Target Volume", {"7"}},
	{"ALC Capture Max PGA", {"13"}},
	{"ALC Capture Min PGA", {"8"}},
	{"ALC Capture Hold Time", {"0"}},
	{"ALC Capture Decay Time", {"1"}},
	{"ALC Capture Attack Time", {"2"}},
	{"ALC WIN SIZE", {"6"}},
	{"ALC Capture NG Threshold", {"14"}},
	{"ALC Capture NG Type", {"0"}},
	{"ALC Capture NG Switch", {"0"}},
#endif	
	{"D2SE MIC BOOST GAIN", {"1"}},
	{"LIN PGA GAIN", {"7"}},	
	{"ADC Capture Volume", {"192"}},	
	{"SPEAKER MIXER DAC TO SPEAKER OUT Switch", {"0"}}, 		
	{"MONO OUT GAIN", {"4"}},
	{"DAC Playback Volume", {"190"}},
	{"MONO MIXER DAC TO MONO OUT Switch", {"1"}},
#ifndef USE_CAP_SUPPORT        
	{"voice processing path select", {"headset"}}, // handset speak headset bluetooth
#endif	
};
#ifdef _USE_7520V3_PHONE_TYPE_WTWD //class-d -->receiver
static struct audio_para_conf  spk_inoutpath_para_voice[] = { //ӦSpkͨMic1lp_Mic1lmͨ
	{"DIFFERENTIAL MUX", {"1"}},	
	{"DMIC MUX", {"0"}},	
	{"SDP OUT MUX", {"0"}},
	{"ADC Soft Ramp", {"0"}},
	{"ADC HPF COEFFICIENT", {"5"}},

	{"ALC MUX", {"0"}},	
#if 0	
	{"ALC Capture Target Volume", {"7"}},
	{"ALC Capture Max PGA", {"13"}},
	{"ALC Capture Min PGA", {"8"}},
	{"ALC Capture Hold Time", {"0"}},
	{"ALC Capture Decay Time", {"1"}},
	{"ALC Capture Attack Time", {"2"}},
	{"ALC WIN SIZE", {"6"}},
	{"ALC Capture NG Threshold", {"14"}},
	{"ALC Capture NG Type", {"0"}},
	{"ALC Capture NG Switch", {"0"}},
#endif	
	{"D2SE MIC BOOST GAIN", {"1"}},
	{"LIN PGA GAIN", {"6"}},	
	{"ADC Capture Volume", {"192"}},	
	{"SPEAKER MIXER DAC TO SPEAKER OUT Switch", {"0"}},		
	{"MONO OUT GAIN", {"4"}}, 
	{"DAC Playback Volume", {"186"}},
	{"MONO MIXER DAC TO MONO OUT Switch", {"1"}},
#ifndef USE_CAP_SUPPORT        
	{"voice processing path select", {"speak"}}, // handset speak headset bluetooth
#endif	
};
#else//momo out -> speaker
static struct audio_para_conf  spk_inoutpath_para_voice[] = { //ӦSpkͨMic1lp_Mic1lmͨ
	{"DIFFERENTIAL MUX", {"1"}},	
	{"DMIC MUX", {"0"}},	
	{"SDP OUT MUX", {"0"}},
	{"ADC Soft Ramp", {"0"}},
	{"ADC HPF COEFFICIENT", {"5"}},

	{"ALC MUX", {"0"}},	
#if 0	
	{"ALC Capture Target Volume", {"7"}},
	{"ALC Capture Max PGA", {"13"}},
	{"ALC Capture Min PGA", {"8"}},
	{"ALC Capture Hold Time", {"0"}},
	{"ALC Capture Decay Time", {"1"}},
	{"ALC Capture Attack Time", {"2"}},
	{"ALC WIN SIZE", {"6"}},
	{"ALC Capture NG Threshold", {"14"}},
	{"ALC Capture NG Type", {"0"}},
	{"ALC Capture NG Switch", {"0"}},
#endif	
	{"D2SE MIC BOOST GAIN", {"1"}},
	{"LIN PGA GAIN", {"6"}},	
	{"ADC Capture Volume", {"192"}},	
	{"SPEAKER MIXER DAC TO SPEAKER OUT Switch", {"0"}},		
	{"MONO OUT GAIN", {"0"}}, 
	{"DAC Playback Volume", {"186"}},
	{"MONO MIXER DAC TO MONO OUT Switch", {"1"}},
#ifndef USE_CAP_SUPPORT        
	{"voice processing path select", {"speak"}}, // handset speak headset bluetooth
#endif	
};

#endif



#else
static struct audio_para_conf  common_out_para_audio[] = {  //Ӧ
	{"DAC MUTE", {"0"}},  	  
	//{"DAC Playback Volume", {"120"}},	
	{"DAC SDP SRC MUX",  {"0"}},  
	{"DAC SRC MUX",  {"0"}} 
};

static struct audio_para_conf  common_in_para_audio[] = {  //Ӧ
	{"DMIC MUX", {"0"}},	
	{"SDP OUT MUX", {"0"}},
	{"ADC Soft Ramp", {"0"}},	
	{"ADC HPF COEFFICIENT", {"5"}},
#if 1	
	{"ALC MUX", {"1"}},	
	{"ALC Capture Target Volume", {"5"}},
	{"ALC Capture Max PGA", {"11"}},
	{"ALC Capture Min PGA", {"2"}},
	{"ALC Capture Hold Time", {"0"}},
	{"ALC Capture Decay Time", {"0"}},
	{"ALC Capture Attack Time", {"0"}},
	{"ALC WIN SIZE", {"6"}},
	{"ALC Capture NG Threshold", {"14"}},
	{"ALC Capture NG Type", {"0"}},
	{"ALC Capture NG Switch", {"0"}},
#endif
	{"D2SE MIC BOOST GAIN", {"1"}},
	{"LIN PGA GAIN", {"3"}},	
	{"ADC Capture Volume", {"180"}},	
};

static struct audio_para_conf  hp_outpath_para_audio[] = {  //ӦHpͨ
	{"SPEAKER MIXER DAC TO SPEAKER OUT Switch", {"0"}}, 		
	{"MONO OUT GAIN", {"4"}},      
	{"MONO MIXER DAC TO MONO OUT Switch", {"1"}}
};

/*
static struct audio_para_conf  spk_outpath_para_audio[] = { //ӦSpkͨ
	{"MONO MIXER DAC TO MONO OUT Switch", {"0"}},	
	{"SPEAKER MIXER GAIN", {"4"}},			
	{"SPEAKER OUTPUT Volume", {"4"}},		
	{"SPEAKER MIXER DAC TO SPEAKER OUT Switch", {"1"}} 	
};
*/

static struct audio_para_conf  spk_outpath_para_audio[] = {  //ӦSpkͨ
	{"SPEAKER MIXER DAC TO SPEAKER OUT Switch", {"0"}}, 		
	{"MONO OUT GAIN", {"3"}},      
	{"MONO MIXER DAC TO MONO OUT Switch", {"1"}}
};

static  struct  audio_para_conf  main_mic_inpath_para_audio[] = { //ӦLin1-Rin1ͨ
	{"DIFFERENTIAL MUX", {"1"}},
};

static  struct  audio_para_conf  aux_mic_inpath_para_audio[] = {//ӦLin2-Rin2ͨ
	{"DIFFERENTIAL MUX", {"2"}},	
};

static struct audio_para_conf  handset_inoutpath_para_voice[] = {  //ӦHpͨMic1lp_Mic1lmͨ
	{"DIFFERENTIAL MUX", {"1"}},	
	{"DMIC MUX", {"0"}},	
	{"SDP OUT MUX", {"0"}},
	{"ADC Soft Ramp", {"0"}},
	{"ADC HPF COEFFICIENT", {"5"}},

	{"ALC MUX", {"0"}},	
#if 0
	{"ALC Capture Target Volume", {"7"}},
	{"ALC Capture Max PGA", {"13"}},
	{"ALC Capture Min PGA", {"8"}},
	{"ALC Capture Hold Time", {"0"}},
	{"ALC Capture Decay Time", {"1"}},
	{"ALC Capture Attack Time", {"2"}},
	{"ALC WIN SIZE", {"6"}},
	{"ALC Capture NG Threshold", {"14"}},
	{"ALC Capture NG Type", {"0"}},
	{"ALC Capture NG Switch", {"0"}},
#endif	
	{"D2SE MIC BOOST GAIN", {"1"}},
	{"LIN PGA GAIN", {"7"}},	
	{"ADC Capture Volume", {"192"}},	
	{"SPEAKER MIXER DAC TO SPEAKER OUT Switch", {"0"}}, 		
	{"MONO OUT GAIN", {"4"}}, 
    {"DAC Playback Volume", {"190"}}, 
	{"MONO MIXER DAC TO MONO OUT Switch", {"1"}},
#ifndef USE_CAP_SUPPORT        
	{"voice processing path select", {"handset"}},  // handset speak headset bluetooth
#endif	
};

static struct audio_para_conf  headset_inoutpath_para_voice[] = {  //ӦHpͨ Mic1rpͨ
	{"DIFFERENTIAL MUX", {"1"}},	
	{"DMIC MUX", {"0"}},	
	{"SDP OUT MUX", {"0"}},
	{"ADC Soft Ramp", {"0"}},
	{"ADC HPF COEFFICIENT", {"5"}},

	{"ALC MUX", {"0"}},	
#if 0
	{"ALC Capture Target Volume", {"7"}},
	{"ALC Capture Max PGA", {"13"}},
	{"ALC Capture Min PGA", {"8"}},
	{"ALC Capture Hold Time", {"0"}},
	{"ALC Capture Decay Time", {"1"}},
	{"ALC Capture Attack Time", {"2"}},
	{"ALC WIN SIZE", {"6"}},
	{"ALC Capture NG Threshold", {"14"}},
	{"ALC Capture NG Type", {"0"}},
	{"ALC Capture NG Switch", {"0"}},
#endif	
	{"D2SE MIC BOOST GAIN", {"1"}},
	{"LIN PGA GAIN", {"7"}},	
	{"ADC Capture Volume", {"192"}},	
	{"SPEAKER MIXER DAC TO SPEAKER OUT Switch", {"0"}}, 		
	{"MONO OUT GAIN", {"4"}},
	{"DAC Playback Volume", {"190"}},
	{"MONO MIXER DAC TO MONO OUT Switch", {"1"}},
#ifndef USE_CAP_SUPPORT        
	{"voice processing path select", {"headset"}}, // handset speak headset bluetooth
#endif	
};

static struct audio_para_conf  spk_inoutpath_para_voice[] = { //ӦSpkͨMic1lp_Mic1lmͨ
	{"DIFFERENTIAL MUX", {"1"}},	
	{"DMIC MUX", {"0"}},	
	{"SDP OUT MUX", {"0"}},
	{"ADC Soft Ramp", {"0"}},
	{"ADC HPF COEFFICIENT", {"5"}},

	{"ALC MUX", {"0"}},	
#if 0	
	{"ALC Capture Target Volume", {"7"}},
	{"ALC Capture Max PGA", {"13"}},
	{"ALC Capture Min PGA", {"8"}},
	{"ALC Capture Hold Time", {"0"}},
	{"ALC Capture Decay Time", {"1"}},
	{"ALC Capture Attack Time", {"2"}},
	{"ALC WIN SIZE", {"6"}},
	{"ALC Capture NG Threshold", {"14"}},
	{"ALC Capture NG Type", {"0"}},
	{"ALC Capture NG Switch", {"0"}},
#endif	
	{"D2SE MIC BOOST GAIN", {"1"}},
	{"LIN PGA GAIN", {"7"}},	
	{"ADC Capture Volume", {"192"}},	
	{"SPEAKER MIXER DAC TO SPEAKER OUT Switch", {"0"}},		
	{"MONO OUT GAIN", {"4"}}, 
	{"DAC Playback Volume", {"190"}},
	{"MONO MIXER DAC TO MONO OUT Switch", {"1"}},
#ifndef USE_CAP_SUPPORT        
	{"voice processing path select", {"speak"}}, // handset speak headset bluetooth
#endif	
};

#endif

static struct audio_para_conf output_dac_vol = {"DAC Playback Volume", {"120"}};

static struct audio_para_conf input_adc_vol = {"ADC Capture Volume", {"192"}};

static struct audio_para_conf dac_mute = {"DAC MUTE", {"1"}};
static struct audio_para_conf adc_mute = {"ADC MUTE", {"1"}};

static struct audio_para_conf spk_path_onoff[] = {
	{"MONO MIXER DAC TO MONO OUT Switch", {"0"}},
};

static struct audio_para_conf rcv_path_onoff[] = {
	{"MONO MIXER DAC TO MONO OUT Switch", {"0"}},
};

static struct audio_para_conf earp_path_onoff[] = {
	{"MONO MIXER DAC TO MONO OUT Switch", {"0"}},
};


static int output_vol_conversion(int vol)
{
	switch(vol){
	case T_AUDIO_OUTPUT_VOL_LEVEL_0:
		return T_OUTPUT_VOL_MINUS_96DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_1:
		return T_OUTPUT_VOL_MINUS_45DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_2:
		return T_OUTPUT_VOL_MINUS_40DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_3:
		return T_OUTPUT_VOL_MINUS_35DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_4:
		return T_OUTPUT_VOL_MINUS_30DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_5:
		return T_OUTPUT_VOL_MINUS_25DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_6:
		return T_OUTPUT_VOL_MINUS_20DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_7:
		return T_OUTPUT_VOL_MINUS_15DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_8:
		return T_OUTPUT_VOL_MINUS_10DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_9:
		return T_OUTPUT_VOL_MINUS_6DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_10:
		return T_OUTPUT_VOL_MINUS_3DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_11:
		return T_OUTPUT_VOL_0DB;
	default:
		return T_OUTPUT_VOL_0DB;
	}
}

static int input_vol_conversion(int vol)
{
	switch(vol) {
	case T_AUDIO_INPUT_VOL_LEVEL_0:
		return T_INPUT_VOL_MINUS_96DB;
	case T_AUDIO_INPUT_VOL_LEVEL_1:
		return T_INPUT_VOL_MINUS_30DB;
	case T_AUDIO_INPUT_VOL_LEVEL_2:
		return T_INPUT_VOL_MINUS_25DB;
	case T_AUDIO_INPUT_VOL_LEVEL_3:
		return T_INPUT_VOL_MINUS_20DB;
	case T_AUDIO_INPUT_VOL_LEVEL_4:
		return T_INPUT_VOL_MINUS_15DB;
	case T_AUDIO_INPUT_VOL_LEVEL_5:
		return T_INPUT_VOL_MINUS_10DB;
	case T_AUDIO_INPUT_VOL_LEVEL_6:
		return T_INPUT_VOL_MINUS_7DB;
	case T_AUDIO_INPUT_VOL_LEVEL_7:
		return T_INPUT_VOL_MINUS_4DB;
	case T_AUDIO_INPUT_VOL_LEVEL_8:
		return T_INPUT_VOL_MINUS_3DB;
	case T_AUDIO_INPUT_VOL_LEVEL_9:
		return T_INPUT_VOL_MINUS_2DB;
	case T_AUDIO_INPUT_VOL_LEVEL_10:
		return T_INPUT_VOL_MINUS_1DB;
	case T_AUDIO_INPUT_VOL_LEVEL_11:
		return T_INPUT_VOL_0DB;
	default:
		return T_INPUT_VOL_MINUS_30DB;
	}
}

#elif defined _USE_CODEC_AK4940

static struct audio_para_conf  common_out_para_audio[] = {  //Ӧ
    {"DAC Soft Mute Control", {"0"}},
    //{"BICK Frequency", {"32fs"}},    
    {"BICK Frequency", {"2"}},//0 64fs,1 48fs,2 32fs

};
	

static struct audio_para_conf  common_in_para_audio[] = {  //Ӧ

		{"Mic Gain Control", {"0"}},
		{"ADC Digital Volume (VOLAD)", {"195"}},
		{"ADC Soft Mute Control", {"0"}},
		

};

static struct audio_para_conf  hp_outpath_para_audio[] = {  //ӦHpͨ
	{"OUT2 MUX", {"DAC"}},
	{"Lineout Type", {"Single-end"}},

};

static struct audio_para_conf  spk_outpath_para_audio[] = { //ӦSpkͨ
	{"OUT1 MUX", {"DAC"}},
	{"Lineout Type", {"Differential"}},

};

static  struct  audio_para_conf  main_mic_inpath_para_audio[] = { //ӦMic1lp_Mic1lmͨ

		{"ADC Input Type", {"Single-end"}},
		{"AIN MUX", {"AIN1"}},	

};

static  struct  audio_para_conf  aux_mic_inpath_para_audio[] = {//ӦMic1rpͨ

	{"ADC Input Type", {"Single-end"}},	
	{"AIN MUX", {"AIN2"}},
};

static struct audio_para_conf  handset_inoutpath_para_voice[] = {  //ӦHpͨMic1lp_Mic1lmͨ
    // common in

	{"Mic Gain Control", {"0"}},
	{"ADC Digital Volume (VOLAD)", {"195"}},
	{"ADC Soft Mute Control", {"0"}},
    //diff in	
	{"ADC Input Type", {"Single-end"}},
	{"AIN MUX", {"AIN1"}},	

    // common out

    {"DAC Soft Mute Control", {"0"}},
    //{"BICK Frequency", {"32fs"}},    
    {"BICK Frequency", {"2"}},//0 64fs,1 48fs,2 32fs
	//diff out

	//voice
#ifndef USE_CAP_SUPPORT

	{"voice processing path select", {"handset"}},  // handset speak headset bluetooth
#endif	
};

static struct audio_para_conf  headset_inoutpath_para_voice[] = {  //ӦHpͨ Mic1rpͨ
    // common in

	{"Mic Gain Control", {"0"}},
	{"ADC Digital Volume (VOLAD)", {"195"}},
	{"ADC Soft Mute Control", {"0"}},
	//diff in
	{"ADC Input Type", {"Single-end"}},	
	{"AIN MUX", {"AIN2"}},	
		// common out

    {"DAC Soft Mute Control", {"0"}},
    //{"BICK Frequency", {"32fs"}},	
    {"BICK Frequency", {"2"}},//0 64fs,1 48fs,2 32fs
	//diff out

	{"OUT2 MUX", {"DAC"}},
	{"Lineout Type", {"Single-end"}},
	//voice
#ifndef USE_CAP_SUPPORT

	{"voice processing path select", {"headset"}}, // handset speak headset bluetooth
#endif	
};

static struct audio_para_conf  spk_inoutpath_para_voice[] = { //ӦSpkͨMic1lp_Mic1lmͨ

    // common in
    {"Mic Gain Control", {"0"}},
	{"ADC Digital Volume (VOLAD)", {"195"}},
	{"ADC Soft Mute Control", {"0"}},
	//diff in
	{"ADC Input Type", {"Single-end"}},
	{"AIN MUX", {"AIN1"}},	
    // common out		
    {"DAC Soft Mute Control", {"0"}},
    //{"BICK Frequency", {"32fs"}},    
    {"BICK Frequency", {"2"}},//0 64fs,1 48fs,2 32fs
	//diff out    
	{"OUT1 MUX", {"DAC"}},
	{"Lineout Type", {"Differential"}},
	//voice
#ifndef USE_CAP_SUPPORT

	{"voice processing path select", {"speak"}}, // handset speak headset bluetooth
#endif	
};

#elif defined _USE_CODEC_NAU8810
static struct audio_para_conf init_default_para[] = {  //ʼ

};

static struct audio_para_conf  common_out_para_audio[] = {  //Ӧ
    //{"DAC Soft Mute Control", {"0"}},


};


static struct audio_para_conf  common_in_para_audio[] = {  //Ӧ

	//{"Mic Gain Control", {"0"}},

};

static struct audio_para_conf  hp_outpath_para_audio[] = {  //ӦHpͨ
	{"Speaker Mute Switch", {"1"}},
	{"Speaker Mixer PCM Playback Switch", {"0"}},
	{"Mono Mute Switch", {"0"}},	
	{"Mono Mixer PCM Playback Switch", {"1"}},


};

static struct audio_para_conf  spk_outpath_para_audio[] = { //ӦSpkͨ
	{"Mono Mute Switch", {"1"}},
	{"Mono Mixer PCM Playback Switch", {"0"}},		
	{"Speaker Volume", {"57"}},	
	{"Speaker Mute Switch", {"0"}},
	{"Speaker Mixer PCM Playback Switch", {"1"}},


};

static  struct  audio_para_conf  main_mic_inpath_para_audio[] = { //ӦMic1lp_Mic1lmͨ

    //#0x2d b6 pga mute
	{"Input Boost Stage PGA Mute Switch", {"1"}},
	{"Capture Volume", {"255"}},
	{"PGA Volume", {"32"}},
	{"Input PGA MicN Switch", {"1"}},
	{"Input PGA MicP Switch", {"1"}},

	//#0x2f b4~b6
	{"Input Boost Stage PMIC PGA Switch", {"0"}},

};

static  struct  audio_para_conf  aux_mic_inpath_para_audio[] = {//ӦMic1rpͨ

    //#0x2d b6 pga mute
	{"Input Boost Stage PGA Mute Switch", {"1"}},
	{"Capture Volume", {"255"}},
	{"PGA Volume", {"32"}},
	{"Input PGA MicN Switch", {"1"}},
	{"Input PGA MicP Switch", {"1"}},

	//#0x2f b4~b6
	{"Input Boost Stage PMIC PGA Switch", {"0"}},

	
};

static struct audio_para_conf  handset_inoutpath_para_voice[] = {  //ӦHpͨMic1lp_Mic1lmͨ
    //in
    //#0x2d b6 pga mute
	{"Input Boost Stage PGA Mute Switch", {"1"}},
	{"Capture Volume", {"255"}},
	{"PGA Volume", {"32"}},
	{"Input PGA MicN Switch", {"1"}},
	{"Input PGA MicP Switch", {"1"}},

	//#0x2f b4~b6
	{"Input Boost Stage PMIC PGA Switch", {"0"}},

    //out
    {"Playback Volume", {"255"}},
	{"Speaker Mute Switch", {"1"}},
	{"Speaker Mixer PCM Playback Switch", {"0"}},	
	{"Mono Mute Switch", {"0"}},
	{"Mono Mixer PCM Playback Switch", {"1"}},



	//voice
#ifndef USE_CAP_SUPPORT

	{"voice processing path select", {"handset"}},  // handset speak headset bluetooth
#endif	
};

static struct audio_para_conf  headset_inoutpath_para_voice[] = {  //ӦHpͨ Mic1rpͨ
    //in
    //#0x2d b6 pga mute
	{"Input Boost Stage PGA Mute Switch", {"1"}},
	{"Capture Volume", {"255"}},
	{"PGA Volume", {"32"}},
	{"Input PGA MicN Switch", {"1"}},
	{"Input PGA MicP Switch", {"1"}},

	//#0x2f b4~b6
	{"Input Boost Stage PMIC PGA Switch", {"0"}},

    //out
    {"Playback Volume", {"255"}},    
	{"Speaker Mute Switch", {"1"}},
	{"Speaker Mixer PCM Playback Switch", {"0"}},
	{"Mono Mute Switch", {"0"}},
	{"Mono Mixer PCM Playback Switch", {"1"}},

	//voice
#ifndef USE_CAP_SUPPORT

	{"voice processing path select", {"headset"}}, // handset speak headset bluetooth
#endif	
};

static struct audio_para_conf  spk_inoutpath_para_voice[] = { //ӦSpkͨMic1lp_Mic1lmͨ

    //in
    //#0x2d b6 pga mute
	{"Input Boost Stage PGA Mute Switch", {"1"}},
	{"Capture Volume", {"255"}},
	{"PGA Volume", {"32"}},
	{"Input PGA MicN Switch", {"1"}},
	{"Input PGA MicP Switch", {"1"}},

	//#0x2f b4~b6
	{"Input Boost Stage PMIC PGA Switch", {"0"}},

	//out
    {"Playback Volume", {"255"}},	
	{"Mono Mute Switch", {"1"}},
	{"Mono Mixer PCM Playback Switch", {"0"}},	
	{"Speaker Volume", {"63"}},
	{"Speaker Mute Switch", {"0"}},
	{"Speaker Mixer PCM Playback Switch", {"1"}},


	//voice
#ifndef USE_CAP_SUPPORT

	{"voice processing path select", {"speak"}}, // handset speak headset bluetooth
#endif	
};


static struct audio_para_conf output_dac_vol = {
	"Playback Volume", {"255"}
	
};

static struct audio_para_conf input_adc_vol = {
	"Capture Volume", {"255"}
};

static struct audio_para_conf dac_mute = {
	"DAC MUTE", {"1"}
};
static struct audio_para_conf adc_mute = {
	"Input Boost Stage PGA Mute Switch", {"0"}
};

static struct audio_para_conf spk_path_onoff[] = {
	{"Mono Mixer PCM Playback Switch", {"0"}},
};

static struct audio_para_conf rcv_path_onoff[] = {
	{"Mono Mixer PCM Playback Switch", {"0"}},
};

static struct audio_para_conf earp_path_onoff[] = {
	{"Speaker Mixer PCM Playback Switch", {"0"}},
};


static int output_vol_conversion(int vol)//reg 0xb
{
	switch(vol){
    	case T_AUDIO_OUTPUT_VOL_LEVEL_0:
    		return 189;
    	case T_AUDIO_OUTPUT_VOL_LEVEL_1:
    		return 195;
    	case T_AUDIO_OUTPUT_VOL_LEVEL_2:
    		return 201;
    	case T_AUDIO_OUTPUT_VOL_LEVEL_3:
    		return 207;
    	case T_AUDIO_OUTPUT_VOL_LEVEL_4:
    		return 213;
    	case T_AUDIO_OUTPUT_VOL_LEVEL_5:
    		return 219;
    	case T_AUDIO_OUTPUT_VOL_LEVEL_6:
    		return 225;
    	case T_AUDIO_OUTPUT_VOL_LEVEL_7:
    		return 231;
    	case T_AUDIO_OUTPUT_VOL_LEVEL_8:
    		return 237;
    	case T_AUDIO_OUTPUT_VOL_LEVEL_9:
    		return 243;
    	case T_AUDIO_OUTPUT_VOL_LEVEL_10:
    		return 249;
    	case T_AUDIO_OUTPUT_VOL_LEVEL_11:
	        return 255;
    	default:
    		return 255;
	}
}
static int input_vol_conversion(int vol)//reg 0xf
{
	switch(vol) {
    	case T_AUDIO_INPUT_VOL_LEVEL_0:
    		return 189;
    	case T_AUDIO_INPUT_VOL_LEVEL_1:
    		return 195;
    	case T_AUDIO_INPUT_VOL_LEVEL_2:
    		return 201;
    	case T_AUDIO_INPUT_VOL_LEVEL_3:
    		return 207;
    	case T_AUDIO_INPUT_VOL_LEVEL_4:
    		return 213;
    	case T_AUDIO_INPUT_VOL_LEVEL_5:
    		return 219;
    	case T_AUDIO_INPUT_VOL_LEVEL_6:
    		return 225;
    	case T_AUDIO_INPUT_VOL_LEVEL_7:
    		return 231;
    	case T_AUDIO_INPUT_VOL_LEVEL_8:
    		return 237;
    	case T_AUDIO_INPUT_VOL_LEVEL_9:
    		return 243;
    	case T_AUDIO_INPUT_VOL_LEVEL_10:
    		return 249;
    	case T_AUDIO_INPUT_VOL_LEVEL_11:
	        return 255;
    	default:
    		return 255;
	}
}



#else //default

static struct audio_para_conf init_default_para[] = { 
};

static struct audio_para_conf  common_out_para_audio[] = {  

};



static struct audio_para_conf  common_in_para_audio[] = { 
};

static struct audio_para_conf  hp_outpath_para_audio[] = { 
};


static struct audio_para_conf  spk_outpath_para_audio[] = {  
};

static  struct  audio_para_conf  main_mic_inpath_para_audio[] = { 
};

static  struct  audio_para_conf  aux_mic_inpath_para_audio[] = {
};

static struct audio_para_conf  handset_inoutpath_para_voice[] = { 
	
};

static struct audio_para_conf  headset_inoutpath_para_voice[] = { 
};

static struct audio_para_conf  spk_inoutpath_para_voice[] = {
};

static struct audio_para_conf output_dac_vol = 	{};

static struct audio_para_conf input_adc_vol = {};

static struct audio_para_conf dac_mute = {};
static struct audio_para_conf adc_mute = {};

static struct audio_para_conf spk_path_onoff[] = {
	
};
static struct audio_para_conf rcv_path_onoff[] = {

};
static struct audio_para_conf earp_path_onoff[] = {

};
static int output_vol_conversion(int vol)
{

	return 24;
}

static int input_vol_conversion(int vol)
{
	
	return 24;

}


#endif

static void mix_set_value_wrap(struct mixer *mixer, const char *control, char **values)
{
	struct mixer_ctl *ctl;
	enum mixer_ctl_type type;
	unsigned int num_ctl_values;
	unsigned int i;

	if (isdigit(control[0]))
		ctl = mixer_get_ctl(mixer, atoi(control));
	else
		ctl = mixer_get_ctl_by_name(mixer, control);

	if (!ctl) {
		fprintf(stderr, "Invalid mixer control(%s)\n",control);
		return;
	}

	type = mixer_ctl_get_type(ctl);
	num_ctl_values = mixer_ctl_get_num_values(ctl);

	if (isdigit(values[0][0])) {

		for (i = 0; i < num_ctl_values; i++) {
			if (mixer_ctl_set_value(ctl, i, atoi(values[i]))) {
				fprintf(stderr, "Error: invalid value for index %d\n", i);
				return;
			}
		}

	} else {
		if (type == MIXER_CTL_TYPE_ENUM) {
			/*if (num_values != 1) {
			    fprintf(stderr, "Enclose strings in quotes and try again\n");
			    return;
			}*/
			if (mixer_ctl_set_enum_by_string(ctl, values[0]))
				fprintf(stderr, "Error: invalid enum value\n");
		} else {
			fprintf(stderr, "Error: only enum types can be set with strings\n");
		}
	}
}

static void mix_get_value_wrap(struct mixer *mixer, const char *control, int *values)
{
	struct mixer_ctl *ctl;
	enum mixer_ctl_type type;
	unsigned int num_ctl_values;
	unsigned int i;
	int val;

	if (isdigit(control[0]))
		ctl = mixer_get_ctl(mixer, atoi(control));
	else
		ctl = mixer_get_ctl_by_name(mixer, control);

	if (!ctl) {
		fprintf(stderr, "Invalid mixer control(%s)\n",control);
		return;
	}

	type = mixer_ctl_get_type(ctl);
	num_ctl_values = mixer_ctl_get_num_values(ctl);


	for (i = 0; i < num_ctl_values; i++) {
		val = mixer_ctl_get_value(ctl, i);
		if (val == -EINVAL) {
			fprintf(stderr, "Error: invalid value for index %d\n", i);
			return;
		}
		*(values+i) = val;
	}

}


#if (defined _USE_CODEC_TI3100)||(defined _USE_CODEC_AK4940)||(defined _USE_CODEC_NAU8810)||(defined _USE_CODEC_ES8311)||(defined _USE_CODEC_TI3104)
/*
int mix_set_input_vol(struct mixer *mixer, int volume)
{
	struct mixer_ctl *ctl;
	char *name = input_adc_vol.control;
	int num_values, i;
	int vol = input_vol_conversion(volume);

	ctl = mixer_get_ctl_by_name(mixer, name);
	if (!ctl) {
		fprintf(stderr, "Invalid mixer control\n");
		return -1;
	}

    num_values = mixer_ctl_get_num_values(ctl);

    for (i = 0; i < num_values; i++) {
		mixer_ctl_set_value(ctl, i, vol);
    }

	return 0;
}

int mix_set_output_vol(struct mixer *mixer, int volume)
{
	struct mixer_ctl *ctl;
	char *name = output_dac_vol.control;
	int num_values, i;

	int vol = output_vol_conversion(volume);

	ctl = mixer_get_ctl_by_name(mixer, name);
	if (!ctl) {
		fprintf(stderr, "Invalid mixer control\n");
		return -1;
	}

	num_values = mixer_ctl_get_num_values(ctl);

    for (i = 0; i < num_values; i++) {
		mixer_ctl_set_value(ctl, i, vol);
    }

	return 0;
}

int mix_set_output_mute(struct mixer *mixer, bool enable)
{
	struct mixer_ctl *ctl;
	char *name = dac_mute.control; 
	int num_values, i;

	ctl = mixer_get_ctl_by_name(mixer, name);
	if (!ctl) {
		fprintf(stderr, "Invalid mixer control\n");
		return -1;
	}

	num_values = mixer_ctl_get_num_values(ctl);

    for (i = 0; i < num_values; i++) {
		mixer_ctl_set_value(ctl, i, enable);
    }

	return 0;
}

int mix_set_input_mute(struct mixer *mixer, bool enable)
{
	struct mixer_ctl *ctl;
	char *name = adc_mute.control;
	ctl = mixer_get_ctl_by_name(mixer, name);
	int num_values, i;

	if (!ctl) {
		fprintf(stderr, "Invalid mixer control\n");
		return -1;
	}

	num_values = mixer_ctl_get_num_values(ctl);

    for (i = 0; i < num_values; i++) {
		mixer_ctl_set_value(ctl, 0, enable);
    }
		
	return 0;
}

int mix_set_outputpath_onoff(struct mixer *mixer, int path ,bool onoff)
{
	struct mixer_ctl *ctl;
	struct audio_para_conf *path_para;
	int i, j, num_values, size;
	switch(path) {
	case T_OUTPUT_RECEIVER:
		size = ARRAY_SIZE(rcv_path_onoff);
		path_para = rcv_path_onoff;
		break;
	case T_OUTPUT_SPEAKER:
		size = ARRAY_SIZE(spk_path_onoff);
		path_para = spk_path_onoff;
		break;
	case T_OUTPUT_HEADSET:
		size = ARRAY_SIZE(earp_path_onoff);
		path_para = earp_path_onoff;
		break;
	default:
		return -1;
	}

	for (i = 0; i < size; i++) {
		ctl = mixer_get_ctl_by_name(mixer, path_para[i].control);
		num_values = mixer_ctl_get_num_values(ctl);

	    for (j = 0; j < num_values; j++) {
			mixer_ctl_set_value(ctl, j, onoff);
	    }

//		mix_set_value_wrap(mixer, spk_path_onoff[i].control, spk_path_onoff[i].values);
    }

	return 0;
}
*/

/*

int mix_set_in_call_tone(struct mixer *mixer, int tontype)
{
	struct mixer_ctl *ctl;
	char name[] = "voice tone sel";
	ctl = mixer_get_ctl_by_name(mixer, name);
	if (!ctl) {
		fprintf(stderr, "Invalid mixer control\n");
		return -1;
	}

	mixer_ctl_set_value(ctl, 0, tontype);

	return 0;
}

int mix_set_default_param(struct mixer *mixer) 
{
	int i;
	for (i = 0; i < ARRAY_SIZE(init_default_para); i++) {
		mix_set_value_wrap(mixer, init_default_para[i].control, init_default_para[i].values);
	}
	
	return 0;
}

*/

#define VOCIE_SND_CARD_NUM 0

int mix_set_input_vol(struct mixer *mixer, int volume)
{
	struct mixer_ctl *ctl;
	char *name = input_adc_vol.control;
	int num_values, i;
	int vol = input_vol_conversion(volume);
    if(name == NULL){
		printf("%s: name is null,return!\n",__func__);
		return 0;

	}
	ctl = mixer_get_ctl_by_name(mixer, name);
	if (!ctl) {
		fprintf(stderr, "Invalid mixer control\n");
		return -1;
	}

    num_values = mixer_ctl_get_num_values(ctl);

    for (i = 0; i < num_values; i++) {
		mixer_ctl_set_value(ctl, i, vol);
    }

	return 0;
}

int mix_set_output_vol(struct mixer *mixer, int volume)
{
	struct mixer_ctl *ctl;
	char *name = output_dac_vol.control;
	int num_values, i;

	int vol = output_vol_conversion(volume);
    if(name == NULL){
		printf("%s: name is null,return!\n",__func__);
		return 0;

	}

	ctl = mixer_get_ctl_by_name(mixer, name);
	if (!ctl) {
		fprintf(stderr, "Invalid mixer control\n");
		return -1;
	}

	num_values = mixer_ctl_get_num_values(ctl);

    for (i = 0; i < num_values; i++) {
		mixer_ctl_set_value(ctl, i, vol);
    }

	return 0;
}

int mix_set_output_mute(struct mixer *mixer, bool enable)
{
	struct mixer_ctl *ctl;
	char *name = dac_mute.control; 
	int num_values, i;
    if(name == NULL){
		printf("%s: name is null,return!\n",__func__);
		return 0;

	}

	ctl = mixer_get_ctl_by_name(mixer, name);
	if (!ctl) {
		fprintf(stderr, "Invalid mixer control\n");
		return -1;
	}

	num_values = mixer_ctl_get_num_values(ctl);

    for (i = 0; i < num_values; i++) {
		mixer_ctl_set_value(ctl, i, enable);
    }

	return 0;
}

int mix_set_input_mute(struct mixer *mixer, bool enable)
{
	struct mixer_ctl *ctl;
	char *name = adc_mute.control;
	int num_values, i;
    if(name == NULL){
		printf("%s: name is null,return!\n",__func__);
		return 0;

	}
	ctl = mixer_get_ctl_by_name(mixer, name);

	if (!ctl) {
		fprintf(stderr, "Invalid mixer control\n");
		return -1;
	}

	num_values = mixer_ctl_get_num_values(ctl);

    for (i = 0; i < num_values; i++) {
		mixer_ctl_set_value(ctl, 0, enable);
    }
		
	return 0;
}

int mix_set_outputpath_onoff(struct mixer *mixer, int path ,bool onoff)
{
	struct mixer_ctl *ctl;
	struct audio_para_conf *path_para;
	int i, j, num_values, size;
	switch(path) {
	case T_OUTPUT_RECEIVER:
		size = ARRAY_SIZE(rcv_path_onoff);
		path_para = rcv_path_onoff;
		break;
	case T_OUTPUT_SPEAKER:
		size = ARRAY_SIZE(spk_path_onoff);
		path_para = spk_path_onoff;
		break;
	case T_OUTPUT_HEADSET:
		size = ARRAY_SIZE(earp_path_onoff);
		path_para = earp_path_onoff;
		break;
	default:
		return -1;
	}
    if(size == 0){
		printf("%s: array size is 0,return!\n",__func__);
		return 0;		
    }		
	for (i = 0; i < size; i++) {
		ctl = mixer_get_ctl_by_name(mixer, path_para[i].control);
		num_values = mixer_ctl_get_num_values(ctl);

	    for (j = 0; j < num_values; j++) {
			mixer_ctl_set_value(ctl, j, onoff);
	    }

//		mix_set_value_wrap(mixer, spk_path_onoff[i].control, spk_path_onoff[i].values);
    }

	return 0;
}

int mix_set_in_call_tone(struct mixer *mixer, int tontype)
{
	struct mixer_ctl *ctl;
	char name[] = "voice tone sel";
	ctl = mixer_get_ctl_by_name(mixer, name);
	if (!ctl) {
		fprintf(stderr, "Invalid mixer control\n");
		return -1;
	}

	mixer_ctl_set_value(ctl, 0, tontype);

	return 0;
}

int mix_set_default_param(struct mixer *mixer) 
{
	int i;
	for (i = 0; i < ARRAY_SIZE(init_default_para); i++) {
		mix_set_value_wrap(mixer, init_default_para[i].control, init_default_para[i].values);
	}
	
	return 0;
}

int mix_set_voice_vol(struct mixer *mixer, int volume)
{
	struct mixer_ctl *ctl;
	char name[] = "voice processing path Volume";
	ctl = mixer_get_ctl_by_name(mixer, name);
	if (!ctl) {
		fprintf(stderr, "Invalid mixer control\n");
		return -1;
	}

	mixer_ctl_set_value(ctl, 0, volume);

	return 0;
}
int mix_get_voice_vol(struct mixer *mixer, int *volume)
{

	mix_get_value_wrap(mixer, "voice processing path Volume", volume);

	return 0;

}

int mix_set_tx_voice_vol(struct mixer *mixer, int volume)
{
	struct mixer_ctl *ctl;
	char name[] = "voice processing tx path Volume";
	ctl = mixer_get_ctl_by_name(mixer, name);
	if (!ctl) {
		fprintf(stderr, "Invalid mixer control\n");
		return -1;
	}

	mixer_ctl_set_value(ctl, 0, volume);

	return 0;
}
int mix_get_tx_voice_vol(struct mixer *mixer, int *volume)
{

	mix_get_value_wrap(mixer, "voice processing tx path Volume", volume);

	return 0;

}


int mix_set_voice_mute(struct mixer *mixer, bool enable)
{
	struct mixer_ctl *ctl;
	char name[] = "voice uplink mute";
	ctl = mixer_get_ctl_by_name(mixer, name);
	if (!ctl) {
		fprintf(stderr, "Invalid mixer control\n");
		return -1;
	}

	mixer_ctl_set_value(ctl, 0, enable);
	
	return 0;
}
int mix_get_voice_mute(struct mixer *mixer, int *enable)
{

	mix_get_value_wrap(mixer, "voice uplink mute", enable);

	return 0;

}

//voice downlink mute

int mix_set_rx_voice_mute(struct mixer *mixer, bool enable)
{
	struct mixer_ctl *ctl;
	char name[] = "voice downlink mute";
	ctl = mixer_get_ctl_by_name(mixer, name);
	if (!ctl) {
		fprintf(stderr, "Invalid mixer control\n");
		return -1;
	}

	mixer_ctl_set_value(ctl, 0, enable);
	
	return 0;
}
int mix_get_rx_voice_mute(struct mixer *mixer, int *enable)
{

	mix_get_value_wrap(mixer, "voice downlink mute", enable);

	return 0;

}






int mix_set_output_path(struct mixer *mixer, int path)
{
	int i;
	for (i = 0; i < ARRAY_SIZE(common_out_para_audio); i++) {
		mix_set_value_wrap(mixer, common_out_para_audio[i].control, common_out_para_audio[i].values);
	}
	switch (path) {
	case T_OUTPUT_RECEIVER:
    case T_OUTPUT_HEADSET:
		for (i = 0; i < ARRAY_SIZE(hp_outpath_para_audio); i++) {
			mix_set_value_wrap(mixer, hp_outpath_para_audio[i].control, hp_outpath_para_audio[i].values);
		}
		break;
	case T_OUTPUT_SPEAKER:
		for (i = 0; i < ARRAY_SIZE(spk_outpath_para_audio); i++) {
			mix_set_value_wrap(mixer, spk_outpath_para_audio[i].control, spk_outpath_para_audio[i].values);
		}
		break;
	default:
		break;
	}

	return 0;
}

int mix_set_input_path(struct mixer *mixer, int path)
{
	int i;
	for (i = 0; i < ARRAY_SIZE(common_in_para_audio); i++) {
		mix_set_value_wrap(mixer, common_in_para_audio[i].control, common_in_para_audio[i].values);
	}

	#if (defined _USE_CODEC_TI3100)||(defined _USE_CODEC_ES8311)
	switch (path) {
	case T_INPUT_MICLP:
		for (i = 0; i < ARRAY_SIZE(main_mic_inpath_para_audio); i++) {
			mix_set_value_wrap(mixer, main_mic_inpath_para_audio[i].control, main_mic_inpath_para_audio[i].values);
		}
		break;
	case T_INPUT_MICRP:
		for (i = 0; i < ARRAY_SIZE(aux_mic_inpath_para_audio); i++) {
			mix_set_value_wrap(mixer, aux_mic_inpath_para_audio[i].control, aux_mic_inpath_para_audio[i].values);
		}
		break;
	default:
		break;
	}


	#else
	switch (path) {
	case T_INPUT_HANDSET:
	case T_INPUT_SPEAKER:
		for (i = 0; i < ARRAY_SIZE(main_mic_inpath_para_audio); i++) {
			mix_set_value_wrap(mixer, main_mic_inpath_para_audio[i].control, main_mic_inpath_para_audio[i].values);
		}
		break;
	case T_INPUT_HEADSET:
		for (i = 0; i < ARRAY_SIZE(aux_mic_inpath_para_audio); i++) {
			mix_set_value_wrap(mixer, aux_mic_inpath_para_audio[i].control, aux_mic_inpath_para_audio[i].values);
		}
		break;
	default:
		break;
	}	
	#endif

	return 0;
}
/*
int mix_set_input_vol(struct mixer *mixer, int volume)
{
	struct mixer_ctl *ctl;
	char *name = input_adc_vol.control;
	int num_values, i;
	int vol = input_vol_conversion(volume);

	ctl = mixer_get_ctl_by_name(mixer, name);
	if (!ctl) {
		fprintf(stderr, "Invalid mixer control\n");
		return -1;
	}

    num_values = mixer_ctl_get_num_values(ctl);

    for (i = 0; i < num_values; i++) {
		mixer_ctl_set_value(ctl, i, vol);
    }

	return 0;
}

int mix_set_output_vol(struct mixer *mixer, int volume)
{
	struct mixer_ctl *ctl;
	char *name = output_dac_vol.control;
	int num_values, i;

	int vol = output_vol_conversion(volume);

	ctl = mixer_get_ctl_by_name(mixer, name);
	if (!ctl) {
		fprintf(stderr, "Invalid mixer control\n");
		return -1;
	}

	num_values = mixer_ctl_get_num_values(ctl);

    for (i = 0; i < num_values; i++) {
		mixer_ctl_set_value(ctl, i, vol);
    }

	return 0;
}

int mix_set_output_mute(struct mixer *mixer, bool enable)
{
	struct mixer_ctl *ctl;
	char *name = dac_mute.control; 
	int num_values, i;

	ctl = mixer_get_ctl_by_name(mixer, name);
	if (!ctl) {
		fprintf(stderr, "Invalid mixer control\n");
		return -1;
	}

	num_values = mixer_ctl_get_num_values(ctl);

    for (i = 0; i < num_values; i++) {
		mixer_ctl_set_value(ctl, i, enable);
    }

	return 0;
}

int mix_set_input_mute(struct mixer *mixer, bool enable)
{
	struct mixer_ctl *ctl;
	char *name = adc_mute.control;
	ctl = mixer_get_ctl_by_name(mixer, name);
	int num_values, i;

	if (!ctl) {
		fprintf(stderr, "Invalid mixer control\n");
		return -1;
	}

	num_values = mixer_ctl_get_num_values(ctl);

    for (i = 0; i < num_values; i++) {
		mixer_ctl_set_value(ctl, 0, enable);
    }
		
	return 0;
}

int mix_set_outputpath_onoff(struct mixer *mixer, int path ,bool onoff)
{
	struct mixer_ctl *ctl;
	struct audio_para_conf *path_para;
	int i, j, num_values, size;
	switch(path) {
	case T_OUTPUT_RECEIVER:
		size = ARRAY_SIZE(rcv_path_onoff);
		path_para = rcv_path_onoff;
		break;
	case T_OUTPUT_SPEAKER:
		size = ARRAY_SIZE(spk_path_onoff);
		path_para = spk_path_onoff;
		break;
	case T_OUTPUT_HEADSET:
		size = ARRAY_SIZE(earp_path_onoff);
		path_para = earp_path_onoff;
		break;
	default:
		return -1;
	}

	for (i = 0; i < size; i++) {
		ctl = mixer_get_ctl_by_name(mixer, path_para[i].control);
		num_values = mixer_ctl_get_num_values(ctl);

	    for (j = 0; j < num_values; j++) {
			mixer_ctl_set_value(ctl, j, onoff);
	    }

//		mix_set_value_wrap(mixer, spk_path_onoff[i].control, spk_path_onoff[i].values);
    }

	return 0;
}
*/






int mix_set_voice_path(struct mixer *mixer, int path)
{
	int i;
/*
	for (i = 0; i < ARRAY_SIZE(common_in_para_audio); i++) {
		tinymix_set_value_test(mixer, common_in_para_audio[i].control, common_in_para_audio[i].values);
	}
	
	for(i = 0;i<ARRAY_SIZE(common_out_para_audio);i++)
	{
 	  	tinymix_set_value_test(mixer,common_out_para_audio[i].control,common_out_para_audio[i].values);
	}
*/	
	switch (path) {
	case T_OUTPUT_RECEIVER:
		for (i = 0; i < ARRAY_SIZE(handset_inoutpath_para_voice); i++)	{
			mix_set_value_wrap(mixer, handset_inoutpath_para_voice[i].control, handset_inoutpath_para_voice[i].values);
		}
		break;
	case T_OUTPUT_SPEAKER:
		for (i = 0; i < ARRAY_SIZE(spk_inoutpath_para_voice); i++) {
			mix_set_value_wrap(mixer, spk_inoutpath_para_voice[i].control, spk_inoutpath_para_voice[i].values);
		}
		break;
	case T_OUTPUT_HEADSET:
		for (i = 0; i < ARRAY_SIZE(headset_inoutpath_para_voice); i++) {
			mix_set_value_wrap(mixer, headset_inoutpath_para_voice[i].control, headset_inoutpath_para_voice[i].values);
		}
	default:
		break;
	}

	return 0;
}


int mix_get_voice_path(struct mixer *mixer, int *path)
{

	mix_get_value_wrap(mixer, "audio path select", path);

	return 0;

}
/*

int mix_set_in_call_tone(struct mixer *mixer, int tontype)
{
	struct mixer_ctl *ctl;
	char name[] = "voice tone sel";
	ctl = mixer_get_ctl_by_name(mixer, name);
	if (!ctl) {
		fprintf(stderr, "Invalid mixer control\n");
		return -1;
	}

	mixer_ctl_set_value(ctl, 0, tontype);

	return 0;
}

int mix_set_default_param(struct mixer *mixer) 
{
	int i;
	for (i = 0; i < ARRAY_SIZE(init_default_para); i++) {
		mix_set_value_wrap(mixer, init_default_para[i].control, init_default_para[i].values);
	}
	
	return 0;
}

*/

	
	
	
//����voice��Ƶ�豸ģʽ dev_mode��handset,speaker,headset	0 ��ʾ�ɹ��� ������ʾ�д���
int set_voice_device_mode(int dev_mode)
{

	struct mixer *voice_mixer = NULL;
	printf("%s: start dev_mode=%d!\n",__func__, dev_mode);

	if ((dev_mode < T_OUTPUT_HANDSET ) ||(dev_mode >= T_OUTPUT_MAX)){
		printf("%s: dev_mode not support, dev_mode=%d!\n",__func__, dev_mode);
		return -1;
	}

	//open mixer dev for  control
	voice_mixer = mixer_open(VOCIE_SND_CARD_NUM);
	if (!voice_mixer) {
		printf("voice_mixer open failed!\n");
		return -1;
	}

	//config mixer dev
	mix_set_voice_path(voice_mixer, dev_mode);

	//close mixer
	mixer_close(voice_mixer);
	voice_mixer = NULL;


	return 0;
	
	
}

//#ifdef _CPE_AUDIO_PRJ
#else
int mix_set_output_path(struct mixer *mixer, int path)
{
	
	return 0;
}

int mix_set_input_path(struct mixer *mixer, int path)
{


	return 0;
}

int mix_set_input_vol(struct mixer *mixer, int volume)
{


	return 0;
}

int mix_set_output_vol(struct mixer *mixer, int volume)
{


	return 0;
}

int mix_set_output_mute(struct mixer *mixer, bool enable)
{


	return 0;
}

int mix_set_input_mute(struct mixer *mixer, bool enable)
{

		
	return 0;
}

int mix_set_outputpath_onoff(struct mixer *mixer, int path ,bool onoff)
{

	return 0;
}


int mix_set_voice_vol(struct mixer *mixer, int volume)
{


	return 0;
}

int mix_set_voice_mute(struct mixer *mixer, bool enable)
{

	
	return 0;
}

int mix_set_voice_path(struct mixer *mixer, int path)
{
	int i;


	return 0;
}


int mix_set_in_call_tone(struct mixer *mixer, int tontype)
{


	return 0;
}

int mix_set_default_param(struct mixer *mixer) 
{

	return 0;
}

int mix_get_voice_vol(struct mixer *mixer, int *volume)
{

	return 0;
}

int mix_set_tx_voice_vol(struct mixer *mixer, int volume)
{
	return 0;
}

int mix_get_tx_voice_vol(struct mixer *mixer, int *volume)
{

	return 0;

}

int mix_get_voice_mute(struct mixer *mixer, int *enable)
{

	return 0;

}

//voice downlink mute

int mix_set_rx_voice_mute(struct mixer *mixer, bool enable)
{
	return 0;
}
int mix_get_rx_voice_mute(struct mixer *mixer, int *enable)
{

	return 0;

}

int mix_get_voice_path(struct mixer *mixer, int *path)
{

	return 0;

}

int set_voice_device_mode(int dev_mode)
{
    return 0;
}

#endif
