#ifndef  _AUDIO_MIXER_CTRL_H
#define  _AUDIO_MIXER_CTRL_H
#include <stdint.h>
#include <stdbool.h>
#include <tinyalsa/asoundlib.h>
#include <sound/asound.h>

enum t_tone_class {
	T_LOWPOWER_TONE  = 0,
	T_SMS_TONE       = 1,
	T_CALLSTD_TONE   = 2,	    
	T_ALARM_TONE     = 3,
	T_CALL_TIME_TONE = 4,	    
};

enum t_output_path {
    T_OUTPUT_RECEIVER = 0,
	T_OUTPUT_HANDSET  = T_OUTPUT_RECEIVER,	
    T_OUTPUT_SPEAKER  = 1,
    T_OUTPUT_HEADSET  = 2,
    T_OUTPUT_MAX,
    
};


enum t_input_path {
    T_INPUT_MICLP    = 0,
    T_INPUT_MICRP    = 1,
	T_INPUT_HANDSET  = T_INPUT_MICLP,	
	T_INPUT_SPEAKER  = T_INPUT_MICRP,
	T_INPUT_HEADSET  = 2,
	T_INPUT_MAX,    
};

enum t_audio_out_vol {
    T_AUDIO_OUTPUT_VOL_LEVEL_0 = 0,
    T_AUDIO_OUTPUT_VOL_LEVEL_1,
    T_AUDIO_OUTPUT_VOL_LEVEL_2,
    T_AUDIO_OUTPUT_VOL_LEVEL_3,
    T_AUDIO_OUTPUT_VOL_LEVEL_4,
    T_AUDIO_OUTPUT_VOL_LEVEL_5,
    T_AUDIO_OUTPUT_VOL_LEVEL_6,
    T_AUDIO_OUTPUT_VOL_LEVEL_7,
    T_AUDIO_OUTPUT_VOL_LEVEL_8,
    T_AUDIO_OUTPUT_VOL_LEVEL_9,
    T_AUDIO_OUTPUT_VOL_LEVEL_10,
    T_AUDIO_OUTPUT_VOL_LEVEL_11,
    T_AUDIO_OUTPUT_VOL_LEVEL_12,
    T_AUDIO_OUTPUT_VOL_LEVEL_13,
    T_AUDIO_OUTPUT_VOL_LEVEL_14,
    T_AUDIO_OUTPUT_VOL_LEVEL_15,
    T_AUDIO_OUTPUT_VOL_LEVEL_16,
    T_MAX_AUDIO_OUTPUT_VOL_LEVEL     
};

enum t_audio_in_vol {
    T_AUDIO_INPUT_VOL_LEVEL_0 = 0,
    T_AUDIO_INPUT_VOL_LEVEL_1,
    T_AUDIO_INPUT_VOL_LEVEL_2,
    T_AUDIO_INPUT_VOL_LEVEL_3,
    T_AUDIO_INPUT_VOL_LEVEL_4,
    T_AUDIO_INPUT_VOL_LEVEL_5,
    T_AUDIO_INPUT_VOL_LEVEL_6,
    T_AUDIO_INPUT_VOL_LEVEL_7,
    T_AUDIO_INPUT_VOL_LEVEL_8,
    T_AUDIO_INPUT_VOL_LEVEL_9,
    T_AUDIO_INPUT_VOL_LEVEL_10,
    T_AUDIO_INPUT_VOL_LEVEL_11,
	
    T_MAX_AUDIO_INPUT_VOL_LEVEL     
} ;

enum t_voice_vol {   //  volume level for voice
    T_VOICE_VOL_0_LEVEL = 0,
    T_VOICE_VOL_1_LEVEL = 1,
    T_VOICE_VOL_2_LEVEL = 2,
    T_VOICE_VOL_3_LEVEL = 3,
    T_VOICE_VOL_4_LEVEL = 4,
    T_VOICE_VOL_5_LEVEL = 5,
};

int mix_set_output_path(struct mixer *mixer, int path);
int mix_set_input_path(struct mixer *mixer, int path);
int mix_set_input_vol(struct mixer *mixer, int volume);
int mix_set_output_vol(struct mixer *mixer, int volume);
int mix_set_output_mute(struct mixer *mixer, bool enable);
int mix_set_input_mute(struct mixer *mixer, bool enable);
int mix_set_outputpath_onoff(struct mixer *mixer, int path ,bool onoff);
int mix_set_voice_vol(struct mixer *mixer, int volume);
int mix_set_voice_mute(struct mixer *mixer, bool enable);
int mix_set_voice_path(struct mixer *mixer, int path);
int mix_set_in_call_tone(struct mixer *mixer, int tontype);
int mix_set_default_param(struct mixer *mixer);
int set_voice_device_mode(int dev_mode);

#endif
