DESCRIPTION = "opencore-amr"
DEPENDS     = ""
SECTION     = "lib"
LICENSE     = "zte"
PV          = "0.1.3"
PR          = "r0"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}/platform:"
#SRC_URI = " \
#          file://opencore-amr-${PV} \
#          "
SRC_URI = " \          
		  https://sourceforge.net/projects/opencore-amr/files/opencore-amr/opencore-amr-${PV}.tar.gz \
		  file://0001-fix-for-sanchips-device.patch \
          "
		  
SRC_URI[md5sum] = "09d2c5dfb43a9f6e9fec8b1ae678e725"
SRC_URI[sha256sum] = "106bf811c1f36444d7671d8fd2589f8b2e0cca58a2c764da62ffc4a070595385"
		  
S = "${WORKDIR}"
#引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc

do_configure () {	
	cd opencore-amr-${PV} && ./build_sc.sh
}

#库和头文件的安装
do_install () {
	install -d ${D}${libdir}/

	install -d ${D}/usr/include
	install -d ${D}/usr/include/opencore-amrnb
	install -d ${D}/usr/include/opencore-amrwb

	install -m 0755 ${S}/opencore-amr-${PV}/pkgs/lib/*.a   ${D}${libdir}/
	
	install -m 0644 ${S}/opencore-amr-${PV}/pkgs/include/opencore-amrnb/*.h ${D}/usr/include/opencore-amrnb
	install -m 0644 ${S}/opencore-amr-${PV}/pkgs/include/opencore-amrwb/*.h ${D}/usr/include/opencore-amrwb
		
	#install elfs
	install -d ${ELFS-PATH}/
	install -m 0755 ${S}/opencore-amr-${PV}/pkgs/lib/*.a ${ELFS-PATH}/

}

#清库
do_cleanlibs () {
	rm -fr ${ELFS-PATH}/libopencore-amrnb.a
	rm -fr ${ELFS-PATH}/libopencore-amrwb.a
}

#rootfs包含的文件
FILES_${PN}       += "${libdir}/*.so"
FILES_${PN}-dbg   += "${libdir}/.debug"
FILES_SOLIBSDEV   = ""
INSANE_SKIP_${PN} = "dev-so"
