DESCRIPTION = "zxic_mainctrl"
DEPENDS     = "libdebug-info libnvram libsofttimer libatutils libsoftap openssl libscipc libupi-ab"
SECTION     = "app"
LICENSE     = "zte"
PV = "1.0.0"
PR = "r0"

CLASS_COM = " \
    ${@bb.utils.contains('DISTRO_FEATURES', 'procd', 'openwrt openwrt-services', '', d)} \
    ${@bb.utils.contains('DISTRO_FEATURES', 'systemd', 'systemd', '', d)} \
"
inherit ${CLASS_COM}

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}/platform:"
SRC_URI = " \
          file://zxic_mainctrl \
		  ${@bb.utils.contains("DISTRO_FEATURES", "procd", "file://zxic_mainctrl.init","", d)} \
		  ${@bb.utils.contains("DISTRO_FEATURES", "systemd", "file://zxic_mainctrl.service","", d)} \
		  ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "file://zxic_mainctrl.sysvinit","", d)} \
          "
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"
S = "${WORKDIR}"
S_SRC_PATH = "${S}/zxic_mainctrl"
#引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc
include ${BSPDIR}/sources/meta-zxic/conf/pub.inc
CFLAGS_append += "${ZXIC_EXTRA_CFLAGS}"

#inherit autotools pkgconfig systemd

do_compile() {
	#echo "TOPDIR = ${TOPDIR}"
	
	make -C ${S_SRC_PATH}
}

do_install () {
	install -d ${D}${bindir}/
	install -m 0755 ${S_SRC_PATH}/zxic_mainctrl ${D}${bindir}/
	install -m 0755 ${S_SRC_PATH}/router_msg_proxy ${D}${bindir}/
	
	if ${@bb.utils.contains('DISTRO_FEATURES','procd','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/zxic_mainctrl.init ${D}${sysconfdir}/init.d/zxic_mainctrl
	fi

	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
		install -d ${D}${systemd_unitdir}/system
		install -m 0644 ${WORKDIR}/zxic_mainctrl.service ${D}${systemd_unitdir}/system
	fi
	
	if ${@bb.utils.contains('DISTRO_FEATURES','sysvinit','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/zxic_mainctrl.sysvinit ${D}${sysconfdir}/init.d/zxic_mainctrl
		install -d ${D}${sysconfdir}/rcS.d
		ln -s ../init.d/zxic_mainctrl ${D}${sysconfdir}/rcS.d/S40zxic_mainctrl
	fi

	#install elfs
	install -d ${ELFS-PATH}/
	install -m 0755 ${S_SRC_PATH}/zxic_mainctrl ${ELFS-PATH}/
	install -m 0755 ${S_SRC_PATH}/router_msg_proxy ${ELFS-PATH}/	
}

do_cleanlibs () {
	rm -fr ${ELFS-PATH}/zxic_mainctrl
	rm -fr ${ELFS-PATH}/router_msg_proxy
}

addtask  cleanlibs after do_clean  before do_cleansstate

FILES_${PN} = "\
    ${bindir}/ \
    ${@bb.utils.contains("DISTRO_FEATURES", "procd", "${sysconfdir}/init.d/zxic_mainctrl","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "${sysconfdir}/","", d)} \
    "
SYSTEMD_SERVICE_${PN}     = "zxic_mainctrl.service"
SYSTEMD_AUTO_ENABLE_${PN} = "enable"

RDEPENDS_${PN} = " libdebug-info libnvram libsofttimer libatutils libsoftap openssl libscipc libupi-ab"
