DESCRIPTION = "Script"
DEPENDS     = ""
SECTION     = "app"
LICENSE     = "zte"
PV = "1.0.0"
PR = "r0"

CLASS_COM = " \
    ${@bb.utils.contains('DISTRO_FEATURES', 'procd', 'openwrt openwrt-services', '', d)} \
    ${@bb.utils.contains('DISTRO_FEATURES', 'systemd', 'systemd', '', d)} \
"
inherit ${CLASS_COM}

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}/platform:"
SRC_URI = " \
          file://Script \
		  ${@bb.utils.contains("DISTRO_FEATURES", "procd", "file://udhcpd.init","", d)} \
		  ${@bb.utils.contains("DISTRO_FEATURES", "systemd", "file://udhcpd.service","", d)} \
		  ${@bb.utils.contains("DISTRO_FEATURES", "procd", "file://udhcpc.init","", d)} \
		  ${@bb.utils.contains("DISTRO_FEATURES", "systemd", "file://udhcpc.service","", d)} \
		  ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "file://udhcpd.sysvinit","", d)} \
		  ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "file://udhcpc.sysvinit","", d)} \
          "
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"
S = "${WORKDIR}"

#引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc

#编译
do_compile() {
	make -C Script
}

#库文件的安装，封库的宏MK_SDK_VERSION
do_install () {
	##${D}=/Script/1.0.0-r0/image
	#install -d ${D}${sbindir}/
	install -d ${D}/sbin/	
	
	if ${@bb.utils.contains('DISTRO_FEATURES','procd','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/udhcpd.init ${D}${sysconfdir}/init.d/udhcpd
		install -Dm 0755 ${WORKDIR}/udhcpc.init ${D}${sysconfdir}/init.d/udhcpc
	fi

	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
		install -d ${D}${systemd_unitdir}/system
		install -m 0644 ${WORKDIR}/udhcpd.service ${D}${systemd_unitdir}/system
		install -m 0644 ${WORKDIR}/udhcpc.service ${D}${systemd_unitdir}/system
	fi
	
	if ${@bb.utils.contains('DISTRO_FEATURES','sysvinit','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/udhcpd.sysvinit ${D}${sysconfdir}/init.d/udhcpd
		install -Dm 0755 ${WORKDIR}/udhcpc.sysvinit ${D}${sysconfdir}/init.d/udhcpc
		install -d ${D}${sysconfdir}/rcS.d
	fi
	
	install -m 0755 ${S}/Script/scripts/*.sh ${D}/sbin/
	#install -m 0755 ${S}/Script/scripts/*.txt ${D}/sbin/
	install -m 0755 ${S}/Script/wifi_script/common/*.sh ${D}/sbin/
	
	install -d ${D}/etc_ro/	
	install -m 0755 ${S}/Script/etc/*.conf ${D}/etc_ro/
	install -m 0755 ${S}/Script/etc/options.auth ${D}/etc_ro/
	install -m 0755 ${S}/Script/etc/options.noauth ${D}/etc_ro/
	install -m 0755 ${S}/Script/etc/initchat ${D}/etc_ro/
	install -m 0755 ${S}/Script/etc/pap-secrets ${D}/etc_ro/
	install -m 0755 ${S}/Script/etc/chap-secrets ${D}/etc_ro/		
}
#清库
do_cleanlibs () {	
}

addtask  cleanlibs after do_clean  before do_cleansstate

#rootfs包含的文件
FILES_${PN} = "/sbin/ /etc_ro/"
FILES_${PN} += "\	
    ${@bb.utils.contains("DISTRO_FEATURES", "procd", "${sysconfdir}/init.d/udhcpd","", d)} \
	${@bb.utils.contains("DISTRO_FEATURES", "procd", "${sysconfdir}/init.d/udhcpc","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "${sysconfdir}/","", d)} \
    "
	
SYSTEMD_SERVICE_${PN}     = "udhcpd.service udhcpc.service"
SYSTEMD_AUTO_ENABLE_${PN} = "disable"	