DESCRIPTION = "linux zxic modify"
SECTION     = "linux zxic modify"
LICENSE     = "zte"
PV = "1.0.0"
PR = "r0"

DEPENDS += "kern-tools-native  flex-native bison-native  bc-native "
FILESEXTRAPATHS_prepend := "${THISDIR}/linux-zxic-modify:"

SRC_URI = " \
    file://Makefile \
    "

SRC_URI[sha256sum] = "054819ffb4eb9e670f762e56d3496ee7018b5c3473d8b83c7f3fa6de02a37bc8"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"
S = "${WORKDIR}"

#编译
machineinfo =+ "${@bb.utils.contains("MACHINE", "zx279132", "zx279132s", "${MACHINE}", d)}"
libc="${@bb.utils.contains("TCLIBC", "musl", "-musl","", d)}"
linux="${PREFERRED_PROVIDER_virtual/kernel}"
KERNEL_BIN_NAME="${@bb.utils.contains("BOOT_CTL", "recovery", "ap_cpuap_recovery.bin", "ap_cpuap.bin", d)}"

EXTRA_OEMAKE_append = "ARCH=${TARGET_ARCH} CROSS_COMPILE=${TARGET_PREFIX}  S="${TMPDIR}/work/${MACHINE}${SDK_VENDOR}-${SDK_OS}${libc}/${linux}/5.4.154-r0" \
                       BINS-PATH=${BINS-PATH} ELFS-PATH=${ELFS-PATH} DISTRO=${DISTRO} MACHINE=${machineinfo}  KERNEL_BIN_NAME=${KERNEL_BIN_NAME} "
do_compile() {
    oe_runmake -C  ${B}
}

#清image
do_cleanimage () {
	rm -fr ${BINS-PATH}/ap_kernel.bin
	rm -fr ${BINS-PATH}/Image
	rm -fr ${BINS-PATH}/*.dtb
	rm -fr ${ELFS-PATH}/linux-zxic/
}

addtask  do_cleanimage after do_clean  before do_cleansstate
