/**
 * 
 * @file      ap_log.c
 * @brief     
 *            This file is part of ZCAT.
 *            zcatӦòlog_agentlogcat_printf/logcat_printk豸
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2019/02/02
 * @version   1.2
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2017/07/17  1.0      hou.bing       Create file
 * 2019/01/24  1.1      jiang.fenglin  1.usblogд
 *                                     2.߳
 * 2019/02/02  1.2      jiang.fenglin  ޸עͷʽΪdoxygen
 * ---------------------------------------------------------------------------
 * 
 * 
 */

#include <string.h>
#include <pthread.h>
#include <sys/prctl.h>
#include "log_agent.h"

/*豸·*/
const char* kernellog_dev = "/dev/logcat_printk";
const char* applog_dev = "/dev/logcat_printf";

static BOOL g_KernelNewLine = TRUE;
static BOOL g_AppNewLine    = TRUE;
extern int hb_flag;
pthread_t read_kernellog_thread = 0;;
pthread_t read_applog_thread = 0;;
int kernellog_fd = -1;
int applog_fd = -1;

extern void zCatAgt_Ap_GetModAndPri(unsigned char **buf, unsigned short *bufLen, unsigned char *pPriority, unsigned char *pMod);
extern BOOL zCatAgt_Ap_ReadBuffer(T_AP_SRC_BUFFER_TYPE *src, T_AP_DEST_BUFFER_TYPE *dest);
extern unsigned int zCatAgt_Ap_SendMsg(unsigned char cmd_code, unsigned char priority, unsigned char mod, unsigned char *buf, unsigned int len);

/**
 * @brief ȡapplog̺߳\n
 *        applog_dev豸еlogݣתȥ.
 * @param[in] args ̺߳
 * @return void
 * @note
 * @see 
 */
void *read_applog(void* args)
{
    int read_len = -1; 
    static unsigned char  readApplogBuffer[4096] = {0};
    
    prctl(PR_SET_NAME, "read_applog");
    //printf("zcat: read_applog \n"); 
    while(1)
    {     
         if(hb_flag)
         read_len = read(applog_fd, readApplogBuffer, sizeof(readApplogBuffer));  
         if(read_len>0) 
         {
                T_AP_DEST_BUFFER_TYPE dest = {0};
                T_AP_SRC_BUFFER_TYPE src = {0};
                src.buf = readApplogBuffer;
                src.beginIndex=0;
                src.bufSize = read_len;
                //printf("zcat: read_applog read_len %d \n", read_len); 
                
                while (zCatAgt_Ap_ReadBuffer(&src , &dest))
                {
                    unsigned char *p   = dest.buf;
                    unsigned short len = dest.len;
                    unsigned char  priority = APP_LOG_DEFAULT_LEVEL;
                    unsigned char  mod = 1;
                    static unsigned char curPriority = APP_LOG_DEFAULT_LEVEL;

                    if (g_AppNewLine)
                    {
                        g_AppNewLine = FALSE;
                        zCatAgt_Ap_GetModAndPri(&p, &len, &priority, &mod);
                        curPriority = priority;
                    }
                    else
                    {
                        priority = curPriority;
                    }
                    zCatAgt_Ap_SendMsg(ZCAT_AP_APP_LOG, priority, mod, p, len);
                    if (dest.newLine == 1)
                    {
                        g_AppNewLine = TRUE;
                    }
                    memset(&dest, 0, sizeof(T_AP_DEST_BUFFER_TYPE));
                }
                memset(readApplogBuffer, 0, sizeof(readApplogBuffer));
         }
          else
        {
            sleep(1);
        }

    }
    return NULL;
}


/**
 * @brief ȡkernellog̺߳\n
 *        kernellog_dev豸еlogݣתȥ.
 * @param[in] args ̺߳
 * @return void
 * @note
 * @see 
 */
void *read_kernellog(void* args)
{
    int read_len = -1; 
    unsigned char readKernelLogBuffer[1024] = {0};

    prctl(PR_SET_NAME, "read_kernellog");
    //printf("read_kernellog kkkkkkkkkkkk fd %d\n", fd); 
    while(1)
    {            
        if(hb_flag)
        read_len = read(kernellog_fd, readKernelLogBuffer, sizeof(readKernelLogBuffer)); 
        if(read_len > 0) 
        {
            T_AP_DEST_BUFFER_TYPE dest = {0};
            T_AP_SRC_BUFFER_TYPE src = {0};
            src.buf = readKernelLogBuffer;
            src.beginIndex=0;
            src.bufSize = read_len;
            //printf("read_kernellog read_len %d \n", read_len); 
            //CHAR atCmd[200] = {0};
            //g_cp_log_count++;
            //sprintf(atCmd, " /sbin/atlog.sh \"%s\" \"%s\" \"%s\",\"%d\",\"%d\"", "send",zte_time(),"wubo deal_with_kernellog_from_devkkkkkkkk", read_len, 0); 
            //system(atCmd);
            while (zCatAgt_Ap_ReadBuffer(&src , &dest))
            {
                unsigned char *p   = dest.buf;
                unsigned short len = dest.len;
                unsigned char  priority = KERNEL_LOG_DEFAULT_LEVEL;
                unsigned char  mod = 1;
                static unsigned char curPriority = KERNEL_LOG_DEFAULT_LEVEL;

                if (g_KernelNewLine)
                {
                    g_KernelNewLine = FALSE;
                    zCatAgt_Ap_GetModAndPri(&p, &len, &priority, &mod);
                    curPriority = priority;
                }
                else
                {
                    priority = curPriority;
                }
                zCatAgt_Ap_SendMsg(ZCAT_AP_KERNEL_LOG, priority, mod, p, len);

                if (dest.newLine == 1)
                {
                    g_AppNewLine = TRUE;
                }

                memset(&dest, 0, sizeof(T_AP_DEST_BUFFER_TYPE));
            }
            memset(readKernelLogBuffer, 0, sizeof(readKernelLogBuffer));
        }
        else
        {
            sleep(1);
        }
    }
}

