/************************************************************************
 * Id: log.c                                                            *
 *                                                                      *
 * TR069 Project:  A TR069 library in C                                 *
 * Copyright (C) 2013-2014  netcwmp.netcwmp group                                *
 *                                                                      *
 *                                                                      *
 * Email: netcwmp ( & ) gmail dot com                                *
 *                                                                      *
 ***********************************************************************/
 
 
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include "cwmp/log.h"

#include <syslog.h>


struct cwmp_log_t
{
    FILE * file;
    int level;
    char * name;
	int file_no;
	long max_size;
};

static cwmp_log_t 	    g_cwmp_log_file;
static cwmp_log_t 		*	g_ot_log_file_ptr;


//ȡLogļ

int cwmp_log_init(const char * filename, int level)
{

    g_cwmp_log_file.file = NULL;
    g_cwmp_log_file.name = NULL;
    if (filename)
    {
        g_cwmp_log_file.file = fopen(filename,"a+");
        g_cwmp_log_file.name = strdup(filename);
    }

    if (g_cwmp_log_file.file == NULL)
    {
        g_cwmp_log_file.file = stdout;
    }

    g_cwmp_log_file.level = level;

	g_cwmp_log_file.file_no = fileno(g_cwmp_log_file.file);

	g_cwmp_log_file.max_size = 512*1024;

    g_ot_log_file_ptr = &g_cwmp_log_file;

    return 0;
}

void cwmp_log_fini()
{
    if (g_cwmp_log_file.name)
    {
        free(g_cwmp_log_file.name);
    }

    if ((g_cwmp_log_file.file != stdout) && (g_cwmp_log_file.file != NULL))
    {
        fclose(g_cwmp_log_file.file);
    }

	g_cwmp_log_file.file_no = -1;

}

void cwmp_log_console(int level, cwmp_log_t * log, const char * fmt, va_list ap)
{
    int priority = 0;
	char buf[1024] = {0}; 

    switch(level)
    {
        case CWMP_LOG_STDERR:
			priority = LOG_DEBUG;
			break;
			
        case CWMP_LOG_EMERG:
			priority = LOG_EMERG;
			break;
			
        case CWMP_LOG_ALERT:
			priority = LOG_ALERT;
			break;
			
        case CWMP_LOG_CRIT:
			priority = LOG_CRIT;
			break;
			
        case CWMP_LOG_ERROR:
			priority = LOG_ERR;
			break;
			
        case CWMP_LOG_WARN:
			priority = LOG_WARNING;
			break;
			
        case CWMP_LOG_NOTICE:
			priority = LOG_NOTICE;
			break;
			
        case CWMP_LOG_INFO:
			priority = LOG_INFO;
			break;
			
        case CWMP_LOG_TRACE:
			priority = LOG_INFO;
			break;
			
        case CWMP_LOG_DEBUG:
			priority = LOG_DEBUG;
			break;

		default:
			priority = LOG_DEBUG;
			break;			
    }

//    vsyslog(priority, fmt, ap);

    vsnprintf(buf, 1023, fmt, ap);
    printf("%s",buf);
}

void cwmp_log_write(int level, cwmp_log_t * log, const char * fmt, va_list ap)
{
    cwmp_log_t * logger;
	long cur_log_size = 0;

    if (log)
    {
        if (log->level < level )
        {
            return;
        }
    }
    else
    {
        if (g_cwmp_log_file.level < level)
        {
            return;
        }
    }

    logger = g_ot_log_file_ptr;

    vfprintf(logger->file, fmt, ap);
    fprintf(logger->file, "\n");

    fflush(logger->file);

    fsync(logger->file_no);

    fseek(logger->file, 0, SEEK_END);

    cur_log_size = ftell(logger->file);	

	if(cur_log_size > logger->max_size)
	{   
	    char buf[1024] = {0};
		cur_log_size = 0;
		fclose(logger->file);
		snprintf(buf, 1023, "%s_bak", g_cwmp_log_file.name);
		if(rename(g_cwmp_log_file.name, buf) < 0)
		{
		    printf("Rename fail!");
		}

        g_cwmp_log_file.file = fopen(g_cwmp_log_file.name,"a+");

        if (g_cwmp_log_file.file == NULL)
        {
            g_cwmp_log_file.file = stdout;
        }
    	g_cwmp_log_file.file_no = fileno(g_cwmp_log_file.file);		
	}
		
}

void cwmp_log_tracer_src(int level, cwmp_log_t * log,const char * fmt, ...)
{
    va_list ap = {0};

    va_start(ap, fmt);
	cwmp_log_console(level, log, fmt, ap);
    cwmp_log_write(level, log, fmt, ap);
    va_end(ap);

}

void cwmp_log_debug_src(const char * fmt, ...)
{
    va_list ap = {0};
    if (g_ot_log_file_ptr->level < CWMP_LOG_DEBUG)
        return;

    va_start(ap, fmt);
	cwmp_log_console(CWMP_LOG_DEBUG, g_ot_log_file_ptr, fmt, ap);
    cwmp_log_write(CWMP_LOG_DEBUG, g_ot_log_file_ptr, fmt, ap);
    va_end(ap);
}

void cwmp_log_info_src(const char * fmt, ...)
{
    va_list ap = {0};
    if (g_ot_log_file_ptr->level < CWMP_LOG_INFO)
        return;

    va_start(ap, fmt);
	cwmp_log_console(CWMP_LOG_INFO, g_ot_log_file_ptr, fmt, ap);
    cwmp_log_write(CWMP_LOG_INFO, g_ot_log_file_ptr, fmt, ap);
    va_end(ap);
}

void cwmp_log_error_src(const char * fmt, ...)
{
    va_list ap = {0};
    if (g_ot_log_file_ptr->level < CWMP_LOG_ERROR)
        return;

    va_start(ap, fmt);
	cwmp_log_console(CWMP_LOG_ERROR, g_ot_log_file_ptr, fmt, ap);
    cwmp_log_write(CWMP_LOG_ERROR, g_ot_log_file_ptr, fmt, ap);
    va_end(ap);
}

void cwmp_log_alert_src(const char * fmt, ...)
{
    va_list ap = {0};
    if (g_ot_log_file_ptr->level < CWMP_LOG_ALERT)
        return;

    va_start(ap, fmt);
	cwmp_log_console(CWMP_LOG_ALERT, g_ot_log_file_ptr, fmt, ap);
    cwmp_log_write(CWMP_LOG_ALERT, g_ot_log_file_ptr, fmt, ap);
    va_end(ap);
}

void cwmp_log_critical_src(const char * fmt, ...)
{
    va_list ap = {0};
    if (g_ot_log_file_ptr->level < CWMP_LOG_CRIT)
        return;

    va_start(ap, fmt);
	cwmp_log_console(CWMP_LOG_CRIT, g_ot_log_file_ptr, fmt, ap);
    cwmp_log_write(CWMP_LOG_CRIT, g_ot_log_file_ptr, fmt, ap);
    va_end(ap);
}

