/************************************************************************
* Ȩ (C)2012, ͨѶɷ޹˾
*
* ļƣ zte_web_mc.c
* ļʶ
* ժҪ
* ˵
* ǰ汾 V0.1
*     ߣ liuyingnan
* ڣ 2012-10-25
*
* ޸ļ¼1
* ޸ݣʼ汾
************************************************************************/

#include "zte_web_mc.h"
#include "message.h"

/******************************************************
* Function:        zte_mc_relay_sms_send_msg
* Description:    the fun to relay SMS send send msg  to the mc process
* Input:
* Output:
* Return:
* Others:
* Modify Date    Version   Author         Modification
* 20121025        V1.0     liuyingnan     create
*******************************************************/
int zte_mc_relay_sms_send_msg(T_zUfiSms_SendReq *msg_ptr)
{
	int ret_code = 0;
	T_zGoaheadMsgBuf send_msg;


	memset(&send_msg, 0, sizeof(send_msg));

	/*check  the input param*/
	if (msg_ptr == NULL) {
		slog(MISC_PRINT, SLOG_ERR, "the mc_relay_sms_send_msg fun's input param is valid!"); /*lint !e26*/
		return -1;
	}

	/*set the value*/
	send_msg.msg_hdr.type = ZTE_SMS_RELAY_TYPE;
	send_msg.msg_hdr.id = ZTE_MC_SMS_SEND_MSG_CMD;
	send_msg.msg_hdr.result = OK;
#if 0  // kw 3  INVARIANT_CONDITION.UNREACH
	/*check the length before memcpy for  safe*/
	if (sizeof(T_zUfiSms_SendReq) > ZTE_MODEM_RELAY_MSGBUF_MAX_LEN) { /*lint !e506*/
		slog(MISC_PRINT, SLOG_ERR, "the size of sms_send_msg_ui_req_info_s_type is more than the msg buf , sizeof(sms_send_msg_ui_req_info_s_type) = %d!"
		     , sizeof(T_zUfiSms_SendReq));/*lint !e26*/
		return -1;
	}
#endif
	memcpy(send_msg.msg_data, msg_ptr, sizeof(T_zUfiSms_SendReq));

	slog(MISC_PRINT, SLOG_NORMAL, "send_message sms send msg start!"); /*lint !e26*/

	//ret_code = zte_send_message(ZUFI_MODULE_ID_AT_LOCAL,MSG_CMD_SEND_SMS, sizeof(send_msg), (char*)&send_msg);
	ret_code = ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_SMS, MSG_CMD_SEND_SMS, sizeof(send_msg), (char*)&send_msg, 0);
	slog(MISC_PRINT, SLOG_DEBUG, "send_message sms send msg end!"); /*lint !e26*/

	if (ret_code != OK) {
		slog(MISC_PRINT, SLOG_ERR, "mc lib relay sms send msg fail"); /*lint !e26*/
		return -1;
	}

	return OK;
}


/******************************************************
* Function:        zte_mc_relay_sms_modify_tag
* Description:    the fun to relay SMS send modify tag msg  to the mc process
* Input:
* Output:
* Return:
* Others:
* Modify Date    Version   Author         Modification
* 20121025        V1.0     liuyingnan     create
*******************************************************/
int zte_mc_relay_sms_modify_tag(T_zUfiSms_ModifyFlag *modify_info_tmp)
{
	int ret_code = 0;
	T_zGoaheadMsgBuf send_msg;
	//zte_wms_modify_tag_s_type modify_info_tmp;

	memset(&send_msg, 0, sizeof(send_msg));
	//memset(&modify_info_tmp, 0, sizeof(modify_info_tmp));

	/*set the value*/
	send_msg.msg_hdr.type = ZTE_SMS_RELAY_TYPE;
	send_msg.msg_hdr.id = ZTE_MC_SMS_MODIFY_TAG_CMD;
	send_msg.msg_hdr.result = OK;

	//modify_info_tmp.sms_file = sms_file;
	//modify_info_tmp.sms_id = msg_id;
#if 0  // kw 3  INVARIANT_CONDITION.UNREACH
	/*check the length before memcpy for  safe*/
	if (sizeof(T_zUfiSms_ModifyFlag) > ZTE_MODEM_RELAY_MSGBUF_MAX_LEN) { /*lint !e506*/
		slog(MISC_PRINT, SLOG_ERR, "the size of mc_relay_sms_modify_s_type is more than the msg buf , sizeof(mc_relay_sms_modify_s_type) = %d!"
		     , sizeof(T_zUfiSms_ModifyFlag));/*lint !e26*/
		return -1;
	}
#endif
	memcpy(send_msg.msg_data, modify_info_tmp, sizeof(T_zUfiSms_ModifyFlag));

	slog(MISC_PRINT, SLOG_NORMAL, "send_message sms modify tag start!"); /*lint !e26*/
	//ret_code = zte_send_message(ZUFI_MODULE_ID_AT_LOCAL,MSG_CMD_SMS_MODIFY_TAG, sizeof(send_msg), (char*)&send_msg);
	ret_code = ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_SMS, MSG_CMD_SMS_MODIFY_TAG, sizeof(send_msg), (char*)&send_msg, 0);
	slog(MISC_PRINT, SLOG_DEBUG, "send_message sms modify tag end!"); /*lint !e26*/

	if (ret_code != OK) {
		slog(MISC_PRINT, SLOG_ERR, "mc lib relay sms send modify tag msg fail"); /*lint !e26*/
		return -1;
	}

	return OK;
}


/******************************************************
* Function:        zte_mc_relay_sms_write_msg
* Description:    the fun to relay SMS send write msg  to the mc process
* Input:
* Output:
* Return:
* Others:
* Modify Date    Version   Author         Modification
* 20121025        V1.0     liuyingnan     create
*******************************************************/
int zte_mc_relay_sms_write_msg(T_zUfiSms_SaveReq *msg_ptr)
{
	int ret_code = 0;
	T_zGoaheadMsgBuf send_msg;

	memset(&send_msg, 0, sizeof(send_msg));

	/*check  the input param*/
	if (msg_ptr == NULL) {
		slog(MISC_PRINT, SLOG_ERR, "the mc_relay_sms_write_msg fun's input param is valid!"); /*lint !e26*/
		return -1;
	}

	/*set the value*/
	send_msg.msg_hdr.type = ZTE_SMS_RELAY_TYPE;
	send_msg.msg_hdr.id = ZTE_MC_SMS_WRITE_MSG_CMD;
	send_msg.msg_hdr.result = OK;
#if 0  // kw 3  INVARIANT_CONDITION.UNREACH
	/*check the length before memcpy for  safe*/
	if (sizeof(T_zUfiSms_SaveReq) > ZTE_MODEM_RELAY_MSGBUF_MAX_LEN) { /*lint !e506*/
		slog(MISC_PRINT, SLOG_ERR, "the size of sms_write_msg_info_s_type is more than the msg buf , sizeof(sms_write_msg_info_s_type) = %d!"
		     , sizeof(T_zUfiSms_SaveReq));/*lint !e26*/
		return -1;
	}
#endif
	memcpy(send_msg.msg_data, msg_ptr, sizeof(T_zUfiSms_SaveReq));

	slog(MISC_PRINT, SLOG_NORMAL, "send_message sms write msg start!"); /*lint !e26*/
	//ret_code = zte_send_message(ZUFI_MODULE_ID_AT_LOCAL,MSG_CMD_DRAFTS_SAVE,sizeof(send_msg), (char*)&send_msg);
	ret_code = ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_SMS, MSG_CMD_DRAFTS_SAVE, sizeof(send_msg), (char*)&send_msg, 0);
	slog(MISC_PRINT, SLOG_DEBUG, "send_message sms write msg end!"); /*lint !e26*/

	if (ret_code != OK) {
		slog(MISC_PRINT, SLOG_ERR, "mc lib relay sms send write msg fail"); /*lint !e26*/
		return -1;
	}

	return OK;
}


/******************************************************
* Function:        zte_mc_relay_sms_delete_msg
* Description:    the fun to relay SMS send delete msg  to the mc process
* Input:
* Output:
* Return:
* Others:
* Modify Date    Version   Author         Modification
* 20121025        V1.0     liuyingnan     create
*******************************************************/
int zte_mc_relay_sms_delete_msg(T_zUfiSms_DelReq *del_info_ptr)
{
	int ret_code = 0;

	//int tmp = 0;
	//int i_tmp = 0;

	/*check  the input param*/
	if (del_info_ptr == NULL) {
		slog(MISC_PRINT, SLOG_ERR,"the mc_relay_sms_delete_msg fun's input param is valid!");/*lint !e26*/
		return -1;
	}

#if 0  // kw 3  INVARIANT_CONDITION.UNREACH
	/*check the length before memcpy for  safe*/
	if (sizeof(T_zUfiSms_DelReq) > MSG_DATA_MAX_LEN) {
		slog(MISC_PRINT, SLOG_ERR,"the size of sms_delete_msg_info_s_type is more than the msg buf , sizeof(sms_delete_msg_info_s_type) = %d!"
		       , sizeof(T_zUfiSms_DelReq));/*lint !e26*/
		return -1;
	}
#endif

	//slog(MISC_PRINT,SLOG_NORMAL,"del_info_ptr->db is %d\n",del_info_ptr->db);/*lint !e26*/

	//ret_code = zte_send_message(ZTE_SOCKET_PATH_MAIN_CONTROL, sizeof(send_msg), (char*)&send_msg);
	//ret_code = zte_send_message(ZUFI_MODULE_ID_AT_LOCAL, MSG_CMD_DEL_SMS_BY_INDEX, sizeof(T_zUfiSms_DelReq), (char *)del_info_ptr);
	ret_code = ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_SMS, MSG_CMD_DEL_SMS_BY_INDEX, sizeof(T_zUfiSms_DelReq), (char *)del_info_ptr, 0);
	slog(MISC_PRINT, SLOG_DEBUG,"send_message sms delete msg end!");/*lint !e26*/
	if (ret_code != OK) {
		slog(MISC_PRINT, SLOG_ERR,"mc lib relay sms send delete msg fail");/*lint !e26*/
		return -1;
	}
	return OK;
}
/******************************************************
* Function:        zte_mc_relay_sms_move_to_sim_msg
* Description:    the fun to  SMS move to sim msg  to the mc process
* Input:
* Output:
* Return:
* Others:
* Modify Date    Version   Author         Modification
* 20121025        V1.0     liuyingnan     create
*******************************************************/
int zte_mc_relay_sms_move_to_sim_msg(T_zUfiSms_DelReq *del_info_ptr)
{
	int ret_code = 0;

	int tmp = 0;
	int i_tmp = 0;

	/*check  the input param*/
	if (del_info_ptr == NULL) {
		slog(MISC_PRINT, SLOG_ERR, "the mc_relay_sms_move_to_sim_msg fun's input param is valid!");
		return -1;
	}

#if 0  // kw 3  INVARIANT_CONDITION.UNREACH
	/*check the length before memcpy for  safe*/
	if (sizeof(T_zUfiSms_DelReq) > MSG_DATA_MAX_LEN) {
		slog(MISC_PRINT, SLOG_ERR, "the size of sms_delete_msg_info_s_type is more than the msg buf , sizeof(sms_delete_msg_info_s_type) = %d!"
		     , sizeof(T_zUfiSms_DelReq));
		return -1;
	}
#endif

	slog(MISC_PRINT, SLOG_NORMAL, "send_message sms move to sim msg start!");
	//slog(MISC_PRINT,SLOG_DEBUG,"del_info_ptr->db is %d\n",del_info_ptr->db);

	//ret_code = zte_send_message(ZTE_SOCKET_PATH_MAIN_CONTROL, sizeof(send_msg), (char*)&send_msg);
	//ret_code = zte_send_message(ZUFI_MODULE_ID_AT_LOCAL, MSG_CMD_COPY_SMS, sizeof(T_zUfiSms_DelReq), (char *)del_info_ptr);
	ret_code = ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_SMS, MSG_CMD_COPY_SMS, sizeof(T_zUfiSms_DelReq), (char *)del_info_ptr, 0);
	slog(MISC_PRINT, SLOG_DEBUG, "send_message sms  move to sim msg end!");
	if (ret_code != OK) {
		slog(MISC_PRINT, SLOG_ERR, "mc lib relay sms send  move to sim msg fail");
		return -1;
	}
	return OK;
}

/******************************************************
* Function:        zte_mc_relay_sms_set_parameter
* Description:    the fun to relay SMS send set_parameter to the mc process
* Input:
* Output:
* Return:
* Others:
* Modify Date    Version   Author         Modification
* 20121025        V1.0     liuyingnan     create
*******************************************************/
int zte_mc_relay_sms_set_parameter(T_zUfiSms_ParaInfo *parameter_ptr)
{
	int ret_code = 0;
	T_zGoaheadMsgBuf send_msg;

	memset(&send_msg, 0, sizeof(send_msg));

	/*check  the input param*/
	if (parameter_ptr == NULL) {
		slog(MISC_PRINT, SLOG_ERR, "the mc_relay_sms_set_parameter fun's input param is valid!"); /*lint !e26*/
		return -1;
	}

	/*set the value*/
	send_msg.msg_hdr.type = ZTE_SMS_RELAY_TYPE;
	send_msg.msg_hdr.id = ZTE_MC_SMS_SET_PARAM_CMD;
	send_msg.msg_hdr.result = OK;
#if 0  // kw 3  INVARIANT_CONDITION.UNREACH
	/*check the length before memcpy for  safe*/
	if (sizeof(T_zUfiSms_ParaInfo) > ZTE_MODEM_RELAY_MSGBUF_MAX_LEN) { /*lint !e506*/
		slog(MISC_PRINT, SLOG_ERR, "the size of sms_parameter_info_s_type is more than the msg buf , sizeof(sms_parameter_info_s_type) = %d!"
		     , sizeof(T_zUfiSms_ParaInfo));/*lint !e26*/
		return -1;
	}
#endif
	memcpy(send_msg.msg_data, parameter_ptr, sizeof(T_zUfiSms_ParaInfo));

	slog(MISC_PRINT, SLOG_NORMAL, "send_message sms set parameter( start!"); /*lint !e26*/
	//ret_code = zte_send_message(ZUFI_MODULE_ID_AT_LOCAL,MSG_CMD_SMS_LOCATION_SET, sizeof(send_msg), (char*)&send_msg);
	ret_code = ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_SMS, MSG_CMD_SMS_LOCATION_SET, sizeof(send_msg), (char*)&send_msg, 0);
	slog(MISC_PRINT, SLOG_DEBUG, "send_message sms set parameter( end!"); /*lint !e26*/

	if (ret_code != OK) {
		slog(MISC_PRINT, SLOG_ERR, "mc lib relay sms set parameter msg fail"); /*lint !e26*/
		return -1;
	}

	return OK;
}




/******************************************************
* Function:        zte_mc_relay_pbm_create_modify_record
* Description:    the fun to relay PBM send create modify  to the mc process
* Input:
* Output:
* Return:
* Others:
* Modify Date    Version   Author         Modification
* 20121025        V1.0     liuyingnan     create
*******************************************************/
int zte_mc_relay_pbm_create_modify_record(zte_pbm_create_ext_record_s_type *pbm_recv_record)
{
	int ret_code = 0;
	T_zGoaheadMsgBuf send_msg;

	memset(&send_msg, 0, sizeof(send_msg));

	/*check the input param*/
	if (pbm_recv_record == NULL) {
		slog(MISC_PRINT, SLOG_ERR, "the mc_relay_pbm_create_modify_record fun's input is NULL "); /*lint !e26*/
		return -1;
	}

	slog(MISC_PRINT, SLOG_DEBUG, "enter the mc_relay_pbm_create_modify_record fun "); /*lint !e26*/

	/*set the value*/
	send_msg.msg_hdr.type = ZTE_PBM_RELAY_TYPE;
	send_msg.msg_hdr.id = ZTE_MC_PBM_CREATE_MODIFY_RECORD_CMD;
	send_msg.msg_hdr.result = OK;
#if 0  // kw 3  INVARIANT_CONDITION.UNREACH
	/*check the length before memcpy for  safe*/
	if (sizeof(zte_pbm_create_ext_record_s_type) > ZTE_MODEM_RELAY_MSGBUF_MAX_LEN) { /*lint !e506*/
		slog(MISC_PRINT, SLOG_ERR, "the size of pbm_create_ext_record_s_type is more than the msg buf , sizeof(pbm_create_ext_record_s_type) = %d!"
		     , sizeof(zte_pbm_create_ext_record_s_type));/*lint !e26*/
		return -1;
	}
#endif
	memcpy(send_msg.msg_data, pbm_recv_record, sizeof(zte_pbm_create_ext_record_s_type));

	slog(MISC_PRINT, SLOG_NORMAL, "send_message PBM create modify record start!"); /*lint !e26*/
#if 0 // cov M when zte_send_message is commented, ret_code!= OK is unreachable	
	//ret_code = zte_send_message(ZTE_SOCKET_PATH_MAIN_CONTROL, sizeof(send_msg), (char*)&send_msg);
	slog(MISC_PRINT, SLOG_DEBUG, "send_message PBM create modify record end!"); /*lint !e26*/

	if (ret_code != OK) {
		slog(MISC_PRINT, SLOG_ERR, "mc lib relay pbm  send create modify record  fail"); /*lint !e26*/
		return -1;
	}
#endif
	return OK;
}



/******************************************************
* Function:        zte_mc_relay_pbm_del_one_record
* Description:    the fun to relay PBM send del one record  to the mc process
* Input:
* Output:
* Return:
* Others:
* Modify Date    Version   Author         Modification
* 20121025        V1.0     liuyingnan     create
*******************************************************/
int zte_mc_relay_pbm_del_one_record(zte_pbm_del_multi_records_s_type *pbm_recv_record)
{
	int ret_code = 0;
	T_zGoaheadMsgBuf send_msg;

	memset(&send_msg, 0, sizeof(send_msg));

	/*check the input param*/
	if (pbm_recv_record == NULL) {
		slog(MISC_PRINT, SLOG_ERR, "the mc_relay_pbm_del_multi_record fun's input is NULL "); /*lint !e26*/
		return -1;
	}

	slog(MISC_PRINT, SLOG_DEBUG, "enter the mc_relay_pbm_del_one_record fun "); /*lint !e26*/

	/*set the value*/
	send_msg.msg_hdr.type = ZTE_PBM_RELAY_TYPE;
	send_msg.msg_hdr.id = ZTE_MC_PBM_DEL_ONE_RECORD_CMD;
	send_msg.msg_hdr.result = OK;
#if 0  // kw 3  INVARIANT_CONDITION.UNREACH
	/*check the length before memcpy for  safe*/
	if (sizeof(zte_pbm_del_multi_records_s_type) > ZTE_MODEM_RELAY_MSGBUF_MAX_LEN) { /*lint !e506*/
		slog(MISC_PRINT, SLOG_ERR, "the size of pbm_del_multi_records_s_type is more than the msg buf , sizeof(pbm_del_multi_records_s_type) = %d!"
		     , sizeof(zte_pbm_create_ext_record_s_type));/*lint !e26*/
		return -1;
	}
#endif
	memcpy(send_msg.msg_data, pbm_recv_record, sizeof(zte_pbm_del_multi_records_s_type));

	slog(MISC_PRINT, SLOG_NORMAL, "send_message PBM del one record start!"); /*lint !e26*/
#if 0 // cov M when zte_send_message is commented, ret_code!= OK is unreachable	
	//ret_code = zte_send_message(ZTE_SOCKET_PATH_MAIN_CONTROL, sizeof(send_msg), (char*)&send_msg);
	slog(MISC_PRINT, SLOG_DEBUG, "send_message PBM del one record end!"); /*lint !e26*/

	if (ret_code != OK) {
		slog(MISC_PRINT, SLOG_ERR, "mc lib relay pbm del one record msg fail"); /*lint !e26*/
		return -1;
	}
#endif
	return OK;
}

/******************************************************
* Function:        zte_mc_relay_pbm_del_multi_record
* Description:    the fun to relay PBM send del multi record  to the mc process
* Input:
* Output:
* Return:
* Others:
* Modify Date    Version   Author         Modification
* 20121025        V1.0     liuyingnan     create
*******************************************************/
int zte_mc_relay_pbm_del_multi_record(zte_pbm_del_multi_records_s_type *pbm_recv_record)
{
	int ret_code = 0;
	T_zGoaheadMsgBuf send_msg;

	memset(&send_msg, 0, sizeof(send_msg));

	/*check the input param*/
	if (pbm_recv_record == NULL) {
		slog(MISC_PRINT, SLOG_ERR, "the mc_relay_pbm_del_multi_record fun's input is NULL "); /*lint !e26*/
		return -1;
	}

	slog(MISC_PRINT, SLOG_DEBUG, "enter the mc_relay_pbm_del_multi_record fun "); /*lint !e26*/

	/*set the value*/
	send_msg.msg_hdr.type = ZTE_PBM_RELAY_TYPE;
	send_msg.msg_hdr.id = ZTE_MC_PBM_DEL_MULTI_RECORD_CMD;
	send_msg.msg_hdr.result = OK;
#if 0  // kw 3  INVARIANT_CONDITION.UNREACH
	/*check the length before memcpy for  safe*/
	if (sizeof(zte_pbm_del_multi_records_s_type) > ZTE_MODEM_RELAY_MSGBUF_MAX_LEN) { /*lint !e506*/
		slog(MISC_PRINT, SLOG_ERR, "the size of pbm_del_multi_records_s_type is more than the msg buf , sizeof(pbm_del_multi_records_s_type) = %d!"
		     , sizeof(zte_pbm_create_ext_record_s_type));/*lint !e26*/
		return -1;
	}
#endif
	memcpy(send_msg.msg_data, pbm_recv_record, sizeof(zte_pbm_del_multi_records_s_type));


	slog(MISC_PRINT, SLOG_NORMAL, "send_message PBM del multi record start!"); /*lint !e26*/
#if 0 // cov M when zte_send_message is commented, ret_code!= OK is unreachable	
	//ret_code = zte_send_message(ZTE_SOCKET_PATH_MAIN_CONTROL, sizeof(send_msg), (char*)&send_msg);
	slog(MISC_PRINT, SLOG_DEBUG, "send_message PBM del multi record end!"); /*lint !e26*/

	if (ret_code != OK) {
		slog(MISC_PRINT, SLOG_ERR, "mc lib relay pbm del multi record msg fail"); /*lint !e26*/
		return -1;
	}
#endif
	return OK;
}


/******************************************************
* Function:        zte_mc_relay_pbm_del_all_record
* Description:    the fun to relay PBM send del all record  to the mc process
* Input:
* Output:
* Return:
* Others:
* Modify Date    Version   Author         Modification
* 20121025        V1.0     liuyingnan     create
*******************************************************/
int zte_mc_relay_pbm_del_all_record(zte_pbm_del_multi_records_s_type *pbm_recv_record)
{
	int ret_code = 0;
	T_zGoaheadMsgBuf send_msg;

	memset(&send_msg, 0, sizeof(send_msg));

	/*check the input param*/
	if (pbm_recv_record == NULL) {
		slog(MISC_PRINT, SLOG_ERR, "the mc_relay_pbm_del_all_record fun's input is NULL "); /*lint !e26*/
		return -1;
	}

	slog(MISC_PRINT, SLOG_DEBUG, "enter the mc_relay_pbm_del_all_record fun "); /*lint !e26*/

	/*set the value*/
	send_msg.msg_hdr.type = ZTE_PBM_RELAY_TYPE;
	send_msg.msg_hdr.id = ZTE_MC_PBM_DEL_ALL_RECORD_CMD;
	send_msg.msg_hdr.result = OK;
#if 0  // kw 3  INVARIANT_CONDITION.UNREACH
	/*check the length before memcpy for  safe*/
	if (sizeof(zte_pbm_del_multi_records_s_type) > ZTE_MODEM_RELAY_MSGBUF_MAX_LEN) { /*lint !e506*/
		slog(MISC_PRINT, SLOG_ERR, "the size of pbm_del_multi_records_s_type is more than the msg buf , sizeof(pbm_del_multi_records_s_type) = %d!"
		     , sizeof(zte_pbm_create_ext_record_s_type));/*lint !e26*/
		return -1;
	}
#endif
	memcpy(send_msg.msg_data, pbm_recv_record, sizeof(zte_pbm_del_multi_records_s_type));


	slog(MISC_PRINT, SLOG_NORMAL, "send_message PBM del all record start!"); /*lint !e26*/
#if 0 // cov M  // when zte_send_message is commented,  ret_code != OK is unreachable	
	//ret_code = zte_send_message(ZTE_SOCKET_PATH_MAIN_CONTROL, sizeof(send_msg), (char*)&send_msg);
	slog(MISC_PRINT, SLOG_DEBUG, "send_message PBM del all record end!"); /*lint !e26*/

	if (ret_code != OK) {
		slog(MISC_PRINT, SLOG_ERR, "mc lib relay pbm del all record msg fail"); /*lint !e26*/
		return -1;
	}
#endif

	return OK;
}








































