
/************************************************************************
*ܽܣat_ctl PPP¼ľʵֽӿںӿ
*ˣ
*޸գ
*޸ݣ
*汾ţ
************************************************************************/

#include "at_context.h"
#include "ppp_dial.h"
#include "message.h"
#include "ps_pdp.h"

#if (APP_OS_TYPE == APP_OS_LINUX)
#include <sys/prctl.h>
#include <pty.h>
//========================================================================================================//
//ȫֱ
//========================================================================================================//

#define UP_SIZE_32      32
#define	PRIVATE_LEN   5
#define DATA2CMD  		"+++"   			//̬л̬ıַ
#define COCMD  			"\r\nCONNECT\r\n"
#define PTMASTER 		"/dev/ptmx"
#define PPP_REPLY_OK       "\r\nOK\r\n"
#define PPP_REPLY_NO_CARRIER	"\r\nNO CARRIER\r\n"

int g_store_ppptty = -1;    //յ+++̬л̬Ҫpppŵtty豸fd
extern int ppp_cid;
extern struct pdpinfo_mng_t	g_pdpinfo_mng[CID_MAX_NUM];
extern int max_fd;

char private_str[PRIVATE_LEN]={0X7E,'A','T','H',0};
char private_str2[PRIVATE_LEN]={0X7E,'+','+','+',0};
char matching_str[PRIVATE_LEN] = {0};
int  matching_len = 0;

static T_PCS_USB_INFO g_sPortInfo =
{
    '0',     // print prompt after receiving
    115200,      // baudrate: 0
    '8',     // databit: 8
    '0',     // debug: off
    '0',     // echo: off
    '0',     // flow control: software
    '0',     // default tty: COM1
    '0',     // parity: none
    '1',     // stopbit: 1
     0       // reserved
};

// תת
static int iFnConvbaud(int32_t iBaudrate)
{
    switch(iBaudrate)
    {
        case 2400:
            return B2400;
        case 4800:
            return B4800;
        case 9600:
            return B9600;
        case 19200:
            return B19200;
        case 38400:
            return B38400;
        case 57600:
            return B57600;
        case 115200:
            return B115200;
        default:
            return B9600;
    }
}

// ʷתת
static int32_t iFnBaudconv(int32_t Baudrate)
{
    switch(Baudrate)
    {
        case B2400:
            return 2400;
        case B4800:
            return 4800;
        case B9600:
            return 9600;
        case B19200:
            return 19200;
        case B38400:
            return 38400;
        case B57600:
            return 57600;
        case B115200:
            return 115200;
        default:
            return 9600;
    }
}



//========================================================================================================//
//ʵ
//========================================================================================================//

// ö˿ϢiFdCom: ļ, ptPortInfo: õĶ˿Ϣ
void PortSet(int iFdCom, const PT_PCS_USB_INFO ptPortInfo)
{
    struct termios tOldTermios = {0}, tNewTermios = {0};
    int iBaudrate = 0;
    char cDatabit = 0, cStopbit = 0, cParity = 0, cFctl = 0;

    bzero(&tOldTermios, sizeof(tOldTermios));
    bzero(&tNewTermios, sizeof(tNewTermios));
    cfmakeraw(&tNewTermios);
    tcgetattr(iFdCom, &tOldTermios); // get the serial port attributions
    /*------------ö˿----------------*/
	iBaudrate = iFnConvbaud(ptPortInfo->iBaudrate);
	//iBaudrate = cfgetispeed(&tOldTermios);
	
    cfsetispeed(&tNewTermios, iBaudrate); //봮˲
    cfsetospeed(&tNewTermios, iBaudrate); //봮˲
    tNewTermios.c_cflag |= CLOCAL;       //ģʽ, ֤򲻻Ϊ˿ڵռ
    tNewTermios.c_cflag |= CREAD;        //ģʽ, ʹܶ˿ڶȡ
    // ģʽ, flow control
    cFctl = ptPortInfo->cFctl;
    switch(cFctl)
    {
        case '0':
            {
                tNewTermios.c_cflag &= ~CRTSCTS;        //no flow control
                tNewTermios.c_iflag |= IGNBRK | IGNPAR;
            }break;
        case '1':
            {
                tNewTermios.c_cflag |= CRTSCTS;         //hardware flow control
            }break;
        case '2':
            {
                tNewTermios.c_iflag |= IXON | IXOFF | IXANY;    //software flow control
            }break;
        default:
            {
                at_print(AT_ERR,"ERR: Unknown cFctl == %c", cFctl);
                break;
            }
    }
    // ģʽ, data bits
    tNewTermios.c_cflag &= ~CSIZE; //ģʽ, ַСλ
    cDatabit = ptPortInfo->cDatabit;
    switch(cDatabit)
    {
        case '5':
            tNewTermios.c_cflag |= CS5;
            // lint -fallthrough
        case '6':
            tNewTermios.c_cflag |= CS6;
            // lint -fallthrough
        case '7':
            tNewTermios.c_cflag |= CS7;
            // lint -fallthrough
        default:
            tNewTermios.c_cflag |= CS8;
    }
    // ģʽ parity check
    cParity = ptPortInfo->cParity;
    switch(cParity)
    {
        case '0':
            {
                tNewTermios.c_cflag &= ~PARENB; //no parity check
            }break;
        case '1':
            {
                tNewTermios.c_cflag |= PARENB;  //odd check
                tNewTermios.c_cflag &= ~PARODD;
            }break;
        case '2':
            {
                tNewTermios.c_cflag |= PARENB;  //even check
                tNewTermios.c_cflag |= PARODD;
            }break;
        default:
            {
                at_print(AT_ERR,"ERR:Unknown cParity == %c", cParity);
                break;
            }
    }
    // ģʽ, stop bits
    cStopbit = ptPortInfo->cStopbit;
    if('2' == cStopbit)
    {
        tNewTermios.c_cflag |= CSTOPB;
    }
    else
    {
        tNewTermios.c_cflag &= ~CSTOPB;
    }
    // other attributions default
    tNewTermios.c_oflag &= ~OPOST;            //ģʽ, ԭʼ
    tNewTermios.c_cc[VMIN] = 1;               //ַ, ҪȡַС
    tNewTermios.c_cc[VTIME] = 1;              //ַ, ȡһַĵȴʱ䣬unit: (1/10)second
    tcflush(iFdCom, TCIFLUSH);                //ݿԽ,
    tcsetattr(iFdCom, TCSANOW, &tNewTermios); //, TCSANOW: ɸıЧ
    tcgetattr(iFdCom, &tOldTermios);
}



//ǷӦ÷װɹӿͳһ  ????
static char * pstrFnStrupr(char * pstr)
{
    char * p = pstr;
    while(*p != '\0')
    {
        if(*p >= 'a' && *p <= 'z')
        {
            *p -= 0x20;
        }
        p++;
    }
    return pstr;
}

//////////////////////////////////////////////////////////////////////////////////////////

int ato_rsp_act(int at_fd, char *at_paras,void ** res_msg, int *res_msglen)
{
    char shellCmd[2*UP_SIZE_32] = {0};
	char *data = NULL;
    FILE *fp = NULL;

   	if(!is_at_cmd_end(at_paras))
    {
        *res_msg = at_err_build(ATERR_PARAM_INVALID);
		*res_msglen = strlen(*res_msg);		
		return AT_END;
    }
#ifndef CONFIG_MIN_8M_VERSION
//#ifdef GUODIAN
    if(g_customer_type == CUSTOMER_GUODIAN)
    {
        struct sock_channel_cb *cb = get_sock_channel_cb(at_fd, 0);
        if(cb != NULL)
        {
            at_print(AT_ERR,"received ATO cmd\n");
            //͸ģʽ£socketͨƿĴģʽģʽлģʽ
			if(TRANSPARENT_CMD_MODE == cb->transportmode)
			{
			    unix_send_proc(cb->unix_sockfd, cb->module_id, MSG_CMD_CMD_TO_DATA_MODE, 0, 0, 0);//֪ͨzte_sockeṭݵĽ
				set_passthough_info(at_fd, cb->len, TRANSPARENT_DATA_MODE, cb->viewmode, cb->transparent_socketid, cb->module_id, cb->msg_cmd);//ôģʽݵķ
				cb->data_suspend = 0;
                data = (char *)malloc(strlen("\r\nOK\r\n")+1);
				if(data == NULL)
					return AT_END;
                memset(data, 0, strlen("\r\nOK\r\n")+1);
                sprintf(data, "\r\nOK\r\n");
			}  
            else
            {
                at_print(AT_ERR, "transfer mode is not TRANSPARENT_CMD_MODE, can't handle ATO cmd\n");
                data = (char *)malloc(strlen("\r\nERROR\r\n")+1);
				if(data == NULL)
					return AT_END;
                memset(data, 0, strlen("\r\nERROR\r\n")+1);
                sprintf(data, "\r\nERROR\r\n");
            }            
            *res_msg = data;
            *res_msglen = strlen(data); //ģʽлɣϱOK
            return AT_END;
        }
    }
//#endif
#endif
    system("rm -rf /etc_rw/config/up_ato_state");
    system("ps | grep pppd | grep -v grep > /etc_rw/config/up_ato_state");
    fp = fopen("/etc_rw/config/up_ato_state", "r");
    if(NULL == fp)
    {
	    at_print(AT_ERR,"ERR: can not open file /etc_rw/config/up_ato_state!!!\n");
        *res_msg = at_err_build(ATERR_PPP_FILE_FAILED);
		*res_msglen = strlen(*res_msg);		
		return AT_END;
    }
    memset(shellCmd, 0, sizeof(shellCmd));
    fgets(shellCmd, sizeof(shellCmd), fp);
	at_print(AT_DEBUG,"shellCmd= %s!!!\n", shellCmd);	
   
    if(strlen(shellCmd) == 0)
    {
        at_print(AT_ERR,"ERR: pppd is not exist and state still is cmd!!!\n");
        *res_msg = at_err_build(ATERR_PPP_NOT_EXISTED);
		*res_msglen = strlen(*res_msg);		
    }
    else
    {
		if(at_fd == g_store_ppptty)
        {      
            g_ppp_ttyfd = at_fd;//¼ǰ豸
            g_store_ppptty = -1;
            data = (char *)malloc(strlen(COCMD)+1);
			if(data != NULL){
            sprintf(data,"%s",COCMD);
            *res_msg = data;
            *res_msglen = strlen(data); 
			}
        }
        else
        {
            *res_msg = at_err_build(ATERR_PPP_WRONG_CHAN);
            *res_msglen = strlen(*res_msg);	
        }
    }
    fclose(fp);
	return AT_END;
}

void zppp_SendAtCmdToPort(char * pstrAtCmd, int iAtCmdLen, int masterPort)
{
    int len = 0;
    if(masterPort > 0)
    {        
        len = at_write(masterPort, pstrAtCmd, iAtCmdLen);
		
        if(len != iAtCmdLen)        	
			at_print(AT_ERR,"Send AT req to masterPort: %d failed. cmd: %s\n | len == %d\n", masterPort, pstrAtCmd, iAtCmdLen);
    }
}

void match_str(char *data,int len)
{
	char temp_str[PRIVATE_LEN] = {0};
	int match_len = strlen(data) + matching_len < PRIVATE_LEN-1 ? strlen(data) + matching_len : PRIVATE_LEN-1;

	memcpy(temp_str,matching_str,matching_len);
	memcpy(temp_str+matching_len,data,match_len - matching_len);
	if(match_len < PRIVATE_LEN-1)
	{
		if(!at_strncmp(temp_str,private_str2,match_len)||!at_strncmp(temp_str,private_str,match_len))
		{
			memcpy(matching_str,temp_str,match_len);
			matching_len = match_len;
		}
		else
		{
			memset(matching_str,0,PRIVATE_LEN);
			matching_len = 0;
		}
	}
	else
	{		
		if(!at_strncmp(temp_str,private_str2,match_len)||!at_strncmp(temp_str,private_str,match_len))
		{
			at_print(AT_ERR,"receive +++!!!\n");
			memset(matching_str,0,PRIVATE_LEN);
			matching_len = 0;
            at_write(g_ppp_ttyfd, PPP_REPLY_OK, strlen(PPP_REPLY_OK));
            g_store_ppptty = g_ppp_ttyfd;
            g_ppp_ttyfd = -1;
			//ƥɹִйҶ
		}
		else
		{
			memset(matching_str,0,PRIVATE_LEN);
			matching_len = 0;
		}
	}
}


//жǷ+++ݣֱ͸pppd
void zppp_check_proc(char * strReadAtCmd, int iAtCmdLen)
{
    char *match_str_tmp = NULL;
	int  diff_len = 0;

	if(matching_len > 0)
    {   
        match_str(strReadAtCmd,iAtCmdLen);
        //zppp_SendAtCmdToPort(strReadAtCmd, iAtCmdLen, g_ppp_ptm);
        if(g_ppp_ttyfd == -1)
        return;
    }
	//diff_str  = data;
	//ƥ䵱ǰַе
	while(diff_len < iAtCmdLen )
	{
		match_str_tmp = strstr(strReadAtCmd+diff_len,private_str2);
		if(match_str_tmp || strstr(strReadAtCmd+diff_len,private_str))
		{
			//ƥɹִйҶ
			at_print(AT_ERR,"receive1 +++!!!\n");
			at_write(g_ppp_ttyfd, PPP_REPLY_OK, strlen(PPP_REPLY_OK));
            g_store_ppptty = g_ppp_ttyfd;
            g_ppp_ttyfd = -1;
			return;
		}
		diff_len += strlen(strReadAtCmd+diff_len)+1;
	}
	if(strReadAtCmd[iAtCmdLen-1] == 0X7E)
	{
		matching_str[0] = 0X7E;
		matching_len = 1;
	}
    zppp_SendAtCmdToPort(strReadAtCmd, iAtCmdLen, g_ppp_ptm);
	return;
}

void  pppdail_regist_init()
{
    register_serv_func2("ATO",0,0,0,ato_rsp_act,NULL);
}


//pdpȥpppPC lcp terminateЭ֪֮ͨpcն˿ٶϿppp
char* quick_disconnect_func(void *msg,struct at_context *context)
{
	ppp_quick_disconnect();
	return NULL;
}

int start_pppd(int at_fd)
{
	char ptysname[UP_SIZE_32] = {0};
	struct termios tOldTermios = {0};
    int iBaudrate = 0;
	
	g_ppp_ptm = at_open(PTMASTER, O_RDWR);//ΪpppŴpty豸
    if(g_ppp_ptm < 0)
    {     
		at_print(AT_ERR,"Open port %s error.\n", PTMASTER);        
        return 0;
    }
    if(grantpt(g_ppp_ptm) != 0) 
    {
        at_close(g_ppp_ptm);
        return 0;
    }
    if(unlockpt(g_ppp_ptm) != 0) 
    { 
        at_close(g_ppp_ptm);
        return 0;
    }
	tcgetattr(at_fd, &tOldTermios); // get the serial port attributions
    iBaudrate = iFnBaudconv(cfgetispeed(&tOldTermios));
	at_print(AT_DEBUG,"iBaudrate: %d\n", iBaudrate);
	g_sPortInfo.iBaudrate = iBaudrate;
    PortSet(g_ppp_ptm, &g_sPortInfo);        
	char *name = ptsname(g_ppp_ptm);
	if(name)
    strncpy(ptysname, name,UP_SIZE_32-1);
    at_print(AT_DEBUG,"pts name: %s\n", ptysname);
    
    ppp_act_proc(ptysname);
    at_print(AT_ERR,"finish starting pppd!!!\n");
	return 1;
}

void ppp_dial_info()
{
	at_print(AT_ERR,"==============ppp_dial_info===============================\n");
	at_print(AT_ERR,"g_ppp_ttyfd:%d, g_ppp_ptm:%d, g_store_ppptty:%d\n",g_ppp_ttyfd,g_ppp_ptm,g_store_ppptty);
	if(g_ppp_ttyfd == -1 && g_ppp_ptm == -1 && g_store_ppptty == -1)
		at_print(AT_ERR,"current state is not ppp_dial or ppp_dial disconnect!!!\n");
	else if(g_ppp_ttyfd == -1 && g_store_ppptty > 0)
		at_print(AT_ERR,"current is ppp_dial but state is cmd and must receive +++!!!\n");
	else if(g_ppp_ttyfd > 0 && g_ppp_ptm > 0)
		at_print(AT_ERR,"current is ppp_dial state and state is data!!!\n");
	at_print(AT_ERR,"==========================================================\n");
}

#endif

int is_ppp_dial_atd(char *at_paras,int at_fd)
{
#if (APP_OS_TYPE == APP_OS_LINUX)
    char pstrAtCmdTemp[UP_SIZE_32] = {0};

    strncpy(pstrAtCmdTemp, at_paras, UP_SIZE_32-1);
	at_print(AT_ERR,"atd_req_rcv_act at_paras= %s  pstrAtCmdTemp= %s\n",at_paras,pstrAtCmdTemp);
    pstrFnStrupr(pstrAtCmdTemp);
    
	if(!strstr(pstrAtCmdTemp, "*98") && !strstr(pstrAtCmdTemp, "*99") && !strstr(pstrAtCmdTemp, "T*98") && !strstr(pstrAtCmdTemp, "T*99"))
    {
       	at_print(AT_ERR,"atd is common cmd and continue!!!\n");	
		return 1;
    }
	char *pchar = strchr(pstrAtCmdTemp, '#');
	if(pchar == NULL){
		softap_assert("");
		return 1;
	}
	if(*(pchar-2) == '*')
	{
		ppp_cid = *(pchar-1)-'0';//ȡatdеcidֵ
		if(ppp_cid < 1 || ppp_cid > CID_MAX_NUM)
			ppp_cid = 1;
	}
	else
		ppp_cid = 1;//atdвЯcidĬcid=1
	
	at_print(AT_ERR,"atd_req_rcv_act:ppp_cid = %d\n", ppp_cid);
	if(g_pdpinfo_mng[ppp_cid-1].is_acted == 1)//жϸcidѾֱ̬ӷerror
	{
		ppp_cid = 0;
		at_write(at_fd, "\r\nERROR\r\n", strlen("\r\nERROR\r\n"));
		return 0;
	}
	
    if(start_pppd(at_fd) == 0)//pppdӦ
    {
    	at_print(AT_ERR,"start pppd failed!!\n");
		return 0;
    }
	g_ppp_ttyfd = at_fd;//¼ǰ豸
	
	at_print(AT_ERR,"g_ppp_ttyfd:%d, g_ppp_ptm:%d!!!\n", g_ppp_ttyfd, g_ppp_ptm);

	struct at_channel_info *at_chan = at_context_find_chn_by_fd(at_fd);
	if(NULL == at_chan){
		softap_assert("");
		return 0;
	}
	at_chan->attribution |= (1<<CH_AUTOIND);//رոͨϱ

    at_write(at_fd, COCMD, strlen(COCMD));
    return 0;
#elif (APP_OS_TYPE == APP_OS_TOS)
	return 1;//cpֱת
#endif
}

void ppp_quick_disconnect()
{
#if (APP_OS_TYPE == APP_OS_LINUX)
	at_print(AT_ERR,"enter ppp_dial quick disconnect fd %d %d %d!!\n",g_ppp_ttyfd,g_store_ppptty,g_ppp_ptm);
	int fd = -1;
	if(g_ppp_ttyfd != -1)
		fd = g_ppp_ttyfd;
	else if(g_store_ppptty != -1)
		fd = g_store_ppptty;
	if(fd != -1)
	{
		at_write(fd, PPP_REPLY_NO_CARRIER, strlen(PPP_REPLY_NO_CARRIER));

		struct at_channel_info *at_chan = at_context_find_chn_by_fd(fd);
		if(NULL != at_chan)
			at_chan->attribution &= 0xFE;//򿪸ͨϱ

	}
	system("killall -9 pppd");
	at_close(g_ppp_ptm);
	g_ppp_ttyfd = -1;
	g_ppp_ptm = -1;
	g_store_ppptty = -1;
#endif
}


