/**
 * @file at_syncnv.c
 * @brief at_ctlAPCPNVͬĽӿʵ
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation. 
 *
 */

/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
#ifdef MULTI_CPU
#include "at_context.h"
#include "at_register.h"
#include "recv_thread.h"
//#include "ps_pdp.h"
#include "ps_normal.h"
#include "softap_api.h"
#if (APP_OS_TYPE == APP_OS_TOS)
#include "ref_nv_def.h"
#endif

/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/
/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/
/*******************************************************************************
 *                        Local function declarations                          *
 ******************************************************************************/
static int build_syncnv_cmd(int *offset, char *nv_name, char *at_cmd);
static char* start_build_sync_apnv(void);
#if (APP_OS_TYPE == APP_OS_TOS)
static int build_sync_cpnv_cmd(int *offset, char *at_cmd);
static char* start_build_sync_cpnv(void);
#endif
/*******************************************************************************
 *                         Local variable definitions                          *
 ******************************************************************************/
/*******************************************************************************
 *                        Global variable definitions                          *
 ******************************************************************************/
extern int is_cid_init;
extern int cid_reserved;
extern void cid_resource_init();
extern void at_context_chn_info_mod(char *at_paras);
extern void set_cp_indcmd_list(char *atcmdlist);

/*******************************************************************************
 *                      Local function implementations                         *
 ******************************************************************************/
static int build_syncnv_cmd(int *offset, char *nv_name, char *at_cmd)
{
	char nv_value[NV_MAX_VAL_LEN]= {0};
    sc_cfg_get(nv_name,nv_value,sizeof(nv_value));
	if(strlen(nv_value))
	{
		*offset += sprintf(at_cmd+(*offset), "\"%s\",\"%s\",",nv_name, nv_value);
	}
	return *offset;
}

/* ҪͬnvҪbuild_syncnv_cmdӿڣnv*/
static char* start_build_sync_apnv(void)
{
    char *at_next=NULL;
	int offset = 0;
	char cid_reserved[NV_NAME_LEN]= {0};
    at_next=malloc(AT_CMD_MAX);
    if(at_next == NULL)
	{
		softap_assert("start_sync_nv: malloc failed!");
		return NULL;
	}
    memset(at_next,0,AT_CMD_MAX);

    //offset+=sprintf(at_next+offset,"+ZSYNCNV:");
	
	/*APnvĸʽӼ*/

	/*DMܿ*/
	build_syncnv_cmd(&offset,"dmreg_enable",at_next);
	/*DMעʱ*/
	build_syncnv_cmd(&offset,"dmreg_time",at_next);
	//DM 
	build_syncnv_cmd(&offset,"registerDmType",at_next);
	//ƶַ
	build_syncnv_cmd(&offset,"urlMobile",at_next);
	//ϴοimeiֵ
	build_syncnv_cmd(&offset,"imeiPrevious",at_next);
	//ϴοiccidֵ
	build_syncnv_cmd(&offset,"iccidPrevious",at_next);
	//ͨ
	build_syncnv_cmd(&offset,"hostName",at_next);
	//ͨ˿ں
	build_syncnv_cmd(&offset,"portNum",at_next);
	//ÿּʱ
	build_syncnv_cmd(&offset,"secsEveryRound",at_next);
	
#ifdef PLATFORM_NV_FROM_AP
	/*ܶŹܿ*/
	build_syncnv_cmd(&offset,"isms_enable",at_next);
#endif
	/*ػܿ*/
	build_syncnv_cmd(&offset,"safecare_enbale",at_next);
    build_syncnv_cmd(&offset,"safecare_version",at_next);
	build_syncnv_cmd(&offset,"default_apn",at_next);
	/*cta_testܿ*/
	build_syncnv_cmd(&offset,"cta_test",at_next);
	build_syncnv_cmd(&offset,"reconnect_type",at_next);
	build_syncnv_cmd(&offset,"max_reconnect_time",at_next);
	build_syncnv_cmd(&offset,"autorspchannel_list",at_next);
	build_syncnv_cmd(&offset,"zunlocktimes",at_next);
	/*ͼƬֱʿ*/
	build_syncnv_cmd(&offset,"zcamera_interprolation",at_next);
	/*Ԥcidһ*/
	sc_cfg_get("cid_reserved", cid_reserved, sizeof(cid_reserved));
	offset+=sprintf(at_next+offset,"\"%s\",\"%s\"","cid_reserved", cid_reserved);
    return at_next;
}

#if (APP_OS_TYPE == APP_OS_TOS)
static int build_sync_cpnv_cmd(int *offset, char *at_cmd)
{
	long retCode = ZOSS_ERROR;
 	char TmpExtcgmi[ZPS_REF_MSINFO_MAX_CGMI_LEN] = {0};
	char TmpExtcgmw[ZPS_REF_MSINFO_MAX_PHONE_EXT_LEN] = {0};
 	char TmpExthver[ZPS_REF_MSINFO_MAX_HARDWAREVERSION_LEN] = {0};
    char TmpExtcgmr[ZPS_REF_MSINFO_MAX_SOFTVERSION_EXT_LEN] = {0};
	char TmpSoftVersion[ZPS_REF_MSINFO_MAX_SOFTVERSION_INT_LEN]={0};
	UINT8 phoneModeStatus = 0;

#if 0    /* Manuf , Model NV CP ͬ AP */
	retCode = zOss_NvItemRead(ZPS_REF_MSINFO_CGMI_BASE_ADDR, (unsigned char *)TmpExtcgmi, ZPS_REF_MSINFO_MAX_CGMI_LEN);
	zOss_ASSERT(retCode!=ZOSS_ERROR);
	*offset += sprintf(at_cmd+(*offset), "\"%s\",\"%s\",", "Manuf", TmpExtcgmi);
	
	retCode = zOss_NvItemRead(ZPS_REF_MSINFO_PHONE_EXT_BASE_ADDR, (unsigned char *)TmpExtcgmw, ZPS_REF_MSINFO_MAX_PHONE_EXT_LEN);
	zOss_ASSERT(retCode!=ZOSS_ERROR);
	*offset += sprintf(at_cmd+(*offset), "\"%s\",\"%s\",", "Model", TmpExtcgmw);
#endif 	

	retCode =zOss_NvItemRead(ZPS_REF_MSINFO_HARDWAREVERSION_BASE_ADDR,(unsigned char *)TmpExthver, ZPS_REF_MSINFO_MAX_HARDWAREVERSION_LEN);
	zOss_ASSERT(retCode!=ZOSS_ERROR);
	*offset += sprintf(at_cmd+(*offset), "\"%s\",\"%s\",", "hw_version", TmpExthver);
	*offset += sprintf(at_cmd+(*offset), "\"%s\",\"%s\",", "hardware_version", TmpExthver);

	retCode = zOss_NvItemRead(ZPS_REF_MSINFO_SOFTVERSION_EXT_BASE_ADDR, (unsigned char *)TmpExtcgmr, ZPS_REF_MSINFO_MAX_SOFTVERSION_EXT_LEN);
	zOss_ASSERT(retCode!=ZOSS_ERROR);		
	*offset += sprintf(at_cmd+(*offset), "\"%s\",\"%s\",", "wa_version", TmpExtcgmr);
	*offset += sprintf(at_cmd+(*offset), "\"%s\",\"%s\",", "cr_version", TmpExtcgmr);
	*offset += sprintf(at_cmd+(*offset), "\"%s\",\"%s\",", "wa_inner_version", TmpExtcgmr);

	retCode = zOss_NvItemRead(ZPS_REF_MSINFO_SOFTVERSION_INT_BASE_ADDR, (unsigned char*)TmpSoftVersion, ZPS_REF_MSINFO_MAX_SOFTVERSION_INT_LEN);
	zOss_ASSERT(retCode!=ZOSS_ERROR);		
	*offset += sprintf(at_cmd+(*offset), "\"%s\",\"%s\",", "cr_inner_version", TmpSoftVersion);

    //оƬ֤ һ
	retCode =zOss_NvItemRead(ZPS_REF_MSINFO_VERSIONMODE_BASE_ADDR, &phoneModeStatus, sizeof(UINT8));
	zOss_ASSERT(retCode!=ZOSS_ERROR);
	if((0x1 & phoneModeStatus) == 1)
	{
		*offset += sprintf(at_cmd+(*offset), "\"%s\",\"%s\"", "version_mode", "1");
		sc_cfg_set("version_mode","1");
	}
	else
	{
		*offset += sprintf(at_cmd+(*offset), "\"%s\",\"%s\"", "version_mode", "0");
		sc_cfg_set("version_mode","0");
	}

	return *offset;

}

/* ҪCPͬAPnvҪbuild_syncnv_cmdӿڣnv*/
static char* start_build_sync_cpnv(void)
{
    char *at_next = NULL;
	int offset = 0;
	
    at_next = malloc(AT_CMD_MAX);
    if(at_next == NULL)
	{
		softap_assert("start_sync_nv: malloc failed!");
		return NULL;
	}
    memset(at_next,0,AT_CMD_MAX);

    //offset+=sprintf(at_next+offset,"+ZSYNCNV:");
	
	build_sync_cpnv_cmd(&offset,at_next);

    return at_next;
}
#endif
/*******************************************************************************
 *                      Global function implementations                        *
 ******************************************************************************/
/**
 * @brief NVͬϢ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
int sync_nv_proc(char *at_paras)
{
	char nv_value[128] = {0};
	char nv_name[NV_NAME_LEN] ={0};
	char *p_nv_next_str	= NULL;
	E_AT_PARSE result = AT_PARSE_SUCCESS;
	
	if(at_paras == NULL)
	{
		softap_assert("aterr_param_invalid");
		return 0;
	}
	p_nv_next_str = at_paras;
	at_print(AT_DEBUG,"proc_sync_nv at_paras: %s\n", at_paras);
	while(*p_nv_next_str)
	{
        memset(nv_name, 0x00, sizeof(nv_name));
		result = get_at_cmd_param_str(p_nv_next_str, nv_name, sizeof(nv_name), &p_nv_next_str);
		if(result != AT_PARSE_SUCCESS)
		{
			softap_assert("get_at_cmd_param_str result wrong!!");
		}
		at_print(AT_DEBUG,"p_nv_next_str: %s\n", p_nv_next_str);
		if(*p_nv_next_str == '\0')
        {
            memset(nv_value, 0x00, sizeof(nv_value));
        }
        else
        {
            memset(nv_value, 0x00, sizeof(nv_value));
            move_to_next_param(p_nv_next_str, &p_nv_next_str);
            result = get_at_cmd_param_str(p_nv_next_str, nv_value, sizeof(nv_value), &p_nv_next_str);
			if(result != AT_PARSE_SUCCESS){softap_assert("get_at_cmd_param_str result wrong!!");}
        }
		at_print(AT_DEBUG,"nv_name: %s, nv_value: %s\n", nv_name, nv_value);
		sc_cfg_set(nv_name, nv_value);
		if(0 == strcmp(nv_name,"cid_reserved"))
		{
			is_cid_init = 1;
			cid_resource_init();
			char versionmode[2] = {0};
			sc_cfg_get("version_mode", versionmode, sizeof(versionmode));
			if(0 == strcmp(versionmode, "1"))
			{
				MSG_BUF *buf=NULL;
				buf=normal_getmsg(MODULE_ID_AT_CTL,MODULE_ID_AT_CTL,MSG_CMD_QUERY_CGDCONT_REQ,0,NULL);
				rcv_clt_req_msg_proc(buf);
				free(buf);
			}
		}
		if(0 == strcmp(nv_name,"autorspchannel_list"))
			at_context_chn_info_mod(nv_value);
		if(0 == strcmp(nv_name,"cpIndCmdList"))
			set_cp_indcmd_list(nv_value);
		if(0 == strcmp(nv_name, "version_mode") && 0 == strcmp(nv_value, "1"))
			cid_reserved = 255;//15;//оƬ֤֧ĬcidԤ
		if(*p_nv_next_str != '\0')
			move_to_next_param(p_nv_next_str, &p_nv_next_str);
		at_print(AT_DEBUG,"p_nv_next_str: %s\n", p_nv_next_str);	
	}
	sc_cfg_save();
	return 1;
}

/**
 * @brief APCPȱʡapnͬ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
void sync_default_apn(struct at_context *context)
{
	int at_fd = 0;
	char apn[APN_MAX_LEN] = {0};
	char *at_str = malloc(APN_MAX_LEN + 32);
#if (APP_OS_TYPE == APP_OS_LINUX)
	if(context)
		at_fd = context->at_channel->at_fd;
	else
		at_fd = at_context_get_fd_by_pos(NEAR_PS);
#elif (APP_OS_TYPE == APP_OS_TOS)
		at_fd = at_context_get_fd_by_pos(FAR_PS);
#endif
	sc_cfg_get("default_apn",apn, APN_MAX_LEN);
	sprintf(at_str,"\"default_apn\",\"%s\"",apn);
	at_socmsg_write(at_fd,MODULE_ID_AT_CTL,MODULE_ID_AT_CTL, MSG_CMD_SYNC_NV_REQ, strlen(at_str), at_str); 
	free(at_str);
}

void sync_appointed_nv(int position, char *nv_name)
{
	char *at_str = malloc(AT_CMD_MAX);
	char value[NV_MAX_VAL_LEN] = {0};
	
	sc_cfg_get(nv_name, value, NV_MAX_VAL_LEN);
	sprintf(at_str,"\"%s\",\"%s\"", nv_name, value);
	int write_fd = at_context_get_fd_by_pos(position);
	at_socmsg_write(write_fd,MODULE_ID_AT_CTL,MODULE_ID_AT_CTL, MSG_CMD_SYNC_NV_REQ, strlen(at_str), at_str); 
	free(at_str);
}

/**
 * @brief APCPNVͬ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
void sync_nv(void)
{
	char *at_str = NULL;
	int at_fd = 0;
#if (APP_OS_TYPE == APP_OS_TOS)
	at_str = start_build_sync_cpnv();
	at_fd = at_context_get_fd_by_pos(FAR_PS);

#elif (APP_OS_TYPE == APP_OS_LINUX)
	at_str = start_build_sync_apnv();
	at_fd = at_context_get_fd_by_pos(NEAR_PS);
#endif
	at_socmsg_write(at_fd,MODULE_ID_AT_CTL,MODULE_ID_AT_CTL, MSG_CMD_SYNC_NV_REQ, strlen(at_str), at_str);  
    free(at_str);
}
#endif
