/**
 * @file at_rcvmsg.c 
 * @brief ʵatͨϢʵ
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation. 
 *
 */

/*******************************************************************************
*                           Include header files                              *
******************************************************************************/
#include "at_context.h"
#include "at_register.h"
#include "recv_thread.h"
#include "softap_api.h"
#include "at_netdog.h"
#include "ps_sms_api.h"
#include "at_zephyr.h"
/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/
#define  BROADCAST_FWD        0XFFFFFFFF //㲥FARPS&VOLTE
#define  BROADCAST_VOLTE      0XFFFFFFF0 //㲥VOLTE
#define  BROADCAST_FARPS      0XFFFFFF00 //㲥FARPS


/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/
/*******************************************************************************
 *                        Local function declarations                          *
 ******************************************************************************/
static int get_msgtype(char *atCmdStr);
//static void write_position_cmd(int fd, char *at_str, int flag);
//static void write_farps_cmd(char *at_str);
static int ext_req_at_proc(int at_fd, char *at_str, void *at_cmd_prefix, int prefix_len, char *at_cmd_paras);
static int fwd_not_VoLTE_req_at(struct at_context * context, int at_fd, char *at_str);
static int fwd_not_VoLTE_extreq_at(struct at_context * context, int at_fd, char *at_str);
static int fwd_req_at_proc(int at_fd, char *at_str, void *at_cmd_prefix, int prefix_len, void * at_cmd_paras);
static int rcv_at_req_handle(int at_fd, char *at_str, void *at_cmd_prefix, int prefix_len, void * at_cmd_paras, int paras_len);
static void rcv_rsp_at_fwd_down(struct at_context * context, char *at_str, void * at_cmd_paras, int at_fd);
static void rcv_rsp_at_client(struct at_context * context, char *at_str, void * at_cmd_paras, int at_fd);
static int rcv_at_rsp_handle(int at_fd, char *at_str, void *at_cmd_prefix, int prefix_len, void * at_cmd_paras, int paras_len);
static int rcv_at_inform_handle(int at_fd, char *at_str, void *at_cmd_prefix, int prefix_len, void * at_cmd_paras, int paras_len);
static int rcv_sms_pdu_handle(int at_fd, char *at_str, void *at_cmd_prefix, int prefix_len, void * at_cmd_paras, int paras_len);
static void set_fwd_fd(int fd);
extern int phone_info_pdu(char *at_paras ,int is_query_report);
/*******************************************************************************
 *                         Local variable definitions                          *
 ******************************************************************************/
//ΪFFʱʾȺΪ0ʱʾת
int fwd_fd = 0;
int whole_at_type = -1; //ʶյ 
/*******************************************************************************
 *                        Global variable definitions                          *
 ******************************************************************************/
/* ϱͨ*/
extern int g_auto_fd;
/* CPAP͵ϱǰ׺*/
char FwIndAtCmdPrefix[AT_CMD_MAX] = {0};

//memory modify AT_CMD_MAX
//Աȡ3GPPб
char cancelled_cmd_list[128] = "+COPS=?+BGLTEPLMN=?+ZPLMNBAND?+ZNCELLINFO?+ZCOPS=?";

#ifdef _USE_BL
char IndAtCmdPrefix[AT_CMD_PREFIX] = {0};
#endif

/*******************************************************************************
 *                      Local function implementations                         *
 ******************************************************************************/
void set_cp_indcmd_list(char *atcmdlist)
{
	memset(FwIndAtCmdPrefix, 0x00, AT_CMD_MAX);

    // coverity STRING_OVERFLOW
	memcpy(FwIndAtCmdPrefix, atcmdlist, (strlen(atcmdlist) > sizeof(FwIndAtCmdPrefix) ? sizeof(FwIndAtCmdPrefix) : strlen(atcmdlist)));
}


/* ȡ*/
static int get_msgtype(char *atCmdStr)
{
    if(strstr(atCmdStr, "OK") != NULL)
        return AT_RSP_OK;
    else
        return AT_RSP_ERR;
}

/*һATԼ󣬷0 򷵻1*/
static int rcv_at_req_first_check(int at_fd, char *at_str)
{
	static	int  have_check = 0;
	char first_req[30] = {0};

	//һATǷΪԼ
	if(have_check == 0)  
	{
		sc_cfg_get("first_req",first_req,30);
		if(first_req[0] == '\0' || strstr(at_str, first_req)!=NULL)
			have_check = 1;
		else
			have_check = 2;
	}
	//һATԼ˵ⲿMCUδ΢оƬһ𿪻,ظָERR
	if(have_check == 2)
	{
		char* err_str = at_err_build(ATERR_ZXIC_ERR);
		at_write(at_fd, err_str, strlen(err_str));
		free(err_str);
		return 0;
	}	

	return 1;
}

//жǷǿԱȡǣ1򷵻0
static int check_cancelled_cmd(char *at_cmd_prefix)
{
	//contextбǰ׺Ϊգ+,=??ֱΪܱȡ
	if(strlen(at_cmd_prefix) == 0 || strcmp(at_cmd_prefix,"+") == 0
		|| strcmp(at_cmd_prefix,"=?") == 0 || strcmp(at_cmd_prefix,"?") == 0)
		return 0;
	
	if(at_strstr(cancelled_cmd_list,at_cmd_prefix) != NULL)
		return 1;
	else
		return 0;
}

/*չATĴΪչͷǵչ*/
static int ext_req_at_proc(int at_fd, char *at_str, void *at_cmd_prefix, int prefix_len, char *at_cmd_paras)
{
    int ret = AT_END;
    struct at_context * context = NULL;
    struct ser_ops_t2*  rcv_req_node = NULL;
	struct extat_ser_ops_t*  modem_req_node = NULL;
    MSG_BUF *pMsg = NULL;
    void * res_msg =	NULL;
    int res_msglen = 0;

    struct ser_ops_t0*  rcv_req_node0 = NULL;

    list_for_each_entry(rcv_req_node0,&g_ser_list0,list)
    {
    
        //עᵽser_ops_t2еǰ׺ȣпܱȸatǰ׺Ҫ
        if(0 == at_strncmp(rcv_req_node0->at_cmd_prefix, (char*)at_cmd_prefix,MAXSTR(rcv_req_node0->at_cmd_prefix, prefix_len)))
        {
			if(at_context_find_ctx_by_fd_type(at_fd, AT_FWD_UP)||at_context_find_ctx_by_fd_type(at_fd, AT_SERVER))
			{		
				//綨ƣMCUMYNETACT֮5ûмɹٴηͣERRORᴥװ
				if(g_customer_type == CUSTOMER_GUODIAN || g_customer_type == CUSTOMER_NANDIAN)
				{
					return 1;
				}
				else
				{
					//ظATͨæ
					char* err_str = at_err_build(ATERR_CHANNEL_BUSY);
					at_context_write_data(at_fd, err_str,strlen(err_str));
					free(err_str);
					return 1;
				}
			}
            if(rcv_req_node0->context != NULL)
            {
                softap_assert("");
                //ret = at_write(at_fd,"\r\nERROR\r\n",strlen("\r\nERROR\r\n"));
                return 1;
            }

            //첽ҪϢעģ飬ɸģ鴦󣬷ӦϢat_ctl
            {
                if(rcv_req_node0->module_id)
                {
                	int send_ret = -1;
					int store_len = 0;
                	//ڷռõatͨжռԣatͨѾرʱĲŻʧܣͷڴֱӷؼɣٷϢ
                    context = at_context_alloc_ctx_by_fd(at_fd,AT_SERVER);
					if(NULL == context)
					{
						return 1;
					}
					store_len = prefix_len<(AT_CMD_PREFIX)?prefix_len:(AT_CMD_PREFIX-1);
					snprintf(context->at_cmd_prefix,store_len+1,"%s",(char *)at_cmd_prefix);
					//strncpy(context->at_cmd_prefix, (char *)at_cmd_prefix, store_len);
                    context->at_proc = (void*)rcv_req_node0;
                    rcv_req_node0->context = context;
                    {
	            	    send_ret = ipc_send_message2(MODULE_ID_AT_CTL, rcv_req_node0->module_id, rcv_req_node0->req_msg_id, at_cmd_paras?strlen(at_cmd_paras)+1:0, at_cmd_paras,0);
                    }
					//ϢʧܣֱӷERRORͷͨ
					if(0 != send_ret)
					{	
						char* err_str = at_err_build(ATERR_PROC_FAILED);
						at_context_write_data(at_fd, err_str,strlen(err_str));
			            free(err_str);
						at_context_free_ctx(context);
					}
                }
            }
            return 1;
        }
    }

	//ԷǵչATƥ䴦
    list_for_each_entry(rcv_req_node,&g_ser_list2,list)
    {
    
        //עᵽser_ops_t2еǰ׺ȣпܱȸatǰ׺Ҫ
        if(0 == at_strncmp(rcv_req_node->at_cmd_prefix, (char*)at_cmd_prefix,MAXSTR(rcv_req_node->at_cmd_prefix, prefix_len)))
        {
			if(at_context_find_ctx_by_fd_type(at_fd, AT_FWD_UP)||at_context_find_ctx_by_fd_type(at_fd, AT_SERVER))
			{		
				//綨ƣMCUMYNETACT֮5ûмɹٴηͣERRORᴥװ
				if(g_customer_type == CUSTOMER_GUODIAN || g_customer_type == CUSTOMER_NANDIAN)
				{
					return 1;
				}
				else
				{
					//ظATͨæ
					char* err_str = at_err_build(ATERR_CHANNEL_BUSY);
					at_context_write_data(at_fd, err_str,strlen(err_str));
					free(err_str);
					return 1;
				}
			}
            if(rcv_req_node->context != NULL)
            {
                softap_assert("");
                //ret = at_write(at_fd,"\r\nERROR\r\n",strlen("\r\nERROR\r\n"));
                return 1;
            }
            ret = rcv_req_node->req_rcv_act(at_fd, at_cmd_paras, &res_msg, &res_msglen);

            //atֱͬӴreq_rcv_actֱӴӦatres_msgAT_END
            if(ret == AT_END)
            {
                if(res_msg == NULL || res_msglen != strlen(res_msg))
                {
                    softap_assert("");
                }
				else
                at_context_write_data(at_fd, res_msg,res_msglen);
            }
            //at ˣȻҪ֧첽ǶokӦصȵעģ鴦֮󣬲Żظ
            //עʱעһϢɣat_ctlӦϢֱat_ctlokӦɣ
            else if(ret == AT_END_AND_MSG)
            {
                if(rcv_req_node->module_id)
                {
                    ipc_send_message(MODULE_ID_AT_CTL, rcv_req_node->module_id, rcv_req_node->req_msg_id, res_msglen, res_msg,0);
                }
                at_context_write_data(at_fd,"\r\nOK\r\n",strlen("\r\nOK\r\n"));
            }
            else if(ret == AT_CONTINUE)//첽ҪϢעģ飬ɸģ鴦󣬷ӦϢat_ctl
            {
                if(rcv_req_node->module_id)
                {
                	int send_ret = -1;
                	//ڷռõatͨжռԣatͨѾرʱĲŻʧܣͷڴֱӷؼɣٷϢ
                    context = at_context_alloc_ctx_by_fd(at_fd,AT_SERVER);
					if(NULL == context)
					{
						if(res_msg)
							free(res_msg);
						return 1;
					}
					int store_len = prefix_len<(AT_CMD_PREFIX)?prefix_len:(AT_CMD_PREFIX-1);
					snprintf(context->at_cmd_prefix,store_len+1,"%s",(char *)at_cmd_prefix);
					//strncpy(context->at_cmd_prefix, (char *)at_cmd_prefix, store_len);
                    context->at_proc = (void*)rcv_req_node;
                    rcv_req_node->context = context;
                    //at_ctlsocket̼ʹunix socketʽͨѶ
                    if(rcv_req_node->module_id == MODULE_ID_SOCKET_PROXY)
                    {
                    	//עat serverʱsocket proxyӦý̹ͬһģID MODULE_ID_SOCKET_PROXY;
                    	//ʵʷϢʱҪatͨȡʵͨŵsocket proxyģID͵ý
						int dst_id = get_dst_moduleid(at_fd);
						int unix_sockfd = get_unix_sockfd(dst_id);

						if(unix_sockfd < 0)  // cov M NEGATIVE_RETURNS
						{
						    // todo:
						}
						else
						{
                            send_ret = unix_send_proc(unix_sockfd, dst_id, rcv_req_node->req_msg_id, res_msglen, res_msg,0);
						}
                    }
                    else
                    {
	            	    send_ret = ipc_send_message2(MODULE_ID_AT_CTL, rcv_req_node->module_id, rcv_req_node->req_msg_id, res_msglen, res_msg,0);
                    }
					//ϢʧܣֱӷERRORͷͨ
					if(0 != send_ret)
					{	
						char* err_str = at_err_build(ATERR_PROC_FAILED);
						at_context_write_data(at_fd, err_str,strlen(err_str));
			            free(err_str);
						at_context_free_ctx(context);
					}
                }
            }
            if(res_msg)
            {
                free(res_msg);
                res_msg = NULL;
            }
            return 1;
        }
    }

	//ԵⲿCPUչATתΪat_ctlϢfdΪԴģIDӦʱװӦATӦַ͸ⲿMCU
    list_for_each_entry(modem_req_node,&g_modem_extat_list,list)
    {
        if(0 == at_strncmp(modem_req_node->at_cmd_prefix, (char*)at_cmd_prefix, MAXSTR(modem_req_node->at_cmd_prefix, prefix_len)))
        {        
        	if(at_context_find_ctx_by_fd_type(at_fd, AT_FWD_UP)||at_context_find_ctx_by_fd_type(at_fd, AT_SERVER))
        	{
				//ظATͨæ
				char* err_str = at_err_build(ATERR_CHANNEL_BUSY);
				at_context_write_data(at_fd, err_str,strlen(err_str));
				free(err_str);
				return 1;
			}
			
			at_print(AT_DEBUG,"rcvmsg_server_extat extat=%s \n", at_str);
            pMsg = malloc(sizeof(MSG_BUF));
			if(pMsg == NULL){
				softap_assert("");
				return 1;
			}
			memset(pMsg, 0x00, sizeof(MSG_BUF));

            pMsg->ulMagic = MSG_MAGIC_WORD;
            pMsg->lMsgType = MSG_TYPE_DEFAULT;
            pMsg->src_id = at_fd;    //ⲿչAT˴ֵΪATͨ
            pMsg->dst_id = MODULE_ID_AT_CTL;
            pMsg->usMsgCmd = modem_req_node->req_msg_id;
            if(modem_req_node->parse_act != NULL)
            {
                ret = modem_req_node->parse_act(at_cmd_paras, (void*)pMsg->aucDataBuf, &pMsg->usDataLen);
                //ʧܣظERRӦԶ
                if(ret == AT_END)
                {	
                	char *retStr = NULL;					
					retStr = at_err_build(ATERR_PARAM_INVALID);
                    at_context_write_data(at_fd, retStr,strlen(retStr));
					free(retStr);
					
					free(pMsg); 
                    return 1;
                }
            }
            else//޲չAT
            {
                pMsg->usDataLen = 0;
            }
			//˴ATͨΪԴģIDڼɶ
			rcv_clt_req_msg_proc(pMsg);
			free(pMsg);         
            return 1;
        }

    }
    return 0;
}

/*չATĴΪͬ첽ַʽ*/
static int ext_req_to_app(int at_fd, char *at_str, void *at_cmd_prefix, int prefix_len, char *at_cmd_paras)
{
	int ret = AT_END;
	struct at_context *context = NULL;
	struct ser_ops_t *rcv_req_node = NULL;
	struct at_channel_info *new_chan = NULL;
	void * res_msg = NULL;

	//ԷǵչATƥ䴦
    list_for_each_entry(rcv_req_node,&g_ser_list,list)
    {    
        //עᵽser_ops_t2еǰ׺ȣпܱȸatǰ׺Ҫ
		if(0 == at_strncmp(rcv_req_node->at_cmd_prefix, (char*)at_cmd_prefix,MAXSTR(rcv_req_node->at_cmd_prefix, prefix_len)))
		{
			if(at_context_find_ctx_by_fd_type(at_fd, AT_FWD_UP)||at_context_find_ctx_by_fd_type(at_fd, AT_SERVER))
			{
				//ظATͨæ
				char* err_str = at_err_build(ATERR_CHANNEL_BUSY);
				at_context_write_data(at_fd, err_str,strlen(err_str));
				free(err_str);
				return 1;
			}

			
			ret = rcv_req_node->req_rcv_act(at_cmd_paras, &res_msg);
			//atֱͬӴreq_rcv_actֱӴӦatres_msgAT_END
			if(ret == AT_END)
			{                
				if(res_msg == NULL)
					at_context_write_data(at_fd,"\r\nOK\r\n",strlen("\r\nOK\r\n"));
				else
				{
					at_context_write_data(at_fd, res_msg,strlen(res_msg));				            
					free(res_msg);
					res_msg = NULL;
				}
				return 1;
			}
			//첽
			else if(ret == AT_CONTINUE)
			{
				if(res_msg)
					softap_assert("exception");
                if(rcv_req_node->module_id)
                {                	
                	//ڷռõatͨжռԣatͨѾرʱĲŻʧܣͷڴֱӷؼɣٷϢ
                    context = at_context_alloc_ctx_by_fd(at_fd,AT_SERVER);
					if(NULL == context)
					{
						softap_assert("exception");
						return 1;
					}
					int store_len = prefix_len<(AT_CMD_PREFIX)?prefix_len:(AT_CMD_PREFIX-1);
					snprintf(context->at_cmd_prefix,store_len+1,"%s",(char *)at_cmd_prefix);
					//strncpy(context->at_cmd_prefix, (char *)at_cmd_prefix, store_len);
                    context->source = rcv_req_node->module_id;
					return 1;
                }
				else
				{
					softap_assert("exception");
				}
		    }
			else
			{
				softap_assert("exception");
			}
        }
    }    
    return 0;
}

void* wait_rsp_timeout_proc(VOID *arg)
{
	int at_fd = (int)arg;

	at_print(AT_ERR,"at_fd: %d!!!!\n", at_fd);

    ipc_send_message(MODULE_ID_AT_CTL, MODULE_ID_AT_CTL, ATCTL_INNER_WAIT_OUTSIDE_RSP_MSG, sizeof(int), &at_fd, IPC_NOWAIT);
	
	NETDOG_AT_STATICS(wait_farps_rsp_timeout++);
	return NULL;
}

void set_wait_rsp_timeout(int fd, struct at_context *up_context)
{
	#if (APP_OS_TYPE == APP_OS_LINUX)	
	int ret = 0;
	
	sc_timer_delete(AtWaitRspTimeID);
	
    ret = sc_timer_create(AtWaitRspTimeID,
                        TIMER_FLAG_ONCE,
                        up_context->at_channel->timeout*1000,
                        wait_rsp_timeout_proc,
                        (void *)fd);
	if(ret != 0)
		softap_assert("");
	#endif
}


/*ֻVOLTEĿͻӦptyԭ·زŻ߽̣תЭջ */
static int fwd_not_VoLTE_req_at(struct at_context * context, int at_fd, char *at_str)
{
    struct at_context *new_context = NULL;
    struct app_clt_ops_t *ext_nod = NULL;

    ext_nod = find_extclt_by_msg(context->msg_id);
    if(ext_nod == NULL)
    {
        at_print(AT_ERR,"fwd_not_VoLTE_req_at ERR: ext_nod == NULL \n");
		softap_assert("");//Ӧߵ
        return -1;
    }

    new_context = at_context_alloc_ctx_by_pos(ext_nod->position);
    if(new_context == NULL)
    {
        at_print(AT_ERR,"fwd_not_VoLTE_req_at \n");
		resend_rcv_atstr(at_fd,at_str);
        return -1;
    }
    new_context->source = context->source;
    new_context->msg_id = context->msg_id;
    new_context->cmdId = context->cmdId;
    new_context->app_param = context->app_param;
	context->app_param = NULL;//Ӧvolteܶ

    at_context_free_ctx(context);

    at_context_write_by_ctx(new_context,at_str,strlen(at_str));
	set_fwd_fd(new_context->at_channel->at_fd);
    return 0;
}

/*ֻVOLTEⲿתptyԭ·غ󣬷͸NEAR_PSЭջ*/
static int fwd_not_VoLTE_extreq_at(struct at_context * context, int at_fd, char *at_str)
{
    int position = at_context_get_pos_by_fd(at_fd);
    struct at_context *up_context;
    struct at_context *down_context = NULL;
    int    down_position = 0;

    up_context = context->fwd_context;
    
    /* Ƿ͸voltevolteϢֱӷ͵modem*/
    if(position == POSITION_VOLTE)
    {
        down_context = at_context_alloc_ctx_by_fwdctx(NEAR_PS, up_context);
        down_position = NEAR_PS;
    }
    else
    {
        softap_assert("");
    }

    /* ޿ͨЯĺATat_ctl´ĵ*/
    if (!down_context)
    {
		resend_rcv_atstr(at_fd,at_str);
    }
    else
    {
    	at_context_free_ctx(context);
        /* cp¼еģapcp෢pduѯʹ*/
        up_context->fwd_context = down_context;
        at_context_write_by_ctx(down_context, at_str, strlen(at_str));
		set_fwd_fd(down_context->at_channel->at_fd);
    }
    return 0;
}


/*ǷȫתЭջ*/
static int fwd_req_at_proc(int at_fd, char *at_str, void *at_cmd_prefix, int prefix_len, void * at_cmd_paras)
{
	struct at_context *context = NULL;
    int position = at_context_get_pos_by_fd(at_fd);
    struct fwd_ops_t* at_forward_node;
    struct at_context *up_context;
    struct at_context *down_context;
    int    down_position = 0;

	//յATת
    context = at_context_find_ctx_by_fd_type(at_fd, AT_FWD_UP); // kw 3
    if(context)
    {/* תȡֱתͨĽڵϢ*/
		if(context->fwd_context)
		{
#if (APP_OS_TYPE == APP_OS_LINUX)
			//apֻttyͨתǿȡֱӻظͨæ
			if(check_is_farps(at_fd) && !check_cancelled_cmd(context->fwd_context->at_cmd_prefix))
			{
				//ظATͨæ
				char* err_str = at_err_build(ATERR_CHANNEL_BUSY);
				at_context_write_data(at_fd, err_str,strlen(err_str));
				free(err_str);
			}
			else//ֱ֮ǰͨд
#endif
				set_fwd_fd(context->fwd_context->at_channel->at_fd);
			
			return 0;
		}
    }
    at_forward_node = find_fwd_by_prefix(at_cmd_prefix, prefix_len);
    /* ΪǰתatתĽڵ*/
    up_context = at_context_alloc_ctx_by_fd(at_fd,AT_FWD_UP);

	if(NULL == up_context)
	{
		//βռõatͨжռԣatͨѾرʱĲŻʧܣֱӷأټת
		return 0;
	}
	//CPUעATֱת
    if(at_forward_node==NULL ||!at_forward_node->req_act || (AT_CONTINUE == at_forward_node->req_act(at_cmd_paras, at_fd, up_context)))
    {
        up_context->at_proc = (void*)at_forward_node;
        //atĴ˳:VOLTE͸modem
        if(position == FAR_PS)
        {
            if(prefix_len <= 0)
            {
            	softap_assert("fwd_req_at_proc prefix is less than 0!!!");
            }
#ifdef _USE_VOLTE
            down_position = POSITION_VOLTE;
#else
        	down_position = NEAR_PS;
#endif           
            /* Ľڵ*/
            down_context = at_context_alloc_ctx_by_fwdctx(down_position,up_context);
        }
        else if(position== POSITION_VOLTE)
        {
            down_context = at_context_alloc_ctx_by_fwdctx(NEAR_PS,up_context);
            down_position = NEAR_PS;
        }  
		else if(position== NEAR_PS)
		{
            down_context = at_context_alloc_ctx_by_fwdctx(FAR_PS,up_context);
            down_position = FAR_PS;
        } 
        else
        {
            //ͷATıϢδעATϱߵλ,ݶ
            //softap_assert("");
            at_print(AT_ERR,"ERR: %s unknow AT",at_str);
            at_context_free_ctx(up_context);
            return -1;
        }

        /* ޿ͨЯĺATat_ctl´ĵ*/
        if (!down_context)
        {
        	at_context_free_ctx(up_context);
			resend_rcv_atstr(at_fd,at_str);
        }
        else
        {
            /* cp¼еģapcp෢pduѯʹ*/
            up_context->fwd_context = down_context;
			at_context_write_by_ctx(down_context, at_str, strlen(at_str));
			set_fwd_fd(down_context->at_channel->at_fd);	
			if(up_context->at_channel->timeout > 0)
			{				
				set_wait_rsp_timeout(at_fd, up_context);	    
			}
			return  1;
        }
    }
	//鲻쳣ⲿAT󣬱req_actغڲظⲿMCUڴ˿ִ
    else
    {
        at_context_free_ctx(up_context);
        at_print(AT_ERR,"%s  REQ  have  been  consumed\n",at_str);
    }
    return 0;
}
/* AT*/
static int rcv_at_req_handle(int at_fd, char *at_str, void *at_cmd_prefix, int prefix_len, void * at_cmd_paras, int paras_len)
{
    struct at_context * context = NULL;
	struct at_channel_info * ch_info = at_context_find_chn_by_fd(at_fd);
	
#if (APP_OS_TYPE == APP_OS_LINUX)
	//Ϊ˱֤ⲿMCUǱһ𿪻ͨ˫ԼĵһATǰ׺
	if(check_is_farps(at_fd) && 0 == rcv_at_req_first_check(at_fd, at_str))
	{
		return 0;
	}
#endif
	if(ch_info)
	{
		snprintf(ch_info->last_cmd,AT_CMD_MAX,"%s\r\n",(char *)at_str);
	}

	//ӦAPP͵VoLTEԭ·
    if((context = at_context_find_ctx_by_fd_type(at_fd, AT_CLIENT)) 
		&& 0 == at_strncmp(context->at_cmd_prefix,(char*)at_cmd_prefix, MAXSTR(context->at_cmd_prefix,prefix_len))
		&& context->at_channel->position == POSITION_VOLTE)
    { 
        /*ֻVOLTEĿͻӦptyԭ·زŻ߽̣תЭջ */
        return fwd_not_VoLTE_req_at(context, at_fd, at_str);
    }
	//ⲿCPU͵VoLTEԭ·
    else if( (context = at_context_find_ctx_by_fd_type(at_fd, AT_FWD_DOWN)) 
		&& 0 == at_strncmp(context->at_cmd_prefix,(char*)at_cmd_prefix, MAXSTR(context->at_cmd_prefix,prefix_len))
		&& context->at_channel->position == POSITION_VOLTE)
    { 
    	/*ֻVOLTEⲿתptyԭ·غת͸NEAR_PSЭջ*/
        return fwd_not_VoLTE_extreq_at(context, at_fd, at_str);
    }
    else
    {
        if((context = at_context_find_ctx_by_fd_type(at_fd, AT_SERVER)) != 0)
        {	 
        	NETDOG_AT_STATICS(farps_cmd_again++);
        	at_print(AT_ERR,"more than one REQ at cmd on channel %d as AT_SERVER, prefix is %s, now at str is %s!!!\n", at_fd, context->at_cmd_prefix,at_str);
        }
        else if ((context = at_context_find_ctx_by_fd_type(at_fd, AT_FWD_UP)) != 0)
        {			
        	NETDOG_AT_STATICS(farps_cmd_again++);
        	at_print(AT_ERR,"more than one REQ at cmd on channel %d as AT_FWD_UP, prefix is %s, now at str is %s!!!\n", at_fd, context->fwd_context->at_cmd_prefix,at_str);
        }		

		
		/*ⲿչATڲΪźͷǵദڲͨתΪϢ*/
        if(ext_req_at_proc(at_fd, at_str, at_cmd_prefix, prefix_len,at_cmd_paras))
        {
            return 0;
        }
		else if(ext_req_to_app(at_fd, at_str, at_cmd_prefix, prefix_len,at_cmd_paras))
        {
            return 0;
        }


		//ǱCPUܴATһͨдATͨ͸ⲿCPU
		return fwd_req_at_proc(at_fd, at_str, at_cmd_prefix, prefix_len, at_cmd_paras);
    }
}

/* תĽڵӦϢĴ*/
static void rcv_rsp_at_fwd_down(struct at_context * context, char *at_str, void * at_cmd_paras, int at_fd)
{
    int msgtype = get_msgtype(at_str);
    int ret = AT_END;

	at_print(AT_ERR, "rcvmsg_rsp_at_fwd_down context->prefix = %s \n" ,context->at_cmd_prefix);
    /* תյӦ,ֻPDPתҪأһATת,ֱת͸λ*/
    if(context->at_proc != NULL)
    {
        struct fwd_ops_t *forward_node = (struct fwd_ops_t *)context->at_proc;
        at_netdog_monitor(at_fd, at_str, context->at_cmd_prefix);
        if(msgtype == AT_RSP_OK && forward_node->ok_act)
        {
            ret = forward_node->ok_act(at_cmd_paras, context->fwd_context);
        }
        else if(msgtype == AT_RSP_ERR && forward_node->err_act)
        {
            ret = forward_node->err_act(at_cmd_paras,context->fwd_context);
        }
    }
    if(ret == AT_WAIT_AUTO)
    {
		delay_resend_atstr(at_fd,at_str);  
    }
    else
    {
		set_fwd_fd(context->fwd_context->at_channel->at_fd);
		//ͨʱʱ䣬Ҫرնʱ
		if(context->fwd_context->at_channel->timeout > 0)
		{		
#if (APP_OS_TYPE == APP_OS_LINUX)	
			sc_timer_delete(AtWaitRspTimeID);
#endif
		}
        at_context_free_ctx(context->fwd_context);
        at_context_free_ctx(context);
    }
}

/* ͻĽڵӦϢĴ*/
static void rcv_rsp_at_client(struct at_context * context, char *at_str, void * at_cmd_paras, int at_fd)
{
    int msgtype = get_msgtype(at_str);
    int ret = AT_END;
    void   *res_msg = NULL;
    int    res_msglen = 0;
    struct app_clt_ops_t *clt_nod = NULL;

    at_print(AT_ERR, "rcvmsg_rsp_at_client context->prefix = %s \n" ,context->at_cmd_prefix);

	//оƬ֤жϷ֧
	if(atcmd_stream_rep_proc(context, at_str))
		return;
	/* ֻпͻעATprocӿڵģŻжӦĽӿڴ*/
    if(context->at_proc)
    {
        struct clt_ops_t *req_node = (struct clt_ops_t *)context->at_proc;

        /* ok_acterr_actķֵȷһδ¼ͨAT_CONTINUEһatķͣ
           ͨAT_END¼ֹ*/
        at_netdog_monitor(at_fd, at_str, context->at_cmd_prefix);
        if(msgtype == AT_RSP_OK && req_node->ok_act)
        {
            ret = req_node->ok_act(at_cmd_paras,context,&res_msg,&res_msglen);
        }
        else if(msgtype == AT_RSP_ERR && req_node->err_act)
        {
            ret = req_node->err_act(at_cmd_paras,context,&res_msg,&res_msglen);
        }

        if(ret == AT_END)
        {/* ͻ˵ɺװӦϢϱͻAPP*/
            at_print(AT_DEBUG,"rcvmsg_rsp_at_client reply to app \n");
            if(context->msg_id != 0)
            {
                clt_nod = find_extclt_by_msg(context->msg_id);
                if(clt_nod == NULL)
                {
                    at_print(AT_ERR,"ERR: find_extclt_by_msg fail \n");
                    at_context_free_ctx(context);
                    return;
                }
                at_print(AT_NORMAL,"rcvmsg_rsp_at_client send msg to app msg_id=0x%x,dst_id=0x%x,rsp_msg_id=0x%x \n",context->msg_id,context->source,clt_nod->rsp_msg_id);
				send_rsp_msg(context->source,context->msg_id,clt_nod->rsp_msg_id,res_msglen,res_msg);
            }           
            at_context_free_ctx(context);
        }
        //ĿǰPDPzgipdnsϱOKϱ
        //¼Ѿɣڵȴĳϱ
        else if(ret == AT_WAIT_AUTO)
        {
			delay_resend_atstr(at_fd,at_str);  
            return;
        }
        //Ŀǰpdpȡcid󣬱ָķcgact
        else if(ret == AT_CONTINUE)
        {
			at_context_write_by_ctx(context, res_msg, res_msglen);			
            at_context_write_data(context->at_channel->at_fd, res_msg, res_msglen);
        }
        else
        {
            softap_assert("");
        }

        if(res_msg != NULL)
        {
            free(res_msg);
        }
    }
    else
    {
        at_context_free_ctx(context);
    }
}
/* ӦAT*/
static int rcv_at_rsp_handle(int at_fd, char *at_str, void *at_cmd_prefix, int prefix_len, void * at_cmd_paras, int paras_len)
{
    struct at_context * context = NULL;


    if((context = at_context_find_ctx_by_fd_type(at_fd, AT_FWD_DOWN)) != 0)
    {/* תĽڵϢĴ*/
        rcv_rsp_at_fwd_down(context, at_str, at_cmd_paras, at_fd);
    }
    else if( (context = at_context_find_ctx_by_fd_type(at_fd, AT_CLIENT)) != 0)
    {/* ͻĽڵϢĴ*/
        rcv_rsp_at_client(context, at_str, at_cmd_paras, at_fd);
    }	
    else
    {/* ƥ䲻ģȡӳӦ𣬲*/
        NETDOG_AT_STATICS(rcv_undesirable_rsp++);
        at_print(AT_ERR,"AT_TYPE_RESPONSE have not related context,may abort rsp\n");
    }

    return 0;
}

char PsmIndAtCmdPrefix[AT_CMD_MAX] = {0};	 /*չõϱATǰ׺*/
void rcv_at_inform_filter(int at_fd, void *at_cmd_prefix, int prefix_len)
{	
    int position = at_context_get_pos_by_fd(at_fd);
	char temp_prefix[21]= {0};
	int tempPrefixlen = 0;
	int ismatch = 0;
	char* ptr = NULL;
	char* ptr1 = NULL;
	int len_start = 0, len_end = 0;

	tempPrefixlen = (prefix_len>20)? 20: prefix_len;
	snprintf(temp_prefix,tempPrefixlen+1,"%s",(char *)at_cmd_prefix);
 	//strncpy(temp_prefix, at_cmd_prefix, tempPrefixlen);

	//ǿMCUֻ+CGREG+CREGϱ
	if(CUSTOMER_GUODIAN == g_customer_type || CUSTOMER_NANDIAN == g_customer_type)
	{
		strcpy(PsmIndAtCmdPrefix, "+CGREG+CREG");
	}
#ifndef USE_CAP_SUPPORT
	else
	{
		sc_cfg_get("customIndCmdList", PsmIndAtCmdPrefix, sizeof(PsmIndAtCmdPrefix));
	}
#endif
	//at_print(AT_ERR,"[XXX]customIndCmdList =%s\n",PsmIndAtCmdPrefix);
	//at_print(AT_ERR,"[XXX]FwIndAtCmdPrefix =%s\n",FwIndAtCmdPrefix);	
	//at_print(AT_ERR,"[XXX]at_cmd_prefix =%s\n",temp_prefix);
	//תNEAR_PS[0]ͨ
	//if((g_auto_fd == at_fd || check_is_fd(at_fd) == 0) && position == NEAR_PS)
	if(g_auto_fd == at_fd)
	{		
		//ϱУ㲥FARPS&VOLTE,ֻ㲥VOLTEЭջ
		if(strlen(PsmIndAtCmdPrefix) != 0)
		{
			ptr = PsmIndAtCmdPrefix;
			while(NULL != (ptr1 =  at_strstr(ptr, temp_prefix)))
			{
				len_start += (int)(ptr1-PsmIndAtCmdPrefix);
				len_end = len_start+strlen(temp_prefix);
				if(0 == len_start){
					if(!isdigit(PsmIndAtCmdPrefix[len_end]) && !isalpha(PsmIndAtCmdPrefix[len_end])){
						ismatch=1;
						break;
					}
				}else{
					if(!isdigit(PsmIndAtCmdPrefix[len_end]) && !isalpha(PsmIndAtCmdPrefix[len_end])
						&& !isdigit(PsmIndAtCmdPrefix[len_start-1]) && !isalpha(PsmIndAtCmdPrefix[len_start-1])){
						ismatch=1;
						break;
					}
				}
				ptr+=len_end;

			}
			if(ismatch){
				set_fwd_fd(BROADCAST_FWD);				
				at_print(AT_ERR,"[XXX]set_fwd_fd  111\n");
			}else{
				set_fwd_fd(BROADCAST_VOLTE);
				at_print(AT_ERR,"[XXX]set_fwd_fd  222\n");
			}
		}
		else if(strlen(FwIndAtCmdPrefix) != 0)
		{
			if(at_strstr(FwIndAtCmdPrefix, temp_prefix))
			{
				set_fwd_fd(BROADCAST_FWD);	
				at_print(AT_ERR,"[XXX]set_fwd_fd  333\n");
			}
			else
			{
				set_fwd_fd(BROADCAST_VOLTE);	
				at_print(AT_ERR,"[XXX]set_fwd_fd  444\n");
			}
		}
		else
		{
			set_fwd_fd(BROADCAST_FWD);	
			at_print(AT_ERR,"[XXX]set_fwd_fd  555\n");
		}
	}	
	/* VOLTEϱ͸FAR_PS*/
	else if(position == POSITION_VOLTE)
	{
		if(strlen(PsmIndAtCmdPrefix) != 0)
		{
			if(at_strstr(PsmIndAtCmdPrefix, temp_prefix))
			{
				set_fwd_fd(BROADCAST_FARPS);	
				at_print(AT_ERR,"[XXX]set_fwd_fd  666\n");
			}
			else
			{
				set_fwd_fd(0);	
				at_print(AT_ERR,"[XXX]set_fwd_fd  777\n");
			}
		}
		else if(strlen(FwIndAtCmdPrefix) != 0)
		{
			if(at_strstr(FwIndAtCmdPrefix, temp_prefix))
			{
				set_fwd_fd(BROADCAST_FARPS);	
				at_print(AT_ERR,"[XXX]set_fwd_fd 888\n");
			}
			else
			{
				set_fwd_fd(0);	
				at_print(AT_ERR,"[XXX]set_fwd_fd  999\n");
			}
		}		
		else
		{
			set_fwd_fd(BROADCAST_FARPS);	
			at_print(AT_ERR,"[XXX]set_fwd_fd  AAA\n");
		}		
	}
	//fdʵͨϢԴΪfdյϱ
	else if(check_is_fd(at_fd) == 0 && position == NEAR_PS)
	{
		set_fwd_fd(BROADCAST_FARPS);	
		at_print(AT_ERR,"[XXX]set_fwd_fd  BBB\n");
	}

}


/* ֪ͨAT*/
static int rcv_at_inform_handle(int at_fd, char *at_str, void *at_cmd_prefix, int prefix_len, void * at_cmd_paras, int paras_len)
{
    int position = at_context_get_pos_by_fd(at_fd);
    struct at_context * context = NULL;
    struct at_context *fwd_context = NULL;
	struct inform_ops_t* entry = NULL;	

    /* ͻĽڵƥ*/
    if(NULL != (context = at_context_find_ctx_by_fd_type(at_fd, AT_CLIENT)))
    {
        /* atǰ׺ƥ䣬һ˵֮ǰͻ·atмϱ*/
        if( (prefix_len >0 && at_cmd_prefix != NULL && 0 == at_strncmp(context->at_cmd_prefix,(char*)at_cmd_prefix, prefix_len))
                || (prefix_len >0 && at_cmd_prefix != NULL && 0==strncmp("> ",at_cmd_prefix, prefix_len)))
        {
        	at_print(AT_ERR,"receive client inform str = %s, fd = %d\n", at_str, at_fd);
        	//оƬ֤жϷ֧
			if(atcmd_stream_inform_proc(context, at_str))
				return 0;			
						
		    list_for_each_entry(entry,&g_inform_list,list)
		    {
		        if((0 == at_strncmp(entry->at_cmd_prefix,(char*)at_cmd_prefix, MAXSTR(entry->at_cmd_prefix,prefix_len))) && entry->inform_act)

					entry->inform_act(at_cmd_paras, (int)context);
		            
		    }
           
            return 0;
        }
    }
    /* תζĽڵƥ*/
    else if(NULL != (fwd_context = at_context_find_ctx_by_fd_type(at_fd, AT_FWD_DOWN)))
    {
    	//ʵͨյٽATǰ׺ƥ䣬ֱתͨ
		if(0 == check_is_fd(at_fd))
		{
			set_fwd_fd(fwd_context->fwd_context->at_channel->at_fd);
			return 0;
		}
		
		/* atǰ׺ƥ䣬һ˵֮ǰתatмϱ
           תм߼Ӧڲģ鲻ĺʹģ˲õϱ
         */
        if( (prefix_len >0 && at_cmd_prefix != NULL && 0 == at_strncmp(fwd_context->at_cmd_prefix, (char*)at_cmd_prefix, prefix_len))
                ||(prefix_len >0 && at_cmd_prefix != NULL && 0==strncmp("> ",at_cmd_prefix, prefix_len)) )
        {
        	at_print(AT_ERR,"receive fwd_down inform str = %s, fd = %d\n", at_str, at_fd);
			set_fwd_fd(fwd_context->fwd_context->at_channel->at_fd);
			if(strstr(at_str,"> ") != NULL)
			{
				struct at_channel_info * ch_info = at_context_find_chn_by_fd(fwd_context->fwd_context->at_channel->at_fd);
				if(ch_info != NULL)
				ch_info->cmd_state = 1;//յ> øͨ״̬Ϊ״̬ͨյǶ
			}
            return 0;
        }
    }
    /* һϱg_auto_fdͨϱVOLTEϱg_auto_fdĬѡһ򿪵NEAR_PSλõatͨ*/
    if(g_auto_fd == at_fd || position == POSITION_VOLTE || position == FAR_PS)
    {
    	at_print(AT_ERR,"receive auto report str = %s, fd = %d, g_auto_fd = %d, position = %d\n", at_str, at_fd, g_auto_fd, position);

		list_for_each_entry(entry,&g_inform_list,list)
		{
		   if((0 == at_strncmp(entry->at_cmd_prefix,(char*)at_cmd_prefix, MAXSTR(entry->at_cmd_prefix,prefix_len))) && entry->inform_act)
		   {
#ifdef _USE_BL
			if(at_cmd_prefix){
			if(AT_CMD_PREFIX > prefix_len)
			   memcpy(IndAtCmdPrefix, at_cmd_prefix, prefix_len);
			else
				memcpy(IndAtCmdPrefix, at_cmd_prefix, AT_CMD_PREFIX-1);
			}
#endif
			   entry->inform_act(at_cmd_paras, 0);
#ifdef _USE_BL
			   memset(IndAtCmdPrefix, 0x00, AT_CMD_PREFIX);
#endif
		   }			   
		}
    {
        struct inform_ops_t0* entry0 = NULL;  

        list_for_each_entry(entry0,&g_inform_list0,list)
        {
           if((0 == at_strncmp(entry0->at_cmd_prefix,(char*)at_cmd_prefix, MAXSTR(entry0->at_cmd_prefix,prefix_len))))
           {
            at_print(AT_ERR,"inform_act at_cmd_prefix0 = %s \n", entry0->at_cmd_prefix);
            //ϢʧܣֱӷERRORͷͨ
            if(at_cmd_paras && 0 != ipc_send_message2(MODULE_ID_AT_CTL, entry0->module_id, entry0->req_msg_id, strlen(at_cmd_paras)+1, at_cmd_paras,0))
            {
                at_print(AT_ERR,"inform_act at_cmd_prefix0 ipc err\n");
            }
           }
        }
    }
    }
	if(at_cmd_prefix)
	rcv_at_inform_filter(at_fd, at_cmd_prefix, prefix_len);
    
    return 0;
}

/* PDUAT
һЭջϱPDU, һǴⲿMCUAPյPDUҪתЭջ*/
static int rcv_sms_pdu_handle(int at_fd, char *at_str, void *at_cmd_prefix, int prefix_len, void * at_cmd_paras, int paras_len)
{
    int position = at_context_get_pos_by_fd(at_fd);
    struct at_context * context = NULL;
	int i = 0, curlen = 0, leftDatalen = 0;
	int totallen = strlen(at_str);
	
    /* ͻƥ     ZMGR ZMGLϱPDU*/
    if(NULL != (context = at_context_find_ctx_by_fd_type(at_fd, AT_CLIENT)))
    {        
        at_print(AT_ERR,"client pdu:%s, msgid:%d, prefix:%s\n", (char *)at_cmd_paras, context->msg_id, context->at_cmd_prefix);
        //at_print(AT_ERR,"client pdu\n");
#ifdef _USE_BL
        at_print(AT_NORMAL,"corem prefix:%s,cmdId:%d\n", context->at_cmd_prefix, context->cmdId);
        phone_info_pdu(at_cmd_paras ,(int)context);
#else
        atSms_RecvPdu(at_cmd_paras, context);
#endif
        return 0;       

    }
    /* תζƥ䡣cp:Ӻ˼ͨѶȡмϱߴ*/
    else if(NULL != (context = at_context_find_ctx_by_fd_type(at_fd, AT_FWD_UP)))
    {
        //at_print(AT_DEBUG,"coremtest context:%p, fwcontext:%p, str:%s\n", context, context->fwd_context, context->at_cmd_prefix);
        if(context->fwd_context)
            at_print(AT_DEBUG,"coremtest contextfwd:%p, str:%s\n", context->fwd_context, context->fwd_context->at_cmd_prefix);

        at_print(AT_DEBUG,"corem len:%d, str: %s, position:%d, ctprefix:%s\n", prefix_len, (char *)at_cmd_prefix, position, context->fwd_context->at_cmd_prefix);
        /* appduҪתЭջ, cpҪת*/
        if(position == FAR_PS && context->fwd_context != NULL)
        {
            at_print(AT_DEBUG,"corem cmdp:%s, msgid:%d, prefix:%s\n", (char *)at_cmd_paras, context->msg_id, context->at_cmd_prefix);
            if(context->fwd_context->at_channel == NULL)
            {
                softap_assert("");
				return 0;
            }
            set_fwd_fd(context->fwd_context->at_channel->at_fd);			
            return 0;
        }
    } 

	/*NEAR_PSVOLTE_PTYϱPDUCDS CMT */
	if(g_auto_fd == at_fd || position == POSITION_VOLTE)
	{
		at_print(AT_ERR,"Recv Pdu auto rsp\n");
		//at_print(AT_DEBUG,"corem cmdp:%s\n", (char *)at_cmd_paras);
#ifdef _USE_BL
		at_print(AT_DEBUG,"corem prefix NULL\n");
        phone_info_pdu(at_cmd_paras ,NULL);
#else
		atSms_RecvPdu(at_cmd_paras, NULL);		
#endif
	}
    return 0;
}


/*******************************************************************************
 *                      Global function implementations                        *
 ******************************************************************************/
/**
 * @brief ATͨϢʵ֡ࡢӦࡢ֪ͨ༰PDUatϢ
 * @param msg Ϣ
 * @return ϸϢμat_write_positionöϢ
 * @note   
 * @warning 
 */
int at_rcvmsg_handle(int at_fd, char *at_str, int at_len)
{
    /* at*/
    int at_str_type;
    /* atǰ׺ʼλãֱָatڴ棬atǰ׺λúַһʱ'\0'atǰ׺ȱһʹãȷǰ׺*/
    void * at_cmd_prefix = NULL;
    /* atǰ׺ȣpduϢǰ׺Ϊ0ʱat_cmd_prefixΪ*/
    int prefix_len = 0;
    /* atʼλãֱָatڴ棬atڲʱat_cmd_parasΪnullparas_lenΪ0*/
    void * at_cmd_paras = NULL;
    /* atȣΪ0*/
    int paras_len = 0;

    /* ATǰ׺Ϣʶǰ׺ݼAT*/
    at_str_type = parase_at_cmd(at_str, &at_cmd_prefix, &prefix_len, &at_cmd_paras, &paras_len);
    //at_print(AT_NORMAL,"at_rcvmsg_handle str=%s, len = %d\n, at_fd = %d, at_str_type = %d, at_cmd_paras: %s\n",at_str, at_len, at_fd,at_str_type,(char *)at_cmd_paras);
	
	if(whole_at_type == -1)
		whole_at_type = at_str_type;
#ifdef MULTI_CPU
	/*˼Ϣ+MSG:XXXXX*/
    if(0 == at_strncmp("MSG", (char*)at_cmd_prefix, MAXSTR("MSG", prefix_len)))
    {
		at_print(AT_ERR,"receive socmsg str = %s\n", at_str);
		/* Ǻ˼ͨѶATϢat_ctlڲֱӴ͸Ӧô˴ͽ*/
		at_socmsg_trans_and_write(at_cmd_paras,paras_len); 
        return 0;
    }
#endif
    if(at_str_type == AT_TYPE_REQUEST)//
    {
    	//ıATATᱻתFAR_PS
    	//磺\r\n+CMT: "+8613813800713","","18/04/18,14:05:18+32"\r\n at\r\n
    	if(fwd_fd != 0 && whole_at_type != at_str_type)
			return 0;
			
    	at_print(AT_ERR,"at_rcvmsg_handle AT_TYPE_REQUEST str=%s, at_fd = %d, at_cmd_paras: %s, prefix_len: %d, paras_len: %d\n",at_str, at_fd,(char *)at_cmd_paras, prefix_len, paras_len);
		//ǰ׺ȴǰ׺󱣴泤ʱ add by zpr 210115
		if(prefix_len >= AT_CMD_PREFIX)
		{
			//ظAT
			char* err_str = at_err_build(ATERR_STR_TOO_LONG);
			at_context_write_data(at_fd, err_str,strlen(err_str));
			free(err_str);
			return 0;
		}
        return rcv_at_req_handle(at_fd, at_str, at_cmd_prefix, prefix_len, at_cmd_paras, paras_len);
    }
    else if(at_str_type == AT_TYPE_RESPONSE)//Ӧ
    {
    	at_print(AT_ERR,"at_rcvmsg_handle AT_TYPE_RESPONSE str=%s, at_fd = %d, at_cmd_paras: %s, prefix_len: %d, paras_len: %d\n",at_str, at_fd,(char *)at_cmd_paras, prefix_len, paras_len);
        return rcv_at_rsp_handle(at_fd, at_str, at_cmd_prefix, prefix_len, at_cmd_paras, paras_len);
    }
    else if(at_str_type == AT_TYPE_INFORM)//мϱ
        return rcv_at_inform_handle(at_fd, at_str, at_cmd_prefix, prefix_len, at_cmd_paras, paras_len);
    else if(at_str_type == AT_TYPE_PDU)//PDU
    {
    	at_print(AT_ERR,"at_rcvmsg_handle AT_TYPE_PDU at_fd = %d, prefix_len: %d, paras_len: %d\n", at_fd, prefix_len, paras_len);
		if(at_cmd_paras)
		return rcv_sms_pdu_handle(at_fd, at_str, at_cmd_prefix, prefix_len, at_cmd_paras, paras_len);
    }
    return 0;
}


//תATֻҪһΪеĽΪͻʱ
void set_fwd_fd(int fd)
{
	if(fwd_fd == fd)
	{}
	else if(fwd_fd == 0 || fwd_fd == BROADCAST_FWD)
	{
		fwd_fd = fd;
	}
	else if(fwd_fd == BROADCAST_VOLTE  && fd == BROADCAST_FWD)
	{
	
	}
	else if(fwd_fd == BROADCAST_VOLTE  && fd == BROADCAST_FARPS)
	{
		softap_assert("");
	}
	else if(fwd_fd == BROADCAST_FARPS  && fd == BROADCAST_FWD)
	{
		softap_assert("");
	}
}
#ifndef HAVE_STRNLEN
extern int strnlen(char *s, unsigned int n);
#endif
/* AP˷ⲿMCUATӦͻMCU
 ҪⲿMCUҪתתATַ */
char* format_inform_for_farps(char *at_str)
{
#if (APP_OS_TYPE == APP_OS_LINUX)
	struct formatinform_ops_t * format_inform_node;
	char *at_param = NULL; 

    if((*at_str == 'A'||*at_str == 'a')&&(*(at_str+1) == 'T'||*(at_str+1) == 't'))
		return NULL;	

	list_for_each_entry(format_inform_node,&g_formatinform_list,list)
	{
		at_param = strstr(at_str, format_inform_node->at_cmd_prefix);
		if(at_param != NULL)
		{
			char *at_new_str = malloc(AT_CMD_MAX);
			char *at_new_param = NULL, *at_end = NULL, *next_str = NULL;
			int left_len = AT_CMD_MAX;
			
			at_param += strlen(format_inform_node->at_cmd_prefix);
	
			if(!at_new_str){
				softap_assert("malloc fail");
				return NULL;
			}
			memset(at_new_str, 0x00, AT_CMD_MAX);
			if(left_len <= at_param-at_str){
				free(at_new_str);
				return NULL;
			}
			memcpy(at_new_str, at_str, at_param-at_str);
			next_str = at_new_str + strnlen(at_new_str,left_len-1);
			left_len = left_len - strnlen(at_new_str,left_len-1);
	
			at_new_param = format_inform_node->inform_act(at_param);
			if(at_new_param)
			{
				if(left_len <= strlen(at_new_param)){
					free(at_new_str);
					free(at_new_param);
					return NULL;
				}
				memcpy(next_str, at_new_param, strlen(at_new_param));
				next_str = next_str + strlen(at_new_param); 
				left_len = left_len - strlen(at_new_param);
				free(at_new_param);
			}
			
			at_end = strstr(at_param, "\r\n");
			if(at_end)
			{	
				if(left_len <= strlen(at_end)){
					free(at_new_str);
					return NULL;
				}
				memcpy(next_str, at_end, strlen(at_end));			
				next_str = next_str + strlen(at_end);
			}
	
			*next_str = '\0';
			return at_new_str;
		}
	}
#endif
	return NULL;
}

/*תʽȺATַ*/
static void fwd_all_at_str(int fd, char *at_str)
{
	if(fd == BROADCAST_FARPS)
	{
		at_context_write_by_pos(FAR_PS, at_str);
	}
	else if(fd == BROADCAST_VOLTE)
	{
		at_context_write_by_pos(POSITION_VOLTE, at_str);
	}
	else if(fd == BROADCAST_FWD)
	{
		at_context_write_by_pos(FAR_PS, at_str);
		//if(check_is_pty())
		//{
			at_context_write_by_pos(POSITION_VOLTE, at_str);
		//}
	}
	else
	{	
		char* at_new_str = NULL;
		int ret = -1;

		//жתATǷҪʽ
		at_new_str = format_inform_for_farps(at_str);
		if(!at_new_str)
		{
			ret = at_context_write_data(fd, at_str, strlen(at_str)); 
		}
		else			
		{
			ret = at_context_write_data(fd, at_new_str, strlen(at_new_str)); 
			free(at_new_str);
		}
		if(ret < 0)
		{/*дʧֹܷͨ*/
#ifdef USE_CAP_SUPPORT
		struct at_context * context = NULL;
		if((context = at_context_find_ctx_by_fd_type(fd, AT_FWD_DOWN)) != 0){
			char* err_str = at_err_build(ATERR_PROC_FAILED);
			at_context_write_data(context->fwd_context->at_channel->at_fd, err_str,strlen(err_str));
			free(err_str);
		}
#endif
			rcv_at_rsp_handle(fd,"ERROR","",0,"",0);
			at_print(AT_ERR,"fwd_all_at_str write fail \n");
		}
	}
}

/*ԽյATַеַ "at_recv_thread"̴߳ATͨϢݽյatַ
װat*/
int rcv_at_str_proc(int at_fd, char *at_str, int at_len)
{
    char *whole_cmd_str = NULL;
    char *next_str = at_str;
    char *next_str_rn = NULL;
	char *pdu_str = NULL;
    char *next_str_r = NULL;
    char *next_str_n = NULL;
    char *pdu_data = NULL;
	char *pend_ctrlz = NULL, *pend_esc = NULL;
	int position = at_context_get_pos_by_fd(at_fd);

    at_print(AT_DEBUG,"rcv_at_str_proc recv fd:%d,len:%d,data:%s\n", at_fd, at_len, get_small_str(at_str));
    /*֮ǰķֶATַд*/
    if((whole_cmd_str = is_whole_atcmd(at_fd, at_str, at_len)) == NULL)
    {
        //at_print(AT_ERR,"ERR: recv incompleted cmd and stored!!\n");
        return 0;
    }
    fwd_fd = 0;
	whole_at_type = -1;
    //͸ЭջPDUʶ
    pend_ctrlz = strchr(whole_cmd_str, CTRL_Z_CHAR);
	pend_esc = strchr(whole_cmd_str, ESC_CHAR);
    if(NEAR_PS != position && (pend_ctrlz || pend_esc))
    {    
    	if(pend_ctrlz) *(pend_ctrlz+1) = '\0';
		if(pend_esc)  *(pend_esc+1) = '\0';       
        rcv_sms_pdu_handle(at_fd, whole_cmd_str,NULL, 0, whole_cmd_str, strlen(whole_cmd_str));
		next_str = whole_cmd_str + strlen(whole_cmd_str);
		struct at_channel_info * ch_info = at_context_find_chn_by_fd(at_fd);
		if(ch_info != NULL)
		ch_info->cmd_state = 0;//յĶݺڴݺ󣬻ָյöŵͨ״̬Ϊͨ״̬
		goto send_at_str;
    }
    /*"\r\n""\n""\r"Ϊ߽磬ȡÿATд."\r\n"
    "\r""\n"βӦ"\r\n"β*/
	next_str = whole_cmd_str;
	while(next_str < whole_cmd_str + strlen(whole_cmd_str))
    {
        char *single_at;

        next_str_rn = find_sub_str(next_str,"\r\n",strlen(next_str));
        next_str_r = find_sub_str(next_str,"\r",strlen(next_str));
        next_str_n = find_sub_str(next_str,"\n",strlen(next_str));
		if(next_str_n > (whole_cmd_str + strlen(whole_cmd_str)))
		{
			softap_assert("");
		}

		#if 1
		{
			char *quo_double_pre = NULL;
			char *quo_double_after = NULL;
			char *real_next_str_r = NULL;
			char *real_next_str_n = NULL;
			char *cusd = find_sub_str(next_str,"+CUSD:",strlen(next_str));

			if(cusd != NULL && (cusd < next_str_r || cusd < next_str_n))
			{//cusd\r\n
			
    	    	quo_double_pre = find_sub_str(next_str,"\"",strlen(next_str));
				if(quo_double_pre != NULL && quo_double_pre > cusd && (quo_double_pre < next_str_r || quo_double_pre < next_str_n)){
					quo_double_after = find_sub_str(quo_double_pre + 1,"\"",strlen(quo_double_pre + 1));
					if(quo_double_after != NULL && (quo_double_after - next_str - 1 <  strlen(next_str))){
						real_next_str_r = find_sub_str(quo_double_after + 1,"\r",strlen(quo_double_after + 1));
						real_next_str_n = find_sub_str(quo_double_after + 1,"\n",strlen(quo_double_after + 1));
						next_str_rn = find_sub_str(quo_double_after + 1,"\r\n",strlen(quo_double_after + 1));//corem0418
						if(real_next_str_r != NULL && real_next_str_r <= next_str_rn){
							next_str_r = real_next_str_r;
						}
						if(real_next_str_n != NULL && real_next_str_n <= next_str_rn+1){
							next_str_n = real_next_str_n;
						}
					}
				}					
			}
#if 0			
			if(quo_double_pre != NULL){
				at_print(AT_ERR,"quo_pre:%s\n", quo_double_pre);
			}
			if(quo_double_after != NULL){
				at_print(AT_ERR,"quo_aft:%d\n", quo_double_after - next_str);
			}
			if(real_next_str_r != NULL){
				at_print(AT_ERR,"real_r:%d\n", real_next_str_r - next_str);
			}
			if(real_next_str_n != NULL){
				at_print(AT_ERR,"real_n:%d\n", real_next_str_n - next_str);
			}
			if(next_str_rn != NULL){
				at_print(AT_ERR,"real_rn:%d\n", next_str_rn - next_str);
			}
#endif
        	
		}
#endif	
		
        //һAT"\r\n"β
        if((next_str_rn!=NULL)&&(next_str_r!=NULL)&&(next_str_rn==next_str_r)&&(next_str_rn<next_str_n))
        {
            //ATͷΪ"\r\n"
            if(next_str == next_str_rn)
            {               
                next_str += 2;
				continue;
            }
            single_at = (char *)malloc(next_str_rn-next_str+1);
			if(single_at == NULL){
				softap_assert("rcv_at_str_proc no mem!");
				free(whole_cmd_str);
				return -1;
			}
			memset(single_at, 0x00, next_str_rn-next_str+1);
            memcpy(single_at, next_str,next_str_rn-next_str);           
			at_rcvmsg_handle(at_fd, single_at,strlen(single_at));
			free(single_at);
            next_str = next_str_rn+2;
        }
        //һAT"\n"β
        else if((next_str_n!=NULL)&&(next_str_rn>next_str_n || next_str_rn==NULL)&&(next_str_r>next_str_n || next_str_r==NULL))
        {
            //յ"\n"ϴνضΪ'\r'Ϊ
            if(next_str == next_str_n)
            {
                next_str++;
                continue;
            }
            single_at = (char *)malloc(next_str_n-next_str+1);
			if(single_at == NULL){
				softap_assert("rcv_at_str_proc no mem!");
				free(whole_cmd_str);
				return -1;
			}
			memset(single_at, 0x00, next_str_n-next_str+1);
			memcpy(single_at, next_str,next_str_n-next_str);
			at_rcvmsg_handle(at_fd, single_at,strlen(single_at));
			free(single_at);
            next_str = next_str_n+1;
        }
        //һAT"\r"β,'\n'ûյʱҲAT֪Ƿ
        else if((next_str_r!=NULL)&&(next_str_rn>next_str_r || next_str_rn==NULL)&&(next_str_r<next_str_n || next_str_n==NULL))
        {
            //յ"\r"һATضϣ´ַΪ'\n'
            if(next_str == next_str_r)
            {
                next_str ++;
                continue;
            }
            single_at = (char *)malloc(next_str_r-next_str+1);
			if(single_at == NULL){
				softap_assert("rcv_at_str_proc no mem!");
				free(whole_cmd_str);
				return -1;
			}
			memset(single_at, 0x00, next_str_r-next_str+1);
			memcpy(single_at, next_str,next_str_r-next_str);
			at_rcvmsg_handle(at_fd, single_at,strlen(single_at));
			free(single_at);
            next_str = next_str_r+1;
        }
		//ͶϢϱ
        else if((pdu_str = strstr(next_str,"> "))!= NULL)
        {
            /*single_at = (char *)malloc(3);
			if(single_at == NULL){
				softap_assert("rcv_at_str_proc no mem!");
				free(whole_cmd_str);
				return -1;
			}
			memset(single_at, 0x00, 3);
            memcpy(single_at, "> ",2);*/
			at_rcvmsg_handle(at_fd, "> ",strlen("> "));
			//free(single_at);
        	next_str = pdu_str + 2;
			*next_str = '\0';
            goto  send_at_str;
        }
		else if(next_str_rn == NULL && next_str_r == NULL && next_str_n == NULL)//ǰ/r/nûе
		{
			break;
		}
		else
		{
			softap_assert("rcv_at_str_proc unkonw str!");
		}
    }
    //βΪ"\r\n""\r"ʱҪβ
    if(whole_cmd_str+strlen(whole_cmd_str)-next_str > 0)
    {
    	//ڲǷʱʱж
		start_farps_waittimer(at_fd);
		struct at_channel_info * ch_info = at_context_find_chn_by_fd(at_fd);
		unsigned int store_len = whole_cmd_str+strlen(whole_cmd_str)-next_str;
		store_len = store_len<(AT_CMD_MAX)?store_len:(AT_CMD_MAX-1);
		if(ch_info != NULL)
		memcpy(ch_info->store_cmd, next_str, store_len);
    }
send_at_str:
    //ڷַתַ߽ת
    if(next_str > whole_cmd_str && fwd_fd != 0)
    {
    	//ضַֹڲʹַapiӿ
        *(next_str) = '\0';
		fwd_all_at_str(fwd_fd,whole_cmd_str);
    }
    free(whole_cmd_str);
    return 0;
}

