/**
 * @file passthrough.c
 * @brief ṩsocket͸
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */
#include "at_context.h"
#include "at_register.h"
#include "recv_thread.h"
#include "softap_api.h"

#ifndef CONFIG_MIN_8M_VERSION
/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
#include "termios.h"
#include "ext_socket_func.h"
#include <sys/un.h>
#include <limits.h>


/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/
#define INTERVAL_TIME 1000000 //λ΢
/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/
struct passthough_info {
	int at_fd;
	int len;		//ݳ
	int viewmode;	//ݸʽ
	int priv;		//˽ݣsocketӦΪsocket id
	//͸Ӧ
	int module_id;
	int msg_cmd;
	void *addition; /**/
};


#define MAX_SOCK_CHAN_NUM MODULE_ID_SOCKET_PROXY_END-MODULE_ID_SOCKET_PROXY+1


struct quectel_passthough_info {
	int at_fd;
	int len;		//ݳ
	//int viewmode;	//ݸʽ
	int connect_id;		//˽ݣsocketӦΪsocket id
	int module_id;//͸Ӧ
	int msg_cmd;
};

/*******************************************************************************
 *                        Local function declarations                          *
 ******************************************************************************/
//static int set_passthough_info(int at_fd, int len, int transportmode,int viewmode, int priv, int mod_id, int msg_cmd);
static int passthough_data_proc(struct sock_channel_cb *cb, char * data, int datalen);
static int passthough_check_byfd(int at_fd);
static int set_passthough_info_quectel(int at_fd, int connect_id, int mod_id, int msg_cmd);
static int passthough_data_proc_quectel(char * data, int datalen);
static int passthough_check_byfd_quectel(int at_fd);


/*******************************************************************************
 *                         Local variable definitions                          *
 ******************************************************************************/
//static struct passthough_info *g_passthough_info = NULL;
struct sock_channel_cb g_sock_channel_cb[MAX_SOCK_CHAN_NUM] = {0};
int default_unix_sockfd = 0;	//socket proxyͨŵĬunix socket 

static struct quectel_passthough_info *g_passthough_info_quectel = NULL;
#define	CHECK_LEN   3
static char private_str2[CHECK_LEN] = {'+', '+', '+'};
/*ڷϲӦô͸ݺӦϢ*/
//static int passthrough_fd = -1;

//static long long int g_last_data_tick = 0;
/*******************************************************************************
 *                        Global variable definitions                          *
 ******************************************************************************/
/*******************************************************************************
 *                      Local function implementations                         *
 ******************************************************************************/

//atͨӦģIDȡsocketͨƿ
struct sock_channel_cb * get_sock_channel_cb(int at_fd, int module_id)
{
	int i;
	for (i = 0; i <  MAX_SOCK_CHAN_NUM; i++) {
		//жatͨصsocket proxy ӦǷѾ
		if (0 == g_sock_channel_cb[i].module_id) {
			continue;
		}
		//ģIDҿƿ飬ֱӷ
		if (module_id) {
			if (module_id == g_sock_channel_cb[i].module_id) {
				return &g_sock_channel_cb[i];
			} else {
				continue;
			}
		}
		//ģIDΪ0atͨҿƿ飬ֱӷ
		if (at_fd && (g_sock_channel_cb[i].at_fd == at_fd)) {

			return &g_sock_channel_cb[i];
		}
	}
	return NULL;
}

/* ͸Ϣ*/
int set_passthough_info(int at_fd, int len, int transportmode, int viewmode, int priv, int mod_id, int msg_cmd)
{
	struct sock_channel_cb *cb = get_sock_channel_cb(at_fd, mod_id);

	if (NULL == cb) {
		softap_assert("at fd is not initialized!");
		return -1;
	}

	cb->len = len;
	cb->rcv_len = 0;
	if (cb->rcv_buf)
		memset(cb->rcv_buf, 0, AT_CHAN_MAX_BUF_LEN);
	cb->priv = priv;
	cb->transportmode = transportmode;
	cb->msg_cmd = msg_cmd;
	cb->viewmode = viewmode;
	if (transportmode == TRANSPARENT_DATA_MODE) {
		cb->transparent_socketid = priv;
	}
	cb->last_data_tick = get_time_us();
	at_print(AT_NORMAL, "set_passthough_info src_id:0x%x, cmd:0x%x, mode:%d, tick:%lld \n", mod_id, msg_cmd, viewmode, cb->last_data_tick);

	return 1;

}

/* ͸ָģ*/
static int passthough_data_proc(struct sock_channel_cb *cb, char * data, int datalen)
{
	int total_len = 0;
	char *msgdata = NULL;
	struct comm_reqmsg * reqmsg = NULL;
	//atͨҵsocketͨƿ

	if (FTP_DATA_MODE == cb->transportmode) {
		struct zteftp_put_rspmsg *rspmsg = NULL;
		int pksize = 1024;
		int pknum = 0;
		int i;

		if (cb->addition == NULL)
			return 0;

		rspmsg = (struct zteftp_put_rspmsg *)cb->addition;

		//zdm ⣬˭ܱ֤ⲿMCUһܹһԽݶд꣬ĻαҪʱ
		if (datalen < rspmsg->data_lenth) {
			/*Сóȣ˴"ERROR"Ӧóʱղݻ᷵*/
			at_print(AT_ERR, "passthough_data_proc datalen(%d) less than %d,%s\n", datalen, rspmsg->data_lenth, data);
//			if (cb->addition) {    // kw 3 INVARIANT_CONDITION.GEN  when cb->addition is null, already return;
				free(cb->addition);
				cb->addition = NULL;
//			}
			//FTP󣬾Ҫ˳PUT/GETģʽatģʽ
			if (cb->data_suspend) { //ǰ͸ģʽsocketҪлTRANSPARENT_CMD_MODE̬ͨATOл͸ģʽ̬
				set_passthough_info(cb->at_fd, 0, TRANSPARENT_CMD_MODE, 0, cb->transparent_socketid, 0, MSG_CMD_NETWRITE_REQ);
			} else {
				set_passthough_info(cb->at_fd, 0, AT_CMD_MODE, 0, 0, 0, 0);
			}
			return 0;
		} else {
			/*ݴóȣȡóȵ*/
			datalen = rspmsg->data_lenth;
		}

		pknum = datalen / pksize;
		total_len = pksize + sizeof(struct zteftp_put_reqmsg);
		msgdata = malloc(total_len);
		if (msgdata == NULL) {
			at_print(AT_ERR, "passthough_data_proc: malloc failed! \n");
			softap_assert("");
			free(cb->addition);
			cb->addition = NULL;//kw_3
			return -1;
		}
		for (i = 0; i < pknum; i++) {
			memset(msgdata, 0x00, total_len);
			strcpy(((struct zteftp_put_reqmsg *)msgdata)->file_name, rspmsg->file_name);
			((struct zteftp_put_reqmsg *)msgdata)->eof = rspmsg->eof | (1 << 31);
			((struct zteftp_put_reqmsg *)msgdata)->data_lenth = pksize;
			memcpy(((struct zteftp_put_reqmsg *)msgdata)->file_content, data, pksize);
			unix_send_proc(cb->unix_sockfd, cb->module_id, cb->msg_cmd, total_len, msgdata, 0);
		}
		if (datalen % pksize) {
			memset(msgdata, 0x00, total_len);
			strcpy(((struct zteftp_put_reqmsg *)msgdata)->file_name, rspmsg->file_name);
			((struct zteftp_put_reqmsg *)msgdata)->eof = rspmsg->eof | (1 << 31);
			((struct zteftp_put_reqmsg *)msgdata)->data_lenth = datalen % pksize;
			memcpy(((struct zteftp_put_reqmsg *)msgdata)->file_content, data, datalen % pksize);
			unix_send_proc(cb->unix_sockfd, cb->module_id, cb->msg_cmd, total_len, msgdata, 0);
		}
		free(msgdata);
		if (cb->data_suspend) { //ǰ͸ģʽsocketҪлTRANSPARENT_CMD_MODE̬ͨATOл͸ģʽ̬
			set_passthough_info(cb->at_fd, 0, TRANSPARENT_CMD_MODE, 0, cb->transparent_socketid, 0, MSG_CMD_NETWRITE_REQ);
		} else {
			set_passthough_info(cb->at_fd, 0, AT_CMD_MODE, 0, 0, 0, 0);
		}
		free(cb->addition);
		cb->addition = NULL;//kw_3
	} else {
		if (cb->addition) {
		free(cb->addition);
		cb->addition = NULL;
		}//kw_3
		if (0 == cb->viewmode) { //hexģʽ
			total_len = datalen + sizeof(struct comm_reqmsg);
			msgdata = malloc(total_len);
			if (msgdata == NULL) {
				at_print(AT_ERR, "passthough_data_proc: malloc failed! \n");
				softap_assert("");
				return -1;
			}
			memset(msgdata, 0x00, total_len);
			reqmsg = (struct comm_reqmsg *)msgdata;
			reqmsg->socketid = cb->priv;
			reqmsg->len = datalen;
			memcpy(msgdata + sizeof(struct comm_reqmsg), data, datalen);
			unix_send_proc(cb->unix_sockfd, cb->module_id, cb->msg_cmd, total_len, msgdata, 0);
			free(msgdata);
		} else if (1 == cb->viewmode) { //textģʽ
			char *buf = NULL;
			char temp[3] = {0};
			int i = 0;

			if (datalen % 2) {
				//ֱӽݷ͸ָӦ
				at_context_write_data(cb->at_fd, "\r\nERROR:980\r\n", strlen("\r\nERROR:980\r\n"));
				//atͨлat̬
				if (cb->data_suspend) { //ǰ͸ģʽsocketҪлTRANSPARENT_CMD_MODE̬ͨATOл͸ģʽ̬
					set_passthough_info(cb->at_fd, 0, TRANSPARENT_CMD_MODE, 0, cb->transparent_socketid, 0, MSG_CMD_NETWRITE_REQ);
				} else {
					set_passthough_info(cb->at_fd, 0, AT_CMD_MODE, 0, 0, 0, 0);
				}
				return 0;

			}
			if (datalen / 2 > cb->len) {
				at_context_write_data(cb->at_fd, "\r\nERROR:914\r\n", strlen("\r\nERROR:914\r\n"));
				//atͨлat̬
				if (cb->data_suspend) { //ǰ͸ģʽsocketҪлTRANSPARENT_CMD_MODE̬ͨATOл͸ģʽ̬
					set_passthough_info(cb->at_fd, 0, TRANSPARENT_CMD_MODE, 0, cb->transparent_socketid, 0, MSG_CMD_NETWRITE_REQ);
				} else {
					set_passthough_info(cb->at_fd, 0, AT_CMD_MODE, 0, 0, 0, 0);
				}
				return 0;
			}

			total_len = datalen / 2 + sizeof(struct comm_reqmsg);
			msgdata = malloc(total_len);
			if (msgdata == NULL) {
				at_print(AT_ERR, "passthough_data_proc: malloc failed! \n");
				softap_assert("");
				return -1;
			}
			memset(msgdata, 0x00, total_len);
			reqmsg = (struct comm_reqmsg *)msgdata;
			reqmsg->socketid = cb->priv;
			reqmsg->len = datalen / 2;
			buf = msgdata + sizeof(struct comm_reqmsg);

			while (i < datalen / 2) {
				//assicתΪ
				memcpy(temp, data + 2 * i, 2);
				errno = 0;
				buf[i] = strtol(temp, NULL, 16);
				if (errno == ERANGE)// kw ERRNO.NOT_CHECKED
				{
					at_print(AT_ERR, "strtol errno %d: %s\n", errno, strerror(errno));
				}
				i++;
			}
			unix_send_proc(cb->unix_sockfd, cb->module_id, cb->msg_cmd, total_len, msgdata, 0);
			free(msgdata);
		}
		//writeе͸ģʽ͸socketӦú󣬾ͿԽatͨлatģʽ
		if (WRITE_DATA_MODE == cb->transportmode) {
			if (cb->data_suspend) { //ǰ͸ģʽsocketҪлTRANSPARENT_CMD_MODE̬ͨATOл͸ģʽ̬
				set_passthough_info(cb->at_fd, 0, TRANSPARENT_CMD_MODE, 0, cb->transparent_socketid, 0, MSG_CMD_NETWRITE_REQ);
			} else {
				set_passthough_info(cb->at_fd, 0, AT_CMD_MODE, 0, 0, 0, 0);
			}
		}

	}

	return 0;
}

/* ͸Ϣ*/
static int set_passthough_info_quectel(int at_fd, int connect_id, int mod_id, int msg_cmd)
{
	if (g_passthough_info_quectel) {
		softap_assert("more pass though set!");
	}
	g_passthough_info_quectel = malloc(sizeof(struct quectel_passthough_info));
	if (g_passthough_info_quectel == NULL) 
		return -1;
	g_passthough_info_quectel->at_fd = at_fd;
	//g_passthough_info_quectel->len = len;
	g_passthough_info_quectel->connect_id = connect_id;
	g_passthough_info_quectel->module_id = mod_id;
	g_passthough_info_quectel->msg_cmd = msg_cmd;
	return 0;
}
/* ͸ָģ*/
static int passthough_data_proc_quectel(char * data, int datalen)
{
	int total_len = 0;
	char *msgdata = NULL;
	struct quectel_comm_reqmsg * reqmsg = NULL;


	if (g_passthough_info_quectel->module_id) {
		total_len = datalen + sizeof(struct quectel_comm_reqmsg);
		msgdata = malloc(total_len);
		if(msgdata == NULL)
			return -1;
		memset(msgdata, 0x00, total_len);
		reqmsg = (struct quectel_comm_reqmsg *)msgdata;
		reqmsg->connect_id = g_passthough_info_quectel->connect_id;
		reqmsg->len = datalen;
		memcpy(msgdata + sizeof(struct quectel_comm_reqmsg), data, datalen);
		unix_send_proc(MODULE_ID_AT_CTL, g_passthough_info_quectel->module_id, g_passthough_info_quectel->msg_cmd, total_len, msgdata, 0);

		free(msgdata);
		free(g_passthough_info_quectel);
		g_passthough_info_quectel = NULL;

	}
	return 0;
}
/* ͸Ϣfd*/
static int passthough_check_byfd_quectel(int at_fd)
{
	if (g_passthough_info_quectel && g_passthough_info_quectel->at_fd == at_fd) {
		return 1;
	}
	return 0;
}

//жǷ+++ݣֱ͸sockeṭǣģʽлģʽ
static int data_check_proc(struct sock_channel_cb *cb, char * strReadAtCmd, int iAtCmdLen)
{
	long long int cur_data_tick = 0;

	cur_data_tick = get_time_us();
	if (cur_data_tick - cb->last_data_tick > INTERVAL_TIME) {
		if (strncmp(strReadAtCmd, private_str2, iAtCmdLen) == 0) {
			at_print(AT_ERR, "receive +++!!!\n");
			return 1;
		}
	}
	cb->last_data_tick = cur_data_tick;

	return 0;
}

void urcok_proc(int src_id)
{
	AT_AUTORSP_INFO urcok = {0};

	sprintf(urcok.autorsp_cmd, "\r\nOK\r\n");
	urcok.len = strlen(urcok.autorsp_cmd);

	ipc_send_message2(src_id, MODULE_ID_AT_CTL, MSG_CMD_AUTO_RSP, sizeof(AT_AUTORSP_INFO), &urcok, 0);
	return;
}
/*͸ӦϢ
1FTP PUTOK/ERROR͸
2FTP GETdata+OKERRORӦ͸*/
static void passthrough_msg_rsq(MSG_BUF *msg_buf)
{
	AT_PASSTHROUGH_RSP  *rspMsg = (AT_PASSTHROUGH_RSP*)msg_buf->aucDataBuf;
	char *data = rspMsg->rsp_cmd;
	int ret;
	struct sock_channel_cb *cb = get_sock_channel_cb(0, msg_buf->src_id);

	if (NULL == cb) {
		softap_assert("passthrough_msg_rsq NULL == cb");
		return;
	}
	if (cb->addition) {
		free(cb->addition);
		cb->addition = NULL;
	}

	/*λΪ1ʱлͨ*/
	if (rspMsg->len & 1 << 31) {
		if (cb->data_suspend) { //ǰ͸ģʽsocketҪлTRANSPARENT_CMD_MODE̬ͨATOл͸ģʽ̬
			set_passthough_info(cb->at_fd, 0, TRANSPARENT_CMD_MODE, 0, cb->transparent_socketid, 0, MSG_CMD_NETWRITE_REQ);
		} else {
			set_passthough_info(cb->at_fd, 0, AT_CMD_MODE, 0, 0, 0, 0);
		}
	}
	ret = at_context_write_data(cb->at_fd, data, rspMsg->len & 0x7fffffff);
	at_print(AT_NORMAL, "passthrough_msg_rsq ret = %d\n", ret);
}

static void handle_socket_close_ind(int module_id)
{
	struct sock_channel_cb *cb = get_sock_channel_cb(0, module_id);
	if (cb != NULL) {
		//͸ģʽ£socketͨƿĴģʽģʽлATģʽ
		{
			at_print(AT_ERR, "handle_socket_close_ind: transparent mode socket closed, change to AT_CMD_MODE\n");
			unix_send_proc(cb->unix_sockfd, cb->module_id, MSG_CMD_DATA_TO_CMD_MODE, 0, 0, 0);//֪ͨzte_sockeṭݵĽ
			set_passthough_info(cb->at_fd, 0, AT_CMD_MODE, 0, 0, 0, 0);//ôģʽ
		}
		cb->data_suspend = 0;
	}
	return;
}
/*******************************************************************************
 *                      Global function implementations                        *
 ******************************************************************************/
void sleep_in_ms(int ms)
{
	struct timeval delay;
	delay.tv_sec = 0;
	delay.tv_usec = ms * 1000;
	select(0, NULL, NULL, NULL, &delay);
	return;
}




/*͸Ϣ,Ŀǰֻ֧һ·ͨ͸*/
int set_passthough_bycmd(MSG_BUF *msg)
{
	struct ser_ops_t2 * ser_nod = find_ser_by_msg(msg->usMsgCmd);
	if(ser_nod == NULL)
		return -1;
	//緽
	if (msg->usMsgCmd == MSG_CMD_SENDBUF_RSP) { //͸ģʽ
		struct comm_rspmsg *rspmsg = (struct comm_rspmsg *)msg->aucDataBuf;
		struct at_context *context = ser_nod->context;
		if (rspmsg->ret >= 0) {
			set_passthough_info(ser_nod->context->at_channel->at_fd, rspmsg->len, WRITE_DATA_MODE, rspmsg->viewmode, rspmsg->socketid, msg->src_id, MSG_CMD_NETWRITE_REQ);
		}
	}
	if (msg->usMsgCmd == MSG_CMD_NETCREATE_RSP) { //ͻ͸ģʽ
		struct netcreate_rspmsg *rspmsg = (struct netcreate_rspmsg *)msg->aucDataBuf;
		struct at_context *context = ser_nod->context;
		if (rspmsg->ret >= 0 && rspmsg->mode != CONN_TYPE_TCP_S) { //Ϊͻʱӽɹֱӽ͸ģʽ
			set_passthough_info(ser_nod->context->at_channel->at_fd, 0, TRANSPARENT_DATA_MODE, 0, rspmsg->socketid, msg->src_id, MSG_CMD_NETWRITE_REQ);
		}
	}
	if (msg->usMsgCmd == MSG_CMD_NETACCEPT_RSP) { //͸ģʽ
		struct netaccept_rspmsg *rspmsg = (struct netaccept_rspmsg *)msg->aucDataBuf;
		if (rspmsg->ret >= 0 && rspmsg->transportMode == TRANSPARENT_MODE) { //Ϊʱܿͻӳɹʱ͸ģʽ
			set_passthough_info(ser_nod->context->at_channel->at_fd, 0, TRANSPARENT_DATA_MODE, 0, rspmsg->socketid, msg->src_id, MSG_CMD_NETWRITE_REQ);
		}

	}
#ifdef AT_QUECTEL
	//quectel
	if (msg->usMsgCmd == MSG_CMD_QISEND_RSP) {
		struct quectel_qisend_rspmsg *rspmsg = (struct quectel_qisend_rspmsg *)msg->aucDataBuf;
		struct at_context *context = ser_nod->context;
		if (rspmsg->send_type != QUERY_DATA_INFO && rspmsg->ret == READY_TO_SEND) {
			set_passthough_info_quectel(ser_nod->context->at_channel->at_fd, rspmsg->connect_id, msg->src_id, MSG_CMD_QISENDBUF_REQ);
		}
	}
	if (msg->usMsgCmd == MSG_CMD_FTPPUT_RSP) {
		/* FTPϴ͸Ϣ*/
		struct zteftp_put_rspmsg *rspmsg = (struct zteftp_put_rspmsg *)msg->aucDataBuf;
		struct at_context *context = ser_nod->context;

		if (rspmsg->ret == 0) {
			/*CONNECTϢʱȴ͸*/

			struct sock_channel_cb *cb = get_sock_channel_cb(ser_nod->context->at_channel->at_fd, msg->src_id);

			if(cb == NULL)
				return -1;
			cb->addition = malloc(sizeof(struct zteftp_put_rspmsg));
			if(cb->addition == NULL)
				return -1;
			memcpy(cb->addition, rspmsg, sizeof(struct zteftp_put_rspmsg));
			//at_socket_data_procյokerrorӦԺ󣬽atͨе̬
			set_passthough_info(ser_nod->context->at_channel->at_fd, rspmsg->data_lenth, FTP_DATA_MODE, 0, rspmsg->eof, msg->src_id, MSG_CMD_FTPPUT_REQ);
		}
	} else if (msg->usMsgCmd == MSG_CMD_FTPGET_RSP) {
		//zdm ʵ⣬ΪʲôҪڽ֮ϱconnect
		//passthrough_fd = ser_nod->context->at_channel->at_fd;
		//FTP GETģʽⲿMCUڷat֮յOKERRORϱ֮ǰᷢͳ"+++"κ
		//˽ճȡģʽϢIDΪ0

		struct zteftp_get_rspmsg *rspmsg = (struct zteftp_get_rspmsg *)msg->aucDataBuf;

		if (rspmsg->result >= 0) {
			//at_socket_data_procյokerrorӦԺ󣬽atͨе̬
			//set_passthough_info(ser_nod->context->at_channel->at_fd, 0, FTP_DATA_MODE, 0, 0, msg->src_id, 0);
			//Ϊ4,ڽտܵ"+++"
			set_passthough_info(ser_nod->context->at_channel->at_fd, 4, FTP_DATA_MODE, 0, 0, msg->src_id, 0);
		}
	}
#endif	
	return 0;
}

/* socketؽϢ */
void clear_socket_info(struct sock_channel_cb *cb)
{
	if (cb->addition) {
		free(cb->addition);
		cb->addition = NULL;
	}
	if (cb->rcv_buf)
		memset(cb->rcv_buf, 0, AT_CHAN_MAX_BUF_LEN);
	cb->rcv_len = 0;
	cb->len = 0;
}

/*socket͸*/
int handle_socket_data(int at_fd)
{
	int len = 0;
	char *rcv_buf = NULL;
	int change_to_cmd_mode = 0;

	struct sock_channel_cb *cb = get_sock_channel_cb(at_fd, 0);
	if (cb) {
		if (AT_CMD_MODE == cb->transportmode || TRANSPARENT_CMD_MODE == cb->transportmode) {
			return -1;
		}

		//ֵռ䣬һͨ룬ͷţЧʣֻݷ00
		if (!cb->rcv_buf) {
			cb->rcv_buf = malloc(AT_CHAN_MAX_BUF_LEN);
			if (!cb->rcv_buf){
				softap_assert("handle_socket_data malloc failed\n");
				return -1;
			}
			memset(cb->rcv_buf, 0, AT_CHAN_MAX_BUF_LEN);
			cb->rcv_len = 0;
		}
		rcv_buf = cb->rcv_buf;

		//socket writeе͸ָĳȽжȡֱȡָȵΪֹ
		if ((WRITE_DATA_MODE == cb->transportmode) || (FTP_DATA_MODE == cb->transportmode)) {
			//TEXTģʽӴڽݴСX2
			if (cb->viewmode == 1) {
				len = cb->len * 2;
				if (cb->rcv_len < cb->len * 2)
					cb->rcv_len += at_read(at_fd, rcv_buf + cb->rcv_len, cb->len * 2 - cb->rcv_len);
			} else if (cb->viewmode == 0) {
				len = cb->len;
				if (cb->rcv_len < cb->len) {
					cb->rcv_len += at_read(at_fd, rcv_buf + cb->rcv_len, cb->len - cb->rcv_len);
					if (FTP_DATA_MODE == cb->transportmode) {
						change_to_cmd_mode = data_check_proc(cb, rcv_buf, cb->rcv_len);
					}
				}
			} else {
				at_print(AT_ERR, "handle_socket_data cb->viewmode = %d \n", cb->viewmode);
			}

			//δȫҲлcmdģʽʱ˳ȴ
			if ((cb->rcv_len < len) && (change_to_cmd_mode != 1)) {
				//͸ݴftpݴģʽ¼¼յݵʱ䣬ڳʱж
				cb->last_data_tick = get_time_us();
				return 0;
			}
		} else { //͸ģʽFTP GET/PUTУշݵ󳤶ȶȡɣֱӷ͵socket proxy
			//if (cb->rcv_buf) //klocwork
			memset(cb->rcv_buf, 0, AT_CHAN_MAX_BUF_LEN);
			cb->rcv_len = at_read(at_fd, rcv_buf, MAX_WRITE_LEN);
		}

		//select쳣أʱֱӷ
		if (cb->rcv_len <= 0) {  // cov M  add <0 return
			return 0;
		}

		//緽
		at_print(AT_NORMAL, "handle_socket_data mode:%d, module:0x%x, len:%d, rcv_len:%d, %s \n", cb->transportmode, cb->module_id, cb->len, cb->rcv_len, rcv_buf);

		//Ƿ+++ָʾг͸ģʽ͸ģʽ²
		if (WRITE_DATA_MODE != cb->transportmode && FTP_DATA_MODE != cb->transportmode) {
			change_to_cmd_mode = data_check_proc(cb, rcv_buf, cb->rcv_len);
		}

		//лģʽ
		if (change_to_cmd_mode == 1) {
			at_print(AT_NORMAL, "handle_socket_data change_to_cmd_mode == 1 \n");
			//+++ȫֱ
			//Ϣ֪ͨsocketģʽеģʽ
			unix_send_proc(cb->unix_sockfd, cb->module_id, MSG_CMD_DATA_TO_CMD_MODE, 0, 0, 0);

			//socketͨƿĴģʽлatģʽ,͸ģʽͨATOָ͸ģʽ
			if (TRANSPARENT_DATA_MODE == cb->transportmode) {
				set_passthough_info(at_fd, cb->len, TRANSPARENT_CMD_MODE, cb->viewmode, cb->priv, cb->module_id, cb->msg_cmd);
				cb->data_suspend = 1;
			} else {
				clear_socket_info(cb);

				if (cb->data_suspend) { //ǰ͸ģʽsocketҪлTRANSPARENT_CMD_MODE̬ͨATOл͸ģʽ̬
					set_passthough_info(cb->at_fd, 0, TRANSPARENT_CMD_MODE, 0, cb->transparent_socketid, 0, MSG_CMD_NETWRITE_REQ);
				} else {
					set_passthough_info(cb->at_fd, 0, AT_CMD_MODE, 0, 0, 0, 0);
				}
			}
			urcok_proc(cb->module_id);//ģʽлɣϱOK
		}
		//͸
		else {
			at_print(AT_NORMAL, "handle_socket_data change_to_cmd_mode == 0 \n");
			passthough_data_proc(cb, rcv_buf, cb->rcv_len);
		}
		return 0;
	}
#if 0
	//quectel
	if (passthough_check_byfd_quectel(at_fd)) {
		if(g_passthough_info_quectel == NULL || cb == NULL)
			return -1;
		//char *rcv_buf = buf;
		if (g_passthough_info_quectel->len == 0) {
			cb->rcv_len = at_read(at_fd, rcv_buf, MAX_SEND_LEN);
		} else {
			while (cb->rcv_len < g_passthough_info_quectel->len)
				cb->rcv_len += at_read(at_fd, rcv_buf + cb->rcv_len, g_passthough_info_quectel->len - cb->rcv_len);
		}

		passthough_data_proc_quectel(rcv_buf, cb->rcv_len);

		return 0;
	}
#endif	
	return -1;
}

//socketʱ
void proc_socket_timeout()
{
	int i;
	char nv_timeout[32] = {0};
	long long timeout = 0;
	long long ll_nv_timeout = 0;
	long long cur_time = get_time_us(); //΢

	sc_cfg_get("wait_timeout", nv_timeout, sizeof(nv_timeout)); //	
	ll_nv_timeout = atoll(nv_timeout); //kw 3
	if(ll_nv_timeout > LLONG_MAX-1)
	{
		ll_nv_timeout  = 0;
	}
#if 1 // kw 3 SV.TAINTED.BINOP
	if(cur_time > LLONG_MAX-1)
	{
		cur_time  = LLONG_MAX;
	}    
#endif
	timeout = ll_nv_timeout * 1000 * 1000;
	at_print(AT_DEBUG, "proc_socket_timeout nv:%s, timeout \n", nv_timeout, timeout);

	for (i = 0; i < MAX_SOCK_CHAN_NUM; i++) {
		//жatͨصsocket proxy ӦǷѾ
		if (0 == g_sock_channel_cb[i].module_id) {
			continue;
		}

		//ֻз͸ݴŹĳʱ
		if (WRITE_DATA_MODE == g_sock_channel_cb[i].transportmode) {
			if (cur_time - g_sock_channel_cb[i].last_data_tick >= timeout) {
				at_print(AT_NORMAL, "proc_socket_timeout src_id:0x%x, mode:%d, cmd:0x%x, timeout:%lld, cur:%lld \n", g_sock_channel_cb[i].module_id, g_sock_channel_cb[i].transportmode, g_sock_channel_cb[i].msg_cmd, timeout, cur_time);
				clear_socket_info(&g_sock_channel_cb[i]);

				//ERROR
				at_context_write_data(g_sock_channel_cb[i].at_fd, "\r\nERROR:915\r\n", strlen("\r\nERROR:915\r\n"));

				if (g_sock_channel_cb[i].data_suspend) { //ǰ͸ģʽsocketҪлTRANSPARENT_CMD_MODE̬ͨATOл͸ģʽ̬
					set_passthough_info(g_sock_channel_cb[i].at_fd, 0, TRANSPARENT_CMD_MODE, 0, g_sock_channel_cb[i].transparent_socketid, 0, MSG_CMD_NETWRITE_REQ);
				} else {
					set_passthough_info(g_sock_channel_cb[i].at_fd, 0, AT_CMD_MODE, 0, 0, 0, 0);
				}

			}
		}
	}
}

//ȡ̵ĳʱʱ䣬0ʾûгʱʱ
void get_socket_timeout(struct timeval *time)
{
	int i;
	char nv_timeout[32] = {0};
	long long near_time = 0, cur_time = 0;
	long long cost_time = 0, remain_time = 0;

	for (i = 0; i < MAX_SOCK_CHAN_NUM; i++) {
		//жatͨصsocket proxy ӦǷѾ
		if (0 == g_sock_channel_cb[i].module_id) {
			continue;
		}

		//ֻз͸ݴŹĳʱ
		if (WRITE_DATA_MODE == g_sock_channel_cb[i].transportmode) {
			//δݵͨ
			if (near_time == 0)
				near_time = g_sock_channel_cb[i].last_data_tick;
			else if (near_time > g_sock_channel_cb[i].last_data_tick)
				near_time = g_sock_channel_cb[i].last_data_tick;
		}
	}

	//гʱ
	if (near_time != 0) {
		sc_cfg_get("wait_timeout", nv_timeout, sizeof(nv_timeout)); //λ: 
		if (strcmp(nv_timeout, "") == 0 || strcmp(nv_timeout, "0") == 0)
			return;
		//ʱʣʱС1s1sĬϳʱʱ䰴Ĭϴ1sͬʱСĬʱ䰴ʵʣʱ䴦
		cur_time    = get_time_us();
        if(cur_time < 0 || cur_time > LLONG_MAX-1)
        {      
     		at_print(AT_ERR, "cur_time is error:%lld \n", cur_time);
            cur_time = 0;
        }
        
		cost_time   = cur_time - near_time;
		long long i_nv_timeout = atoi(nv_timeout); // kw3 for cov M, set type long long instead of int
		if(i_nv_timeout < 0 || i_nv_timeout > INT_MAX-1)
		{
		    i_nv_timeout  = 0;
		}
		remain_time = i_nv_timeout*1000000 - cost_time;
		if (remain_time < 1*1000000) {
			time->tv_sec = 1;
			time->tv_usec = 0;
		}
		else if (remain_time < i_nv_timeout*1000000) {
			time->tv_sec = remain_time/1000000;
			time->tv_usec = remain_time%1000000;
		}
		at_print(AT_ERR, "get_socket_timeout last:%lldus, cur:%lldus, remain_time:%lldus, timeout:%ds, sec:%ld, usec:%ld \n", near_time, get_time_us(), remain_time, atoi(nv_timeout), time->tv_sec, time->tv_usec);
	}
}

/*FTP͸ӦϢ*/
int  at_socket_data_proc(MSG_BUF *msg_buf)
{
	switch (msg_buf->usMsgCmd) {
	/*ϲӦôFTP͸ݺӦϢ*/
	case MSG_CMD_PASSTHROUGH_RSP:
		passthrough_msg_rsq(msg_buf);
		return 1;
	case MSG_CMD_TRANSPARENT_SOCKET_CLOSE_IND:
		handle_socket_close_ind(msg_buf->src_id);
		return 1;
	default:
		break;
	}
	return 0;
}

void start_goudian_baseapp(void)
{
	char appname[50] = {0};	//socket proxyӦҪЯģid
	char unix_server_path[50] = {0};//unix socket·
	int sockfd;
	struct sockaddr_un addr;
	int ret = -1;

	//socket proxyӦỵ́ģIDδݸӦãsocket proxyڲʹøģIDϢ
	sprintf(appname, "/sbin/zte_socket -m %d &",  MODULE_ID_GUODIAN_BASE);
	soft_system(appname);


	sockfd	= socket(PF_UNIX, SOCK_STREAM, 0);
	if (sockfd < 0) {
		printf("socket failed : %s!\r\n", strerror(errno));
		softap_assert("failed to create unix socket fd!");
		return;
	}
	//ģID÷ļ·at_ctlsocket proxy֮䱣һ
	sprintf(unix_server_path, "%s%d", UNIX_SOCKET_SERVER, MODULE_ID_GUODIAN_BASE);
	addr.sun_family = AF_UNIX;
	strcpy(addr.sun_path, unix_server_path);

	while (ret < 0) {
		ret = connect(sockfd, (struct sockaddr *)&addr, sizeof(addr));
		if (ret < 0) {
			printf("connect failed : %s, addr is %s!\r\n", strerror(errno), addr.sun_path);
			sleep_in_ms(10);
		}
	}

	default_unix_sockfd = sockfd;
}


//ȡat_ctlsocket proxyͨŵĬunix socket
int get_default_sockfd(void)
{
	return default_unix_sockfd;
}

#endif
void passthough_rsq_cmd(MSG_BUF *msg_buf)
{
#ifndef CONFIG_MIN_8M_VERSION
	AT_AUTORSP_INFO  *autorspMsg = (AT_AUTORSP_INFO*)msg_buf->aucDataBuf;
	char *data = autorspMsg->autorsp_cmd;
	int len = autorspMsg->len;
	struct sock_channel_cb *cb = NULL;
	int ret;

	if (msg_buf->src_id < MODULE_ID_SOCKET_PROXY || msg_buf->src_id > MODULE_ID_SOCKET_PROXY_END) {
		at_print(AT_NORMAL, "passthough_rsq_cmd src_id:%d is not socket \n", msg_buf->src_id);
		return;
	}

	cb = get_sock_channel_cb(0, msg_buf->src_id);
	if (NULL == cb) {
		softap_assert("passthough_rsq_cmd NULL == cb");
		return;		
	}
	ret = at_context_write_data(cb->at_fd, data, len);
	at_print(AT_NORMAL, "passthough_rsq_cmd ret = %d\n", ret);
#endif
}



//atͨȡӦsocket proxyӦỵ́ȡ˵ǰͨһ
//յsocket proxyatsocket proxỵsocket proxyģIDatͨ
//ͬʱunix socketat_ctlsocket proxy
int get_dst_moduleid(int at_fd)
{
#ifndef CONFIG_MIN_8M_VERSION
	int i;
	int uninit_index = -1;//δʼsock_channel_cbԪ±
	char appname[50] = {0};	//socket proxyӦҪЯģid
	char unix_server_path[50] = {0};//unix socket·
	int sockfd;
	struct sockaddr_un addr;
	int ret = -1;
	for (i = 0; i <  MAX_SOCK_CHAN_NUM; i++) {
		//жatͨصsocket proxy ӦǷѾ
		if (0 == g_sock_channel_cb[i].module_id) {
			uninit_index = i;
			continue;
		}
		if (g_sock_channel_cb[i].at_fd == at_fd) {
			return g_sock_channel_cb[i].module_id;
		}
	}
	if (-1 == uninit_index) {
		softap_assert("all socket channel is initialized");
		return -1;
	}
	//ʼsocket ͨƿϢ
	g_sock_channel_cb[uninit_index].at_fd = at_fd;
	g_sock_channel_cb[uninit_index].module_id = MODULE_ID_SOCKET_PROXY + uninit_index;


	//socket proxyӦỵ́ģIDδݸӦãsocket proxyڲʹøģIDϢ
	sprintf(appname, "/sbin/zte_socket -m %d &", g_sock_channel_cb[uninit_index].module_id);
	soft_system(appname);


	sockfd  = socket(PF_UNIX, SOCK_STREAM, 0);
	if (sockfd < 0) {
		printf("socket failed : %s!\r\n", strerror(errno));
		softap_assert("failed to create unix socket fd!");
		return -1;
	}
	//ģID÷ļ·at_ctlsocket proxy֮䱣һ
	sprintf(unix_server_path, "%s%d", UNIX_SOCKET_SERVER, g_sock_channel_cb[uninit_index].module_id);
	addr.sun_family = AF_UNIX;
	strcpy(addr.sun_path, unix_server_path);

	while (ret < 0) {
		ret = connect(sockfd, (struct sockaddr *)&addr, sizeof(addr));
		if (ret < 0) {
			printf("connect failed : %s, addr is %s!\r\n", strerror(errno), addr.sun_path);
			sleep_in_ms(10);
		}
	}

	g_sock_channel_cb[uninit_index].unix_sockfd = sockfd;

	return g_sock_channel_cb[uninit_index].module_id;
#endif
}

//ȡat_ctlsocket proxyͨŵunix socket
int get_unix_sockfd(int module_id)
{
#ifndef CONFIG_MIN_8M_VERSION
	int i;
	for (i = 0; i <  MAX_SOCK_CHAN_NUM; i++) {
		//жatͨصsocket proxy ӦǷѾ
		if (0 == g_sock_channel_cb[i].module_id) {
			continue;
		}
		//ģIDȡunix socket
		if (g_sock_channel_cb[i].module_id == module_id) {
			return g_sock_channel_cb[i].unix_sockfd;
			break;
		}
	}
#endif
	return -1;

}

//յPDPȥϱϢʱ֪ͨzte socket
int send_cgev_deact_info(int c_id)
{
#ifndef CONFIG_MIN_8M_VERSION
	int i;
	//zte socket̹㲥ͣɽڲж
	for (i = 0; i <  MAX_SOCK_CHAN_NUM; i++) {
		if (g_sock_channel_cb[i].module_id > 0) {
			unix_send_proc(g_sock_channel_cb[i].unix_sockfd, g_sock_channel_cb[i].module_id, MSG_CMD_PDP_DEACT_IND, sizeof(int), &c_id, 0);
		}
	}
#endif
	return 0;

}
