#include    <stdio.h>
#include    <stdlib.h>
#include    <sys/ioctl.h>
#include    <arpa/inet.h>
#include    <net/if.h>
#include    <net/route.h>
#include    <string.h>
#include    <dirent.h>

#include "zte_mainctrl.h"

extern void str_vary_dit(char * str, char *result);
#if 0
/*
 * substitution of getNthValue which dosen't destroy the original value
 */
static int static_getNthValueSafe(int index, char *value, char delimit, char *result, int len)
{
	int i = 0, result_len = 0;
	char *begin, *end;

	if (!value || !result || !len)
		return -1;

	begin = value;
	end = strchr(begin, delimit);

	while (i < index && end) {
		begin = end + 1;
		end = strchr(begin, delimit);
		i++;
	}

	//no delimit
	if (!end) {
		if (i == index) {
			end = begin + strlen(begin);
			result_len = (len - 1) < (end - begin) ? (len - 1) : (end - begin);
		} else
			return -1;
	} else
		result_len = (len - 1) < (end - begin) ? (len - 1) : (end - begin);

	memcpy(result, begin, result_len);
	*(result + result_len) = '\0';

	return 0;
}

/*change the value of the Nth macip list */
/*the macip list format is:
  [mac1]+[ip1];[mac2]+[ip2];....*/
/*add by lyf 2012/5/21*/
static int changeNthValue(int index, char *value, char delimit, char *result, char *web_list)
{
	int i = 0;
	int front_len = 0;
	int end_len = 0;
	int edit_len = 0;
	int total_len = 0;

	char *begin, *end;
	char tempchar[NV_MACIP_LIST_MAX_LEN] = {0};

	if (!value || !result || !web_list)
		return -1;

	begin = value;
	end = strchr(begin, delimit);

	while (i < index && end) {
		begin = end + 1;
		end = strchr(begin, delimit);
		i++;
	}

	//no delimit
	if (!end) {
		if (i == index) {
			end = begin + strlen(begin) - 1;
			front_len = begin - value;
			strncpy(tempchar, value, front_len);
			strncpy(tempchar + front_len, web_list, (strlen(web_list)));
			total_len = front_len + strlen(web_list);
		} else {
			return -1;
		}
	} else {
		front_len = begin - value;
		edit_len = end - begin;
		end_len = strlen(value) - front_len - edit_len;
		strncpy(tempchar, value, front_len);
		strncpy(tempchar + front_len, web_list, strlen(web_list));
		strncpy(tempchar + front_len + strlen(web_list), value + front_len + edit_len, end_len);
		total_len = front_len + strlen(web_list) + end_len;


	}

	memcpy(result, tempchar, total_len);
	*(result + total_len) = '\0';

	return 0;
}

/*delete the value of the Nth macip list*/
/*the macip list format is:
  [mac1]+[ip1];[mac2]+[ip2];....*/
/*add by lyf 2012/5/21*/
static int deleteNthValue(int index,  char *value, char delimit)
{
	char *begin, *end;
	int i = 0, j = 0;
	int need_check_flag = 0;
	char *buf = NULL;
	int default_len = 0;

	if (!value)
		return -1;
	buf = strdup(value);
	begin = buf;
	end = strchr(begin, delimit);
	while (end) {
		if (i == index) {
			memset(begin, 0, end - begin);
			if (index == 0)
				need_check_flag = 1;
			break;
		}
		begin = end;
		end = strchr(begin + 1, delimit);
		i++;
	}

	if (!end && index == i)
		memset(begin, 0, strlen(begin));

	if (need_check_flag) {
		for (i = 0; i < strlen(value); i++) {
			if (buf[i] == '\0')
				continue;
			if (buf[i] == ';')
				buf[i] = '\0';
			break;
		}
	}
	default_len = strlen(value);
	for (i = 0, j = 0; i < strlen(value); i++) {
		if (buf[i] != '\0') {
			value[j++] = buf[i];
		}
	}
	for (i = j; i < default_len; i++)
		value[i] = '\0';

	free(buf);
	return 0;
}
//zte_routerʵ,opms_wan_modeӦøݵǰȱʡڣʶethwan_modepswan_modewifiwan_modeеһ
void zte_qos_list_run(void)
{
	char Qos_enable[CONFIG_DEFAULT_LENGTH] = {0};
	char Qos_auto_control[CONFIG_DEFAULT_LENGTH] = {0};
	char list[NV_QOS_LIST_MAX_LEN] = {0};
	char rec[NV_QOS_LIST_MAX_LEN] = {0};
	char opms_wan_mode[CONFIG_DEFAULT_LENGTH] = {0};
	char wan_if[CONFIG_DEFAULT_LENGTH] = {0};
	char lan_if_cable[CONFIG_DEFAULT_LENGTH] = {0};
	char lan_if_wifi[CONFIG_DEFAULT_LENGTH] = {0};
	char uplimit_total[CONFIG_DEFAULT_LENGTH] = {0};
	char downlimit_total[CONFIG_DEFAULT_LENGTH] = {0};
	int i = 0;
	char ip_list[32] = {0};
	char maxdownload[32] = {0};
	char maxupload[32] = {0};
	char tempchar[32] = {0};
	sc_cfg_get("Qos_enable", Qos_enable, sizeof(Qos_enable));
	sc_cfg_get("Qos_auto_control", Qos_auto_control, sizeof(Qos_auto_control));
	sc_cfg_get("opms_wan_mode", opms_wan_mode, sizeof(opms_wan_mode));
	sc_cfg_get("Qos_control_list", list, sizeof(list));
	sc_cfg_get("UpLimit_Total", uplimit_total, sizeof(uplimit_total));
	sc_cfg_get("DownLimit_Total", downlimit_total, sizeof(downlimit_total));

	if (0 == strlen(opms_wan_mode)) {
		return;
	}

	if (!strcmp(opms_wan_mode, "PPPOE")) {
		strcpy(wan_if, "ppp0");
		strcpy(lan_if_cable, "eth1");
		strcpy(lan_if_wifi, "ath0");

	}
	if (!strcmp(opms_wan_mode, "PPP")) {
		strcpy(wan_if, "usb0");
		strcpy(lan_if_cable, "eth0");
		strcpy(lan_if_wifi, "ath0");

	}
	if (!strcmp(opms_wan_mode, "DHCP") || !strcmp(opms_wan_mode, "STATIC")) {
		strcpy(wan_if, "eth0");
		strcpy(lan_if_cable, "eth1");
		strcpy(lan_if_wifi, "ath0");

	}
	if (!strcmp(opms_wan_mode, "BRIDGE")) {
		return;
	}
	/*clear the qdisc first before func return,important!(the qos state from enabled to disabled)*/
	/*clear upload*/
	ZTE_LOG(LOG_INFO, "delete the qdisc ################"); /*lint !e26*/
	doSystem("tc qdisc del dev %s root", wan_if);
	/*clear download*/
	doSystem("tc qdisc del dev %s root", lan_if_cable);
	doSystem("tc qdisc del dev %s root", lan_if_wifi);
	/*flush the mangle table*/
	doSystem("iptables -t mangle -F");
	ZTE_LOG(LOG_INFO, "delete over qdisc::"); /*lint !e26*/

	if (!strlen(Qos_enable)) {
		return;
	}
	if (!atoi(Qos_enable)) {
		return;
	}
	if (atoi(Qos_auto_control)) {
		return;
	}

	if (0 == strlen(list)) {
		return;
	}
	ZTE_LOG(LOG_INFO, "list= %s", list); /*lint !e26*/

	/*mark data first for the upload limit(because of SNAT )*/
	doSystem("iptables -t mangle -A PREROUTING  -p tcp -m length --length :64 -j MARK --set-mark 256 ");
	doSystem("iptables -t mangle -A PREROUTING  -p tcp -m length --length :64 -j RETURN  ");

	while ((static_getNthValueSafe(i++, list, ';', rec, sizeof(rec)) != -1)) {
		// get ip
		if ((static_getNthValueSafe(0, rec, '+', ip_list, sizeof(ip_list)) == -1)) {
			continue;
		}
		if (strlen(ip_list)) {
			ZTE_LOG(LOG_INFO, "ip_list= %s", ip_list); /*lint !e26*/
			sprintf(tempchar, "%d", i);
			doSystem("iptables -t mangle -A PREROUTING -s %s -j MARK --set-mark %s ", ip_list, tempchar);
			doSystem("iptables -t mangle -A PREROUTING -s %s -j RETURN ", ip_list);
			memset(tempchar, 0, sizeof(tempchar));
		}
		memset(ip_list, 0, sizeof(ip_list));
		memset(rec, 0, sizeof(rec));
	}
	/*upload&&download*/
	doSystem("tc qdisc add dev %s root handle 1: htb", wan_if);
	doSystem("tc qdisc add dev %s root handle 1: htb default 256", lan_if_cable);
	doSystem("tc qdisc add dev %s root handle 1: htb default 256", lan_if_wifi);

	doSystem("tc class add dev %s parent 1: classid 1:256 htb rate %skbit ceil %skbit prio 0 ", wan_if, uplimit_total, uplimit_total);
	doSystem("tc class add dev %s parent 1: classid 1:256 htb rate %skbit ceil %skbit prio 0 ", lan_if_cable, downlimit_total, downlimit_total);
	doSystem("tc class add dev %s parent 1: classid 1:256 htb rate %skbit ceil %skbit prio 0 ", lan_if_wifi, downlimit_total, downlimit_total);


	doSystem("tc qdisc add dev %s parent 1:256 handle 256: sfq perturb 5 ", wan_if);
	doSystem("tc qdisc add dev %s parent 1:256 handle 256: sfq perturb 5 ", lan_if_cable);
	doSystem("tc qdisc add dev %s parent 1:256 handle 256: sfq perturb 5 ", lan_if_wifi);

	doSystem("tc filter add dev %s parent 1:0 protocol ip prio 0 handle 256 fw classid 1:256", wan_if);

	i = 0;
	while ((static_getNthValueSafe(i++, list, ';', rec, sizeof(rec)) != -1)) {
		// get ip
		if ((static_getNthValueSafe(0, rec, '+', ip_list, sizeof(ip_list)) == -1)) {
			continue;
		}
		// get maxdownload
		if ((static_getNthValueSafe(1, rec, '+', maxdownload, sizeof(maxdownload)) == -1)) {
			continue;
		}
		// get maxupload
		if ((static_getNthValueSafe(2, rec, '+', maxupload, sizeof(maxupload)) == -1)) {
			continue;
		}
		/*the max download and upload can be 0*/
		if (strlen(ip_list)) {

			sprintf(tempchar, "%d", i);
			doSystem("tc class add dev %s parent 1: classid 1:%s htb rate %skbit ceil %skbit prio 1", wan_if, tempchar, maxupload, maxupload);
			doSystem("tc class add dev %s parent 1: classid 1:%s htb rate %skbit ceil %skbit prio 1", lan_if_cable, tempchar, maxdownload, maxdownload);
			doSystem("tc class add dev %s parent 1: classid 1:%s htb rate %skbit ceil %skbit prio 1", lan_if_wifi, tempchar, maxdownload, maxdownload);
			doSystem("tc qdisc add dev %s parent 1:%s handle 1%s: sfq perturb 15", wan_if, tempchar, tempchar);
			doSystem("tc qdisc add dev %s parent 1:%s handle 1%s: sfq perturb 15", lan_if_cable, tempchar, tempchar);
			doSystem("tc qdisc add dev %s parent 1:%s handle 1%s: sfq perturb 15", lan_if_wifi, tempchar, tempchar);
			doSystem("tc filter add dev %s protocol ip parent 1:0 handle %s fw classid 1:%s", wan_if, tempchar, tempchar);
			doSystem("tc filter add dev %s parent 1:0 protocol ip u32 match ip dst %s flowid 1:%s", lan_if_cable, ip_list, tempchar);
			doSystem("tc filter add dev %s parent 1:0 protocol ip u32 match ip dst %s flowid 1:%s", lan_if_wifi, ip_list, tempchar);
			memset(tempchar, 0, sizeof(tempchar));
		}
		memset(rec, 0, sizeof(rec));
		memset(ip_list, 0, sizeof(ip_list));
		memset(maxdownload, 0, sizeof(maxdownload));
		memset(maxupload, 0, sizeof(maxupload));

	}
	sc_cfg_save();
}


/*add a Qos list to the Qos control list */
/*the Qos list format is:
  [ip]+[maxdownload]+[maxupload]+[comment];[ip]+[maxdownload]+[maxupload]+[comment];....*/
/*add by lyf 2012/6/11*/
void zte_goform_qoslist_add_process(char_t *web_ip, char_t *max_download, char_t *max_upload, char_t *web_comment)
{


	/* value of make qos list */
	char qos_list[NV_QOS_LIST_MAX_LEN] = {0};
	char list[NV_QOS_LIST_MAX_LEN] = {0};

	if (!max_download || !web_ip || !max_upload)
		return;
	sc_cfg_get("Qos_control_list", qos_list, sizeof(qos_list));
	if (0 != strlen(qos_list)) {
		snprintf(list, sizeof(list), "%s;%s+%s+%s+%s", qos_list, web_ip, max_download, max_upload, web_comment);
	} else {
		snprintf(list, sizeof(list), "%s+%s+%s+%s", web_ip, max_download, max_upload, web_comment);
	}

	sc_cfg_set("Qos_control_list", list);

	zte_qos_list_run();
	sc_cfg_save();

}


/*delete a Qos list from the  list */
/*the Qos list format is:
  [ip]+[maxdownload]+[maxupload]+[comment];[ip]+[maxdownload]+[maxupload]+[comment];....*/
/*add by lyf 2012/6/11*/
void zte_goform_qoslist_del_process(char_t *index)/*lint !e129*/
{
	char qos_list[NV_QOS_LIST_MAX_LEN] = {0};
	//int list_count=0;
	int deleIndex = 0;

	if (!index)
		return;
	/*the web index begin from 1,but the fun index begin from 0*/
	deleIndex = atoi(index) - 1;
	sc_cfg_get("Qos_control_list", qos_list, sizeof(qos_list));
	if (0 == strlen(qos_list)) {
		return;
	}

	deleteNthValue(deleIndex, qos_list, ';');
	sc_cfg_set("Qos_control_list", qos_list);
	zte_qos_list_run();
	sc_cfg_save();



}



/*edit a qos list of the list */
/*the Qos list format is:
  [ip]+[maxdownload]+[maxupload]+[comment];[ip]+[maxdownload]+[maxupload]+[comment];....*/
/*add by lyf 2012/6/11*/
void zte_goform_qoslist_edit_process(char_t *web_ip, char_t *maxdownload, char_t *maxupload, char_t *web_comment, char_t *index) /*lint !e129*/
{
	char qos_address[64] = {0};
	char qos_list[NV_QOS_LIST_MAX_LEN] = {0};
	char rec[NV_QOS_LIST_MAX_LEN] = {0};
	int editIndex = 0;

	if (!web_ip || !maxdownload || !maxupload || !index)
		return;
	/*the web index begin from 1,but the fun index begin from 0*/
	editIndex = atoi(index) - 1;
	sc_cfg_get("Qos_control_list", qos_list, sizeof(qos_list));
	if (0 == strlen(qos_list)) {
		return;
	}

	sprintf(qos_address, "%s+%s+%s+%s", web_ip, maxdownload, maxupload, web_comment);
	changeNthValue(editIndex, qos_list, ';', rec, qos_address);
	sc_cfg_set("Qos_control_list", rec);
	zte_qos_list_run();
	sc_cfg_save();

}


/*QoSδʵopms_wan_modeӦøݵǰȱʡڣʶethwan_modepswan_modewifiwan_modeеһ*/
void zte_goform_Qos(void)/*lint !e18*/
{
	char Qos_enable[CONFIG_DEFAULT_LENGTH] = {0};
	char Qos_auto_control[CONFIG_DEFAULT_LENGTH] = {0};
	char opms_wan_mode[CONFIG_DEFAULT_LENGTH] = {0};
	char ack_enable[CONFIG_DEFAULT_LENGTH] = {0};

	sc_cfg_get("Qos_enable", Qos_enable, sizeof(Qos_enable));
	sc_cfg_get("Qos_auto_control", Qos_auto_control, sizeof(Qos_auto_control));
	sc_cfg_get("opms_wan_mode", opms_wan_mode, sizeof(opms_wan_mode));
	sc_cfg_get("Qos_control_list", ack_enable, sizeof(ack_enable));

	if (!atoi(Qos_enable)) {
		/*if the wanmode is ppp0,then to call the ack first shall scrip*/
		if (atoi(ack_enable)) {
			if (!strcmp(opms_wan_mode, "PPP")) {
				ZTE_LOG(LOG_INFO, "ack first is running////////////"); /*lint !e26*/
				doSystem("ack_first.sh");
			}
			sc_cfg_save();
			return ;/*lint !e533 !e110 */
		}



		doSystem("speed_limit_ini.sh");
		sc_cfg_save();
		return ;/*lint !e533 !e110 */
	}

	if (!atoi(Qos_auto_control)) {
		zte_qos_list_run();
	} else {
		ZTE_LOG(LOG_INFO, "QoS auto traffic control is starting!");/*lint !e26*/

		doSystem("qos.sh");

	}
	sc_cfg_save();
}

/******************************************************
* Function: zte_static_route_list_ini_run()
* Description:  run the static route list after the device reboot
  the static route list format is:
   [name]+[private]+[active]+[des ip]+[ip subnet mask]+[GateWay]+[metric];.....
* Input:
* Output:
* Return:
* Others:
* 2012/5/21  created by Liu Yifei
*******************************************************/
void zte_static_route_list_ini_run(void)
{
	//char name[CONFIG_DEFAULT_LENGTH] = {0};
	char des_ip[32] = {0};
	char subnet_mask[32] = {0};
	char gateway[32] = {0};
	char static_routelist[NV_STATIC_ROUTE_LIST_MAX_LEN] = {0};
	char rec[NV_STATIC_ROUTE_LIST_MAX_LEN] = {0};
	char pirvate[3] = {0}; /*private button*/
	char active[3] = {0}; /*active button*/
	char metric[3] = {0};
	int list_index = 0;
	int active_flag = 0;

	sc_cfg_get("static_route_list", static_routelist, sizeof(static_routelist));
	if (0 == strlen(static_routelist)) {
		return;
	}
	while ((getNthValueSafe(list_index++, static_routelist, ';', rec, sizeof(rec)) != -1)) {
		/*get private info*/
		if ((getNthValueSafe(1, rec, '+', pirvate, sizeof(pirvate)) == -1)) {
			continue;
		}
		/*get active info*/
		if ((getNthValueSafe(2, rec, '+', active, sizeof(active)) == -1)) {
			continue;
		}
		/*get des ip address*/
		if ((getNthValueSafe(3, rec, '+', des_ip, sizeof(des_ip)) == -1)) {
			continue;
		}
		/*get subnet mask*/
		if ((getNthValueSafe(4, rec, '+', subnet_mask, sizeof(subnet_mask)) == -1)) {
			continue;
		}
		/*get gateway*/
		if ((getNthValueSafe(5, rec, '+', gateway, sizeof(gateway)) == -1)) {
			continue;
		}
		/*get metric*/
		if ((getNthValueSafe(6, rec, '+', metric, sizeof(metric)) == -1)) {
			continue;
		}
		if ((0 != strlen(active)) && (0 != strlen(des_ip))
		    && (0 != strlen(subnet_mask)) && (0 != strlen(gateway))) {
			if (active_flag = atoi(active)) {
				if (!strcmp(subnet_mask, "255.255.255.255")) {
					doSystem("route add -host %s gw %s metric %s", des_ip, gateway, metric);
				} else {
					doSystem("route add -net %s netmask %s gw %s metric %s", des_ip, subnet_mask, gateway, metric);
				}
			}
		}


	}

	sc_cfg_save();


}

/******************************************************
* Function: zte_static_route_list_add()
* Description:  add a list to the static route list
  the static route list format is:
   [name]+[private]+[active]+[des ip]+[ip subnet mask]+[GateWay]+[metric];.....
* Input:  static route info from the web
* Output:
* Return:
* Others:
* 2012/5/21  created by Liu Yifei
*******************************************************/
void zte_static_route_list_add(char *name, char *private, char *active, char *des_ip, char *subnet_mask, char *gateway, char *metric)
{
	char static_routelist[NV_STATIC_ROUTE_LIST_MAX_LEN] = {0};
	char list[NV_STATIC_ROUTE_LIST_MAX_LEN] = {0};
	int active_flag = 0;

	if (!name || !des_ip || !subnet_mask || !gateway) { /*private,active,metric may equal to 0*/
		return;
	}
	sc_cfg_get("static_route_list", static_routelist, sizeof(static_routelist));

	if (0 != strlen(static_routelist)) {
		snprintf(list, sizeof(list), "%s;%s+%s+%s+%s+%s+%s+%s", static_routelist, name, private, active, des_ip, subnet_mask, gateway, metric);
	} else {
		snprintf(list, sizeof(list), "%s+%s+%s+%s+%s+%s+%s", name, private, active, des_ip, subnet_mask, gateway, metric);
	}

	sc_cfg_set("static_route_list", list);
	if (active_flag = atoi(active)) {
		if (!strcmp(subnet_mask, "255.255.255.255")) {
			doSystem("route add -host %s gw %s metric %s", des_ip, gateway, metric);
		} else {
			doSystem("route add -net %s netmask %s gw %s metric %s", des_ip, subnet_mask, gateway, metric);
		}
	}

	sc_cfg_save();
}
/******************************************************
* Function: zte_static_route_list_run_one()
* Description:  run one list from the static route list
  the static route list format is:
   [name]+[private]+[active]+[des ip]+[ip subnet mask]+[GateWay]+[metric]
* Input:
  list--the list to run
  delimit -- delimitor
* Output:
* Return:
* Others:
* 2012/5/21  created by Liu Yifei
*******************************************************/
void zte_static_route_list_run_one(char *list, char delimit)
{
	char des_ip[32] = {0};
	char subnet_mask[32] = {0};
	char gateway[32] = {0};
	char pirvate[3] = {0};
	char active[3] = {0};
	char metric[3] = {0};
	int active_flag = 0;

	if (!list) {
		return;
	}

	/*get private info*/
	if ((getNthValueSafe(1, list, delimit, pirvate, sizeof(pirvate)) == -1)) { /*the index begin from 1,ingore the name(index 0)*/
		return;
	}
	/*get active info*/
	if ((getNthValueSafe(2, list, delimit, active, sizeof(active)) == -1)) {
		return;
	}
	/*get des ip address*/
	if ((getNthValueSafe(3, list, delimit, des_ip, sizeof(des_ip)) == -1)) {
		return;
	}
	/*get subnet mask*/
	if ((getNthValueSafe(4, list, delimit, subnet_mask, sizeof(subnet_mask)) == -1)) {
		return;
	}
	/*get gateway*/
	if ((getNthValueSafe(5, list, delimit, gateway, sizeof(gateway)) == -1)) {
		return;
	}
	/*get metric*/
	if ((getNthValueSafe(6, list, delimit, metric, sizeof(metric)) == -1)) {
		return;
	}
	if ((0 != strlen(active)) && (0 != strlen(des_ip))
	    && (0 != strlen(subnet_mask)) && (0 != strlen(gateway))) {
		if (active_flag = atoi(active)) {
			if (!strcmp(subnet_mask, "255.255.255.255")) {
				doSystem("route add -host %s gw %s metric %s", des_ip, gateway, metric);
			} else {
				doSystem("route add -net %s netmask %s gw %s metric %s", des_ip, subnet_mask, gateway, metric);
			}
		}
	}

}
/******************************************************
* Function: zte_static_route_list_del_one()
* Description:  delete one list from the static route list
  the static route list format is:
   [name]+[private]+[active]+[des ip]+[ip subnet mask]+[GateWay]+[metric]
* Input:
  list--the list to delete
  delimit -- delimitor
* Output:
* Return:
* Others:
* 2012/5/21  created by Liu Yifei
*******************************************************/
void zte_static_route_list_del_one(char *list, char delimit)
{
	char des_ip[32] = {0};
	char subnet_mask[32] = {0};
	char gateway[32] = {0};
	char pirvate[3] = {0};
	char active[3] = {0};
	char metric[3] = {0};
	int active_flag = 0;

	if (!list) {
		return;
	}

	/*get private info*/
	if ((getNthValueSafe(1, list, delimit, pirvate, sizeof(pirvate)) == -1)) { /*the index begin from 1,ingore the name(index 0)*/
		return;
	}
	/*get active info*/
	if ((getNthValueSafe(2, list, delimit, active, sizeof(active)) == -1)) {
		return;
	}
	/*get des ip address*/
	if ((getNthValueSafe(3, list, delimit, des_ip, sizeof(des_ip)) == -1)) {
		return;
	}
	/*get subnet mask*/
	if ((getNthValueSafe(4, list, delimit, subnet_mask, sizeof(subnet_mask)) == -1)) {
		return;
	}
	/*get gateway*/
	if ((getNthValueSafe(5, list, delimit, gateway, sizeof(gateway)) == -1)) {
		return;
	}
	/*get metric*/
	if ((getNthValueSafe(6, list, delimit, metric, sizeof(metric)) == -1)) {
		return;
	}
	if ((0 != strlen(active)) && (0 != strlen(des_ip))
	    && (0 != strlen(subnet_mask)) && (0 != strlen(gateway))) {
		if (active_flag = atoi(active)) {
			if (!strcmp(subnet_mask, "255.255.255.255")) {
				doSystem("route del -host %s gw %s metric %s", des_ip, gateway, metric);
			} else {
				doSystem("route del -net %s netmask %s gw %s metric %s", des_ip, subnet_mask, gateway, metric);
			}
		}
	}

}
/******************************************************
* Function: zte_static_route_list_del()
* Description:  delete a list from the static route list according to the delete index
  the static route list format is:
   [name]+[private]+[active]+[des ip]+[ip subnet mask]+[GateWay]+[metric];.....
* Input:
  index--the index  of deleted items
  delimit -- delimitor
* Output:
* Return:
* Others:
* 2012/5/21  created by Liu Yifei
*******************************************************/
void zte_static_route_list_del(int index, char delimit)
{
	char static_routelist[NV_STATIC_ROUTE_LIST_MAX_LEN] = {0};
	char list[NV_STATIC_ROUTE_LIST_MAX_LEN] = {0};/*temp list*/
	//int active_flag=0;
	char *begin = NULL;
	char *end = NULL;
	char *buf = NULL;
	int i = 0;
	int j = 0;
	int need_check_flag = 0;
	int default_len = 0;

	sc_cfg_get("static_route_list", static_routelist, sizeof(static_routelist));
	if (!strlen(static_routelist)) {
		return;
	}

	buf = strdup(static_routelist);
	begin = buf;
	end = strchr(begin, delimit);
	while (end) {
		if (i == index) {
			strncpy(list, begin, end - begin);
			zte_static_route_list_del_one(list, '+');
			memset(begin, 0, end - begin);
			memset(list, 0, strlen(list));
			if (index == 0)
				need_check_flag = 1;
			break;
		}
		begin = end;

		end = strchr(begin + 1, delimit);
		i++;
	}
	if (!end && index == i) {
		strncpy(list, begin, strlen(begin));
		zte_static_route_list_del_one(list, '+');
		memset(list, 0, strlen(list)); /*set the temp list to 0*/
		memset(begin, 0, strlen(begin));

	}


	if (need_check_flag) {
		for (i = 0; i < strlen(static_routelist); i++) {
			if (buf[i] == '\0') {
				continue;
			}
			if (buf[i] == ';') {
				buf[i] = '\0';
			}
			break;
		}
	}
	default_len = strlen(static_routelist);
	for (i = 0, j = 0; i < strlen(static_routelist); i++) {
		if (buf[i] != '\0') {
			static_routelist[j++] = buf[i];
		}
	}
	for (i = j; i < default_len; i++)
		static_routelist[i] = '\0';

	sc_cfg_set("static_route_list", static_routelist);
	sc_cfg_save();
	free(buf);


}
/******************************************************
* Function: zte_static_route_list_edit_one()
* Description:  edit a list from the static route list
  the static route list format is:
   [name]+[private]+[active]+[des ip]+[ip subnet mask]+[GateWay]+[metric];.....
* Input:
  index--the index of deleted item
  value--the static route list
  delimit--delimitor
  web_list--static route info from the web
* Output:
  result-- the edited static route list
* Return:
* Others:
* 2012/5/21  created by Liu Yifei
*******************************************************/
int zte_static_route_list_edit_one(int index, char *value, char delimit, char *result, char *web_list)
{
	int i = 0;
	int front_len = 0;
	int end_len = 0;
	int edit_len = 0;
	int total_len = 0;
	char *begin = NULL;
	char *end = NULL;
	char tempchar[NV_STATIC_ROUTE_LIST_MAX_LEN] = {0};
	char dosys_list[NV_STATIC_ROUTE_LIST_MAX_LEN] = {0};

	if (!value || !result || !web_list)
		return -1;

	begin = value;
	end = strchr(begin, delimit);
	while (i < index && end) {
		begin = end + 1;
		end = strchr(begin, delimit);
		i++;
	}

	//no delimit
	if (!end) {
		if (i == index) {
			end = begin + strlen(begin) - 1;
			strncpy(dosys_list, begin, end - begin + 1);
			printf(dosys_list);
			zte_static_route_list_del_one(dosys_list, '+');
			memset(dosys_list, 0, strlen(dosys_list));
			front_len = begin - value;
			strncpy(tempchar, value, front_len);
			strncpy(tempchar + front_len, web_list, (strlen(web_list)));
			zte_static_route_list_run_one(web_list, '+');
			total_len = front_len + strlen(web_list);
		} else {
			return -1;
		}
	} else {
		front_len = begin - value;
		edit_len = end - begin;
		end_len = strlen(value) - front_len - edit_len;
		strncpy(dosys_list, begin, end - begin);
		printf(dosys_list);
		zte_static_route_list_del_one(dosys_list, '+');
		memset(dosys_list, 0, strlen(dosys_list));
		strncpy(tempchar, value, front_len);
		strncpy(tempchar + front_len, web_list, strlen(web_list));
		strncpy(tempchar + front_len + strlen(web_list), value + front_len + edit_len, end_len);
		zte_static_route_list_run_one(web_list, '+');
		total_len = front_len + strlen(web_list) + end_len;
	}
	memcpy(result, tempchar, total_len);
	*(result + total_len) = '\0';

	return 0;

}
/******************************************************
* Function: zte_static_route_list_edit()
* Description:  edit a list from the static route list
  call zte_static_route_list_edit_one() to process
  the static route list format is:
   [name]+[private]+[active]+[des ip]+[ip subnet mask]+[GateWay]+[metric];.....
* Input:
  index--the index of deleted item
  list info from the web
* Output:
* Return:
* Others:
* 2012/5/21  created by Liu Yifei
*******************************************************/
void zte_static_route_list_edit(char *index, char *web_name, char *web_private, char *web_active, char *web_des_ip, char *web_subnet_mask, char *web_gateway, char *web_metric)
{
	char staticroute_one_list[NV_STATIC_ROUTE_LIST_MAX_LEN] = {0};
	char static_route_list[NV_STATIC_ROUTE_LIST_MAX_LEN] = {0};
	char rec[NV_STATIC_ROUTE_LIST_MAX_LEN] = {0};
	int editIndex = 0;
	if (!web_name || !web_des_ip || !web_subnet_mask || !web_gateway) { /*private,active,metric may equal to 0*/
		return;
	}
	editIndex = atoi(index) - 1;
	sc_cfg_get("static_route_list", static_route_list, sizeof(static_route_list));
	if (!strlen(static_route_list)) {
		return;
	}
	sprintf(staticroute_one_list, "%s+%s+%s+%s+%s+%s+%s", web_name, web_private, web_active, web_des_ip, web_subnet_mask, web_gateway, web_metric);
	zte_static_route_list_edit_one(editIndex, static_route_list, ';', rec, staticroute_one_list);
	sc_cfg_set("static_route_list", rec);
	sc_cfg_save();
}
#endif

//add by gongxuanhui 03/13/2014
static void zte_router_make_MTU_Rule(char *buf, int len, char *wan_name, char *mtu_value)
{
	snprintf(buf, len, "ifconfig %s mtu %s ", wan_name,  mtu_value);
}

//add by gongxuanhui 03/13/2014
void zte_router_MTU_set(void)
{
	char cmd[1024] = {0};
	char mtu[128] = {0};
	int mtu_int;

	memset(cmd, 0, sizeof(cmd));

	//zte_router_nvconfig_read("mtu");
	//strcpy(mtu , g_router_nvconfig_buf);

	sc_cfg_get("mtu", mtu, sizeof(mtu));

	if (0 == strcmp(mtu, "")) {
		slog(NET_PRINT, SLOG_ERR, "Warning: mtu  valu is null \n");
		return;
	}

	if ((mtu_int = atoi(mtu)) < 572 || mtu_int > 1500) {
		slog(NET_PRINT, SLOG_ERR, "Warning: mtu value is illgality\n");
		return;
	}

	zte_router_make_MTU_Rule(cmd, sizeof(cmd), defwan_rel, mtu);

	system_cmd_ex(cmd);
	//system_cmd_ex("firewall_init.sh");
	return;
}

//1217
void zte_unpn_set(void)
{
	char upnpEnabled[8] = {0};
	
	sc_cfg_get("upnpEnabled", upnpEnabled, sizeof(upnpEnabled));
	slog(NET_PRINT, SLOG_NORMAL, "router : start to set upnp %s\n", upnpEnabled);
	if(atoi(upnpEnabled))
		system_cmd_ex("upnp.sh");
}
void zte_router_dhcp_set_process(void)
{
	slog(NET_PRINT, SLOG_NORMAL, "router : start to set dhcp \n");
	system_cmd_ex("lan.sh");
	//doSystem("killall fullshare");
	//doSystem("killall smbd");
	//doSystem("killall nmbd");
	//doSystem("fullshare &");
	//doSystem("smbd -D");
	//doSystem("nmbd -D");
	//doSystem("sh /mnt/jffs2/scripts/upnp.sh");
}

//add by gongxuanhui 03/13/2014
void zte_router_mtu_set_process(void)
{
	zte_router_MTU_set();
	zte_router_init();
}


//set  mac_ip_list when get msg from web_firewall 08/09/2015
void zte_macip_list_run(void)
{
	char dhcp_enable[ROUTER_DEFAULT_LEN] = {0};
	char list[NV_MACIP_LIST_MAX_LEN] = {0};
	char mac_address[32] = {0};   /*mac address */
	char ip_address[32]  = {0};  /*ip address */

	int dhcp_server_enable = 0;
	int i = 0;
	char rec[NV_MACIP_LIST_MAX_LEN] = {0};
	char cmd[1024] = {0};

	sc_cfg_get("dhcpEnabled", dhcp_enable, sizeof(dhcp_enable));
	if (0 == strlen(dhcp_enable)) {
		slog(NET_PRINT, SLOG_ERR, "Error: can't find \"dhcpEnabled\" in flash.\n"); /*lint !e26*/
		return;
	}
	dhcp_server_enable = atoi(dhcp_enable);
	/* if dhcp is disable, then return directly: 0 mean disable, 1 means enable */
	if (0 == dhcp_server_enable) {
		return;
	}

	sc_cfg_get("mac_ip_list", list, sizeof(list));

	/*kill udhcpd*/
	system_cmd_ex("config-udhcpd.sh \"lan\" -k");
	/*clear the static_lease list in udhcpd.conf file*/
	system_cmd_ex("config-udhcpd.sh \"lan\" -S");
	while ((getNthValueSafe(i++, list, ';', rec, sizeof(rec)) != -1)) {
		// get mac
		if ((getNthValueSafe(1, rec, '+', mac_address, sizeof(mac_address)) == -1)) {
			continue;
		}
		// get ip
		if ((getNthValueSafe(2, rec, '+', ip_address, sizeof(ip_address)) == -1)) {
			continue;
		}
		if ((0 != strlen(mac_address))
		    && (0 != strlen(ip_address))) {
			memset(cmd, 0, sizeof(cmd));
			sprintf(cmd, "config-udhcpd.sh \"lan\" -S %s %s", mac_address, ip_address);
			system_cmd_ex(cmd);
			//system_cmd_ex("config-udhcpd.sh -S %s %s",mac_address,ip_address);
		}


	}

	/*restart udhcpd*/
	system_cmd_ex("config-udhcpd.sh \"lan\" -r");

}

void zte_bind_macip_list(void)
{
	char dhcp_enable[ROUTER_DEFAULT_LEN] = {0};
	char static_dhcp_enable[ROUTER_DEFAULT_LEN] = {0};

	sc_cfg_get("dhcpEnabled", dhcp_enable, sizeof(dhcp_enable));
	if (0 == strlen(dhcp_enable)) {
		slog(NET_PRINT, SLOG_ERR, "Error: can't find \"dhcpEnabled\" in flash.\n"); /*lint !e26*/
		return;
	}
	/* if dhcp is disable, then return directly: 0 mean disable, 1 means enable */
	if (0 == atoi(dhcp_enable)) {
		return;
	}

	/*kill udhcpd*/
	system_cmd_ex("config-udhcpd.sh \"lan\" -k");

	sc_cfg_get("static_dhcp_enable", static_dhcp_enable, sizeof(static_dhcp_enable));

	//static_dhcp_enable=0,رMAC-IP󶨹ܣudhcpd.confļа󶨵MAC-IP
	//static_dhcp_enable=1,MAC-IP󶨹ܣ֮ǰMAC-IP󶨹ϵдudhcpd.conf
	if (0 == atoi(static_dhcp_enable)) {
		/*clear the static_lease list in udhcpd.conf file*/
		system_cmd_ex("config-udhcpd.sh \"lan\" -S");
	} else
		system_cmd_ex("config-udhcpd.sh \"lan\" -E");

	system_cmd_ex("config-udhcpd.sh \"lan\" -r");

}

void zte_bind_macip_list_add(struct static_macip_info *static_macip)
{
	char dhcp_enable[ROUTER_DEFAULT_LEN] = {0};
	char static_dhcp_enable[ROUTER_DEFAULT_LEN] = {0};
	char* mac_address = NULL;   /*mac address  to add*/
	char* ip_address = NULL;  /*ip address to add */
	char cmd[200] = {0};

	sc_cfg_get("dhcpEnabled", dhcp_enable, sizeof(dhcp_enable));
	if (0 == strlen(dhcp_enable)) {
		slog(NET_PRINT, SLOG_ERR, "Error: can't find \"dhcpEnabled\" in flash.\n"); /*lint !e26*/
		return;
	}
	/* if dhcp is disable, then return directly: 0 mean disable, 1 means enable */
	if (0 == atoi(dhcp_enable)) {
		return;
	}

	mac_address = static_macip->mac;
	ip_address = static_macip->ip;

	/*kill udhcpd*/
	system_cmd_ex("config-udhcpd.sh \"lan\" -k");

	sc_cfg_get("static_dhcp_enable", static_dhcp_enable, sizeof(static_dhcp_enable));

	//static_dhcp_enable=0,رMAC-IP󶨹ܣհ󶨵MAC-IP
	if (1 == atoi(static_dhcp_enable)) {
		//MAC-IP󶨹
		if ((0 != strlen(mac_address)) && (0 != strlen(ip_address))) {
			sprintf(cmd, "config-udhcpd.sh \"lan\" -S %s %s", mac_address, ip_address);
			system_cmd_ex(cmd);
		}
	}

	system_cmd_ex("config-udhcpd.sh \"lan\" -r");

}

void zte_bind_macip_list_del(char* mac)
{
	char dhcp_enable[ROUTER_DEFAULT_LEN] = {0};
	char static_dhcp_enable[ROUTER_DEFAULT_LEN] = {0};
	char cmd[200] = {0};

	sc_cfg_get("dhcpEnabled", dhcp_enable, sizeof(dhcp_enable));
	if (0 == strlen(dhcp_enable)) {
		slog(NET_PRINT, SLOG_ERR, "Error: can't find \"dhcpEnabled\" in flash.\n"); /*lint !e26*/
		return;
	}
	/* if dhcp is disable, then return directly: 0 mean disable, 1 means enable */
	if (0 == atoi(dhcp_enable)) {
		return;
	}

	/*kill udhcpd*/
	system_cmd_ex("config-udhcpd.sh \"lan\" -k");

	sc_cfg_get("static_dhcp_enable", static_dhcp_enable, sizeof(static_dhcp_enable));

	//static_dhcp_enable=0,رMAC-IP󶨹ܣհ󶨵MAC-IP
	if (1 == atoi(static_dhcp_enable)) {
		//ɾMAC-IP󶨹
		if (0 != strlen(mac)) {
			sprintf(cmd, "config-udhcpd.sh \"lan\" -D %s", mac);
			system_cmd_ex(cmd);
		}
	}

	system_cmd_ex("config-udhcpd.sh \"lan\" -r");

}


void get_mac_hostname_pro(struct mac_hostname_info *mac_hostname_)
{
	char *mac = NULL;
	char *hostname = NULL;
	char cmd[200] = {0};
	mac = mac_hostname_->mac;
	hostname = mac_hostname_->hostname;
	sprintf(cmd, "config-hostname.sh \"%s\" \"%s\"", mac, hostname);
	system_cmd_ex(cmd);

}

void children_device_add(struct mac_hostname_info *mac_hostname)
{
	char *mac = NULL;
	char *hostname = NULL;
	char cmd[200] = {0};
	mac = mac_hostname->mac;
	hostname = mac_hostname->hostname;
	slog(NET_PRINT, SLOG_NORMAL, "children_device_add:mac= %s, hostname = %s\n", mac, hostname);
	if ((0 != strlen(mac)) && (0 != strlen(hostname))) {
		sprintf(cmd, "config-parents.sh device \"%s\" \"%s\"", mac, hostname);
		system_cmd_ex(cmd);
	}
}

void children_device_del(char * mac)
{
	char cmd[100] = {0};
	if (0 != strlen(mac)) {
		sprintf(cmd, "config-parents.sh device \"%s\"", mac);
		system_cmd_ex(cmd);
	}
}


void white_site_add(struct white_site_info * white_site)
{
	char *name = NULL;
	char *site = NULL;
	char cmd[600] = {0};
	name = white_site->name;
	site = white_site->site;
	slog(NET_PRINT, SLOG_NORMAL, "white_site_add:site= %s, name = %s\n", site, name);
	if (0 != strlen(site)) {
		sprintf(cmd, "config-parents.sh white_site -A \"%s\" \"%s\"", site, name);
		system_cmd_ex(cmd);
	}

}


void white_site_remove(char * ids)
{
	char cmd[100] = {0};
	if (0 != strlen(ids)) {
		sprintf(cmd, "config-parents.sh white_site -D \"%s\"", ids);
		system_cmd_ex(cmd);
	}
}


void zte_children_start_nonet(void)
{
	char sys_cmd_bufer[500] = {0};

	FILE *chilren_device_file = NULL;
	char line[200] = {0};
	char mac[18] = {0};
	char path_conf[50] = {0};
	char path_file[100] = {0};
	sc_cfg_get("path_conf", path_conf, sizeof(path_conf));
	sprintf(path_file, "%s/children_device_file", path_conf);

	/*flush filter chain*/
	sprintf(sys_cmd_bufer, "iptables -F %s %s", CLILDREN_MAC_CHAIN, FMT_ECHO_IPTABLES_CMD);
	system_cmd_ex(sys_cmd_bufer);
	memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));
	sprintf(sys_cmd_bufer, "iptables -F %s %s", CLILDREN_WEB_CHAIN, FMT_ECHO_IPTABLES_CMD);
	system_cmd_ex(sys_cmd_bufer);
	memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));
	sprintf(sys_cmd_bufer, "iptables -F %s %s", CLILDREN_WEB_PHONE_CHAIN, FMT_ECHO_IPTABLES_CMD);
	system_cmd_ex(sys_cmd_bufer);


	chilren_device_file = fopen(path_file, "r");
	if (chilren_device_file == NULL) {
		fprintf(stderr, "can not open file children_device_file.");
		return;
	}

	while (fgets(line, 200, chilren_device_file) != NULL) {
		memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));

		strncpy(mac, line, 17);

		if (strcmp(mac, "") != 0) {
			sprintf(sys_cmd_bufer, "iptables -A %s -m mac --mac-source %s -j DROP", CLILDREN_MAC_CHAIN, mac);
			slog(NET_PRINT, SLOG_NORMAL, "%s \n", sys_cmd_bufer);
			system_cmd_ex(sys_cmd_bufer);
		}

		memset(line, 0, sizeof(line));
		memset(mac, 0, sizeof(mac));
	}
	fclose(chilren_device_file);
}

static void make_children_white_site_rule(char mac[])
{
	slog(NET_PRINT, SLOG_NORMAL, "make_children_white_site_rule start! \n");
	char sys_cmd_bufer[600] = {0};
	FILE *white_site_file = NULL;
	char url_hexstring[ZTE_ROUTER_URL_FILTER_LEN] = {0};
	char line[600] = {0};
	char site[600] = {0};//klocwork
	char temp_site[600] = {0};

	unsigned int len = 0;

	char path_conf[50] = {0};
	char path_file[100] = {0};
	sc_cfg_get("path_conf", path_conf, sizeof(path_conf));
	sprintf(path_file, "%s/white_site_file", path_conf);

	white_site_file = fopen(path_file, "r");
	if (white_site_file == NULL) {
		fprintf(stderr, "can not open file white_site_file.");

		//PCն:ĬϽmacַ53˿ڵİ
		memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));
		sprintf(sys_cmd_bufer, "iptables -A %s -m mac --mac-source %s -p udp --dport 53 -j DROP", CLILDREN_WEB_CHAIN, mac);
		system_cmd_ex(sys_cmd_bufer);

		//ֻն:ĬϽmacַ53˿ڵİ
		memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));
		sprintf(sys_cmd_bufer, "iptables -A %s -m mac --mac-source %s -p udp --dport 53 -j DROP", CLILDREN_WEB_PHONE_CHAIN, mac);
		system_cmd_ex(sys_cmd_bufer);

		return;
	}

	while (fgets(line, 600, white_site_file) != NULL) {
		memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));
		memset(url_hexstring, 0, sizeof(url_hexstring));

		int i = 0;
		for (i = 0; i < 600; i++) {
			if (line[i] == ',') {
				len = i;
				break;
			}
		}
		strncpy(site, line, len);

		if (strcmp(site, "") != 0) {
			//ȥַǰhttpͷ
			if (!strncasecmp(site, "http://", strlen("http://"))) {
				strncpy(site, site + strlen("http://"), sizeof(site)-1);
			}
			if (!strncasecmp(site, "https://", strlen("https://"))) {
				strncpy(site, site + strlen("https://"), sizeof(site)-1);
			}
			//ȥַ.com/β
			int seq = 0;
			int len_site = 0;
			memset(temp_site, 0, sizeof(temp_site));
			strcpy(temp_site, site);
			for (seq = 0; seq < strlen(temp_site); seq++) {
				if (temp_site[seq] == '/') {
					len_site = seq;
					memset(site, 0, sizeof(site));
					strncpy(site, temp_site, len_site);
					break;
				}
			}



			str_vary_dit(site, url_hexstring);
			slog(NET_PRINT, SLOG_NORMAL, "site=%s url_hexstring=%s\n", site, url_hexstring);
			snprintf(sys_cmd_bufer, sizeof(sys_cmd_bufer), "iptables -A %s -m mac --mac-source %s -m string --hex-string  \"|%s|\" --algo kmp -j ACCEPT", \
			        CLILDREN_WEB_CHAIN, mac, url_hexstring);//klocwork
			system_cmd_ex(sys_cmd_bufer);

			memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));
			snprintf(sys_cmd_bufer, sizeof(sys_cmd_bufer), "iptables -A %s -m mac --mac-source %s -m string --hex-string  \"|%s|\" --algo kmp -j ACCEPT", \
			        CLILDREN_WEB_PHONE_CHAIN, mac, url_hexstring);
			system_cmd_ex(sys_cmd_bufer);

		}

		memset(line, 0, sizeof(line));
		memset(site, 0, sizeof(site));
		len = 0;
	}

	fclose(white_site_file);

	//ĬϽmacַ53˿ڵİ
	memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));
	sprintf(sys_cmd_bufer, "iptables -A %s -m mac --mac-source %s -p udp --dport 53 -j DROP", CLILDREN_WEB_CHAIN, mac);
	system_cmd_ex(sys_cmd_bufer);

	memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));
	sprintf(sys_cmd_bufer, "iptables -A %s -m mac --mac-source %s -p udp --dport 53 -j DROP", CLILDREN_WEB_PHONE_CHAIN, mac);
	system_cmd_ex(sys_cmd_bufer);


}

void zte_children_stop_nonet(void)
{
	char sys_cmd_bufer[500] = {0};
	FILE *chilren_device_file = NULL;
	char line[200] = {0};
	char mac[18] = {0};

	char path_conf[50] = {0};
	char path_file[100] = {0};
	sc_cfg_get("path_conf", path_conf, sizeof(path_conf));
	sprintf(path_file, "%s/children_device_file", path_conf);

	system_cmd_ex("iptables -t filter -D INPUT -p udp --dport 53  -j ACCEPT");
	system_cmd_ex("iptables -t filter -D FORWARD -p udp --dport 53  -j ACCEPT");



	/*flush filter chain*/
	sprintf(sys_cmd_bufer, "iptables -F %s %s", CLILDREN_MAC_CHAIN, FMT_ECHO_IPTABLES_CMD);
	system_cmd_ex(sys_cmd_bufer);
	memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));
	sprintf(sys_cmd_bufer, "iptables -F %s %s", CLILDREN_WEB_CHAIN, FMT_ECHO_IPTABLES_CMD);
	system_cmd_ex(sys_cmd_bufer);
	memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));
	sprintf(sys_cmd_bufer, "iptables -F %s %s", CLILDREN_WEB_PHONE_CHAIN, FMT_ECHO_IPTABLES_CMD);
	system_cmd_ex(sys_cmd_bufer);

	chilren_device_file = fopen(path_file, "r");
	if (chilren_device_file == NULL) {
		fprintf(stderr, "can not open file children_device_file.");
		return;
	}

	while (fgets(line, 200, chilren_device_file) != NULL) {
		memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));

		strncpy(mac, line, 17);

		if (strcmp(mac, "") != 0) {
			make_children_white_site_rule(mac);
		}

		memset(line, 0, sizeof(line));
		memset(mac, 0, sizeof(mac));
	}
	fclose(chilren_device_file);
}

/* DHCP_SETTING_REQ */
void zte_router_dhcp_setting_req_process(dhcp_setting_req *pdhcp_setting_req)
{
	(void)sc_cfg_set("lan_ipaddr", pdhcp_setting_req->lan_ip);
	(void)sc_cfg_set("lan_netmask", pdhcp_setting_req->lan_netmask);
	if (!pdhcp_setting_req->dhcp_enabled) {
		(void)sc_cfg_set("dhcpEnabled", "0");
	} else {
		(void)sc_cfg_set("dhcpEnabled", "1");
		(void)sc_cfg_set("dhcpStart", pdhcp_setting_req->dhcp_start);
		(void)sc_cfg_set("dhcpEnd", pdhcp_setting_req->dhcp_end);
		(void)sc_cfg_set("dhcpDns", pdhcp_setting_req->dhcp_dns);
		(void)sc_cfg_set("dhcpLease_hour", pdhcp_setting_req->dhcp_lease);
	}

	system_cmd_ex("user-config-udhcpd.sh");
}

